/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.formatters.DicomUtils;
import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.terra.tap.dm.DMObject;

public class SystemNameFormatter
implements Formatter {
    private String result = null;

    public Object format(DMObject dmo) {
        this.result = "";
        if (dmo != null) {
            String manufacturer = (String)dmo.getValue(8, 112);
            String model = (String)dmo.getValue(8, 4240);
            String magStrength = (String)dmo.getValue(24, 135);
            String modality = com.ge.med.cse.cvf.util.DicomUtils.getModality(dmo);
            boolean mfgByGE = DicomUtils.manufactureByGE((DMObject)dmo);
            boolean notMfgByGE = false;
            notMfgByGE = manufacturer != null ? manufacturer.trim().length() == 0 || !manufacturer.trim().substring(0, 2).equals("GE") : true;
            String AManufacturer = manufacturer != null ? manufacturer.trim() : "";
            String cl_ModelName = model != null ? model.trim() : "";
            String sop_class_uid = (String)dmo.getValue(8, 22);
            boolean SecondaryCap = sop_class_uid.equals("1.2.840.10008.5.1.4.1.1.7");
            String AModelName = "";
            if (model != null) {
                AModelName = cl_ModelName.equals("GENESIS_FOREIGN") ? "GENESIS" : (cl_ModelName.equals("GENESIS_SIGNA") ? "Signa" : cl_ModelName);
            }
            float magst = 0.0f;
            try {
                magst = Float.parseFloat(magStrength);
            }
            catch (Exception ex) {
                // empty catch block
            }
            float flt_magStrength_Tesla = 0.0f;
            flt_magStrength_Tesla = mfgByGE && 175.0 < (double)magst ? (float)((double)magst / 10000.0) : magst;
            String subresult = "";
            subresult = "MR".equalsIgnoreCase(modality) && !SecondaryCap ? flt_magStrength_Tesla + "T" : "";
            if (notMfgByGE) {
                if (AManufacturer.trim().length() != 0) {
                    this.result = this.result + AManufacturer + " ";
                }
                this.result = this.result + AModelName;
            } else {
                this.result = AModelName.trim() + " " + subresult;
            }
            return this.result;
        }
        return null;
    }
}

