/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import java.text.DecimalFormat;

public class CTScanRangeFormatter
implements Formatter {
    private String result = null;

    public Object format(DMObject objToformat) {
        String imgtype = DicomUtils.getImageType(objToformat, false);
        String startScanRange = null;
        String endScanRange = null;
        DecimalFormat df = new DecimalFormat("0.0");
        if (imgtype != null) {
            if (imgtype.equals("SSAVE")) {
                endScanRange = "0.0";
                startScanRange = "0.0";
                this.result = startScanRange + "  -  " + endScanRange;
            } else {
                String start_ras = (String)objToformat.getValue(25, 4120);
                String end_ras = (String)objToformat.getValue(25, 4122);
                String start_loc = null;
                String end_loc = null;
                if (imgtype.equals("PROSP") || imgtype.equals("RETRO")) {
                    DMObject[] dmo;
                    String query = null;
                    String seriesid = (String)objToformat.getValue(32, 17);
                    String seriesuid = (String)objToformat.getValue(32, 14);
                    if (seriesid != null && seriesid.length() != 0 && seriesuid != null && seriesuid.length() != 0) {
                        query = "(0x0020, 0x000e) = " + seriesuid + " AND (0x0020, 0x0011) = " + seriesid;
                    }
                    if ((dmo = objToformat.getRelated("image", new DMQuery(query))) != null) {
                        float startloc = -3.4028235E38f;
                        float endloc = Float.MAX_VALUE;
                        for (int i = 0; i < dmo.length; ++i) {
                            String curloc = (String)dmo[i].getValue(32, 4161);
                            if (curloc == null) continue;
                            startloc = Math.max(startloc, new Float(curloc).floatValue());
                            endloc = Math.min(endloc, new Float(curloc).floatValue());
                        }
                        if (startloc != -3.4028235E38f) {
                            start_loc = "" + df.format(Math.abs(startloc));
                        }
                        if (endloc != Float.MAX_VALUE) {
                            end_loc = "" + df.format(Math.abs(endloc));
                        }
                    }
                } else if (imgtype.equals("SCOUT")) {
                    DMObject[] dmo;
                    String query = null;
                    String seriesid = (String)objToformat.getValue(32, 17);
                    String seriesuid = (String)objToformat.getValue(32, 14);
                    if (seriesid != null && seriesid.length() != 0 && seriesuid != null && seriesuid.length() != 0) {
                        query = "(0x0020, 0x000e) = " + seriesuid + " AND (0x0020, 0x0011) = " + seriesid;
                    }
                    if ((dmo = objToformat.getRelated("image", new DMQuery(query))) != null) {
                        float startloc = -3.4028235E38f;
                        float endloc = Float.MAX_VALUE;
                        for (int i = 0; i < dmo.length; ++i) {
                            Float sctstr = (Float)dmo[i].getValue(39, 4176);
                            Float sctend = (Float)dmo[i].getValue(39, 4177);
                            if (sctstr != null) {
                                startloc = Math.max(startloc, sctstr.floatValue());
                                endloc = Math.min(endloc, sctstr.floatValue());
                            }
                            if (sctend == null) continue;
                            startloc = Math.max(startloc, sctend.floatValue());
                            endloc = Math.min(endloc, sctend.floatValue());
                        }
                        if (startloc != -3.4028235E38f) {
                            start_loc = "" + df.format(Math.abs(startloc));
                        }
                        if (endloc != Float.MAX_VALUE) {
                            end_loc = "" + df.format(Math.abs(endloc));
                        }
                    }
                }
                if (start_ras != null && start_loc != null) {
                    startScanRange = start_ras + start_loc;
                }
                if (end_ras != null && end_loc != null) {
                    endScanRange = end_ras + end_loc;
                }
                if (startScanRange != null && endScanRange != null) {
                    this.result = startScanRange + "  -  " + endScanRange;
                }
            }
        }
        return this.result;
    }
}

