/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.basic;

import com.ge.med.cse.cvf.dataloader.Dataset;
import com.ge.med.cse.cvf.dataloader.DatasetClassifier;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.j3d.DMVolumeCreator;
import com.ge.med.cse.cvf.j3d.VolumeCreator;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class VolumeDatasetModel
extends DatasetModel {
    private VolumeCreator volumeCreator = new DMVolumeCreator();
    private Logger logger = Logger.getLogger(VolumeDatasetModel.class.getName());
    protected Map<Integer, XjVolumeModel> xjVolModels = new HashMap<Integer, XjVolumeModel>();

    public void setVolumeCreator(VolumeCreator volumeCreator) {
        this.volumeCreator = volumeCreator;
    }

    public VolumeDatasetModel() {
    }

    public VolumeDatasetModel(Dataset ds) {
        super(ds);
    }

    @Override
    public void buildModel() {
        DatasetClassifier classifier = this.dataset.getClassifier();
        if (classifier != null && classifier.analyze(this.dataset).startsWith("Valid")) {
            int groups = classifier.numberOfGroups();
            for (int grp = 0; grp < groups; ++grp) {
                DMTagValueInterface[] images = classifier.getImages(grp);
                String status = "DATA_VALID";
                this.dataset.getDataSetValidator().validateImages(images);
                if (status.equals("DATA_VALID")) {
                    XjVolumeInfo volume = this.volumeCreator.createVolume(images);
                    this.setModelData(grp, volume);
                    classifier.clearCache();
                    this.firePropertyChange("MODELLOADED", "", this.dataset.getName());
                    continue;
                }
                String message = CvUtils.getResourceBundle().getString(status);
                this.logger.log(UserMessageLevel.USER_MSG, message);
            }
        }
    }

    public void putVolumeModel(int group, XjVolumeModel gsiModel) {
        this.xjVolModels.put(group, gsiModel);
    }

    public XjVolumeModel getVolumeModel(int group) {
        return this.xjVolModels.get(group);
    }

    public void clearVolumeModels() {
        this.xjVolModels.clear();
    }
}

