/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.dataloader.DatasetLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.basic.DynamicVolumeDatasetModel;
import com.ge.med.cse.cvf.j3d.DynamicVolume;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class XpVolumeLoader
implements Runnable,
Observer {
    private DMObject[] series = null;
    private J3DViewport[] ports = null;
    private TaskMonitor monitor = null;
    private volatile boolean isInterrupted = false;
    private Logger logger = Logger.getLogger(XpVolumeLoader.class.getName());

    public XpVolumeLoader(DMObject[] series, J3DViewport[] vp, TaskMonitor monitor) {
        if (series != null) {
            this.series = Arrays.copyOf(series, series.length);
        }
        this.monitor = monitor;
        if (vp != null) {
            this.ports = Arrays.copyOf(vp, vp.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DataContext dataConext = ContextProvider.getDataContext(DatasetLoaderUtils.APP_ID);
            final DynamicVolumeDatasetModel model = (DynamicVolumeDatasetModel)dataConext.getDatasetModel("DATASET_3D_SINGLE");
            DMTagValueInterface[] allImage = this.series[0].getRelated("image");
            String response = model.getDataset().getDataSetValidator().validateImages(allImage);
            if (!response.equalsIgnoreCase("DATA_VALID")) {
                if (this.monitor != null) {
                    this.monitor.taskFailed("DATA_LOADING_TASK_VOLUME_SINGLE", response, null);
                }
                this.logger.log(Level.WARNING, "Volume Validation failed reson: " + response);
                return;
            }
            final DatasetLoader baseLoader = dataConext.getDatasetLoader("DATASET_3D_SINGLE");
            double[] ras_ulc = new double[3];
            double[] ras_dx = new double[3];
            double[] ras_dy = new double[3];
            double[] ras_dz = new double[3];
            int[] dims = new int[3];
            J3DGeomUtils.sortSlicesByLocation((DMObject[])allImage);
            J3DGeomUtils.getVolumeGeometry(allImage, ras_ulc, ras_dx, ras_dy, ras_dz, dims);
            if (this.isInterrupted) {
                return;
            }
            DynamicVolume dvol = new DynamicVolume(dims, ras_ulc, ras_dx, ras_dy, ras_dz, (DMObject[])allImage);
            DMTag[] tags = DatasetLoaderUtils.getNeededTags(this.series[0]);
            if (this.isInterrupted) {
                return;
            }
            if (this.monitor != null) {
                this.monitor.taskBegin("DATA_LOADING_TASK_VOLUME_SINGLE", allImage.length);
            }
            dvol.addImage(((DMObject)allImage[0]).getImages(tags)[0]);
            String modDVol = DicomUtils.getModality(dvol);
            if (modDVol == null || modDVol.equals("")) {
                dvol.setModality(DicomUtils.getModality(allImage[0]));
            }
            J3DVolumeModel volModel = new J3DVolumeModel(dvol);
            model.putVolumeModel(0, volModel);
            if (this.monitor != null) {
                this.monitor.taskProgress("DATA_LOADING_TASK_VOLUME_SINGLE", 0);
            }
            if (this.isInterrupted) {
                return;
            }
            long start = System.currentTimeMillis();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    baseLoader.load(XpVolumeLoader.this.ports[0], model, CvPropertiesManager.getProperties(), XpVolumeLoader.this.monitor);
                    baseLoader.load(XpVolumeLoader.this.ports[1], model, CvPropertiesManager.getProperties(), XpVolumeLoader.this.monitor);
                    baseLoader.load(XpVolumeLoader.this.ports[2], model, CvPropertiesManager.getProperties(), XpVolumeLoader.this.monitor);
                    baseLoader.load(XpVolumeLoader.this.ports[3], model, CvPropertiesManager.getProperties(), XpVolumeLoader.this.monitor);
                }
            });
            System.out.println("XpVolumeLoader.run() ---" + (System.currentTimeMillis() - start));
            int size = allImage.length;
            for (int i = 1; i < size; ++i) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    dvol.addImage(((DMObject)allImage[i]).getImages(tags)[0]);
                } else {
                    dvol.addImage(((DMObject)allImage[i]).getImages(tags)[0]);
                }
                if (this.monitor != null) {
                    this.monitor.taskProgress("DATA_LOADING_TASK_VOLUME_SINGLE", i);
                }
                if (!this.isInterrupted) continue;
                return;
            }
            dvol.setLoadingComplete();
            if (this.monitor != null) {
                this.monitor.taskDone("DATA_LOADING_TASK_VOLUME_SINGLE");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!(ex instanceof InterruptedException) && this.monitor != null) {
                this.monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
            }
        }
        finally {
            this.ports = null;
            this.series = null;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.isInterrupted = true;
    }
}

