/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.adv.CvDMObject;
import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpReplaceImageLoader
implements DatasetLoader,
Observer,
Runnable,
PropertyChangeListener {
    volatile boolean isInterrupted = false;
    private JComponent viewport = null;
    private DatasetModel model = null;
    private TaskMonitor monitor = null;
    private Properties props = null;
    private volatile int frameIndex = 0;
    private XpDicomElement uid = new XpDicomElement(8, 24);

    @Override
    public void load(JComponent viewport, DatasetModel model, Properties prop, TaskMonitor monitor) {
        this.viewport = viewport;
        this.model = model;
        this.monitor = monitor;
        this.props = prop;
        viewport.addPropertyChangeListener("FrameIndex", this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.isInterrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            try {
                Object data = this.model.getDataset().getData();
                if (this.viewport instanceof XpCompositePort && data instanceof DMObject) {
                    this.loadDMObject(this.viewport, data);
                    break block8;
                }
                if (this.viewport instanceof XpCompositePort && data instanceof DMComposite) {
                    this.loadDMComposite(this.viewport, data);
                    break block8;
                }
                throw new IllegalArgumentException("viewport is not composite port or dataset is not dmobject");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!(ex instanceof InterruptedException)) {
                    this.monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
                }
            }
            finally {
                this.viewport.removePropertyChangeListener("FrameIndex", this);
                this.viewport = null;
                this.model = null;
                this.props = null;
            }
        }
    }

    private void loadDMComposite(JComponent viewport, Object data) throws InvocationTargetException, InterruptedException {
        DMComposite dmo = (DMComposite)data;
        final XpCompositePort compPort = (XpCompositePort)viewport;
        DMTag[] tags = DatasetLoaderUtils.getNeededTags(dmo);
        XjDicomObjectFrame[] imgDM = dmo.getImages(tags);
        String modality = DicomUtils.getModality(dmo);
        if (imgDM != null && imgDM.length > 0) {
            if (imgDM.length > 1 && "MG".equalsIgnoreCase(modality)) {
                CvUtils.sort3DImageSetByLocation(imgDM);
            }
            String str = this.model.getDataset().getDataSetValidator().validateImages(new DMTagValueInterface[]{dmo});
            if ("SUPPORTED_MODALITY".trim().equalsIgnoreCase(str)) {
                if (this.isInterrupted) {
                    return;
                }
                String suid = null;
                boolean loadCalibration = false;
                if (!CvUtils.isPixelSpacingPresent(dmo)) {
                    suid = (String)dmo.getValue(32, 14);
                    loadCalibration = CvUtils.calibrationExists(suid);
                }
                int totalImage = imgDM.length;
                String imgUID = (String)dmo.getValue(8, 24);
                if (this.monitor != null) {
                    this.monitor.taskBegin("DATA_LOADING_TASK_2D_SINGLE_IMAGE", totalImage);
                }
                for (int i = 0; i < totalImage; ++i) {
                    double cal;
                    if (this.isInterrupted) {
                        return;
                    }
                    CvImageLoader.CvMedicalDmImageList imgPixelCheck = new CvImageLoader.CvMedicalDmImageList(compPort, (DMImage[])imgDM);
                    XpMedicalImage[] medicalDmImg = imgPixelCheck.getImages();
                    if (loadCalibration && (cal = CvUtils.getCalibrationFactor(suid, imgUID)) != -1.0) {
                        XpSlice sl = medicalDmImg[i].getSlice();
                        sl.pixelSizeX = cal;
                        sl.pixelSizeY = cal;
                    }
                    final XpMedicalImage medimg = medicalDmImg[i];
                    if (SwingUtilities.isEventDispatchThread()) {
                        compPort.replaceImage(medimg, i);
                    } else {
                        final int toSet = i;
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                compPort.replaceImage(medimg, toSet);
                            }
                        });
                    }
                    if (this.monitor == null) continue;
                    this.monitor.taskProgress("DATA_LOADING_TASK_2D_SINGLE_IMAGE", i);
                }
            }
            if (this.monitor != null) {
                this.monitor.taskDone("DATA_LOADING_TASK_2D_SINGLE_IMAGE");
            }
        }
    }

    private void loadDMObject(JComponent viewport, Object data) throws InvocationTargetException, InterruptedException {
        DMObject dmo = (DMObject)data;
        final XpCompositePort compPort = (XpCompositePort)viewport;
        DMTagValueInterface[] imgDMO = dmo.getRelated("image");
        if (imgDMO != null && imgDMO.length > 0) {
            String str = this.model.getDataset().getDataSetValidator().validateImages(imgDMO);
            if ("SUPPORTED_MODALITY".trim().equalsIgnoreCase(str)) {
                if (this.isInterrupted) {
                    return;
                }
                DMTag[] tags = DatasetLoaderUtils.getNeededTags(dmo);
                ArrayList<CvDMObject> mvDMObjectList = DatasetLoaderUtils.sortImagesWithImageNumber((DMObject[])imgDMO);
                String suid = null;
                boolean loadCalibration = false;
                DMObject o = mvDMObjectList.get(0).getDmObject();
                if (!CvUtils.isPixelSpacingPresent(o)) {
                    suid = (String)o.getValue(32, 14);
                    loadCalibration = CvUtils.calibrationExists(suid);
                }
                int totalnumberOfImagesShow = 0;
                int totalImage = 0;
                try {
                    totalImage = Integer.parseInt(this.props.getProperty("NO_OF_IMAGES", mvDMObjectList.size() + ""));
                }
                catch (Exception e) {
                    this.monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", e);
                    return;
                }
                if (this.monitor != null) {
                    this.monitor.taskBegin("DATA_LOADING_TASK_2D_SINGLE_IMAGE", totalImage);
                }
                while (totalnumberOfImagesShow != totalImage) {
                    if (this.frameIndex + 1 > totalImage) {
                        this.frameIndex = 0;
                    }
                    int currentFrameIndex = this.frameIndex;
                    CvDMObject mvDMObject = mvDMObjectList.get(currentFrameIndex);
                    int noOfFrames = 1;
                    int repFrameNo = 1;
                    DMObject dmObj = mvDMObject.getDmObject();
                    Integer v = CvDSAImageUtils.getNumFrames(dmObj);
                    int n = noOfFrames = v != null ? Integer.parseInt("" + v) : 1;
                    if (noOfFrames > 1 && dmObj.getValue(40, 24592) != null) {
                        Object temp = dmObj.getValue(40, 24592);
                        int n2 = repFrameNo = temp != null ? Integer.parseInt("" + temp) : 1;
                    }
                    if (!mvDMObject.isLoadDone()) {
                        if (this.isInterrupted) {
                            return;
                        }
                        XjDicomObjectFrame[] ims = mvDMObject.getDmObject().getImages(tags);
                        String modality = DicomUtils.getModality(mvDMObject.getDmObject());
                        if (ims.length > 1 && "MG".equalsIgnoreCase(modality)) {
                            CvUtils.sort3DImageSetByLocation(ims);
                        }
                        repFrameNo = repFrameNo < ims.length ? repFrameNo : 1;
                        CvImageLoader.CvMedicalDmImageList imgPixelCheck = new CvImageLoader.CvMedicalDmImageList(compPort, new DMImage[]{ims[repFrameNo - 1]});
                        XpMedicalImage medicalDmImg = imgPixelCheck.getImages()[0];
                        if (loadCalibration) {
                            medicalDmImg.getValue(this.uid);
                            double cal = CvUtils.getCalibrationFactor(suid, this.uid.getStringValue());
                            if (cal != -1.0) {
                                XpSlice sl = medicalDmImg.getSlice();
                                sl.pixelSizeX = cal;
                                sl.pixelSizeY = cal;
                            }
                        }
                        final XpMedicalImage medimg = medicalDmImg;
                        if (SwingUtilities.isEventDispatchThread()) {
                            compPort.replaceImage(medimg, currentFrameIndex);
                        } else {
                            final int toSet = currentFrameIndex;
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    compPort.replaceImage(medimg, toSet);
                                }
                            });
                        }
                        mvDMObject.setLoadDone(true);
                        if (this.monitor != null) {
                            this.monitor.taskProgress("DATA_LOADING_TASK_2D_SINGLE_IMAGE", totalnumberOfImagesShow);
                        }
                        ++totalnumberOfImagesShow;
                    }
                    ++this.frameIndex;
                }
            }
            if (this.monitor != null) {
                this.monitor.taskDone("DATA_LOADING_TASK_2D_SINGLE_IMAGE");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newIndex = ((FramePositioningCapable)evt.getSource()).getFrameIndex();
        this.frameIndex = newIndex - 1;
    }
}

