/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.adv.XpBlankImageLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpReplaceImageLoader;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class XpGSPSLoader
implements Runnable,
Observer {
    private DMObject[] series = null;
    private DMObject[] referencedSeries = null;
    private TaskMonitor taskMonitor = null;
    private TaskMonitor gspsTaskMonitor = null;
    private XpReplaceImageLoader reploader = null;
    private XpViewport vp = null;
    private DMObject gspsObject = null;

    public XpGSPSLoader(final DMObject[] series, final XpViewport vp, TaskMonitor taskmonitor) {
        this.series = series == null ? new DMObject[0] : Arrays.copyOf(series, series.length);
        this.taskMonitor = taskmonitor;
        this.vp = vp;
        this.gspsTaskMonitor = new TaskMonitor(){

            @Override
            public void taskProgress(String taskName, int units) {
                XpGSPSLoader.this.taskMonitor.taskProgress(taskName, units);
            }

            @Override
            public void taskFailed(String taskName, String reason, Exception e) {
                XpGSPSLoader.this.taskMonitor.taskFailed(taskName, reason, e);
            }

            @Override
            public void taskDone(String taskName) {
                int status;
                if (XpGSPSLoader.this.gspsObject == null) {
                    Object[] prObjs = series[0].getRelated("image");
                    if (prObjs == null || prObjs.length == 0) {
                        XpGSPSLoader.this.taskMonitor.taskFailed(taskName, "GSPS_LOAD_FAILED", null);
                        return;
                    }
                    CvUtils.sortImages(prObjs);
                    XpGSPSLoader.this.gspsObject = (DMObject)prObjs[0];
                }
                if ((status = CvImageLoader.getInstance().loadCPI(vp, XpGSPSLoader.this.gspsObject)) == 0) {
                    XpGSPSLoader.this.taskMonitor.taskDone("DATA_LOADING_TASK_GSPS_SERIES");
                } else {
                    XpGSPSLoader.this.taskMonitor.taskFailed(taskName, "GSPS_LOAD_FAILED", null);
                }
                XpGSPSLoader.this.gspsObject = null;
            }

            @Override
            public void taskBegin(String taskName, int totalWork) {
                XpGSPSLoader.this.taskMonitor.taskBegin(taskName, totalWork);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.taskMonitor.taskBegin("DATA_LOADING_TASK_GSPS_SERIES", this.series.length);
            String statusMsg = this.findReferencedSeries(this.vp, this.series[0]);
            DataContext dataContext = ContextProvider.getDataContext(DatasetLoaderUtils.APP_ID);
            this.reploader = new XpReplaceImageLoader();
            DatasetModel model = dataContext.getDatasetModel("DATASET_2D_1");
            if ("GSPS_REFERENCED_SERIES_FOUND".equals(statusMsg)) {
                XpBlankImageLoader blankloader = new XpBlankImageLoader();
                model.getDataset().setData(this.referencedSeries[0]);
                blankloader.load(this.vp, model, CvPropertiesManager.getProperties(), this.gspsTaskMonitor);
                this.reploader.load(this.vp, model, CvPropertiesManager.getProperties(), this.gspsTaskMonitor);
                if (SwingUtilities.isEventDispatchThread()) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            XpGSPSLoader.this.reploader.run();
                        }
                    });
                    thread.start();
                } else {
                    this.reploader.run();
                }
            } else {
                this.taskMonitor.taskFailed("DATA_LOADING_TASK_GSPS_SERIES", statusMsg, null);
            }
        }
        finally {
            this.vp = null;
            this.series = null;
            this.referencedSeries = null;
            this.gspsTaskMonitor = null;
            this.gspsObject = null;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof DMObject && CPIUtils.isGSPS((DMObject)arg)) {
            this.gspsObject = (DMObject)arg;
            return;
        }
        if (this.reploader != null) {
            this.reploader.update(o, arg);
        }
    }

    public String findReferencedSeries(XpViewport viewport, DMObject gspsDmo) {
        if (this.series.length != 0 && !DatasetLoaderUtils.isPRSeries(this.series[0])) {
            return "NOT_A_GSPS_SERIES";
        }
        DMComposite gspsObject = null;
        if (gspsDmo.getType().equalsIgnoreCase("series")) {
            gspsObject = gspsDmo.getRelated("image")[0].getComposites()[0];
        } else if (gspsDmo.getType().equalsIgnoreCase("image")) {
            gspsObject = gspsDmo.getComposites()[0];
        }
        if (gspsObject == null) {
            return "NO_IMAGE_PRESENT";
        }
        DMSession session = gspsObject.getSession();
        this.referencedSeries = null;
        String refSerUID = null;
        Object seqObj = gspsObject.getValue(40, 12560);
        if (seqObj instanceof DMSequence) {
            DMiSeqItem item;
            Object val;
            DMiSequence peer = ((DMSequence)seqObj).getPeer();
            DMObject[] dmos = null;
            Object obj = peer.getValue(0, new DMTag(8, 4416));
            if (obj instanceof DMiSequence && (val = (item = ((DMiSequence)obj).getItem(0)).getValue(new DMTag(8, 4437))) != null) {
                DMQuery dmq = new DMQuery("(0x0008,0x0018) = " + val);
                dmos = session.getRelated("image", dmq);
                if (dmos == null || dmos.length == 0) {
                    return "GSPS_REF_IMAGE_NOT_FOUND";
                }
                refSerUID = (String)dmos[0].getValue(32, 14);
                DMQuery query = new DMQuery("(0x0020,0x000E) = " + refSerUID);
                this.referencedSeries = dmos[0].getRelated("series", query);
            }
        }
        if (this.referencedSeries == null || this.referencedSeries.length == 0) {
            return "GSPS_REFERENCED_SERIES_NOT_FOUND";
        }
        return "GSPS_REFERENCED_SERIES_FOUND";
    }
}

