/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.dataloader.DatasetLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.basic.DynamicVolumeDatasetModel;
import com.ge.med.cse.cvf.j3d.DynamicVolume;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class XpFusionVolumeLoadRunner
implements Runnable,
Observer {
    private DMObject[] series = null;
    private TaskMonitor taskMonitor = null;
    private volatile boolean isInterrupted = false;
    private J3DViewport[] ports = null;
    private DatasetLoader layeredLoader = null;
    private DatasetLoader baseLoader = null;
    private DynamicVolumeDatasetModel layeredmodel = null;
    private DynamicVolumeDatasetModel model = null;

    public XpFusionVolumeLoadRunner(DMObject[] series, J3DViewport[] ports, TaskMonitor taskMonitor) {
        this.series = series != null ? Arrays.copyOf(series, series.length) : null;
        this.ports = ports != null ? Arrays.copyOf(ports, ports.length) : null;
        this.taskMonitor = taskMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DataContext dataConext = ContextProvider.getDataContext(DatasetLoaderUtils.APP_ID);
            this.layeredLoader = dataConext.getDatasetLoader("DATASET_3D_FUSION");
            this.baseLoader = dataConext.getDatasetLoader("DATASET_3D_SINGLE");
            this.layeredmodel = (DynamicVolumeDatasetModel)dataConext.getDatasetModel("DATASET_3D_FUSION");
            this.model = (DynamicVolumeDatasetModel)dataConext.getDatasetModel("DATASET_3D_SINGLE");
            String modObj0 = DicomUtils.getModality(this.series[0]);
            String modObj1 = DicomUtils.getModality(this.series[1]);
            DMObject dmoCT = null;
            DMObject dmoPT = null;
            if (modObj0.equalsIgnoreCase("CT") && modObj1.equalsIgnoreCase("PT")) {
                dmoCT = this.series[0];
                dmoPT = this.series[1];
            } else if (modObj0.equalsIgnoreCase("PT") && modObj1.equalsIgnoreCase("CT")) {
                dmoPT = this.series[0];
                dmoCT = this.series[1];
            }
            if (dmoCT == null || dmoPT == null) {
                this.taskMonitor.taskFailed("DATA_LOADING_TASK_VOLUME_FUSION", "INVALID_FUSION_VOLUME", null);
                return;
            }
            if (dmoCT != null && dmoPT != null && DatasetLoaderUtils.isFusionValid(dmoCT, dmoPT)) {
                String modForVol2PT;
                DMTag[] tagsCT = DatasetLoaderUtils.getNeededTags(dmoCT);
                DMTag[] tagsPT = DatasetLoaderUtils.getNeededTags(dmoPT);
                if (this.isInterrupted) {
                    return;
                }
                DMTagValueInterface[] ctDMO = dmoCT.getRelated("image");
                DMTagValueInterface[] ptDMO = dmoPT.getRelated("image");
                String ptValidFovolume = this.model.getDataset().getDataSetValidator().validateImages(ptDMO);
                String ctValidFovolume = this.layeredmodel.getDataset().getDataSetValidator().validateImages(ctDMO);
                if (ctValidFovolume.equals("EXCEEEDS_SIZE") || ptValidFovolume.equals("EXCEEEDS_SIZE")) {
                    this.taskMonitor.taskFailed("DATA_LOADING_TASK_VOLUME_FUSION", "EXCEEEDS_SIZE", null);
                    return;
                }
                if (ctValidFovolume.equals("INVALID_IMAGETYPE") || ptValidFovolume.equals("INVALID_IMAGETYPE")) {
                    this.taskMonitor.taskFailed("DATA_LOADING_TASK_VOLUME_FUSION", "INVALID_IMAGETYPE", null);
                    return;
                }
                if (ctValidFovolume.equals(J3DGeomUtils.getErrorString(4))) {
                    this.taskMonitor.taskFailed("DATA_LOADING_TASK_VOLUME_FUSION", ctValidFovolume, null);
                    return;
                }
                if (!ctValidFovolume.equals(J3DGeomUtils.getErrorString(0)) || !ptValidFovolume.equals(J3DGeomUtils.getErrorString(0))) {
                    this.taskMonitor.taskFailed("DATA_LOADING_TASK_VOLUME_FUSION", "VOLUME_NOT_SUPPORTED", null);
                    return;
                }
                if (!CvImageFusionUtils.isValidFusionCombination(dmoCT, dmoPT)) {
                    JOptionPane.showMessageDialog(this.ports[0], CvUtils.getResourceBundle().getObject("ERROR_MATCHING_SLICE_NOT_FOUND"), CvUtils.getResourceBundle().getString("MEDIA_VIEWER_TITLE"), 0);
                    return;
                }
                CvImageFusionUtils.sortImagesByLocation((DMObject[])ctDMO);
                CvImageFusionUtils.sortImagesByLocation((DMObject[])ptDMO);
                double[] ulcCT = new double[3];
                double[] resxCT = new double[3];
                double[] resyCT = new double[3];
                double[] reszCT = new double[3];
                int[] dimCT = new int[3];
                J3DGeomUtils.getVolumeGeometry(ctDMO, ulcCT, resxCT, resyCT, reszCT, dimCT);
                DynamicVolume dvol1CT = new DynamicVolume(dimCT, ulcCT, resxCT, resyCT, reszCT, (DMObject[])ctDMO);
                double[] ulcPT = new double[3];
                double[] resxPT = new double[3];
                double[] resyPT = new double[3];
                double[] reszPT = new double[3];
                int[] dimPT = new int[3];
                J3DGeomUtils.getVolumeGeometry(ptDMO, ulcPT, resxPT, resyPT, reszPT, dimPT);
                DynamicVolume dvol2PT = new DynamicVolume(dimPT, ulcPT, resxPT, resyPT, reszPT, (DMObject[])ptDMO);
                int ctlength = ctDMO.length;
                int ptlength = ptDMO.length;
                int max = Math.max(ctlength, ptlength);
                if (this.taskMonitor != null) {
                    this.taskMonitor.taskBegin("DATA_LOADING_TASK_VOLUME_FUSION", max);
                }
                dvol1CT.addImage(((DMObject)ctDMO[0]).getImages(tagsCT)[0]);
                dvol2PT.addImage(((DMObject)ptDMO[0]).getImages(tagsPT)[0]);
                String modForVol1CT = DicomUtils.getModality(dvol1CT);
                if (modForVol1CT == null || modForVol1CT.equals("")) {
                    dvol1CT.setModality(DicomUtils.getModality(ctDMO[0]));
                }
                if ((modForVol2PT = DicomUtils.getModality(dvol2PT)) == null || modForVol2PT.equals("")) {
                    dvol2PT.setModality(DicomUtils.getModality(ptDMO[0]));
                }
                J3DVolumeModel volModelPT = new J3DVolumeModel(dvol2PT);
                this.model.putVolumeModel(0, volModelPT);
                J3DVolumeModel volModelCT = new J3DVolumeModel(dvol1CT);
                this.model.clearVolumeModels();
                this.model.putVolumeModel(0, volModelPT);
                this.layeredmodel.putVolumeModel(0, volModelCT);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        XpFusionVolumeLoadRunner.this.baseLoader.load(XpFusionVolumeLoadRunner.this.ports[0], XpFusionVolumeLoadRunner.this.layeredmodel, CvPropertiesManager.getProperties(), XpFusionVolumeLoadRunner.this.taskMonitor);
                        XpFusionVolumeLoadRunner.this.baseLoader.load(XpFusionVolumeLoadRunner.this.ports[1], XpFusionVolumeLoadRunner.this.model, CvPropertiesManager.getProperties(), XpFusionVolumeLoadRunner.this.taskMonitor);
                        XpFusionVolumeLoadRunner.this.baseLoader.load(XpFusionVolumeLoadRunner.this.ports[2], XpFusionVolumeLoadRunner.this.model, CvPropertiesManager.getProperties(), XpFusionVolumeLoadRunner.this.taskMonitor);
                        XpFusionVolumeLoadRunner.this.baseLoader.load(XpFusionVolumeLoadRunner.this.ports[3], XpFusionVolumeLoadRunner.this.model, CvPropertiesManager.getProperties(), XpFusionVolumeLoadRunner.this.taskMonitor);
                        for (int i = 0; i < XpFusionVolumeLoadRunner.this.ports.length; ++i) {
                            if (!(XpFusionVolumeLoadRunner.this.ports[i] instanceof Fusion3DCapable)) continue;
                            XpFusionVolumeLoadRunner.this.layeredLoader.load(XpFusionVolumeLoadRunner.this.ports[i], XpFusionVolumeLoadRunner.this.layeredmodel, CvPropertiesManager.getProperties(), XpFusionVolumeLoadRunner.this.taskMonitor);
                        }
                    }
                });
                if (this.taskMonitor != null) {
                    this.taskMonitor.taskProgress("DATA_LOADING_TASK_VOLUME_FUSION", 0);
                }
                for (int i = 1; i < max; ++i) {
                    if (i < ctlength) {
                        dvol1CT.addImage(((DMObject)ctDMO[i]).getImages(tagsCT)[0]);
                    }
                    if (i < ptlength) {
                        dvol2PT.addImage(((DMObject)ptDMO[i]).getImages(tagsPT)[0]);
                    }
                    if (this.taskMonitor != null) {
                        this.taskMonitor.taskProgress("DATA_LOADING_TASK_VOLUME_FUSION", i);
                    }
                    if (!this.isInterrupted) continue;
                    return;
                }
                dvol1CT.setLoadingComplete();
                dvol2PT.setLoadingComplete();
                if (this.taskMonitor != null) {
                    this.taskMonitor.taskDone("DATA_LOADING_TASK_VOLUME_FUSION");
                }
            } else {
                this.taskMonitor.taskFailed("DATA_LOADING_TASK_VOLUME_FUSION", "INVALID_FUSION_VOLUME", null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!(ex instanceof InterruptedException)) {
                this.taskMonitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
            }
        }
        finally {
            this.series = null;
            this.ports = null;
            this.layeredLoader = null;
            this.baseLoader = null;
            this.layeredmodel = null;
            this.model = null;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.isInterrupted = true;
    }
}

