/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.MultiDatasetLoader;
import com.ge.med.cse.cvf.dataloader.adv.CvDMObject;
import com.ge.med.cse.cvf.dataloader.adv.XpBlankImageLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpSingleSeriesLoadRunner;
import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpCompareModeLoader
implements Runnable,
MultiDatasetLoader,
Observer,
PropertyChangeListener {
    private boolean isInterrupted = false;
    private volatile int frameIndex = 0;
    JComponent[] ports = null;
    DatasetModel[] models = null;
    TaskMonitor monitor = null;

    @Override
    public void update(Observable o, Object arg) {
        this.isInterrupted = true;
    }

    @Override
    public void load(JComponent viewport, DatasetModel model, Properties prop, TaskMonitor monitor) {
        throw new RuntimeException("Not implemetned");
    }

    @Override
    public void run() {
        block36: {
            try {
                if (this.ports != null && this.ports.length > 1 && this.ports[0] instanceof XpCompositePort && this.ports[1] instanceof XpCompositePort) {
                    final XpCompositePort port1 = (XpCompositePort)this.ports[0];
                    final XpCompositePort port2 = (XpCompositePort)this.ports[1];
                    DMObject dmo1 = (DMObject)this.models[0].getDataset().getData();
                    DMObject dmo2 = (DMObject)this.models[1].getDataset().getData();
                    if (DatasetLoaderUtils.isPRSeries(dmo1) && !DatasetLoaderUtils.isPRSeries(dmo2)) {
                        CvImageLoader.getInstance().loadData(port1, new DMObject[]{dmo1}, true);
                        XpSingleSeriesLoadRunner singleLoader = new XpSingleSeriesLoadRunner(new DMObject[]{dmo2}, port2, this.monitor);
                        singleLoader.run();
                        return;
                    }
                    if (!DatasetLoaderUtils.isPRSeries(dmo1) && DatasetLoaderUtils.isPRSeries(dmo2)) {
                        CvImageLoader.getInstance().loadData(port2, new DMObject[]{dmo2}, true);
                        XpSingleSeriesLoadRunner singleLoader = new XpSingleSeriesLoadRunner(new DMObject[]{dmo1}, port1, this.monitor);
                        singleLoader.run();
                        return;
                    }
                    if (DatasetLoaderUtils.isPRSeries(dmo1) && DatasetLoaderUtils.isPRSeries(dmo2)) {
                        CvImageLoader.getInstance().loadData(port1, new DMObject[]{dmo1}, true);
                        CvImageLoader.getInstance().loadData(port2, new DMObject[]{dmo2}, true);
                        return;
                    }
                    DMTagValueInterface[] allImg1 = dmo1.getRelated("image");
                    DMTagValueInterface[] allImg2 = dmo2.getRelated("image");
                    String result = this.models[0].getDataset().getDataSetValidator().validateImages(allImg1);
                    String str = this.models[1].getDataset().getDataSetValidator().validateImages(allImg2);
                    if (str.equalsIgnoreCase("SUPPORTED_MODALITY") && result.equalsIgnoreCase("SUPPORTED_MODALITY")) {
                        if (this.isInterrupted) {
                            return;
                        }
                        DMTag[] tags1 = DatasetLoaderUtils.getNeededTags(dmo1);
                        DMTag[] tags2 = DatasetLoaderUtils.getNeededTags(dmo2);
                        ArrayList<CvDMObject> mvDMObjectList1 = DatasetLoaderUtils.sortImagesWithImageNumber((DMObject[])allImg1);
                        ArrayList<CvDMObject> mvDMObjectList2 = DatasetLoaderUtils.sortImagesWithImageNumber((DMObject[])allImg2);
                        String nodeType1 = dmo1.getType();
                        String nodeType2 = dmo2.getType();
                        DMTagValueInterface[] imageComps1 = null;
                        DMTagValueInterface[] imageComps2 = null;
                        int numFrames1 = 1;
                        int numFrames2 = 1;
                        String modality1 = "";
                        String modality2 = "";
                        XjDicomObjectFrame[] imgDM1 = null;
                        XjDicomObjectFrame[] imgDM2 = null;
                        int size1 = mvDMObjectList1.size();
                        int size2 = mvDMObjectList2.size();
                        if ("image".equalsIgnoreCase(nodeType1)) {
                            modality1 = DicomUtils.getModality(dmo1);
                            imageComps1 = ((DMObject)allImg1[0]).getComposites();
                            if (imageComps1 != null && imageComps1.length > 0) {
                                numFrames1 = CvDSAImageUtils.getNumFrames(imageComps1[0]);
                                tags1 = DatasetLoaderUtils.getNeededTags(imageComps1[0]);
                                imgDM1 = imageComps1[0].getImages(tags1);
                                if (numFrames1 > 1 && "MG".equalsIgnoreCase(modality1)) {
                                    this.models[0].getDataset().setData(imageComps1[0]);
                                    size1 = numFrames1;
                                    CvUtils.sort3DImageSetByLocation(imgDM1);
                                }
                                if (imgDM1 != null && imgDM1.length > 0) {
                                    String str1 = this.models[0].getDataset().getDataSetValidator().validateImages(imageComps1);
                                    if ("SUPPORTED_MODALITY".trim().equalsIgnoreCase(str1) && this.isInterrupted) {
                                        return;
                                    }
                                }
                            }
                        }
                        if ("image".equalsIgnoreCase(nodeType2)) {
                            modality2 = DicomUtils.getModality(dmo2);
                            imageComps2 = ((DMObject)allImg2[0]).getComposites();
                            if (imageComps2 != null && imageComps2.length > 0) {
                                numFrames2 = CvDSAImageUtils.getNumFrames(imageComps2[0]);
                                tags2 = DatasetLoaderUtils.getNeededTags(imageComps2[0]);
                                imgDM2 = imageComps2[0].getImages(tags2);
                                if (numFrames2 > 1 && "MG".equalsIgnoreCase(modality2)) {
                                    this.models[1].getDataset().setData(imageComps2[0]);
                                    size2 = numFrames2;
                                    CvUtils.sort3DImageSetByLocation(imgDM2);
                                }
                                if (imgDM2 != null && imgDM2.length > 0) {
                                    String str2 = this.models[1].getDataset().getDataSetValidator().validateImages(imageComps2);
                                    if ("SUPPORTED_MODALITY".trim().equalsIgnoreCase(str2) && this.isInterrupted) {
                                        return;
                                    }
                                }
                            }
                        }
                        port1.putClientProperty("NODE_TYPE", nodeType1);
                        port2.putClientProperty("NODE_TYPE", nodeType2);
                        XpBlankImageLoader blankLoader = new XpBlankImageLoader();
                        blankLoader.load(port1, this.models[0], CvPropertiesManager.getProperties(), this.monitor);
                        if (this.isInterrupted) {
                            return;
                        }
                        blankLoader.load(port2, this.models[1], CvPropertiesManager.getProperties(), this.monitor);
                        if (this.isInterrupted) {
                            return;
                        }
                        int maxsize = size1 > size2 ? size1 : size2;
                        this.monitor.taskBegin("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", maxsize);
                        int totalnumberOfImagesShow = 0;
                        this.monitor.taskProgress("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", totalnumberOfImagesShow);
                        while (totalnumberOfImagesShow != maxsize) {
                            int toSet;
                            XpMedicalImage medimg;
                            XpMedicalImage[] medicalDmImg;
                            CvImageLoader.CvMedicalDmImageList imgPixelCheck;
                            int temp;
                            boolean isParsed = false;
                            if (this.isInterrupted) {
                                return;
                            }
                            if (this.frameIndex + 1 > maxsize) {
                                this.frameIndex = 0;
                            }
                            if (size1 > (temp = this.frameIndex) && imgDM1 != null) {
                                imgPixelCheck = new CvImageLoader.CvMedicalDmImageList(port1, (DMImage[])imgDM1);
                                medicalDmImg = imgPixelCheck.getImages();
                                medimg = medicalDmImg[temp];
                                if (SwingUtilities.isEventDispatchThread()) {
                                    port1.replaceImage(medimg, temp);
                                } else {
                                    toSet = temp;
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            port1.replaceImage(medimg, toSet);
                                        }
                                    });
                                }
                                isParsed = true;
                            } else if (size1 > temp && !mvDMObjectList1.get(temp).isLoadDone()) {
                                final XpMedicalImage[] imgs1 = XpMedicalDmImage.wrapDMImages(mvDMObjectList1.get(temp).getDmObject().getImages(tags1));
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XpCompareModeLoader.this.isInterrupted) {
                                            return;
                                        }
                                        port1.replaceImage(imgs1[0], temp);
                                    }
                                });
                                mvDMObjectList1.get(temp).setLoadDone(true);
                                isParsed = true;
                            }
                            if (size2 > temp && imgDM2 != null) {
                                imgPixelCheck = new CvImageLoader.CvMedicalDmImageList(port2, (DMImage[])imgDM2);
                                medicalDmImg = imgPixelCheck.getImages();
                                medimg = medicalDmImg[temp];
                                if (SwingUtilities.isEventDispatchThread()) {
                                    port2.replaceImage(medimg, temp);
                                } else {
                                    toSet = temp;
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            port2.replaceImage(medimg, toSet);
                                        }
                                    });
                                }
                                isParsed = true;
                            } else if (size2 > temp && !mvDMObjectList2.get(temp).isLoadDone()) {
                                final XpMedicalImage[] imgs2 = XpMedicalDmImage.wrapDMImages(mvDMObjectList2.get(temp).getDmObject().getImages(tags2));
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XpCompareModeLoader.this.isInterrupted) {
                                            return;
                                        }
                                        port2.replaceImage(imgs2[0], temp);
                                    }
                                });
                                mvDMObjectList2.get(temp).setLoadDone(true);
                                isParsed = true;
                            }
                            if (isParsed) {
                                ++totalnumberOfImagesShow;
                                if (this.monitor != null) {
                                    this.monitor.taskProgress("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", totalnumberOfImagesShow);
                                }
                            }
                            ++this.frameIndex;
                        }
                        this.monitor.taskDone("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE");
                    } else {
                        this.monitor.taskFailed("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", "INVALID_MODALITY", null);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof InterruptedException) break block36;
                this.monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
            }
        }
    }

    @Override
    public void load(JComponent[] ports, DatasetModel[] models, Properties prop, TaskMonitor monitor) {
        this.ports = ports != null ? Arrays.copyOf(ports, ports.length) : null;
        this.models = models != null ? Arrays.copyOf(models, models.length) : null;
        this.monitor = monitor;
        if (ports != null) {
            ports[1].addPropertyChangeListener("FrameIndex", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

