/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.dataloader.DatasetLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpBlankImageLoader
implements DatasetLoader {
    @Override
    public void load(JComponent viewport, DatasetModel model, Properties prop, TaskMonitor monitor) {
        block7: {
            try {
                Object data = model.getDataset().getData();
                if (viewport instanceof XpCompositePort) {
                    XpCompositePort compPort = (XpCompositePort)viewport;
                    if (data instanceof DMObject) {
                        DMObject dmo = (DMObject)data;
                        int totalImages = 0;
                        try {
                            totalImages = Integer.parseInt(prop.getProperty("NO_OF_IMAGES"));
                        }
                        catch (Exception e) {
                            totalImages = dmo.getNumberOfRelated("image");
                        }
                        String str = model.getDataset().getDataSetValidator().validateImages(dmo.getRelated("image"));
                        this.loadImages(compPort, totalImages, str, monitor);
                        break block7;
                    }
                    if (data instanceof DMComposite) {
                        DMComposite dmo = (DMComposite)data;
                        DMTag[] tags = DatasetLoaderUtils.getNeededTags(dmo);
                        DMImage[] dmImg = dmo.getImages(tags);
                        int totalImages = dmImg.length;
                        String str = model.getDataset().getDataSetValidator().validateImages(new DMTagValueInterface[]{dmo});
                        this.loadImages(compPort, totalImages, str, monitor);
                        break block7;
                    }
                    throw new IllegalArgumentException("Invalid dataset");
                }
                throw new IllegalArgumentException("Invalid viewport");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof InterruptedException) break block7;
                monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
            }
        }
    }

    private void loadImages(final XpCompositePort compPort, final int totalImages, String str, TaskMonitor monitor) {
        if ("SUPPORTED_MODALITY".equalsIgnoreCase(str.trim())) {
            if (SwingUtilities.isEventDispatchThread()) {
                compPort.setImages(new XjImage[totalImages]);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        compPort.setImages(new XjImage[totalImages]);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtilities.invokeLater(runnable);
                }
            }
        } else {
            monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "INVALID_MODALITY", null);
        }
    }
}

