/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader;

import com.ge.med.cse.cvf.dataloader.Dataset;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

public abstract class DatasetModel
implements PropertyChangeListener {
    public static final String ModelLoadedProperty = "MODELLOADED";
    protected Dataset dataset;
    protected PropertyChangeSupport ps = new PropertyChangeSupport(this);
    protected ArrayList modelData = new ArrayList();

    public DatasetModel() {
    }

    public DatasetModel(Dataset ds) {
        this.dataset = ds;
        ds.addPropertyChangeListener("DataChanged", this);
    }

    public void setDataset(Dataset ds) {
        if (this.dataset != null) {
            this.dataset.removePropertyChangeListener("DataChanged", this);
        }
        this.dataset = ds;
        ds.addPropertyChangeListener("DataChanged", this);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modelData.clear();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.ps.addPropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.ps.addPropertyChangeListener(prop, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.ps.removePropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.ps.removePropertyChangeListener(prop, pcl);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.ps.firePropertyChange(propertyName, oldValue, newValue);
    }

    public int numberOfGroups() {
        return this.modelData.size();
    }

    public Object getModelData(int gr) {
        if (this.modelData.size() <= gr) {
            return null;
        }
        return this.modelData.get(gr);
    }

    public void setModelData(int gr, Object data) {
        if (gr < this.modelData.size()) {
            this.modelData.set(gr, data);
        } else {
            this.modelData.add(data);
        }
    }

    public int groupIndex(Object data) {
        return this.modelData.indexOf(data);
    }

    public void removeModelData(Object data) {
        this.modelData.remove(data);
    }

    public abstract void buildModel();
}

