/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.crossref.XPCrossRefLinesManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.JImage2DVc;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.MouseInputListener;

public class XpSliceCollectionRoi
implements RoiActor,
Replicable,
Visible,
GrayScaleCapable {
    private ArrayList slices = new ArrayList();
    private ArrayList atualSlicesDrawn = null;
    private XpImage image = null;
    private Point2D[] segments = null;
    private String lineStyle = "DOTTED";
    private Color lineColor = Color.cyan;
    private boolean validate = false;
    private boolean visible = true;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private XpDicomElement ser = new XpDicomElement(32, 17);
    private XpDicomElement img = new XpDicomElement(32, 19);
    private XpDicomElement imguid = new XpDicomElement(8, 24);
    private int largestAnnotationLen = 0;
    private int numIntersections = 0;
    private boolean grayscaleMode = false;
    private final int iterationTolerance = 2;
    private final int proximityTolerance = 8;
    private final int offsetXY = 4;
    private XpAnnotationModel annotModel = null;
    private final Double crossRefLineToViewPortSizeRatio = Double.parseDouble(CvPropertiesManager.getProperty("cvf.xref.line.length.minimum", "0.2"));
    private boolean crossRefLinesUpdated = false;
    private boolean annotationIntersectingSliceNumber = false;
    Line2D.Double vcLeft = new Line2D.Double();
    Line2D.Double vcTop = new Line2D.Double();
    Line2D.Double vcRight = new Line2D.Double();
    Line2D.Double vcBot = new Line2D.Double();
    double x;
    double y;
    double w;
    double h;
    private final Map<Integer, Double> initialSlicePointsMap = new HashMap<Integer, Double>();
    private final Map<Integer, Double> finalSlicePointsMap = new HashMap<Integer, Double>();
    private ArrayList roilistener = new ArrayList();
    private XpRoiEvent roiEvent = new XpRoiEvent(this);
    MouseInputListener listener = new MouseInputListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            XpSliceCollectionRoi.this.roiEvent.setHintMask(0);
            for (int i = 0; i < XpSliceCollectionRoi.this.roilistener.size(); ++i) {
                XpRoiEventListener rel = (XpRoiEventListener)XpSliceCollectionRoi.this.roilistener.get(i);
                rel.roiPressed(XpSliceCollectionRoi.this.roiEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    };

    @Override
    public Object clone() {
        XpSliceCollectionRoi slroi = new XpSliceCollectionRoi();
        slroi.setImage(this.image);
        for (int i = 0; i < this.slices.size(); ++i) {
            myXpSlice sl = (myXpSlice)((myXpSlice)this.slices.get(i)).clone();
            slroi.slices.add(sl);
            slroi.largestAnnotationLen = this.largestAnnotationLen;
        }
        slroi.validate = true;
        slroi.setVisible(this.isVisible());
        return slroi;
    }

    public void addSlice(XpMedicalImage image) {
        int sliceStringLen;
        if (image == null) {
            return;
        }
        image.getValue(this.imguid);
        image.getValue(this.img);
        image.getValue(this.ser);
        myXpSlice sl = new myXpSlice(new XpSlice(image), this.ser.getIntValue(), this.img.getIntValue(), this.imguid.getStringValue());
        if (this.slices.contains(sl)) {
            return;
        }
        this.slices.add(sl);
        String sliceSting = this.getSliceString(this.slices.size() - 1);
        int n = sliceStringLen = sliceSting != null ? sliceSting.length() : 0;
        if (sliceStringLen > this.largestAnnotationLen) {
            this.largestAnnotationLen = sliceStringLen;
        }
        this.validate = true;
    }

    public void addSlices(XpMedicalImage[] images) {
        if (images == null || images.length == 0) {
            return;
        }
        for (int i = 0; i < images.length; ++i) {
            int sliceStringLen;
            images[i].getValue(this.imguid);
            images[i].getValue(this.img);
            images[i].getValue(this.ser);
            myXpSlice sl = new myXpSlice(new XpSlice(images[i]), this.ser.getIntValue(), this.img.getIntValue(), this.imguid.getStringValue());
            if (this.slices.contains(sl)) continue;
            this.slices.add(sl);
            String sliceSting = this.getSliceString(this.slices.size() - 1);
            int n = sliceStringLen = sliceSting != null ? sliceSting.length() : 0;
            if (sliceStringLen <= this.largestAnnotationLen) continue;
            this.largestAnnotationLen = sliceStringLen;
        }
        this.validate = true;
    }

    public void removeAllSlices() {
        this.slices.clear();
        this.largestAnnotationLen = 0;
    }

    public final int getNumberOfSlices() {
        return this.slices.size();
    }

    private void postCrossReference() {
        this.numIntersections = 0;
        if (this.validate && this.image != null) {
            if (this.slices.size() > 0) {
                this.segments = new Point2D[2 * this.slices.size()];
                for (int i = 0; i < this.slices.size(); ++i) {
                    myXpSlice s = (myXpSlice)this.slices.get(i);
                    Point2D[] p = this.image.getSlice().getIntersection(s.getSlice());
                    if (p[0].equals(p[1])) {
                        p = this.image.getSlice().getIntersectionWithInfinite(s.getSlice());
                    }
                    this.segments[2 * i] = p[0];
                    this.segments[2 * i + 1] = p[1];
                    if (p[0].equals(p[1])) continue;
                    ++this.numIntersections;
                }
            } else {
                this.segments = null;
            }
            this.validate = false;
            if (this.numIntersections == 0) {
                XPCrossRefLinesManager.logUserMessage(6);
            }
        }
    }

    final void line(Graphics g, Point2D p0, Point2D p1, int offset) {
        g.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    private Point2D intersect(Line2D.Double line1, Line2D.Double line2) {
        Line2D.Double l2;
        Line2D.Double l1 = new Line2D.Double(line1.getP1(), line1.getP2());
        if (l1.intersectsLine(l2 = new Line2D.Double(line2.getP1(), line2.getP2()))) {
            if (l1.x2 == l1.x1) {
                l1.x2 += 1.0;
            }
            double m1 = (l1.y2 - l1.y1) / (l1.x2 - l1.x1);
            double c1 = l1.y1 - m1 * l1.x1;
            if (l2.x2 == l2.x1) {
                l2.x2 += 1.0;
            }
            double m2 = (l2.y2 - l2.y1) / (l2.x2 - l2.x1);
            double c2 = l2.y1 - m2 * l2.x1;
            double x = (c2 - c1) / (m1 - m2);
            double y = m1 * x + c1;
            return new Point2D.Double(x, y);
        }
        return null;
    }

    private void getValidPoints(Point2D[] points, XpVisualComponent vc) {
        boolean xinside;
        Line2D.Double line = new Line2D.Double(points[0], points[1]);
        boolean bl = points[0].getX() <= points[1].getX() ? points[0].getX() >= this.x && points[1].getX() <= this.x + this.w : (xinside = points[1].getX() >= this.x && points[0].getX() <= this.x + this.w);
        boolean yinside = points[0].getY() <= points[1].getY() ? points[0].getY() >= this.y && points[1].getY() <= this.y + this.h : points[1].getY() >= this.y && points[0].getY() <= this.y + this.h;
        boolean intersects = false;
        if (xinside && yinside) {
            this.updateXRefLineEndpoints(points, vc);
        } else {
            if (this.vcLeft.intersectsLine(line)) {
                if (points[0].getX() < this.x) {
                    points[0] = this.intersect(this.vcLeft, line);
                }
                if (points[1].getX() < this.x) {
                    points[1] = this.intersect(this.vcLeft, line);
                }
                intersects = true;
            }
            if (this.vcTop.intersectsLine(line)) {
                if (points[0].getY() < this.y) {
                    points[0] = this.intersect(this.vcTop, line);
                }
                if (points[1].getY() < this.y) {
                    points[1] = this.intersect(this.vcTop, line);
                }
                intersects = true;
            }
            if (this.vcRight.intersectsLine(line)) {
                if (points[0].getX() > this.x + this.w) {
                    points[0] = this.intersect(this.vcRight, line);
                }
                if (points[1].getX() > this.x + this.w) {
                    points[1] = this.intersect(this.vcRight, line);
                }
                intersects = true;
            }
            if (this.vcBot.intersectsLine(line)) {
                if (points[0].getY() > this.y + this.h) {
                    points[0] = this.intersect(this.vcBot, line);
                }
                if (points[1].getY() > this.y + this.h) {
                    points[1] = this.intersect(this.vcBot, line);
                }
                intersects = true;
            }
            if (!intersects) {
                points[0] = new Point2D.Double(0.0, 0.0);
                points[1] = new Point2D.Double(0.0, 0.0);
            } else {
                this.updateXRefLineEndpoints(points, vc);
            }
        }
    }

    public void initialize(XpVisualComponent vc, Graphics2D g) {
        Font prevfont = g.getFont();
        XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
        Font afont = ap.getAnnotationFont(vc.getWidth(), vc.getHeight());
        g.setFont(afont);
        g.setFont(prevfont);
        this.x = vc.getX();
        this.y = vc.getY();
        this.w = vc.getWidth();
        this.h = vc.getHeight();
        this.vcLeft.setLine(this.x, this.y, this.x, this.y + this.h);
        this.vcTop.setLine(this.x, this.y, this.x + this.w, this.y);
        this.vcRight.setLine(this.x + this.w, this.y, this.x + this.w, this.y + this.h);
        this.vcBot.setLine(this.x, this.y + this.h, this.x + this.w, this.y + this.h);
    }

    @Override
    public void paintRoi(XpVisualComponent vc, Graphics2D g) {
        if (!this.visible) {
            return;
        }
        JImage2DVc image2DVC = (JImage2DVc)vc.getParent();
        XpMedicalImage2DVc xpMedicalImage2DVc = (XpMedicalImage2DVc)image2DVC.getParent();
        this.annotModel = xpMedicalImage2DVc.getAnnotationModel();
        CTransform t = vc.getTransform((byte)0, (byte)1);
        AffineTransform at = t.getTransform2D();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.validate && this.image != null) {
            this.postCrossReference();
            this.validate = false;
        }
        this.initialize(vc, g);
        int sliceNumberingPos = 0;
        this.atualSlicesDrawn = new ArrayList();
        if (this.segments != null) {
            for (int i = 0; i < this.slices.size(); ++i) {
                boolean vertical;
                Point2D[] dp;
                Point2D p1 = this.segments[2 * i];
                Point2D p2 = this.segments[2 * i + 1];
                dp = new Point2D.Double[]{at.transform(p1, dp[0]), at.transform(p2, dp[1])};
                Double sumTotalBeforeUpdation = ((Point2D)dp[0]).getX() + ((Point2D)dp[1]).getX() + ((Point2D)dp[0]).getY() + ((Point2D)dp[1]).getY();
                this.initialSlicePointsMap.put(i, sumTotalBeforeUpdation);
                Point2D.Double[] dp_HorizontalVertical = new Point2D.Double[2];
                Font prevfont = g.getFont();
                XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
                Font afont = ap.getAnnotationFont(vc.getWidth(), vc.getHeight());
                g.setFont(afont);
                String sliceStr = this.getSliceString(i);
                double sliceNumberLength = g.getFontMetrics().charWidth('m') * sliceStr.length() + sliceStr.length() * 4;
                g.setFont(prevfont);
                if (p1.getX() == p2.getX() && p1.getY() == p2.getY()) continue;
                if (this.isGrayScaleMode()) {
                    g.setColor(Color.WHITE);
                } else {
                    g.setColor(this.lineColor);
                }
                double ang = Math.abs(Math.atan2(Math.abs(((Point2D)dp[1]).getY() - ((Point2D)dp[0]).getY()), Math.abs(((Point2D)dp[1]).getX() - ((Point2D)dp[0]).getX())));
                boolean bl = vertical = Math.toDegrees(ang) > 45.0;
                int direction = vertical ? (((Point2D)dp[0]).getY() < ((Point2D)dp[1]).getY() ? 1 : -1) : (((Point2D)dp[0]).getX() < ((Point2D)dp[1]).getX() ? 1 : -1);
                boolean reverse = sliceNumberingPos == 0 && direction == 1 || sliceNumberingPos == 1 && direction == -1;
                this.getValidPoints(dp, vc);
                Double sumTotalAfterUpdation = dp[0].getX() + dp[1].getX() + dp[0].getY() + dp[1].getY();
                this.finalSlicePointsMap.put(i, sumTotalAfterUpdation);
                if (dp[0].getY() == dp[1].getY() && dp[0].getX() != dp[1].getX()) {
                    if (sliceNumberingPos == 0) {
                        dp_HorizontalVertical[0] = new Point2D.Double(dp[0].getX() + sliceNumberLength, dp[0].getY());
                        dp_HorizontalVertical[1] = new Point2D.Double(dp[1].getX(), dp[0].getY());
                    } else {
                        dp_HorizontalVertical[0] = new Point2D.Double(dp[0].getX(), dp[0].getY());
                        dp_HorizontalVertical[1] = new Point2D.Double(dp[1].getX() - sliceNumberLength, dp[0].getY());
                    }
                } else if (dp[0].getY() != dp[1].getY() && dp[0].getX() == dp[1].getX()) {
                    if (sliceNumberingPos == 0) {
                        dp_HorizontalVertical[0] = new Point2D.Double(dp[0].getX(), dp[0].getY() + sliceNumberLength);
                        dp_HorizontalVertical[1] = new Point2D.Double(dp[1].getX(), dp[1].getY());
                    } else {
                        dp_HorizontalVertical[0] = new Point2D.Double(dp[0].getX(), dp[0].getY());
                        dp_HorizontalVertical[1] = new Point2D.Double(dp[1].getX(), dp[1].getY() - sliceNumberLength);
                    }
                }
                g.setFont(afont);
                this.drawsliceNumber(g, i, (int)dp[sliceNumberingPos].getX(), (int)dp[sliceNumberingPos].getY(), vertical, reverse, sliceNumberLength, vc, dp);
                if (this.lineStyle != null) {
                    if (dp[0].getX() != 0.0 && dp[0].getY() != 0.0 && dp[1].getX() != 0.0 && dp[1].getY() != 0.0) {
                        this.atualSlicesDrawn.add(((myXpSlice)this.slices.get(i)).imgNum);
                    }
                    if (dp[1].getY() != 0.0 || dp[0].getY() != 0.0 || dp[1].getX() != 0.0 || dp[0].getX() != 0.0) {
                        if (this.lineStyle.compareTo("SOLID") == 0) {
                            if (dp[0].getY() != dp[1].getY() && dp[0].getX() != dp[1].getX()) {
                                this.drawDottedLine(g, dp[0], dp[1], 0);
                            } else {
                                this.drawDottedLine(g, dp_HorizontalVertical[0], dp_HorizontalVertical[1], 0);
                            }
                        } else if (this.lineStyle.compareTo("DOTTED") == 0) {
                            if (dp[0].getY() != dp[1].getY() && dp[0].getX() != dp[1].getX()) {
                                this.drawDottedLine(g, dp[0], dp[1], 0);
                            } else {
                                this.drawDottedLine(g, dp_HorizontalVertical[0], dp_HorizontalVertical[1], 0);
                            }
                        }
                    }
                }
                sliceNumberingPos = sliceNumberingPos == 0 ? 1 : 0;
            }
        }
    }

    private String getSliceString(int index) {
        if (this.slices == null || this.slices.isEmpty() || index >= this.slices.size() || index > 0 && index >= this.slices.size()) {
            return null;
        }
        myXpSlice s = (myXpSlice)this.slices.get(index);
        String num = s.getSeriesNumber() + "/" + s.getImageNumber();
        return num;
    }

    private void drawsliceNumber(Graphics2D g, int index, int xPos, int yPos, boolean vertical, boolean reverse, double sliceNumberLength, XpVisualComponent vc, Point2D[] points) {
        boolean sliceNumberContainsAnnotation = false;
        myXpSlice sl = (myXpSlice)this.slices.get(index);
        char[] chars = (sl.getSeriesNumber() + "/" + sl.getImageNumber()).toCharArray();
        sliceNumberContainsAnnotation = this.isSliceLabelIntersecting(sliceNumberLength, vc, points);
        if (reverse) {
            if (sliceNumberContainsAnnotation) {
                this.drawSliceNumberInGivenDirection(g, index, xPos, yPos, vertical, chars, false);
            } else {
                this.drawSliceNumberInGivenDirection(g, index, xPos, yPos, vertical, chars, true);
            }
        } else if (sliceNumberContainsAnnotation) {
            this.drawSliceNumberInGivenDirection(g, index, xPos, yPos, vertical, chars, true);
        } else {
            this.drawSliceNumberInGivenDirection(g, index, xPos, yPos, vertical, chars, false);
        }
    }

    private void drawSliceNumberInGivenDirection(Graphics2D g, int index, int xPos, int yPos, boolean vertical, char[] chars, boolean isReverse) {
        int yoffset;
        int offset = 0;
        for (int j = 0; j <= chars.length; ++j) {
            offset = g.getFontMetrics().charWidth(j) + 4;
        }
        int xoffset = vertical ? 0 : offset;
        int n = yoffset = vertical ? offset : 0;
        if (isReverse) {
            int y = vertical ? yPos + 10 : yPos;
            int x = vertical ? xPos : xPos;
            for (int i = chars.length - 1; i >= 0; --i) {
                g.drawChars(chars, i, 1, x -= xoffset, y -= yoffset);
            }
        } else {
            int y = vertical ? yPos + 7 : yPos;
            int x = vertical ? xPos : xPos + 7;
            for (int i = 0; i < chars.length; ++i) {
                g.drawChars(chars, i, 1, x, y);
                y += yoffset;
                x += xoffset;
            }
        }
    }

    public boolean isSliceLabelIntersecting(double sliceNumberLength, XpVisualComponent vc, Point2D[] points) {
        double slope = (points[1].getY() - points[0].getY()) / (points[1].getX() - points[0].getX());
        double height = vc.getHeight() - 4;
        double width = vc.getWidth() - 4;
        double x1Iterator = points[0].getX();
        double y1Iterator = points[0].getY();
        double x2Iterator = points[1].getX();
        double y2Iterator = points[1].getY();
        if (Math.abs(slope) >= 1.0) {
            if (y1Iterator < y2Iterator) {
                double sliceNumber_Y_Iterator;
                for (sliceNumber_Y_Iterator = y1Iterator; sliceNumber_Y_Iterator >= y1Iterator - sliceNumberLength; sliceNumber_Y_Iterator -= 1.0) {
                    if (this.annotModel.insideAnnotation((int)x1Iterator, (int)sliceNumber_Y_Iterator) == -1 && !(sliceNumber_Y_Iterator < 0.0)) continue;
                    this.annotationIntersectingSliceNumber = true;
                    break;
                }
                for (sliceNumber_Y_Iterator = y2Iterator; sliceNumber_Y_Iterator <= y2Iterator + sliceNumberLength; sliceNumber_Y_Iterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)x2Iterator, (int)sliceNumber_Y_Iterator) == -1 && !(sliceNumber_Y_Iterator >= height)) continue;
                    this.annotationIntersectingSliceNumber = true;
                    break;
                }
            } else {
                double sliceNumber_Y_Iterator;
                for (sliceNumber_Y_Iterator = y1Iterator; sliceNumber_Y_Iterator <= y1Iterator + sliceNumberLength; sliceNumber_Y_Iterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)x1Iterator, (int)sliceNumber_Y_Iterator) == -1 && !(sliceNumber_Y_Iterator >= height)) continue;
                    this.annotationIntersectingSliceNumber = true;
                    break;
                }
                for (sliceNumber_Y_Iterator = y2Iterator; sliceNumber_Y_Iterator >= y2Iterator - sliceNumberLength; sliceNumber_Y_Iterator -= 1.0) {
                    if (this.annotModel.insideAnnotation((int)x2Iterator, (int)sliceNumber_Y_Iterator) == -1 && !(sliceNumber_Y_Iterator <= 0.0)) continue;
                    this.annotationIntersectingSliceNumber = true;
                    break;
                }
            }
        } else if (x1Iterator < x2Iterator) {
            double sliceNumber_X_Iterator;
            for (sliceNumber_X_Iterator = x1Iterator; sliceNumber_X_Iterator >= x1Iterator - sliceNumberLength; sliceNumber_X_Iterator -= 1.0) {
                if (this.annotModel.insideAnnotation((int)sliceNumber_X_Iterator, (int)y1Iterator) == -1 && !(sliceNumber_X_Iterator < 0.0)) continue;
                this.annotationIntersectingSliceNumber = true;
                break;
            }
            for (sliceNumber_X_Iterator = x2Iterator; sliceNumber_X_Iterator <= x2Iterator + sliceNumberLength; sliceNumber_X_Iterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)sliceNumber_X_Iterator, (int)y2Iterator) == -1 && !(sliceNumber_X_Iterator >= width)) continue;
                this.annotationIntersectingSliceNumber = true;
                break;
            }
        } else {
            double sliceNumber_X_Iterator;
            for (sliceNumber_X_Iterator = x1Iterator; sliceNumber_X_Iterator >= x1Iterator - sliceNumberLength; sliceNumber_X_Iterator -= 1.0) {
                if (this.annotModel.insideAnnotation((int)sliceNumber_X_Iterator, (int)y1Iterator) == -1 && !(sliceNumber_X_Iterator >= width)) continue;
                this.annotationIntersectingSliceNumber = true;
                break;
            }
            for (sliceNumber_X_Iterator = x2Iterator; sliceNumber_X_Iterator <= x2Iterator + sliceNumberLength; sliceNumber_X_Iterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)sliceNumber_X_Iterator, (int)y2Iterator) == -1 && !(sliceNumber_X_Iterator < 0.0)) continue;
                this.annotationIntersectingSliceNumber = true;
                break;
            }
        }
        return this.annotationIntersectingSliceNumber;
    }

    private void drawDottedLine(Graphics2D g, Point2D p0, Point2D p1, int offset) {
        float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
        g.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
        g.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    public void updateXRefLineEndpoints(Point2D[] points, XpVisualComponent vc) {
        double x1 = points[0].getX();
        double y1 = points[0].getY();
        double x2 = points[1].getX();
        double y2 = points[1].getY();
        double slope = (y2 - y1) / (x2 - x1);
        if (x1 == x2) {
            if (y1 != y2) {
                this.checkVerticalLineInterferenceAndUpdate(points, vc, false);
            }
        } else if (y1 == y2) {
            this.checkHorizontalLineInterferenceAndUpdate(points, vc, false);
        } else if (Math.abs(slope) >= 1.0) {
            this.checkVerticalLineInterferenceAndUpdate(points, vc, true);
        } else {
            this.checkHorizontalLineInterferenceAndUpdate(points, vc, true);
        }
    }

    private void checkHorizontalLineInterferenceAndUpdate(Point2D[] points, XpVisualComponent vc, boolean isInclined) {
        double vIterator;
        double mX = 0.0;
        double mY = 0.0;
        double upperXIterator = 0.0;
        double lowerXIterator = 0.0;
        double upperYIterator = 0.0;
        double lowerYIterator = 0.0;
        boolean lowerContains = false;
        boolean upperContains = false;
        double x1 = points[0].getX();
        double y1 = points[0].getY();
        double x2 = points[1].getX();
        double y2 = points[1].getY();
        double slope = (y2 - y1) / (x2 - x1);
        double yIntercept = y1 - slope * x1;
        mX = (points[0].getX() + points[1].getX()) / 2.0;
        mY = (points[0].getY() + points[1].getY()) / 2.0;
        upperXIterator = mX;
        upperYIterator = mY;
        lowerXIterator = mX;
        lowerYIterator = mY;
        double height = vc.getHeight() - 4;
        double width = vc.getWidth() - 4;
        while (upperXIterator >= x1) {
            upperYIterator = isInclined ? slope * (upperXIterator -= 2.0) + yIntercept : upperYIterator;
            for (vIterator = upperYIterator - 8.0; vIterator <= upperYIterator + 8.0; vIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)upperXIterator, (int)vIterator) == -1 && !(vIterator < 0.0)) continue;
                upperContains = true;
                break;
            }
            if (!upperContains) continue;
        }
        while (lowerXIterator <= x2) {
            lowerYIterator = isInclined ? slope * (lowerXIterator += 2.0) + yIntercept : lowerYIterator;
            for (vIterator = lowerYIterator - 8.0; vIterator <= lowerYIterator + 8.0; vIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)lowerXIterator, (int)vIterator) == -1 && !(vIterator > height)) continue;
                lowerContains = true;
                break;
            }
            if (!lowerContains) continue;
        }
        Double referenceLineLength = null;
        Double minimumReferenceLineLength = width * this.crossRefLineToViewPortSizeRatio;
        if (lowerContains && (referenceLineLength = XpSliceCollectionRoi.getReferenceLineLength(lowerXIterator, upperXIterator, lowerYIterator, upperYIterator)) >= minimumReferenceLineLength) {
            points[1].setLocation(lowerXIterator, lowerYIterator);
            this.crossRefLinesUpdated = true;
        }
        if (upperContains && (referenceLineLength = XpSliceCollectionRoi.getReferenceLineLength(lowerXIterator, upperXIterator, lowerYIterator, upperYIterator)) >= minimumReferenceLineLength) {
            points[0].setLocation(upperXIterator, upperYIterator);
            this.crossRefLinesUpdated = true;
        }
    }

    private void checkVerticalLineInterferenceAndUpdate(Point2D[] points, XpVisualComponent vc, boolean isInclined) {
        double hIterator;
        double mX = 0.0;
        double mY = 0.0;
        double upperXIterator = 0.0;
        double lowerXIterator = 0.0;
        double upperYIterator = 0.0;
        double lowerYIterator = 0.0;
        double width = vc.getWidth() - 4;
        double height = vc.getHeight() - 4;
        boolean lowerContains = false;
        boolean upperContains = false;
        double x1 = points[0].getX();
        double y1 = points[0].getY();
        double x2 = points[1].getX();
        double y2 = points[1].getY();
        double slope = (y2 - y1) / (x2 - x1);
        double yIntercept = y1 - slope * x1;
        mX = (points[0].getX() + points[1].getX()) / 2.0;
        mY = (points[0].getY() + points[1].getY()) / 2.0;
        upperXIterator = mX;
        upperYIterator = mY;
        lowerXIterator = mX;
        lowerYIterator = mY;
        while (upperYIterator >= y1) {
            upperXIterator = isInclined ? ((upperYIterator -= 2.0) - yIntercept) / slope : upperXIterator;
            for (hIterator = upperXIterator - 8.0; hIterator <= upperXIterator + 8.0; hIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)hIterator, (int)upperYIterator) == -1 && !(hIterator > width)) continue;
                upperContains = true;
                break;
            }
            if (!upperContains) continue;
        }
        while (lowerYIterator <= y2) {
            lowerXIterator = isInclined ? ((lowerYIterator += 2.0) - yIntercept) / slope : lowerXIterator;
            for (hIterator = lowerXIterator - 8.0; hIterator <= lowerXIterator + 8.0; hIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)hIterator, (int)lowerYIterator) == -1 && !(hIterator < 0.0) && !(lowerYIterator > height)) continue;
                lowerContains = true;
                break;
            }
            if (!lowerContains) continue;
        }
        if (y2 < y1) {
            upperXIterator = mX;
            upperYIterator = mY;
            while (upperYIterator <= y1) {
                upperXIterator = isInclined ? ((upperYIterator += 2.0) - yIntercept) / slope : upperXIterator;
                for (hIterator = upperXIterator - 8.0; hIterator <= upperXIterator + 8.0; hIterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)hIterator, (int)upperYIterator) == -1 && !(upperYIterator >= height)) continue;
                    upperContains = true;
                    break;
                }
                if (!upperContains) continue;
            }
            lowerXIterator = mX;
            lowerYIterator = mY;
            while (lowerYIterator >= y2) {
                lowerXIterator = isInclined ? ((lowerYIterator -= 2.0) - yIntercept) / slope : lowerXIterator;
                for (hIterator = lowerXIterator - 8.0; hIterator <= lowerXIterator + 8.0; hIterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)hIterator, (int)lowerYIterator) == -1 && !(lowerYIterator < 0.0)) continue;
                    lowerContains = true;
                    break;
                }
                if (!lowerContains) continue;
            }
        }
        Double referenceLineLength = null;
        Double minimumReferenceLineLength = height * this.crossRefLineToViewPortSizeRatio;
        if (lowerContains && (referenceLineLength = XpSliceCollectionRoi.getReferenceLineLength(lowerXIterator, upperXIterator, lowerYIterator, upperYIterator)) >= minimumReferenceLineLength) {
            points[1].setLocation(lowerXIterator, lowerYIterator);
            this.crossRefLinesUpdated = true;
        }
        if (upperContains && (referenceLineLength = XpSliceCollectionRoi.getReferenceLineLength(lowerXIterator, upperXIterator, lowerYIterator, upperYIterator)) >= minimumReferenceLineLength) {
            points[0].setLocation(upperXIterator, upperYIterator);
            this.crossRefLinesUpdated = true;
        }
    }

    public boolean isCrossRefLinesUpdated() {
        return this.crossRefLinesUpdated;
    }

    public boolean isAnnotationIntersectingXRef() {
        return this.annotationIntersectingSliceNumber;
    }

    public Map<Integer, Double> getInitialSlicePointsMap() {
        return this.initialSlicePointsMap;
    }

    public Map<Integer, Double> getFinalSlicePointsMap() {
        return this.finalSlicePointsMap;
    }

    @Override
    public boolean contains(XpVisualComponent vc, int x, int y) {
        return false;
    }

    public void setlineStyle(String Style2) {
        this.lineStyle = Style2;
    }

    public void setlineColor(Color c) {
        this.lineColor = c;
    }

    @Override
    public MouseInputListener getMouseInputListener() {
        return this.listener;
    }

    @Override
    public void setImage(XpImage image) {
        this.image = image;
        this.postCrossReference();
    }

    @Override
    public XpImage getImage() {
        return this.image;
    }

    @Override
    public GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
        this.roilistener.add(rel);
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
        this.roilistener.remove(rel);
    }

    @Override
    public void setSelected(boolean arg0) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    protected final void firePropertyChange(String property, Object value) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, property, null, value);
        this.pcs.firePropertyChange(e);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("ROI_MODEL", this);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public final ArrayList getActualSlicesDrawn() {
        return this.atualSlicesDrawn;
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g) {
        this.grayscaleMode = g;
    }

    private static Double getReferenceLineLength(Double x1, Double x2, Double y1, Double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    private class myXpSlice {
        private XpSlice slice = null;
        private int serNum = -1;
        private int imgNum = -1;
        private String imgUID = null;

        public myXpSlice(XpSlice sl, int ser, int img, String imguid) {
            this.slice = sl;
            this.serNum = ser;
            this.imgNum = img;
            this.imgUID = imguid;
        }

        public XpSlice getSlice() {
            return this.slice;
        }

        public int getSeriesNumber() {
            return this.serNum;
        }

        public int getImageNumber() {
            return this.imgNum;
        }

        public String getImageUID() {
            return this.imgUID;
        }

        public boolean equals(Object obj) {
            return obj instanceof myXpSlice && this.imgUID.equals(((myXpSlice)obj).getImageUID());
        }

        public int hashCode() {
            return this.imgUID.hashCode();
        }

        public Object clone() {
            myXpSlice sl = new myXpSlice((XpSlice)this.slice.clone(), this.serNum, this.imgNum, this.imgUID);
            return sl;
        }
    }
}

