/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.crossref.CvAnnotationPolicy;
import com.ge.med.cse.cvf.crossref.XpCvSliceMarker;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.marker.XpSliceMarker;
import java.awt.Container;
import java.awt.Dimension;

public class XpReferenceImageViewport
extends XpFrameVisualizer {
    XpSliceMarker sliceMarker = null;
    SliceSourceCapable ssc = null;
    boolean scaling_ = false;
    private static String annotGenerator = null;

    public XpReferenceImageViewport() {
        try {
            this.setAnnotationGenerator(CvUtils.getClass(annotGenerator), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XpAnnotationVc.setAnnotationPolicy(new CvAnnotationPolicy());
        this.setPreferredSize(new Dimension(128, 128));
        this.putClientProperty("reference_viewport", "true");
        this.setAnnotationGroup("all", true);
        this.setAnnotationItems(new String[]{"ESI_Information", "Windowing"}, true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeSliceMarker();
        this.ssc.removeSliceListener(this.sliceMarker);
        this.sliceMarker = null;
        this.ssc = null;
    }

    public void setScaling(boolean scaling) {
        this.scaling_ = scaling;
    }

    public boolean getScaling() {
        return this.scaling_;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d;
        Container parent;
        if (this.scaling_ && (parent = this.getParent()) != null && (d = parent.getSize()) != null && d.getWidth() > 0.0) {
            int w = (int)(128.0 * d.getWidth() / 512.0);
            return new Dimension(w, w);
        }
        return super.getPreferredSize();
    }

    public void setImage(XpMedicalImage img) {
        XpImageScene scene2 = new XpImageScene(img);
        this.setFrameScene(scene2, img);
    }

    public void addSliceMarker() {
        this.sliceMarker = new XpCvSliceMarker(this.getWidth(), this.getHeight());
        this.getMedicalImageVc().getImageVc().add(this.sliceMarker);
    }

    public void removeSliceMarker() {
        if (this.sliceMarker != null) {
            this.getMedicalImageVc().getImageVc().remove(this.sliceMarker);
        }
    }

    public void setSliceSourceCapable(SliceSourceCapable ssc) {
        this.ssc = ssc;
        this.sliceMarker.setSliceSourceCapable(ssc);
    }

    @Override
    public Object clone() {
        XpReferenceImageViewport vp = new XpReferenceImageViewport();
        vp.setScaling(this.getScaling());
        vp.setImage((XpMedicalImage)this.getFrame());
        vp.setImageRenderAttributes(this.getImageRenderAttributes());
        vp.addSliceMarker();
        vp.setSliceSourceCapable(this.ssc);
        return vp;
    }

    public XpSliceMarker getSliceMarker() {
        return this.sliceMarker;
    }

    public SliceSourceCapable getSliceSourceCapable() {
        return this.ssc;
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        if (agName.equals("ESI_Information") || agName.equals("Windowing") || agName.equals("none")) {
            super.setAnnotationGroup(agName, activate);
        } else if (agName.equalsIgnoreCase("all") || agName.equalsIgnoreCase("partial")) {
            super.setAnnotationGroup("ESI_Information", activate);
            super.setAnnotationGroup("Windowing", activate);
        }
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        if (annoItems != null && annoItems.length > 0) {
            for (int i = 0; i < annoItems.length; ++i) {
                if (annoItems[i].equals("ESI_Information") || annoItems[i].equals("Windowing") || annoItems[i].equals("none")) {
                    super.setAnnotationItems(new String[]{annoItems[i]}, activate);
                    continue;
                }
                if (!annoItems[i].equalsIgnoreCase("all") && !annoItems[i].equalsIgnoreCase("partial")) continue;
                super.setAnnotationGroup(annoItems[i], activate);
                super.setAnnotationItems(new String[]{"ESI_Information", "Windowing"}, activate);
            }
        }
    }

    static {
        annotGenerator = CvPropertiesManager.getProperty("cvf.annotation.generator", XpCVAnnotationGenerator.class.getName());
    }
}

