/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.hc.cse.commons.formatters.DicomUtils;
import com.ge.med.cse.cvf.comparators.DefaultImComparator;
import com.ge.med.cse.cvf.crossref.CvCrossRefUtils;
import com.ge.med.cse.cvf.crossref.CvReferenceImageDirector;
import com.ge.med.cse.cvf.crossref.XpReferenceImageDirector;
import com.ge.med.cse.cvf.crossref.XpReferenceImageManager;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpReferenceImageApp {
    public static final String REFERENCE_VP_SELECTION = "reference_vp_selection";
    protected XpReferenceImageManager refImage = null;
    protected XpViewport mvp = null;
    protected DMSession session = null;
    protected DMObject refSeries = null;
    private static final Logger logger = Logger.getLogger(XpReferenceImageApp.class.getName());
    private static Map refImageList = Collections.synchronizedMap(new HashMap());
    private static Map refToMainVpMap = Collections.synchronizedMap(new HashMap());
    private boolean force = false;
    public static final int ALL_ON = 0;
    public static final int ALL_OFF = 1;
    public static final int SELECTED_ON = 2;
    public static final int SELECTED_OFF = 3;
    public static final int CROSS_REF_ON = 4;
    public static final int CROSS_REF_OFF = 5;
    private static int refImgContext = -1;
    private static boolean compareMode;
    public static final int PL_MIX = 256;
    PropertyChangeListener mvpListsner = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpReferenceImageApp.this.removeRefImage(false);
            XpReferenceImageApp.this.mvp.repaint();
        }
    };
    private PropertyChangeListener refvpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpReferenceImageApp rApp = XpReferenceImageApp.getRefAppInstance(XpReferenceImageApp.this.mvp);
            if (null != rApp) {
                XpViewport[] refvps;
                for (XpViewport vp : refvps = rApp.refImage.getRefPorts()) {
                    vp.removePropertyChangeListener("CONTENT_CHANGED", XpReferenceImageApp.this.refvpListener);
                }
            }
            XpReferenceImageApp.this.removeRefImage(false);
            XpReferenceImageApp.this.mvp.repaint();
        }
    };
    PropertyChangeListener formatListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!XpReferenceImageApp.this.refImage.canPostRefImage(XpReferenceImageApp.this.mvp)) {
                XpReferenceImageApp.this.removeRefImage(false);
            }
            if (!XpReferenceImageApp.isCompareMode()) {
                boolean mode = ((XpReferenceImageDirector)XpReferenceImageApp.this.refImage).getCurrentMode();
                if (XpReferenceImageApp.this.refImage.getReferencePortCount() > 0 && !mode) {
                    XpReferenceImageApp.this.refImage.postReferenceImage(XpReferenceImageApp.this.force);
                }
                XpReferenceImageApp.this.mvp.repaint();
            }
        }
    };

    public static boolean isCompareMode() {
        return compareMode;
    }

    public static XpReferenceImageApp getInstance(XpViewport mainvp, boolean selected, boolean compareModeOn) {
        return XpReferenceImageApp.getInstance(mainvp, selected, false, compareModeOn);
    }

    public static XpReferenceImageApp getInstance(XpViewport mainvp, boolean selected, boolean force, boolean compareModeOn) {
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return null;
        }
        XpReferenceImageApp riapp = null;
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            riapp.setMode(selected);
            logger.log(Level.INFO, "Returning already created instance of the RefImageApp.");
            return riapp;
        }
        try {
            riapp = new XpReferenceImageApp(mainvp, selected, force, compareModeOn);
            refImageList.put(Integer.toString(mainvp.hashCode()), riapp);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Error in creating new instance of ReferenceImageApp :: " + ex);
        }
        return riapp;
    }

    public static XpReferenceImageApp copyInstance(XpViewport sourcevp, XpViewport destvp, boolean force) {
        if (sourcevp == null || destvp == null) {
            logger.log(Level.WARNING, "Source/Destination viewport is null.");
            return null;
        }
        XpReferenceImageApp destriapp = null;
        if (refImageList.containsKey(Integer.toString(destvp.hashCode()))) {
            logger.log(Level.WARNING, "Reference viewport already there on dest viewport.");
            return null;
        }
        XpReferenceImageApp riapp = null;
        if (!refImageList.containsKey(Integer.toString(sourcevp.hashCode()))) {
            logger.log(Level.WARNING, "Reference viewport not found on source viewport.");
            return null;
        }
        riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(sourcevp.hashCode()));
        try {
            XpViewport[] ports;
            destriapp = XpReferenceImageApp.getInstance(destvp, riapp.getMode(), force);
            destriapp.setSession(riapp.session);
            destriapp.setReferenceSeries(riapp.getReferenceSeries(), -1);
            if (!XpReferenceImageApp.isCompareMode()) {
                ((XpReferenceImageDirector)destriapp.refImage).setFrameIndex(riapp.refImage.getReferenceFrameIndex());
            }
            if ((ports = riapp.refImage.getRefPorts()) != null && ports.length > 0 && ports[0] instanceof XpImageRenderAttributesOwner) {
                XpImageRenderAttributes ira = ((XpImageRenderAttributesOwner)((Object)ports[0])).getImageRenderAttributes();
                if (!XpReferenceImageApp.isCompareMode()) {
                    ((XpReferenceImageDirector)destriapp.refImage).setImageRenderAttributes(ira);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Error in creating new instance of ReferenceImageApp :: " + ex);
        }
        return destriapp;
    }

    public static void postReferenceImage(XpViewport mainvp, boolean selected, boolean compareMode) {
        XpReferenceImageApp ria;
        DMSession sess;
        TransactionLogName tln = new TransactionLogName("TID=CV_referenceImageVPOn");
        logger.log(Level.INFO, "{0} begin", tln);
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        DMSystem dmsys = null;
        try {
            dmsys = CvUtils.getDMSystem();
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Exception while getting DMSystem, stack trace {0} ", new Object[]{exp});
        }
        DMSession dMSession = sess = dmsys != null ? dmsys.getLocalDB() : null;
        if (sess == null) {
            logger.log(Level.WARNING, "DMSession not set.");
            result.status = 8;
        }
        if (mainvp == null) {
            logger.log(Level.WARNING, "Selected port is null.");
            result.status = 8;
        }
        if ((ria = XpReferenceImageApp.getInstance(mainvp, selected, compareMode)) == null) {
            result.status = 8;
        } else {
            ria.setSession(sess);
            result = ria.fetchValidReferenceSeries(compareMode);
            if (result != null && result.status != -1) {
                if (ria.getRefPortCount() == 0) {
                    XpReferenceImageApp.removeReferenceImage(mainvp, false);
                }
            } else {
                ria.addReferencePortParams(mainvp, compareMode);
            }
            if (result != null) {
                XpReferenceImageApp.setOprMsg(result.status);
            }
        }
        logger.log(Level.INFO, "{0} end", tln);
    }

    private void addReferencePortParams(XpViewport mainvp, boolean compareMode) {
        if (compareMode) {
            XpViewport[] refVps;
            XpReferenceImageApp.setRefImageContext(4);
            XpReferenceImageApp riapp = XpReferenceImageApp.getRefAppInstance(mainvp);
            if (null != riapp && null != (refVps = riapp.refImage.getRefPorts())[0]) {
                refToMainVpMap.put(Integer.toString(refVps[0].hashCode()), mainvp);
                refVps[0].addPropertyChangeListener("CONTENT_CHANGED", this.refvpListener);
            }
        }
    }

    public static void postReferenceImage(XpViewport mainvp, boolean selected, int se, int im, boolean compareMode) {
        XpReferenceImageApp ria;
        DMSession sess;
        TransactionLogName tln = new TransactionLogName("TID=CV_referenceImageVPOnCmd");
        logger.log(Level.INFO, "{0} begin", tln);
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        DMSystem dmsys = null;
        try {
            dmsys = CvUtils.getDMSystem();
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Exception while getting DMSystem, stack trace {0} ", new Object[]{exp});
        }
        DMSession dMSession = sess = dmsys != null ? dmsys.getLocalDB() : null;
        if (sess == null) {
            logger.log(Level.WARNING, "DMSession not set.");
            result.status = 8;
        }
        if (mainvp == null) {
            logger.log(Level.WARNING, "Selected port is null.");
            result.status = 8;
        }
        if ((ria = XpReferenceImageApp.getInstance(mainvp, selected, compareMode)) == null) {
            result.status = 8;
        } else {
            ria.setSession(sess);
            if (se < 0) {
                result = ria.fetchValidReferenceSeries(compareMode);
                if (result != null && result.status != -1) {
                    if (ria.getRefPortCount() == 0) {
                        XpReferenceImageApp.removeReferenceImage(mainvp, false);
                    }
                } else {
                    ria.addReferencePortParams(mainvp, compareMode);
                }
                if (result != null) {
                    XpReferenceImageApp.setOprMsg(result.status);
                }
            } else {
                int status = ria.setReferenceSeriesByNumber(se, im);
                if (status != -1) {
                    if (ria.getRefPortCount() == 0) {
                        XpReferenceImageApp.removeReferenceImage(mainvp, false);
                    }
                } else {
                    ria.addReferencePortParams(mainvp, compareMode);
                }
                XpReferenceImageApp.setOprMsg(status);
            }
        }
        logger.log(Level.INFO, "{0} end", tln);
    }

    private static void setOprMsg(int status) {
        if (status != -1) {
            if (status == 0) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_NO_VALID_SE"));
            } else if (status == 1) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_INVALID_EXAM"));
            } else if (status == 2) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES"));
            } else if (status == 3) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_POS_ENTRY_LANDMARK"));
            } else if (status == 4) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_POS_ENTRY_LANDMARK"));
            } else if (status == 5) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_POS_ENTRY_LANDMARK"));
            } else if (status == 6 || status == 10) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_SAME_SCAN_PL"));
            } else if (status == 7) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REF_SERIES_NOT_FOUND"));
            } else if (status == 9) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            } else if (status == 11) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_INVALID_NO_OF_SERIES_COMPAREMODE"));
            } else {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_FAIL_MSG"));
            }
        }
    }

    public static void removeReferenceImage(XpViewport mainvp, boolean selected) {
        XpReferenceImageApp riapp;
        TransactionLogName tln = new TransactionLogName("TID=CV_referenceImageVPOff");
        logger.log(Level.INFO, "{0} begin", tln);
        if (XpReferenceImageApp.isRefPortOn(mainvp) && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            riapp.removeRefImage(selected);
        }
        logger.log(Level.INFO, "{0} end", tln);
    }

    public static Component cloneSelectedPort(XpViewport mainvp) {
        int sel = XpReferenceImageApp.getSelectedRefPortIndex(mainvp);
        if (sel == -1) {
            sel = mainvp instanceof SelectionCapable ? ((SelectionCapable)((Object)mainvp)).getComponentSelection() : 0;
        }
        if (sel != -1) {
            return XpReferenceImageApp.cloneWithRefPort(mainvp, sel);
        }
        return null;
    }

    public static int getSelectedRefPortIndex(XpViewport mainvp) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return ((XpReferenceImageDirector)riapp.refImage).getSelectedRefPortIndex();
        }
        return -1;
    }

    public static boolean isRefPortOn(XpViewport mainvp) {
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return false;
        }
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            return true;
        }
        return refToMainVpMap.containsKey(Integer.toString(mainvp.hashCode()));
    }

    public static XpReferenceImageApp getRefAppInstance(XpViewport mainvp) {
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return null;
        }
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            return (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
        }
        if (refToMainVpMap.containsKey(Integer.toString(mainvp.hashCode()))) {
            XpViewport mainPort = (XpViewport)refToMainVpMap.get(Integer.toString(mainvp.hashCode()));
            return (XpReferenceImageApp)refImageList.get(Integer.toString(mainPort.hashCode()));
        }
        logger.log(Level.WARNING, "No App instance exist for mainvp.");
        return null;
    }

    public static Component cloneWithRefPort(XpViewport mainvp, int portindex) {
        if (mainvp == null) {
            return null;
        }
        if (!XpReferenceImageApp.isRefPortOn(mainvp)) {
            return null;
        }
        XpReferenceImageApp riapp = XpReferenceImageApp.getRefAppInstance(mainvp);
        if (null != riapp) {
            if (XpReferenceImageApp.isCompareMode()) {
                return XpReferenceImageApp.cloneRefPortCompareMode(mainvp, portindex);
            }
            XpViewport port = riapp.clonePort(mainvp, portindex);
            if (port != null) {
                Component refvp = ((XpReferenceImageDirector)riapp.refImage).cloneRefPort(portindex);
                if (refvp != null) {
                    ((XpSingularPort)port).getMedicalImageVc().add(refvp, 0);
                }
                return port;
            }
        }
        return null;
    }

    private XpViewport clonePort(XpViewport mainvp, int portindex) {
        if (portindex >= 0) {
            JComponent c = null;
            c = mainvp instanceof SelectionCapable ? ((SelectionCapable)((Object)mainvp)).getViewportComponent(portindex) : mainvp;
            if (c != null) {
                XpViewport port = null;
                String renderer = CvPropertiesManager.getProperty("cvf.print.renderer");
                port = renderer != null ? CvUtils.createViewPortCopy((XpFrameVisualizer)c, renderer) : (XpViewport)((XpViewport)c).clone();
                return port;
            }
        }
        return null;
    }

    private static Component cloneRefPortCompareMode(XpViewport mainvp, int portindex) {
        if (mainvp == null) {
            return null;
        }
        XpReferenceImageApp riapp = XpReferenceImageApp.getRefAppInstance(mainvp);
        if (null == riapp) {
            return null;
        }
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            return riapp.clonePort(mainvp, portindex);
        }
        if (portindex >= 0) {
            return ((CvReferenceImageDirector)riapp.refImage).cloneRefPort(portindex);
        }
        return null;
    }

    public static Component copyRefPort(XpViewport mainvp, XpViewport destvp, int portindex) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return ((XpReferenceImageDirector)riapp.refImage).copyRefPortTo(destvp, portindex);
        }
        return null;
    }

    public static boolean isRefPortAllOn(XpViewport mainvp) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return ((XpReferenceImageDirector)riapp.refImage).isRefPortAllOn();
        }
        return false;
    }

    public static boolean isRefPortOn(XpViewport mainvp, int portindex) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return riapp.refImage.isRefPortOn(portindex);
        }
        return false;
    }

    public static int getRefPortCount(XpViewport mainvp) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return riapp.getRefPortCount();
        }
        return 0;
    }

    public static boolean isRefPortSelected(XpViewport mainvp) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return ((XpReferenceImageDirector)riapp.refImage).isRefPortSelected();
        }
        return false;
    }

    public static JComponent getSelectedRefPort(XpViewport mainvp) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return ((XpReferenceImageDirector)riapp.refImage).getSelectedRefPort();
        }
        return null;
    }

    public static void setRefPortSelection(XpViewport mainvp, int portindex) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            if (portindex < 0) {
                ((XpReferenceImageDirector)riapp.refImage).clearRefVpSelection();
            } else {
                ((XpReferenceImageDirector)riapp.refImage).setRefVpSelection(portindex);
            }
        }
    }

    public static XpViewport getRefViewportComponent(XpViewport mainvp, int index) {
        XpReferenceImageApp riapp;
        if (XpReferenceImageApp.isRefPortOn(mainvp) && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return riapp.refImage.getRefPort(index);
        }
        return null;
    }

    public static void setRefImageContext(int context) {
        refImgContext = context;
    }

    public static int getRefImageContext() {
        return refImgContext;
    }

    public static Capable getCapable(XpViewport mainvp, String capIFname) {
        XpReferenceImageApp riapp;
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return null;
        }
        if (XpReferenceImageApp.isRefPortOn(mainvp) && !XpReferenceImageApp.isCompareMode() && null != (riapp = XpReferenceImageApp.getRefAppInstance(mainvp))) {
            return ((XpReferenceImageDirector)riapp.refImage).getCapable(capIFname);
        }
        return null;
    }

    private XpReferenceImageApp(XpViewport mainvp, boolean selected, boolean force, boolean compareModeOn) {
        this.mvp = mainvp;
        this.force = force;
        compareMode = compareModeOn;
        if (compareModeOn) {
            this.refImage = new CvReferenceImageDirector(mainvp);
            this.mvp.addPropertyChangeListener("CONTENT_CHANGED", this.mvpListsner);
        } else {
            this.refImage = new XpReferenceImageDirector(mainvp, selected);
            this.mvp.addPropertyChangeListener("CONTENT_CHANGED", this.mvpListsner);
            this.mvp.addPropertyChangeListener("RowColumnProperty", this.formatListener);
        }
    }

    public void setSession(DMSession sess) {
        this.session = sess;
    }

    public void setMode(boolean selected) {
        if (!XpReferenceImageApp.isCompareMode()) {
            ((XpReferenceImageDirector)this.refImage).updateMode(selected);
        }
    }

    public boolean getMode() {
        if (!XpReferenceImageApp.isCompareMode()) {
            return ((XpReferenceImageDirector)this.refImage).getCurrentMode();
        }
        return false;
    }

    public void setReferenceSeries(DMObject refseries, int imNum) {
        if (refseries != null) {
            int numImgs = refseries.getNumberOfRelated("image");
            if (numImgs == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                return;
            }
            if (numImgs > CvUtils.getLargeSeriesSize()) {
                logger.log(Level.WARNING, "Reference Image not supported for reference Series > " + CvUtils.getLargeSeriesSize());
                return;
            }
            DMObject[] imgs = refseries.getRelated("image");
            if (imgs == null || imgs.length == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                return;
            }
            XpMedicalImage[] imgList = CvUtils.getXpImages(imgs);
            if (imgList != null) {
                Arrays.sort(imgList, new DefaultImComparator());
                this.refImage.setReferenceImageList(imgList);
                int index = Arrays.binarySearch(imgList, new Integer(imNum), new DefaultImComparator());
                if (index < 0) {
                    index = 0;
                }
                this.refImage.setReferenceFrameIndex(index);
                this.refImage.postReferenceImage(this.force);
                this.mvp.repaint();
            } else {
                logger.log(Level.WARNING, "Series does not contain images.");
            }
        } else {
            logger.log(Level.WARNING, "Not a valid reference series");
        }
    }

    public DMObject getReferenceSeries() {
        return this.refSeries;
    }

    public void removeRefImage(boolean selected) {
        this.refImage.disconnectViewport(selected);
        if (this.refImage.getReferencePortCount() == 0) {
            refImageList.remove(Integer.toString(this.mvp.hashCode()));
            Iterator it = refToMainVpMap.keySet().iterator();
            String mainVpKey = null;
            Integer keyVal = -1;
            while (it.hasNext()) {
                keyVal = it.next();
                XpViewport mainvp = (XpViewport)refToMainVpMap.get(keyVal);
                if (mainvp.hashCode() != this.mvp.hashCode()) continue;
                mainVpKey = (String)((Object)keyVal);
                break;
            }
            if (mainVpKey != null) {
                refToMainVpMap.remove(mainVpKey);
            }
            this.mvp.removePropertyChangeListener("CONTENT_CHANGED", this.mvpListsner);
            this.mvp.removePropertyChangeListener("RowColumnProperty", this.formatListener);
            if (XpReferenceImageApp.isCompareMode()) {
                XpReferenceImageApp.setRefImageContext(5);
            }
        }
        this.mvp.repaint();
    }

    public int getRefPortCount() {
        XpReferenceImageApp riapp = XpReferenceImageApp.getRefAppInstance(this.mvp);
        if (null != riapp) {
            return riapp.refImage.getReferencePortCount();
        }
        return -1;
    }

    public CvCrossRefUtils.CrossRefResult fetchValidReferenceSeries(boolean compareMode) {
        TransactionLogName tln = new TransactionLogName("TID=CV_fetchValidRefSeries");
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        result.status = 7;
        if (this.session == null) {
            logger.log(Level.WARNING, "DMSession not set.");
            return result;
        }
        DMImage img = null;
        if (this.mvp instanceof FrameOwner && this.mvp.getImages() != null && this.mvp.getImages().length != 0) {
            int sel;
            JComponent port;
            if (this.mvp instanceof SelectionCapable && (port = ((SelectionCapable)((Object)this.mvp)).getViewportComponent(sel = ((SelectionCapable)((Object)this.mvp)).getComponentSelection())) instanceof FrameOwner) {
                img = ((XpMedicalDmImage)((FrameOwner)((Object)port)).getFrame()).getDMImage();
            }
            if (!this.getMode()) {
                if (img == null) {
                    img = ((XpMedicalDmImage)((FrameOwner)((Object)this.mvp)).getFrame()).getDMImage();
                }
                if (img == null) {
                    img = ((XpMedicalDmImage)this.mvp.getImages()[0]).getDMImage();
                }
            }
            if (img == null) {
                logger.log(Level.WARNING, "No images loaded in the main viewport.");
                return result;
            }
        } else {
            logger.log(Level.WARNING, "Main viewport not instance of FrameOwner.");
            return result;
        }
        logger.log(Level.INFO, "{0} begin", tln);
        if (!XpReferenceImageApp.isCompareMode()) {
            result = CvCrossRefUtils.fetchValidReferenceSeries(this.session, img);
        } else {
            XPscreen selCap;
            String modality = DicomUtils.getModality((DMImage)img);
            if ("MR".equalsIgnoreCase(modality)) {
                Integer GEMS_se_plane;
                Integer series_plane = (Integer)img.getValue(25, 4119);
                String manuf1 = (String)img.getValue(25, 16);
                boolean GEMS_signature_19 = manuf1 != null && manuf1.trim().equals("GEMS_ACQU_01");
                Integer n = GEMS_se_plane = GEMS_signature_19 && series_plane != null ? series_plane : null;
                if (GEMS_se_plane != null && (GEMS_se_plane & 0x100) != 0) {
                    result.status = 0;
                    return result;
                }
            }
            if ((selCap = (XPscreen)SwingUtilities.getAncestorOfClass(SelectionCapable.class, this.mvp)) == null) {
                logger.log(Level.WARNING, "Viewport not valid.");
                return null;
            }
            if (selCap.getNumComponents() == 1) {
                result = CvCrossRefUtils.fetchValidReferenceSeries(this.session, img);
            } else if (selCap.getNumComponents() == 2) {
                result = this.validateSeriesOnPortForCrossReference(img);
            } else if (selCap.getNumComponents() > 2) {
                logger.log(Level.WARNING, "More than two series loaded. Cannot load in compare mode.");
                result.status = 11;
                return result;
            }
        }
        if (result != null && result.refSeries != null) {
            this.refSeries = result.refSeries;
            int numImgs = this.refSeries.getNumberOfRelated("image");
            if (numImgs == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                result.status = 7;
                return result;
            }
            if (numImgs > CvUtils.getLargeSeriesSize()) {
                logger.log(Level.WARNING, "Reference Image not supported for reference Series > " + CvUtils.getLargeSeriesSize());
                result.status = 9;
                return result;
            }
            int refNo = -1;
            DMObject[] imgs = this.refSeries.getRelated("image");
            if (imgs == null || imgs.length == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                result.status = 7;
                return result;
            }
            XpMedicalImage[] imgList = CvUtils.getXpImages(imgs);
            if (imgList != null) {
                Arrays.sort(imgList, new DefaultImComparator());
                this.refImage.setReferenceImageList(imgList);
                if (result.refImage != null) {
                    Object val = result.refImage.getValue(new DMTag(32, 19));
                    if (val != null) {
                        if (val instanceof Integer) {
                            refNo = (Integer)val;
                        } else if (val instanceof String) {
                            try {
                                refNo = Integer.parseInt((String)val);
                            }
                            catch (Exception ex) {}
                        }
                    }
                } else {
                    logger.log(Level.WARNING, "Series does not contain images.");
                }
                int index = Arrays.binarySearch(imgList, new Integer(refNo), new DefaultImComparator());
                if (index < 0) {
                    index = 0;
                }
                this.refImage.setReferenceFrameIndex(index);
                this.refImage.postReferenceImage(this.force);
                this.mvp.repaint();
            }
        } else {
            Object serid = img.getValue(new DMTag(32, 17));
            String examid = (String)img.getValue(new DMTag(32, 16));
            logger.log(Level.WARNING, "No valid reference series found for E" + examid + "/S" + serid);
        }
        logger.log(Level.INFO, "{0} end", tln);
        return result;
    }

    public int setReferenceSeriesByNumber(int serNum, int imNum) {
        if (this.session == null) {
            return 7;
        }
        if (this.mvp instanceof FrameOwner && this.mvp.getImages() != null && this.mvp.getImages().length != 0) {
            int sel;
            JComponent port;
            DMImage img = null;
            if (this.mvp instanceof SelectionCapable && (port = ((SelectionCapable)((Object)this.mvp)).getViewportComponent(sel = ((SelectionCapable)((Object)this.mvp)).getComponentSelection())) instanceof FrameOwner) {
                img = ((XpMedicalDmImage)((FrameOwner)((Object)port)).getFrame()).getDMImage();
            }
            if (!this.getMode()) {
                if (img == null) {
                    img = ((XpMedicalDmImage)((FrameOwner)((Object)this.mvp)).getFrame()).getDMImage();
                }
                if (img == null) {
                    img = ((XpMedicalDmImage)this.mvp.getImages()[0]).getDMImage();
                }
            }
            if (img == null) {
                logger.log(Level.WARNING, "No images loaded in the main viewport.");
                return 7;
            }
            String serid = (String)img.getValue(new DMTag(32, 17));
            if (Integer.parseInt(serid) == serNum) {
                logger.log(Level.WARNING, "Cannot cross reference with same series.");
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES"));
                return 2;
            }
            String examid = (String)img.getValue(new DMTag(32, 16));
            String examuid = (String)img.getValue(new DMTag(32, 13));
            String query = "(0x0020, 0x000D) = " + examuid;
            if (examid != null && examid.trim().length() > 0) {
                query = query + " AND (0x0020, 0x0010) = " + examid;
            }
            query = query + " AND (0x0020, 0x0011) = " + serNum;
            DMObject[] ser = this.session.getRelated("series", new DMQuery(query));
            CvCrossRefUtils.CrossRefResult result = null;
            int status = -1;
            DMObject refSer = null;
            DMObject refImg = null;
            if (ser != null && ser.length > 0) {
                for (int i = 0; i < ser.length; ++i) {
                    result = CvCrossRefUtils.isSeriesValidForCrossReference(ser[i], img);
                    status = result.status;
                    if (result == null || result.status != -1) continue;
                    refSer = ser[i];
                    refImg = result.refImage;
                    break;
                }
            } else {
                result = new CvCrossRefUtils.CrossRefResult();
                status = result.status = 7;
            }
            if (refSer != null) {
                Object val;
                this.refSeries = refSer;
                int numImgs = this.refSeries.getNumberOfRelated("image");
                if (numImgs == 0) {
                    logger.log(Level.WARNING, "Series does not contain images.");
                    return 7;
                }
                if (numImgs > CvUtils.getLargeSeriesSize()) {
                    logger.log(Level.WARNING, "Reference Image not supported for reference Series > " + CvUtils.getLargeSeriesSize());
                    return 9;
                }
                DMObject[] imgs = this.refSeries.getRelated("image");
                if (imgs == null || imgs.length == 0) {
                    logger.log(Level.WARNING, "Series " + serid + " does not contain images");
                    return 0;
                }
                XpMedicalImage[] imgList = CvUtils.getXpImages(imgs);
                if (imgList != null) {
                    Arrays.sort(imgList, new DefaultImComparator());
                    this.refImage.setReferenceImageList(imgList);
                } else {
                    logger.log(Level.WARNING, "Series " + serid + " does not contain images");
                }
                if (imNum < 0 && refImg != null && (val = refImg.getValue(new DMTag(32, 19))) != null) {
                    int refNo = 0;
                    if (val instanceof Integer) {
                        refNo = (Integer)val;
                    } else if (val instanceof String) {
                        try {
                            refNo = Integer.parseInt((String)val);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (refNo != 0) {
                        imNum = refNo;
                    }
                }
                if (imgList != null) {
                    int index = Arrays.binarySearch(imgList, new Integer(imNum), new DefaultImComparator());
                    if (index < 0) {
                        index = 0;
                    }
                    this.refImage.setReferenceFrameIndex(index);
                    this.refImage.postReferenceImage(this.force);
                    this.mvp.repaint();
                } else {
                    logger.log(Level.WARNING, "Series " + serid + " does not contain images");
                }
            } else {
                logger.log(Level.WARNING, "Series " + serid + " is not a valid reference series");
            }
            return status;
        }
        return 7;
    }

    private CvCrossRefUtils.CrossRefResult validateSeriesOnPortForCrossReference(DMImage target) {
        DMImage imgOnSecPort = this.getImagesFromSecondarySelectedPort();
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        result.status = -1;
        result.status = CvCrossRefUtils.isSeriesTypeValidforReference(target);
        if (result.status != -1) {
            return result;
        }
        if (this.session == null) {
            result.status = 7;
            return result;
        }
        if (imgOnSecPort == null) {
            result.status = 7;
            return result;
        }
        Object seriesnoObj = imgOnSecPort.getValue(32, 17);
        int seriesno = Integer.parseInt(seriesnoObj.toString());
        String seriesuid = (String)imgOnSecPort.getValue(32, 14);
        if (seriesno != -1) {
            String examid = (String)target.getValue(new DMTag(32, 16));
            String examuid = (String)target.getValue(new DMTag(32, 13));
            String query = "(0x0020, 0x000D) = " + examuid;
            if (examid != null && examid.trim().length() > 0) {
                query = query + " AND (0x0020, 0x0010) = " + examid;
            }
            query = query + " AND (0x0020, 0x0011) = " + seriesno;
            DMObject[] series = this.session.getRelated("series", new DMQuery(query = query + " AND (0x0020, 0x000E) = " + seriesuid));
            if (series != null && series.length > 0) {
                for (int i = 0; i < series.length; ++i) {
                    result = CvCrossRefUtils.isSeriesValidForCrossReference(series[i], target);
                    if (result == null || result.status != -1) continue;
                    return result;
                }
            }
        }
        if (result.refSeries == null) {
            result.refImage = null;
            result.status = 7;
        }
        return result;
    }

    private DMImage getImagesFromSecondarySelectedPort() {
        JComponent comp = this.getSecondarySelectedPort();
        if (comp == null) {
            logger.log(Level.INFO, "{0} SEV5 No selected port found.");
            return null;
        }
        XpViewport comPort = null;
        if (comp instanceof XpViewport) {
            comPort = (XpViewport)comp;
        }
        if (comPort instanceof FrameOwner) {
            JComponent port;
            if (comPort.getImages() == null && comPort.getImages().length == 0) {
                logger.log(Level.INFO, "{0} SEV5 Images not available.");
                return null;
            }
            DMImage img = null;
            int sel = -1;
            if (comPort instanceof SelectionCapable && (port = ((SelectionCapable)((Object)comPort)).getViewportComponent(sel = ((SelectionCapable)((Object)comPort)).getComponentSelection())) instanceof FrameOwner) {
                img = ((XpMedicalDmImage)((FrameOwner)((Object)port)).getFrame()).getDMImage();
            }
            if (img == null) {
                img = ((XpMedicalDmImage)((FrameOwner)((Object)comPort)).getFrame()).getDMImage();
            }
            if (img == null) {
                img = ((XpMedicalDmImage)comPort.getImages()[0]).getDMImage();
            }
            return img;
        }
        return null;
    }

    private JComponent getSecondarySelectedPort() {
        XPscreen screen_ = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.mvp);
        if (!(screen_ instanceof XPscreen)) {
            return null;
        }
        int secPortNo = 0;
        if (screen_.getSelectedPortNumber() == 0) {
            secPortNo = 1;
        }
        JComponent c = screen_.getPort(secPortNo);
        while (c instanceof XPscreen) {
            c = ((XPscreen)c).getSelectedPort();
        }
        return c;
    }
}

