/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.marker.XpSliceMarker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class XpCvSliceMarker
extends XpSliceMarker
implements GrayScaleCapable,
Replicable {
    private boolean grayscaleMode = false;
    private boolean showSelected = true;
    private Point[] roiDisplayPointsInXDim;
    private Point[] roiDisplayPointsInYDim;
    private SliceControlledCapable scc;

    public boolean isShowSelected() {
        return this.showSelected;
    }

    public void showSelectedOnly(boolean showSelectedOnly) {
        this.showSelected = showSelectedOnly;
    }

    public XpCvSliceMarker(double x, double y) {
        super(x, y);
    }

    @Override
    protected Point2D[] getImageIntersectionPoints(SliceControlledCapable scc, int slIdx) {
        XpImage mi = this.getImage();
        if (mi != null) {
            Point2D[] point2DArray;
            Point2D[][] cintPts = (Point2D[][])this.intPtsMap.get(scc);
            if (cintPts == null) {
                int len = scc.getNumSlices();
                cintPts = new Point2D[len][];
                XpSlice mySlice = mi.getSlice();
                for (int i = 0; i < len; ++i) {
                    XpSlice currSlice = scc.getSlice(i);
                    cintPts[i] = new Point2D[2];
                    cintPts[i][0] = new Point2D.Double();
                    cintPts[i][1] = new Point2D.Double();
                    if (currSlice == null) continue;
                    mySlice.getIntersection(currSlice, cintPts[i]);
                    if (cintPts[i][0].getX() != cintPts[i][1].getX() || cintPts[i][0].getY() != cintPts[i][1].getY()) continue;
                    cintPts[i] = mySlice.getIntersectionWithInfinite(currSlice);
                }
                this.intPtsMap.put(scc, cintPts);
            }
            if (slIdx < 0 || slIdx >= cintPts.length) {
                Point2D[] point2DArray2 = new Point2D[2];
                point2DArray2[0] = new Point2D.Double(0.0, 0.0);
                point2DArray = point2DArray2;
                point2DArray2[1] = new Point2D.Double(0.0, 0.0);
            } else {
                point2DArray = cintPts[slIdx];
            }
            return point2DArray;
        }
        return new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
    }

    @Override
    public Color getForeground() {
        if (this.isGrayScaleMode()) {
            return Color.WHITE;
        }
        return super.getForeground();
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g) {
        this.grayscaleMode = g;
    }

    private void generateDisplayCoordinates() {
        Point2D[][] points2 = null;
        CPoint[] dispPts = null;
        for (Point2D[][] points2 : this.intPtsMap.values()) {
        }
        if (points2 == null) {
            return;
        }
        CPoint[] imgPts = new CPoint[points2.length];
        dispPts = new CPoint[points2.length];
        this.roiDisplayPointsInXDim = new Point[points2.length];
        this.roiDisplayPointsInYDim = new Point[points2.length];
        CTransform ctc = this.getTransform((byte)0, (byte)1);
        if (ctc != null) {
            for (int i = 0; i < points2.length; ++i) {
                imgPts[i] = new CPoint(0);
                imgPts[i].setPoint(points2[i][0].getX(), points2[i][0].getY(), 0.0, (byte)0);
                dispPts[i] = new CPoint(1);
                ctc.transform(imgPts[i], dispPts[i]);
                if (this.roiDisplayPointsInXDim[i] == null) {
                    this.roiDisplayPointsInXDim[i] = new Point();
                }
                this.roiDisplayPointsInXDim[i].setLocation(dispPts[i].x, dispPts[i].y);
                imgPts[i].setPoint(points2[i][1].getX(), points2[i][1].getY(), 0.0, (byte)0);
                ctc.transform(imgPts[i], dispPts[i]);
                if (this.roiDisplayPointsInYDim[i] == null) {
                    this.roiDisplayPointsInYDim[i] = new Point();
                }
                this.roiDisplayPointsInYDim[i].setLocation(dispPts[i].x, dispPts[i].y);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.isShowSelected()) {
            this.generateDisplayCoordinates();
            Graphics2D g = (Graphics2D)graphics;
            Stroke st = g.getStroke();
            Stroke str = this.getMarkerStroke();
            g.setStroke(str);
            Color c = Color.WHITE;
            g.setColor(c);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this.roiDisplayPointsInXDim.length; ++i) {
                if (this.roiDisplayPointsInXDim[i].x == this.roiDisplayPointsInYDim[i].x && this.roiDisplayPointsInXDim[i].y == this.roiDisplayPointsInYDim[i].y) continue;
                g.drawLine((int)this.roiDisplayPointsInXDim[i].getX(), (int)this.roiDisplayPointsInXDim[i].getY(), (int)this.roiDisplayPointsInYDim[i].getX(), (int)this.roiDisplayPointsInYDim[i].getY());
            }
            g.setStroke(st);
        }
        super.paintComponent(graphics);
    }

    @Override
    public void setSliceSourceCapable(SliceSourceCapable ssc) {
        super.setSliceSourceCapable(ssc);
        if (ssc instanceof SliceControlledCapable) {
            this.scc = (SliceControlledCapable)ssc;
        }
    }

    public SliceSourceCapable getSliceSourceCapable() {
        return this.scc;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.scc != null) {
            Point p = me.getPoint();
            int csliceIdx = this.scc.getActiveSliceIndex();
            int idx = this.getNearestSliceIndex(this.scc, p);
            if (idx != -1 && idx != csliceIdx) {
                this.scc.setActiveSliceIndex(idx);
            }
            this.repaint();
        }
    }

    @Override
    public Object clone() {
        XpCvSliceMarker sliceMarker = new XpCvSliceMarker(this.getX(), this.getY());
        sliceMarker.showSelectedOnly(this.isShowSelected());
        sliceMarker.setSliceSourceCapable(this.getSliceSourceCapable());
        return sliceMarker;
    }
}

