/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.base.BaseScreen;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.crossref.XpCvSliceMarker;
import com.ge.med.cse.cvf.crossref.XpReferenceImageDirector;
import com.ge.med.cse.cvf.crossref.XpReferenceImageManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceListener;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CvReferenceImageDirector
implements XpReferenceImageManager {
    private XpViewport mainvpRef;
    private HashMap refvpMap = new HashMap();
    private int refindex;
    private List sliceListenerList = new ArrayList();
    private transient XpMedicalImage[] refimglist = null;
    protected boolean init;
    private int crossRefVpIndex = -1;
    private static final Logger logger = Logger.getLogger(XpReferenceImageDirector.class.getName());
    transient PropertyChangeListener selectionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CvReferenceImageDirector.this.checkRefVpSelection();
        }
    };
    transient PropertyChangeListener mainvpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("FrameIndex")) {
                Integer newIndex = (Integer)e.getNewValue();
                int index = newIndex;
                if (CvReferenceImageDirector.this.mainvpRef instanceof FrameCapable) {
                    FrameCapable fpc = (FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef);
                    for (int i = 0; i < CvReferenceImageDirector.this.sliceListenerList.size(); ++i) {
                        if (index + i >= fpc.getNumFrames()) continue;
                        XpImage img = fpc.getFrame(index + i);
                        XpSlice slice = img.getSlice();
                        SliceListener sl = (SliceListener)CvReferenceImageDirector.this.sliceListenerList.get(i);
                        if (sl == null) continue;
                        sl.setActiveSlice(this, slice);
                    }
                }
            }
        }
    };
    boolean refresh;

    public CvReferenceImageDirector(XpViewport vp) throws IllegalArgumentException {
        if (!(vp instanceof SelectionCapable)) {
            throw new IllegalArgumentException("Viewport is not Selection Capable.");
        }
        this.mainvpRef = vp;
        this.initListeners();
    }

    private void initListeners() {
        if (!this.init) {
            this.mainvpRef.addPropertyChangeListener("FrameIndex", this.mainvpListener);
            this.init = true;
        }
    }

    private void removeListeners() {
        this.mainvpRef.removePropertyChangeListener("FrameIndex", this.mainvpListener);
        this.sliceListenerList.clear();
        this.init = false;
    }

    @Override
    public int getSelectedRefPortIndex() {
        ReferenceViewportWrapper r;
        CvSeriesDisplayer refVp;
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext() && (refVp = (r = (ReferenceViewportWrapper)this.refvpMap.get(it.next())).getPort()).getPrimarySelectedIndex() != -1) {
            return this.getCrossRefVpIndex();
        }
        return -1;
    }

    @Override
    public boolean isRefPortOn(int portindex) {
        ReferenceViewportWrapper r;
        Iterator it = this.refvpMap.keySet().iterator();
        return it.hasNext() && (r = (ReferenceViewportWrapper)this.refvpMap.get(it.next())) != null && r.isAdded();
    }

    private void checkRefVpSelection() {
        XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.mainvpRef);
        if (screen == null) {
            return;
        }
        XpViewport[] vpList = this.getRefPorts();
        if (null != vpList && vpList.length > 0) {
            CvSeriesDisplayer refVp = (CvSeriesDisplayer)vpList[0];
            if (refVp.getComponentSelection() == 0) {
                screen.firePropertyChange("reference_vp_selection", false, true);
            } else {
                screen.firePropertyChange("reference_vp_selection", true, false);
            }
        }
    }

    @Override
    public int getReferenceFrameIndex() {
        return this.refindex;
    }

    @Override
    public XpViewport[] getRefPorts() {
        XpViewport[] rports = new XpViewport[this.refvpMap.size()];
        int i = 0;
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (r == null) continue;
            rports[i] = r.getPort();
            ++i;
        }
        return rports;
    }

    @Override
    public XpViewport getRefPort(int index) {
        return this.refvpMap.get(Integer.toString(index)) != null ? ((ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(index))).getPort() : null;
    }

    public int getCrossRefVpIndex() {
        return this.crossRefVpIndex;
    }

    private int getLocationOfCrossRefPortOnScreen(XPscreen screen) {
        int numPorts = screen.getNumComponents();
        int selectedPortNo = screen.getSelectedPortNumber();
        if (numPorts == 1) {
            return 1;
        }
        if (numPorts == 2) {
            if (selectedPortNo == 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public void postReferenceImage(boolean force) {
        ReferenceViewportWrapper r;
        if (!force && !this.canPostRefImage(this.mainvpRef)) {
            return;
        }
        XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.mainvpRef);
        if (screen == null) {
            return;
        }
        screen.addPropertyChangeListener("ComponentSelection", this.selectionListener);
        int selectedPortIndex = screen.getSelectedPortNumber();
        ReferenceViewportWrapper rvw = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(selectedPortIndex));
        if (rvw == null) {
            SourceViewportWrapper s = new SourceViewportWrapper(0);
            r = new ReferenceViewportWrapper(s);
            this.refvpMap.put(Integer.toString(selectedPortIndex), r);
            r.initPort();
        }
        if (this.refresh) {
            Iterator it = this.refvpMap.keySet().iterator();
            while (it.hasNext()) {
                r = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
                r.refreshImage();
            }
            this.refresh = false;
        }
        screen.firePropertyChange("reference_viewport", false, true);
        this.checkRefVpSelection();
        screen.validate();
        screen.repaint();
    }

    @Override
    public void setReferenceImageList(XpMedicalImage[] rlist) {
        if (this.refimglist != null) {
            this.refresh = true;
        }
        this.refimglist = rlist;
    }

    @Override
    public void disconnectViewport(boolean selected) {
        boolean clear = true;
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (!r.isAdded()) continue;
            clear = false;
            break;
        }
        if (!clear) {
            it = this.refvpMap.keySet().iterator();
            while (it.hasNext()) {
                ReferenceViewportWrapper rvw = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
                if (rvw == null || !rvw.isAdded()) continue;
                rvw.removePort();
                rvw.dispose();
            }
            this.refvpMap.clear();
            this.crossRefVpIndex = -1;
            this.removeListeners();
            XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.mainvpRef);
            if (screen != null) {
                screen.firePropertyChange("reference_viewport", true, false);
            }
            this.refimglist = null;
        }
        this.refresh = false;
        if (null != this.mainvpRef) {
            this.mainvpRef.validate();
            this.mainvpRef.repaint();
            if (this.refvpMap.size() == 0) {
                this.mainvpRef = null;
            }
        }
    }

    @Override
    public void setReferenceFrameIndex(int index) {
        this.refindex = index;
    }

    @Override
    public int getReferencePortCount() {
        return this.refvpMap.size();
    }

    @Override
    public boolean canPostRefImage(XpViewport vp) {
        if (vp instanceof FrameOwner) {
            if (((FrameOwner)((Object)vp)).getFrame() == null) {
                return false;
            }
        } else {
            return false;
        }
        return ((SelectionCapable)((Object)vp)).getViewportComponent(0).getWidth() >= 256 && ((SelectionCapable)((Object)vp)).getViewportComponent(0).getHeight() >= 256;
    }

    public Component cloneRefPort(int index) {
        ReferenceViewportWrapper r;
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext() && (r = (ReferenceViewportWrapper)this.refvpMap.get(it.next())) != null && r.added) {
            return (Component)r.clone();
        }
        return null;
    }

    class ReferenceViewportWrapper
    extends MouseAdapter {
        private SourceViewportWrapper svp;
        private CvSeriesDisplayer refvp;
        private boolean added;
        private XpCvSliceMarker sliceMarker;
        boolean screenOrignallyInCompareLayout = true;
        private int origPortRows = 1;
        private int origPortCols = 1;
        private int crossRefPortRows = -1;
        private int crossRefPortCols = -1;
        private Component[] onPortComps = null;
        private int indexOnPort = -1;
        transient PropertyChangeListener selectionListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CvReferenceImageDirector.this.checkRefVpSelection();
            }
        };

        public ReferenceViewportWrapper(SourceViewportWrapper svp) {
            this.svp = svp;
            this.refvp = this.getReferencePort();
            this.refvp.putClientProperty("reference_viewport", "true");
            if (CvReferenceImageDirector.this.refindex < 0 || CvReferenceImageDirector.this.refindex >= CvReferenceImageDirector.this.refimglist.length) {
                CvReferenceImageDirector.this.refindex = 0;
            }
            if (!this.screenOrignallyInCompareLayout) {
                XpMedicalImage[] imglist = new XpMedicalImage[]{CvReferenceImageDirector.this.refimglist[CvReferenceImageDirector.this.refindex]};
                this.refvp.setImages(imglist);
            } else {
                this.refvp.setFrameIndex(CvReferenceImageDirector.this.refindex);
            }
            this.refvp.setPaging(false);
            this.addSliceMarkerToRefPort(this.svp, this.refvp);
            this.refvp.setVisible(true);
            this.refvp.repaint();
            this.added = true;
        }

        public Object clone() {
            JComponent selPort;
            CvSeriesDisplayer mainVp = selPort = this.refvp;
            int selPortIdx = 0;
            while (selPort instanceof SelectionCapable) {
                SelectionCapable selCap = selPort;
                mainVp = selPort;
                selPortIdx = selCap.getComponentSelection();
                selPort = selCap.getViewportComponent(selPortIdx);
            }
            if (null != selPort && selPort instanceof XpSingularPort) {
                XpSingularPort fv = (XpSingularPort)selPort;
                if (fv.getFrame() == null) {
                    logger.log(Level.WARNING, "{0} Selected port empty");
                    return null;
                }
                if (fv != null) {
                    XpViewport port = null;
                    String renderer = CvPropertiesManager.getProperty("cvf.print.renderer");
                    port = renderer != null ? CvUtils.createViewPortCopy((XpFrameVisualizer)fv, renderer) : (XpViewport)fv.clone();
                    XpCvSliceMarker sliceMarkerObj = (XpCvSliceMarker)this.sliceMarker.clone();
                    ((XpSingularPort)port).getMedicalImageVc().getImageVc().add(sliceMarkerObj);
                    return port;
                }
            }
            return null;
        }

        private CvSeriesDisplayer getReferencePort() {
            XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, CvReferenceImageDirector.this.mainvpRef);
            if (screen == null) {
                return null;
            }
            JComponent comp = screen.getSelectedPort();
            if (comp instanceof CvSeriesDisplayer) {
                CvSeriesDisplayer serdisp = (CvSeriesDisplayer)comp;
                this.origPortRows = serdisp.getRows();
                this.origPortCols = serdisp.getCols();
                serdisp.setRowCol(1, 1);
            }
            CvReferenceImageDirector.this.crossRefVpIndex = CvReferenceImageDirector.this.getLocationOfCrossRefPortOnScreen(screen);
            CvSeriesDisplayer crossRefPort = null;
            if (screen.getNumComponents() == 1) {
                this.screenOrignallyInCompareLayout = false;
                screen.setLayout(XPscreenLayout.layout2x1());
                crossRefPort = (CvSeriesDisplayer)screen.getPort(1);
            } else {
                JComponent crossRefComp = screen.getPort(CvReferenceImageDirector.this.getCrossRefVpIndex());
                if (crossRefComp instanceof CvSeriesDisplayer) {
                    crossRefPort = (CvSeriesDisplayer)crossRefComp;
                    this.crossRefPortRows = crossRefPort.getRows();
                    this.crossRefPortCols = crossRefPort.getCols();
                    this.indexOnPort = crossRefPort.getFrameIndex();
                } else {
                    return null;
                }
            }
            crossRefPort.setRowCol(1, 1);
            if (screen instanceof BaseScreen) {
                BaseScreen bScreen = (BaseScreen)screen;
                for (Component onPortComp : this.onPortComps = bScreen.getOnPortControls(CvReferenceImageDirector.this.crossRefVpIndex)) {
                    ((BaseScreen)screen).showPortControl(CvReferenceImageDirector.this.crossRefVpIndex, onPortComp.getClass().getName(), false);
                }
            }
            return crossRefPort;
        }

        public void addSliceMarkerToRefPort(SliceSourceCapable svp, CvSeriesDisplayer refPort) {
            this.sliceMarker = new XpCvSliceMarker(refPort.getPort(0).getWidth(), refPort.getPort(0).getHeight());
            this.sliceMarker.showSelectedOnly(false);
            this.setSliceSourceCapableForSliceMarker(svp);
            refPort.getPort(0).getMedicalImageVc().getImageVc().add(this.sliceMarker);
        }

        public XpCvSliceMarker getSliceMarker() {
            return this.sliceMarker;
        }

        public void setSliceSourceCapableForSliceMarker(SliceSourceCapable svp) {
            if (this.getSliceMarker() != null) {
                this.sliceMarker.setSliceSourceCapable(svp);
            }
        }

        public void dispose() {
            if (this.refvp != null && !this.added) {
                CvUtils.dispose(this.refvp);
                this.svp.dispose();
                this.refvp = null;
                this.sliceMarker = null;
                this.svp = null;
            }
        }

        public void initPort() {
            if (this.added) {
                this.refvp.addMouseListener(this);
                this.getSliceMarker().addMouseListener(this);
            }
        }

        public void removePort() {
            if (this.getSliceMarker() != null) {
                this.refvp.getPort(0).getMedicalImageVc().getImageVc().remove(this.sliceMarker);
            }
            this.refvp.removeMouseListener(this);
            this.getSliceMarker().removeMouseListener(this);
            this.refvp.putClientProperty("reference_viewport", "false");
            XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, CvReferenceImageDirector.this.mainvpRef);
            if (screen != null) {
                CvSeriesDisplayer mainVpDisp;
                if (screen instanceof BaseScreen) {
                    for (Component onPortComp : this.onPortComps) {
                        ((BaseScreen)screen).showPortControl(CvReferenceImageDirector.this.crossRefVpIndex, onPortComp.getClass().getName(), true);
                    }
                }
                screen.removePropertyChangeListener("ComponentSelection", this.selectionListener);
                if (this.screenOrignallyInCompareLayout) {
                    this.refvp.setRowCol(this.crossRefPortRows, this.crossRefPortCols);
                    this.refvp.setPaging(true);
                    if (this.indexOnPort != -1) {
                        this.refvp.setFrameIndex(this.indexOnPort);
                    }
                } else {
                    screen.setLayout(XPscreenLayout.layout1x1());
                }
                if (CvReferenceImageDirector.this.mainvpRef instanceof CvSeriesDisplayer && (mainVpDisp = (CvSeriesDisplayer)CvReferenceImageDirector.this.mainvpRef).getRows() == 1 && mainVpDisp.getCols() == 1) {
                    mainVpDisp.setRowCol(this.origPortRows, this.origPortCols);
                }
                screen.validate();
                screen.repaint();
                this.added = false;
            }
        }

        public CvSeriesDisplayer getPort() {
            return this.refvp;
        }

        public SourceViewportWrapper getSourceViewport() {
            return this.svp;
        }

        public int getParentPortIndex() {
            return this.getSourceViewport().getPortIndex();
        }

        public void refreshImage() {
            if (CvReferenceImageDirector.this.refindex < 0 || CvReferenceImageDirector.this.refindex >= CvReferenceImageDirector.this.refimglist.length) {
                CvReferenceImageDirector.this.refindex = 0;
            }
            XpMedicalImage[] imglist = new XpMedicalImage[]{CvReferenceImageDirector.this.refimglist[CvReferenceImageDirector.this.refindex]};
            this.refvp.setImages(imglist);
        }

        public void removePropertyChangeListener(String arg0, PropertyChangeListener arg1) {
            this.refvp.removePropertyChangeListener(arg0, arg1);
        }

        public void addPropertyChangeListener(String arg0, PropertyChangeListener arg1) {
            this.refvp.addPropertyChangeListener(arg0, arg1);
        }

        public boolean isAdded() {
            return this.added;
        }
    }

    class SourceViewportWrapper
    implements SliceControlledCapable {
        int index;
        private List slList = new ArrayList();
        private SliceListener svwsl = new SliceListener(){

            @Override
            public void setActiveSlice(Object arg0, XpSlice slice) {
                try {
                    for (int i = 0; i < SourceViewportWrapper.this.slList.size(); ++i) {
                        if ((SliceListener)SourceViewportWrapper.this.slList.get(i) == null) continue;
                        ((SliceListener)SourceViewportWrapper.this.slList.get(i)).setActiveSlice(arg0, slice);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };

        public SourceViewportWrapper(int idx) {
            this.index = idx;
        }

        public int getPortIndex() {
            return this.index;
        }

        @Override
        public int getNumSlices() {
            return CvReferenceImageDirector.this.mainvpRef instanceof FrameCapable ? ((FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).getNumFrames() : 0;
        }

        @Override
        public XpSlice getSlice(int idx) {
            return CvReferenceImageDirector.this.mainvpRef instanceof FrameCapable ? ((FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).getFrame(idx).getSlice() : null;
        }

        @Override
        public XpSlice[] getSlices() {
            if (CvReferenceImageDirector.this.mainvpRef instanceof FrameCapable) {
                FrameCapable fpc = (FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef);
                int num = fpc.getNumFrames();
                XpSlice[] slices = new XpSlice[num];
                for (int i = 0; i < num; ++i) {
                    slices[i] = fpc.getFrame(i).getSlice();
                }
                return slices;
            }
            return null;
        }

        @Override
        public XpSlice getActiveSlice() {
            int idx;
            XpSlice slice = null;
            if (CvReferenceImageDirector.this.mainvpRef != null && CvReferenceImageDirector.this.mainvpRef instanceof FrameCapable && CvReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable && (idx = this.getActiveSliceIndex()) != -1) {
                XpImage img = ((FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).getFrame(idx);
                slice = img.getSlice();
            }
            return slice;
        }

        @Override
        public void setActiveSlice(XpSlice slice) {
            if (CvReferenceImageDirector.this.mainvpRef != null) {
                if (CvReferenceImageDirector.this.mainvpRef instanceof FrameCapable && CvReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable) {
                    int closestIdx = 0;
                    double closestDist = Double.MAX_VALUE;
                    CPoint ul = slice.ul;
                    int nFrames = ((FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).getNumFrames();
                    for (int i = 0; i < nFrames; ++i) {
                        XpImage image = ((FrameCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).getFrame(i);
                        XpSlice miSlice = image.getSlice();
                        double dist = miSlice.getPointToSliceDistance(ul);
                        if (!(dist < closestDist)) continue;
                        closestDist = dist;
                        closestIdx = i;
                    }
                    this.setActiveSliceIndex(closestIdx);
                }
                CvReferenceImageDirector.this.mainvpRef.repaint();
            }
        }

        @Override
        public int getActiveSliceIndex() {
            FramePositioningCapable fpc;
            int idx;
            if (CvReferenceImageDirector.this.mainvpRef != null && CvReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable && (idx = (fpc = (FramePositioningCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).getFrameIndex()) + this.index < fpc.getNumFrames()) {
                return idx + this.index;
            }
            return -1;
        }

        @Override
        public void setActiveSliceIndex(int sliceIndex) {
            if (CvReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable) {
                ((FramePositioningCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).setFrameIndex(sliceIndex - this.index);
            }
            CvReferenceImageDirector.this.mainvpRef.repaint();
        }

        @Override
        public void addSliceListener(SliceListener sl) {
            try {
                if (!CvReferenceImageDirector.this.sliceListenerList.contains(this.svwsl)) {
                    if (CvReferenceImageDirector.this.sliceListenerList.size() < this.index) {
                        for (int i = 0; i < this.index; ++i) {
                            CvReferenceImageDirector.this.sliceListenerList.add(i, null);
                        }
                    }
                    CvReferenceImageDirector.this.sliceListenerList.add(this.index, this.svwsl);
                }
                this.slList.add(sl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void removeSliceListener(SliceListener sl) {
            if (CvReferenceImageDirector.this.mainvpRef != null && CvReferenceImageDirector.this.mainvpRef instanceof SliceSourceCapable) {
                ((SliceSourceCapable)((Object)CvReferenceImageDirector.this.mainvpRef)).removeSliceListener(sl);
            }
            this.slList.remove(sl);
            if (this.slList.size() == 0) {
                CvReferenceImageDirector.this.sliceListenerList.remove(this.svwsl);
            }
        }

        public void dispose() {
            for (int i = 0; i < this.slList.size(); ++i) {
                this.removeSliceListener((SliceListener)this.slList.get(i));
            }
        }
    }
}

