/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.controls.XpZoomSlider;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpZoomPanel
extends XPcaAutoControlPanel
implements ActionListener {
    private XpZoomSlider slider = new XpZoomSlider();
    private JFormattedTextField zoomText = new JFormattedTextField();
    private DecimalFormat df = new DecimalFormat("###0.0");
    private NumberFormat numberFormatter = NumberFormat.getNumberInstance(this.getLocale());
    transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiIntiated = false;
    public static final double MAX_ZOOM = CvUtils.getMaxZoom();
    public static final double MIN_ZOOM = CvUtils.getMinZoom();
    transient PropertyChangeListener viewPortlistener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ComponentSelection")) {
                if (XpZoomPanel.this.uiIntiated) {
                    XpZoomPanel.this.updateZoomSetting();
                }
            } else if (evt.getPropertyName().equals("reference_vp_selection")) {
                XpZoomPanel.this.updateZoomSetting();
            } else if (evt.getPropertyName().equals("zoom")) {
                XpZoomPanel.this.updateZoomSetting();
            }
        }
    };
    transient ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            double zoom = 1.0;
            try {
                zoom = XpZoomPanel.this.df.parse(XpZoomPanel.this.zoomText.getText()).doubleValue();
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            if (zoom > MAX_ZOOM || zoom < MIN_ZOOM) {
                int val = XpZoomPanel.this.slider.getValue();
                double zoom1 = (double)val / 100.0;
                String zo = XpZoomPanel.this.df.format(zoom1);
                XpZoomPanel.this.zoomText.setText(zo);
            } else {
                XpZoomPanel.this.slider.setValue((int)(zoom * 100.0));
            }
        }
    };
    boolean valueChanged = false;
    transient SliderListener slider_listener = new SliderListener();

    public XpZoomPanel() {
        this.setName("XpZoomPanel");
        this.numberFormatter.setMinimumFractionDigits(1);
        TransactionLogName tln = new TransactionLogName("TID=CreateZoomPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating ZoomPanel", tln);
        this.setIcon(CvUtils.getIcon("XP_ZOOM_ICON"));
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end,Creating ZoomPanel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.updateZoomSetting();
            this.uiIntiated = true;
        }
    }

    private void initUI() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        boolean rows = false;
        this.numberFormatter.setMinimumFractionDigits(1);
        JPanel labelPanel = new JPanel();
        JLabel zoomLabel = new JLabel(CvUtils.getResourceBundle().getString("XP_ZOOM_NAME") + ":");
        labelPanel.setLayout(new FlowLayout(0));
        labelPanel.setBorder(new EmptyBorder(0, 2, 0, 5));
        labelPanel.add(zoomLabel);
        this.zoomText.setPreferredSize(new Dimension(50, 25));
        this.zoomText.setText(this.df.format(1.0));
        this.zoomText.setName("ZOOM_TEXT");
        labelPanel.add(this.zoomText);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BorderLayout());
        this.slider.removeChangeListener();
        this.slider.removePropertyChangeListener();
        this.slider.addChangeListener(this.slider_listener);
        this.slider.setMaximum((int)(MAX_ZOOM * 100.0));
        this.slider.setMinimum((int)(MIN_ZOOM * 100.0));
        this.slider.setValue(100);
        this.slider.setName("ZOOM_SLIDER");
        this.slider.setMinorTickSpacing(50);
        this.slider.setPaintTicks(true);
        this.slider.setInputMap(0, new InputMap());
        this.zoomText.addActionListener(this.listener);
        this.zoomText.addFocusListener(new ZoomFocusListener());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer((int)(MIN_ZOOM * 100.0)), new JLabel("" + this.numberFormatter.format(MIN_ZOOM)));
        labelTable.put(new Integer(100), new JLabel("" + this.numberFormatter.format(1.0)));
        labelTable.put(new Integer((int)(MAX_ZOOM * 100.0 * 1.0 / 4.0)), new JLabel("" + this.numberFormatter.format(MAX_ZOOM / 4.0)));
        labelTable.put(new Integer((int)(MAX_ZOOM * 100.0 / 2.0)), new JLabel("" + this.numberFormatter.format(MAX_ZOOM / 2.0)));
        labelTable.put(new Integer((int)(MAX_ZOOM * 100.0 * 3.0 / 4.0)), new JLabel("" + this.numberFormatter.format(MAX_ZOOM * 3.0 / 4.0)));
        labelTable.put(new Integer((int)(MAX_ZOOM * 100.0)), new JLabel(this.numberFormatter.format(MAX_ZOOM)));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        sliderPanel.add((Component)this.slider, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)labelPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 10, 0), 0, 0));
        mainPanel.add((Component)sliderPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 10, 0), 0, 0));
        String[] opts = CvPropertiesManager.getProperty("cvf.zoomPanel.quickZoomOptions", "0.5,1,2,4,8").split(",");
        if (opts != null && opts.length > 0) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            for (int i = 0; i < opts.length; ++i) {
                double zoom = Double.parseDouble(opts[i]);
                if (zoom > MAX_ZOOM || zoom < MIN_ZOOM) continue;
                JButton zbutton = new JButton();
                zbutton.setName("Zoom" + i);
                zbutton.setText(this.numberFormatter.format(zoom) + " X");
                zbutton.setFocusable(false);
                zbutton.addActionListener(this);
                buttonPanel.add((Component)zbutton, new GridBagConstraints(i, 0, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
            }
            buttonPanel.setBorder(new EmptyBorder(15, 0, 0, 0));
            mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        }
        this.add((Component)mainPanel, "North");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_ZOOM_NAME");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.removePropertyChangeListener(this.viewPortlistener);
        screen.addPropertyChangeListener(this.viewPortlistener);
    }

    private void updateZoomSetting() {
        int zoomVal;
        PanZoomCapable pz = this.getPZPort();
        if (pz != null && (zoomVal = (int)(pz.getZoom() * 100.0)) != this.slider.getValue()) {
            this.slider.removeChangeListener(this.slider_listener);
            this.slider.setValue(zoomVal);
            this.zoomText.setText("" + this.df.format(pz.getZoom()));
            this.slider.addChangeListener(this.slider_listener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        try {
            String sub = button.getText().split("X")[0].trim();
            Number number = this.numberFormatter.parse(sub);
            double zoom = number.doubleValue();
            int zoomVal = (int)(zoom * 100.0);
            this.slider.setValue(zoomVal);
            this.zoomText.setText(sub);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_ZOOM_NAME");
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TransactionLogName tln = new TransactionLogName("TID=Cv_Zoomslider");
            XpZoomPanel.this.logger.log(Level.FINE, "{0} begin", tln);
            int val = XpZoomPanel.this.slider.getValue();
            double zoom = (double)val / 100.0;
            String zo = XpZoomPanel.this.df.format(zoom);
            if (!XpZoomPanel.this.valueChanged) {
                XpZoomPanel.this.zoomText.setText(zo);
            }
            XpZoomPanel.this.valueChanged = false;
            PanZoomCapable pzPort = (PanZoomCapable)XpZoomPanel.this.getCapable(PanZoomCapable.class.getName());
            if (pzPort == null) {
                XpZoomPanel.this.logger.log(Level.INFO, "not PanZoomCapable");
                return;
            }
            pzPort.setZoom(zoom);
            pzPort.repaint();
            XpZoomPanel.this.logger.log(Level.FINE, "{0} end", tln);
        }
    }

    class ZoomFocusListener
    implements FocusListener {
        ZoomFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField txt = (JTextField)e.getSource();
            try {
                int val = XpZoomPanel.this.slider.getValue();
                double zoom = (double)val / 100.0;
                String zo = XpZoomPanel.this.df.format(zoom);
                txt.setText(zo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

