/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.BaseScreen;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.ui.XpHoverMenuPanel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.ui.FadeAwayOverLay;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class XpSetUpPanel
extends XPcaPanel
implements PlasmaControl {
    private static final Dimension iconSize = new Dimension(24, 24);
    private HashMap<String, Object> actionCache = new LinkedHashMap<String, Object>();
    private ArrayList<JCheckBox> checkBoxList = new ArrayList();
    private JButton applybtn = new JButton(CvUtils.getResourceBundle().getString("XP_APPLY_BUTTON"));
    private JButton cancelbtn = new JButton(CvUtils.getResourceBundle().getString("XP_BUT_CANCEL"));
    private static final String HOVERMENU_EAST_CTRL = "cvf.hovermenu.ctrl.east.";
    private static final String HOVERMENU_WEST_CTRL = "cvf.hovermenu.ctrl.west.";
    private static final String HOVERMENU_CENTER_CTRL = "cvf.hovermenu.ctrl.center.";
    private ArrayList<BaseAction> appspecificeastctrl = null;
    private ArrayList<BaseAction> appspecificwestctrl = null;
    private ArrayList<BaseAction> appspecificcenterctrl = null;
    private ArrayList<BaseAction> userPreferencectrls = null;
    private HashMap appspecificeastctrlMap = new HashMap();
    private HashMap appspecificwsetctrlMap = new HashMap();
    private HashMap appspecificcenterctrlMap = new HashMap();
    private Capable cap = null;
    private static final int HOVER_MENU_MAX_LIMIT = 5;
    private String hovemenueastcontrols = CvPropertiesManager.getProperty("hovermenu.eastcontrols");
    private String hovermenuwestcontrols = CvPropertiesManager.getProperty("hovermenu.westcontrols");
    private String hovermenucentercontrols = CvPropertiesManager.getProperty("hovermenu.centercontrols");
    private String maxnoofcontrols = CvPropertiesManager.getProperty("hovermenu.MaxNoOfControls");
    private int selectionindex = -1;
    private static Logger logger = Logger.getLogger(XpSetUpPanel.class.getName());
    private transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ComponentSelection") && XpSetUpPanel.this.selectionindex != (Integer)evt.getNewValue()) {
                XpSetUpPanel.this.selectionindex = (Integer)evt.getNewValue();
                XpSetUpPanel.this.setUserPreference();
            }
        }
    };

    public XpSetUpPanel() {
        this.setIcon(CvUtils.getIcon("XP_SETTINGS_ICON"));
        this.initUI();
    }

    private void initUI() {
        this.setTitle(CvUtils.getResourceBundle().getString("SetUP_Tools"));
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        String[] setuptools = CvPropertiesManager.getProperty("cvf.setup.default.actions", "").split(",");
        JPanel buttonpanel = new JPanel();
        buttonpanel.add(this.applybtn);
        this.applybtn.setName("Setup_tool_Add");
        buttonpanel.add(this.cancelbtn);
        for (String key : setuptools) {
            Component box = null;
            Object obj = this.getAction(key);
            if (obj instanceof Action) {
                try {
                    Object name = ((Action)obj).getValue("ShortDescription");
                    if (!(name == null || name.toString().trim().equals("") || key.contains("XpDisplayNormalAction") || key.contains("XpResetAllAction"))) {
                        box = new JCheckBox(name.toString());
                    } else if (((Action)obj).getValue("Name") != null && !((Action)obj).getValue("Name").toString().trim().equals("")) {
                        Object shot_description = ((Action)obj).getValue("Name");
                        box = new JCheckBox(shot_description.toString());
                    } else {
                        System.err.println("!!!!!!!!!!!!!!!!!!! Action : No name for setup tools: " + key);
                    }
                }
                catch (Exception e) {
                    System.err.println("!!!!!!!!!!!!!!Failed to get tool tip text : " + key);
                }
                if (box == null) continue;
                Object dsIcon = ((Action)obj).getValue("SmallIcon");
                if (dsIcon instanceof ImageIcon) {
                    Icon icon = null;
                    icon = key.contains("XpHorizontalTickAction") ? (ImageIcon)dsIcon : this.getScaledIcon(dsIcon);
                    if (icon != null) {
                        ((AbstractButton)box).setIcon(icon);
                    } else {
                        ((AbstractButton)box).setIcon((ImageIcon)dsIcon);
                    }
                } else if (dsIcon == null) {
                    System.err.println("!!!!!!!!!!!!!!Failed to get icon, skipping from available setupstools: " + key);
                    continue;
                }
            }
            if (box == null) continue;
            box.setName(key);
            this.checkBoxList.add((JCheckBox)box);
        }
        for (int i = 0; i < this.checkBoxList.size(); ++i) {
            JPanel p = new JPanel(new FlowLayout(0));
            p.setName("CheckBoxPanel");
            JCheckBox box = this.checkBoxList.get(i);
            String displayStr = box.getText();
            Icon icon = box.getIcon();
            box.setIcon(null);
            box.setText("");
            JLabel lab = new JLabel("  " + displayStr, icon, 2);
            box.setBorderPainted(false);
            p.add(box);
            p.add(lab);
            panel.add(p);
        }
        JScrollPane sp = new JScrollPane(panel, 20, 30);
        sp.setPreferredSize(new Dimension(300, 150));
        this.add(sp);
        this.add(buttonpanel);
        this.addActionListeners();
    }

    private void setUserPreference() {
        XpHoverMenuPanel hoverMenuPanel = null;
        String appName = null;
        if (this.cap != null) {
            if (this.cap instanceof BaseScreen) {
                BaseScreen basescreen = (BaseScreen)this.cap;
                JComponent comp = basescreen.getSelectedPort();
                if (comp != null) {
                    appName = (String)comp.getClientProperty("AppComponentName");
                    System.out.println("XpSetUpPanel.setUserPreference()" + appName);
                    if (appName == null) {
                        appName = "";
                    }
                    this.readAppSpecificcontrols(appName);
                    this.readUserPreferenceControls(appName);
                    this.setSelection(appName);
                    FadeAwayOverLay f = null;
                    if (comp.getClientProperty("FadeAwayOverLay") != null) {
                        f = (FadeAwayOverLay)comp.getClientProperty("FadeAwayOverLay");
                        Component[] component = f.getOnPortComponents();
                        for (int i = 0; i < component.length; ++i) {
                            if (!(component[i] instanceof XpHoverMenuPanel)) continue;
                            hoverMenuPanel = (XpHoverMenuPanel)component[i];
                            break;
                        }
                    }
                } else {
                    logger.log(Level.INFO, "The component is NULL");
                }
            } else if (this.cap instanceof JComponent) {
                JComponent comp = (JComponent)((Object)this.cap);
                appName = (String)comp.getClientProperty("AppComponentName");
                System.out.println("XpSetUpPanel.setUserPreference()" + appName);
                if (appName == null) {
                    appName = "";
                }
                this.readAppSpecificcontrols(appName);
                this.readUserPreferenceControls(appName);
                this.setSelection(appName);
                FadeAwayOverLay f = null;
                if (comp.getClientProperty("FadeAwayOverLay") != null) {
                    f = (FadeAwayOverLay)comp.getClientProperty("FadeAwayOverLay");
                    Component[] component = f.getOnPortComponents();
                    for (int i = 0; i < component.length; ++i) {
                        if (!(component[i] instanceof XpHoverMenuPanel)) continue;
                        hoverMenuPanel = (XpHoverMenuPanel)component[i];
                        break;
                    }
                }
            }
            if (hoverMenuPanel != null) {
                this.CreateHoverMenuPanelwithuserPreference(hoverMenuPanel, appName);
            }
        }
    }

    private void setSelection(String appName) {
        JCheckBox box;
        int j;
        int maxnumberofhovermenucontrols = 5;
        int noofhovermenucontrols = this.userPreferencectrls.size();
        try {
            maxnumberofhovermenucontrols = Integer.parseInt(this.maxnoofcontrols);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (appName.equals("")) {
            appName = "default";
        }
        for (j = 0; j < this.checkBoxList.size(); ++j) {
            JCheckBox box2 = this.checkBoxList.get(j);
            box2.setSelected(false);
        }
        block3: for (j = 0; j < this.checkBoxList.size(); ++j) {
            for (int i = 0; i < this.userPreferencectrls.size(); ++i) {
                box = this.checkBoxList.get(j);
                if (!box.getName().equals(this.userPreferencectrls.get(i).getClass().getName())) continue;
                box.setSelected(true);
                continue block3;
            }
        }
        if (this.hovermenuwestcontrols != null && !this.hovermenuwestcontrols.equalsIgnoreCase("fixed")) {
            this.appspecificwestctrl = (ArrayList)this.appspecificwsetctrlMap.get(appName);
            block5: for (j = 0; j < this.checkBoxList.size(); ++j) {
                for (int i = 0; i < this.appspecificwestctrl.size() && noofhovermenucontrols < maxnumberofhovermenucontrols; ++i) {
                    box = this.checkBoxList.get(j);
                    if (!box.getName().equals(this.appspecificwestctrl.get(i).getClass().getName())) continue;
                    box.setSelected(true);
                    continue block5;
                }
            }
        }
        if (this.hovemenueastcontrols != null && !this.hovemenueastcontrols.equalsIgnoreCase("fixed")) {
            this.appspecificeastctrl = (ArrayList)this.appspecificeastctrlMap.get(appName);
            block7: for (j = 0; j < this.checkBoxList.size(); ++j) {
                for (int i = 0; i < this.appspecificeastctrl.size(); ++i) {
                    box = this.checkBoxList.get(j);
                    if (!box.getName().equals(this.appspecificeastctrl.get(i).getClass().getName())) continue;
                    box.setSelected(true);
                    continue block7;
                }
            }
        }
        if (this.hovermenucentercontrols != null && !this.hovermenucentercontrols.equalsIgnoreCase("fixed")) {
            this.appspecificcenterctrl = (ArrayList)this.appspecificcenterctrlMap.get(appName);
            block9: for (j = 0; j < this.checkBoxList.size(); ++j) {
                for (int i = 0; i < this.appspecificeastctrl.size(); ++i) {
                    box = this.checkBoxList.get(j);
                    if (!box.getName().equals(this.appspecificeastctrl.get(i).getClass().getName())) continue;
                    box.setSelected(true);
                    continue block9;
                }
            }
        }
    }

    private void CreateHoverMenuPanelwithuserPreference(XpHoverMenuPanel hoverMenuPanel, String AppName) {
        this.readUserPreferenceControls(AppName);
        int maxnumberofhovermenucontrols = 5;
        int noofhovermenucontrols = this.userPreferencectrls.size();
        try {
            maxnumberofhovermenucontrols = Integer.parseInt(this.maxnoofcontrols);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (AppName == null || AppName.equals("")) {
            AppName = "default";
        }
        if (this.hovermenuwestcontrols != null && !this.hovermenuwestcontrols.equalsIgnoreCase("fixed")) {
            BaseAction action;
            int i;
            JPanel hovermenuwestControlpanel = new JPanel();
            for (i = 0; i < this.userPreferencectrls.size(); ++i) {
                action = this.userPreferencectrls.get(i);
                action.setCapable(this.cap);
                hoverMenuPanel.createAndAddCtrlsToPanel(hovermenuwestControlpanel, action);
            }
            this.appspecificwestctrl = (ArrayList)this.appspecificwsetctrlMap.get(AppName);
            for (i = 0; i < this.appspecificwestctrl.size() && noofhovermenucontrols < maxnumberofhovermenucontrols; ++i) {
                action = this.appspecificwestctrl.get(i);
                action.setCapable(this.cap);
                boolean isalreadyavailable = false;
                for (int j = 0; j < this.userPreferencectrls.size(); ++j) {
                    BaseAction userspecificaction = this.userPreferencectrls.get(j);
                    if (!userspecificaction.getClass().equals(action.getClass())) continue;
                    isalreadyavailable = true;
                    break;
                }
                if (isalreadyavailable) continue;
                ++noofhovermenucontrols;
                hoverMenuPanel.createAndAddCtrlsToPanel(hovermenuwestControlpanel, action);
            }
            hoverMenuPanel.addPanelsToHoverMenu(hovermenuwestControlpanel, "West");
        } else if (this.hovemenueastcontrols != null && !this.hovemenueastcontrols.equalsIgnoreCase("fixed")) {
            BaseAction action;
            int i;
            JPanel hovermenueastControlpanel = new JPanel();
            for (i = 0; i < this.userPreferencectrls.size(); ++i) {
                action = this.userPreferencectrls.get(i);
                action.setCapable(this.cap);
                hoverMenuPanel.createAndAddCtrlsToPanel(hovermenueastControlpanel, action);
            }
            this.appspecificeastctrl = (ArrayList)this.appspecificeastctrlMap.get(AppName);
            for (i = 0; i < this.appspecificeastctrl.size() && noofhovermenucontrols < maxnumberofhovermenucontrols; ++i) {
                action = this.appspecificeastctrl.get(i);
                action.setCapable(this.cap);
                boolean isalreadyavailable = false;
                for (int j = 0; j < this.userPreferencectrls.size(); ++j) {
                    BaseAction userspecificaction = this.userPreferencectrls.get(j);
                    if (!userspecificaction.getClass().equals(action.getClass())) continue;
                    isalreadyavailable = true;
                    break;
                }
                if (isalreadyavailable) continue;
                ++noofhovermenucontrols;
                hoverMenuPanel.createAndAddCtrlsToPanel(hovermenueastControlpanel, action);
            }
            hoverMenuPanel.addPanelsToHoverMenu(hovermenueastControlpanel, "East");
        } else if (this.hovermenucentercontrols != null && !this.hovermenucentercontrols.equalsIgnoreCase("fixed")) {
            BaseAction action;
            int i;
            JPanel hovermenucenterControlpanel = new JPanel();
            for (i = 0; i < this.userPreferencectrls.size(); ++i) {
                action = this.userPreferencectrls.get(i);
                action.setCapable(this.cap);
                hoverMenuPanel.createAndAddCtrlsToPanel(hovermenucenterControlpanel, action);
            }
            this.appspecificcenterctrl = (ArrayList)this.appspecificcenterctrlMap.get(AppName);
            for (i = 0; i < this.appspecificcenterctrl.size() && noofhovermenucontrols < maxnumberofhovermenucontrols; ++i) {
                action = this.appspecificcenterctrl.get(i);
                action.setCapable(this.cap);
                boolean isalreadyavailable = false;
                for (int j = 0; j < this.userPreferencectrls.size(); ++j) {
                    BaseAction userspecificaction = this.userPreferencectrls.get(j);
                    if (!userspecificaction.getClass().equals(action.getClass())) continue;
                    isalreadyavailable = true;
                    break;
                }
                if (isalreadyavailable) continue;
                ++noofhovermenucontrols;
                hoverMenuPanel.createAndAddCtrlsToPanel(hovermenucenterControlpanel, action);
            }
            hoverMenuPanel.addPanelsToHoverMenu(hovermenucenterControlpanel, "Center");
        }
    }

    private void readAppSpecificcontrols(String AppName) {
        AppName = AppName != null && !AppName.trim().equals("") ? AppName + "." : "";
        int eastCtrlCnt = 0;
        int westCtrlCnt = 0;
        int centerCtrlCnt = 0;
        Properties prop = CvPropertiesManager.getProperties();
        Set<Object> allKeys = prop.keySet();
        for (Object key : allKeys) {
            if (key.toString().startsWith(AppName + HOVERMENU_EAST_CTRL)) {
                ++eastCtrlCnt;
                continue;
            }
            if (key.toString().startsWith(AppName + HOVERMENU_WEST_CTRL)) {
                ++westCtrlCnt;
                continue;
            }
            if (!key.toString().startsWith(AppName + HOVERMENU_CENTER_CTRL)) continue;
            ++centerCtrlCnt;
        }
        this.appspecificeastctrl = new ArrayList();
        this.appspecificwestctrl = new ArrayList();
        this.appspecificcenterctrl = new ArrayList();
        if (this.hovemenueastcontrols != null && !this.hovemenueastcontrols.equalsIgnoreCase("fixed")) {
            if (eastCtrlCnt == 0) {
                return;
            }
            this.addcontrolsToarrayList(prop, eastCtrlCnt, AppName + HOVERMENU_EAST_CTRL, this.appspecificeastctrl);
            if (AppName == null || AppName.trim().equals("")) {
                this.appspecificeastctrlMap.put("default", this.appspecificeastctrl);
            } else {
                this.appspecificeastctrlMap.put(AppName.substring(0, AppName.lastIndexOf(".")), this.appspecificeastctrl);
            }
        }
        if (this.hovermenuwestcontrols != null && !this.hovermenuwestcontrols.equalsIgnoreCase("fixed")) {
            if (westCtrlCnt == 0) {
                return;
            }
            this.addcontrolsToarrayList(prop, westCtrlCnt, AppName + HOVERMENU_WEST_CTRL, this.appspecificwestctrl);
            if (AppName == null || AppName.trim().equals("")) {
                this.appspecificwsetctrlMap.put("default", this.appspecificwestctrl);
            } else {
                this.appspecificwsetctrlMap.put(AppName.substring(0, AppName.lastIndexOf(".")), this.appspecificwestctrl);
            }
        }
        if (this.hovermenucentercontrols != null && !this.hovermenucentercontrols.equalsIgnoreCase("fixed")) {
            this.addcontrolsToarrayList(prop, centerCtrlCnt, AppName + HOVERMENU_CENTER_CTRL, this.appspecificcenterctrl);
            if (AppName == null || AppName.trim().equals("")) {
                this.appspecificcenterctrlMap.put("default", this.appspecificcenterctrl);
            } else {
                this.appspecificcenterctrlMap.put(AppName.substring(0, AppName.lastIndexOf(".")), this.appspecificcenterctrl);
            }
        }
    }

    private void readUserPreferenceControls(String Appname) {
        this.userPreferencectrls = new ArrayList();
        String myfavoritehovermenu = XPDisplayPrefsUtils.getMyFavoriteHoverMenu(Appname);
        String[] str = myfavoritehovermenu.split(",");
        for (int i = 0; i < str.length; ++i) {
            String actionclass = str[i].trim();
            if (actionclass.equals("")) continue;
            try {
                Class c = CvUtils.getClass(actionclass);
                Object o = c.newInstance();
                BaseAction ba = (BaseAction)o;
                this.userPreferencectrls.add(ba);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addcontrolsToarrayList(Properties prop, int count, String locProp, ArrayList list) {
        for (int i = 0; i < count; ++i) {
            String actionclass = prop.getProperty(locProp + i);
            try {
                Class c = CvUtils.getClass(actionclass);
                Object o = c.newInstance();
                BaseAction ba = (BaseAction)o;
                list.add(ba);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addActionListeners() {
        this.applybtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent comp;
                int maxnumberofhovermenucontrols = 5;
                int noofhovermenucontrolsselected = 0;
                String appName = "";
                if (XpSetUpPanel.this.cap instanceof BaseScreen) {
                    BaseScreen basescreen = (BaseScreen)XpSetUpPanel.this.cap;
                    JComponent comp2 = basescreen.getSelectedPort();
                    appName = (String)comp2.getClientProperty("AppComponentName");
                } else if (XpSetUpPanel.this.cap instanceof JComponent) {
                    JComponent comp3 = (JComponent)((Object)XpSetUpPanel.this.cap);
                    appName = (String)comp3.getClientProperty("AppComponentName");
                }
                try {
                    maxnumberofhovermenucontrols = Integer.parseInt(XpSetUpPanel.this.maxnoofcontrols);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                String myfavoritehovermenu = "";
                for (int i = 0; i < XpSetUpPanel.this.checkBoxList.size(); ++i) {
                    int output;
                    JCheckBox box = (JCheckBox)XpSetUpPanel.this.checkBoxList.get(i);
                    if (box.isSelected()) {
                        ++noofhovermenucontrolsselected;
                        myfavoritehovermenu = myfavoritehovermenu + box.getName() + ",";
                    }
                    if (noofhovermenucontrolsselected <= maxnumberofhovermenucontrols) continue;
                    comp = null;
                    if (XpSetUpPanel.this.cap instanceof BaseScreen) {
                        comp = (BaseScreen)comp;
                    }
                    if ((output = JOptionPane.showOptionDialog(comp, CvUtils.getResourceBundle().getString("MY_TOOLS_EXCEEDED") + maxnumberofhovermenucontrols, CvUtils.getResourceBundle().getString("SetUP_Tools"), 0, 1, null, new String[]{CvUtils.getResourceBundle().getString("XP_BUT_OK")}, "default")) != 0) continue;
                    XpSetUpPanel.this.setSelection(appName);
                    return;
                }
                if (myfavoritehovermenu.contains(",")) {
                    myfavoritehovermenu = myfavoritehovermenu.substring(0, myfavoritehovermenu.lastIndexOf(","));
                }
                XpHoverMenuPanel hoverMenuPanel = null;
                if (XpSetUpPanel.this.cap instanceof BaseScreen) {
                    Component[] component;
                    int i;
                    BaseScreen basescreen = (BaseScreen)XpSetUpPanel.this.cap;
                    comp = basescreen.getSelectedPort();
                    XPDisplayPrefsUtils.saveMyfavoriteHovermenuPanels(appName, myfavoritehovermenu);
                    FadeAwayOverLay f = null;
                    if (comp.getClientProperty("FadeAwayOverLay") != null && (i = 0) < (component = (f = (FadeAwayOverLay)comp.getClientProperty("FadeAwayOverLay")).getOnPortComponents()).length && component[i] instanceof XpHoverMenuPanel) {
                        hoverMenuPanel = (XpHoverMenuPanel)component[i];
                    }
                } else if (XpSetUpPanel.this.cap instanceof JComponent) {
                    Component[] component;
                    int i;
                    JComponent comp4 = (JComponent)((Object)XpSetUpPanel.this.cap);
                    XPDisplayPrefsUtils.saveMyfavoriteHovermenuPanels(appName, myfavoritehovermenu);
                    FadeAwayOverLay f = null;
                    if (comp4.getClientProperty("FadeAwayOverLay") != null && (i = 0) < (component = (f = (FadeAwayOverLay)comp4.getClientProperty("FadeAwayOverLay")).getOnPortComponents()).length && component[i] instanceof XpHoverMenuPanel) {
                        hoverMenuPanel = (XpHoverMenuPanel)component[i];
                    }
                }
                if (hoverMenuPanel != null) {
                    XpSetUpPanel.this.CreateHoverMenuPanelwithuserPreference(hoverMenuPanel, appName);
                }
            }
        });
        this.cancelbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String appName = "";
                if (XpSetUpPanel.this.cap instanceof BaseScreen) {
                    BaseScreen basescreen = (BaseScreen)XpSetUpPanel.this.cap;
                    JComponent comp = basescreen.getSelectedPort();
                    appName = (String)comp.getClientProperty("AppComponentName");
                } else if (XpSetUpPanel.this.cap instanceof JComponent) {
                    JComponent comp = (JComponent)((Object)XpSetUpPanel.this.cap);
                    appName = (String)comp.getClientProperty("AppComponentName");
                }
                XpSetUpPanel.this.setSelection(appName);
            }
        });
    }

    private Object getAction(String actionKey) {
        if (actionKey != null && !actionKey.equals("")) {
            if (this.actionCache.containsKey(actionKey.trim())) {
                return this.actionCache.get(actionKey);
            }
            try {
                Object action = CvUtils.getClass(actionKey.trim()).newInstance();
                this.actionCache.put(actionKey.trim(), action);
                return action;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Icon getScaledIcon(Object icon) {
        ImageIcon ic = null;
        if (icon instanceof ImageIcon) {
            Image img = ((ImageIcon)icon).getImage();
            if (img != null) {
                ic = new ImageIcon(img.getScaledInstance(XpSetUpPanel.iconSize.width, XpSetUpPanel.iconSize.height, 4));
                return ic;
            }
            return (ImageIcon)icon;
        }
        if (icon instanceof Icon) {
            return (Icon)icon;
        }
        return ic;
    }

    public static void main(String[] args) {
    }

    @Override
    public void setCapable(Capable s) {
        this.cap = s;
        this.setUserPreference();
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.cap = screen;
        screen.addPropertyChangeListener(this.vpListener);
        if (screen != null) {
            this.setUserPreference();
        }
    }
}

