/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class XpScreenPresentationPanel
extends XPcaAutoControlPanel
implements ItemListener {
    private DefaultComboBoxModel screenListModel = new DefaultComboBoxModel();
    private JComboBox screenLists = new JComboBox(this.screenListModel);
    private JLabel label;
    private static final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private VScreenSupport vsSupport;

    public XpScreenPresentationPanel() {
        TransactionLogName tid = new TransactionLogName("TID=ScreenPresentationPanel");
        logger.log(Level.FINE, "{0} begin, Creating screen presentation panel", tid);
        this.initUI();
        logger.log(Level.FINE, "{0} end, Creating screen presentation panel", tid);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("P10")));
        this.setName("screenPresentationPanel");
        this.screenLists.setName("screenPresentationList");
        this.screenLists.setRenderer(new ItemRenderer());
        this.label = new JLabel(" " + CvUtils.getResourceBundle().getString("XP_SCREEN_PRESENTATION_LEBEL"));
        JPanel screenLayoutsPanel = new JPanel();
        screenLayoutsPanel.setLayout(new GridLayout(1, 2));
        screenLayoutsPanel.setBackground(UIManager.getColor("P8"));
        screenLayoutsPanel.add(this.label);
        screenLayoutsPanel.add(this.screenLists);
        this.add((Component)screenLayoutsPanel, "North");
        this.screenLists.addItemListener(this);
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
    }

    private void addItems(String[] screens) {
        this.screenListModel.removeAllElements();
        for (int i = 0; i < screens.length; ++i) {
            this.screenListModel.addElement(screens[i]);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("XpScreenPresentationPanel");
        frame.getContentPane().add(new XpScreenPresentationPanel());
        frame.setSize(new Dimension(512, 512));
        frame.pack();
        frame.setVisible(true);
    }

    public void setVScreenSupport(VScreenSupport vscreenSupport) {
        this.vsSupport = vscreenSupport;
        if (this.vsSupport != null) {
            this.addItems(this.vsSupport.getVScreens());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() instanceof String && this.vsSupport != null) {
            String screen = (String)e.getItem();
            ContextProvider.getApplicationContext((String)this.getScreen().getClientProperty("APP_IDENTIFIER")).setCurrentScreen(screen);
            this.vsSupport.setVScreen(screen);
        }
    }

    public static interface VScreenSupport {
        public String[] getVScreens();

        public void setVScreen(String var1);
    }

    private class ItemRenderer
    extends JLabel
    implements ListCellRenderer {
        public ItemRenderer() {
            this.setOpaque(true);
            this.setIconTextGap(10);
            this.setHorizontalAlignment(2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(UIManager.getColor("P8"));
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(UIManager.getColor("P7"));
                this.setForeground(list.getForeground());
            }
            int width = (int)this.getPreferredSize().getWidth();
            if (width != 0) {
                this.setPreferredSize(new Dimension(width + 20, 20));
            }
            if (value instanceof String) {
                this.setText((String)value);
            } else {
                logger.log(Level.INFO, "Item = " + value + " is not valid for screen presentation.");
            }
            return this;
        }
    }
}

