/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ScreenLayoutHelper;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public class XpScreenLayoutPanel
extends XPcaAutoControlPanel {
    private final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    public static final String LOAD_DATA = "load_data";
    private JToggleButton[] layoutBtn = null;
    private static final String XP_SCREEN_LAYOUT_TOOLTIP = CvUtils.getResourceBundle().getString("XP_SCREEN_LAYOUT_TOOLTIP");
    private static final String XP_SCREEN_LAYOUT_NAME = CvUtils.getResourceBundle().getString("XP_SCREEN_LAYOUT_NAME");
    transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("layout_changed") && XpScreenLayoutPanel.this.getScreen().getScreenLayout() instanceof XPscreenLayout) {
                XPscreenLayout scrnLayout = XpScreenLayoutPanel.this.getScreen().getScreenLayout();
                String layout = XPscreenLayout.getLayoutName(scrnLayout.getLayoutString());
                for (int i = 0; i < XpScreenLayoutPanel.this.layoutBtn.length; ++i) {
                    if (!XpScreenLayoutPanel.this.layoutBtn[i].getName().equalsIgnoreCase(layout)) continue;
                    XpScreenLayoutPanel.this.logger.log(Level.INFO, "Screen layout changed to:" + layout);
                    if (XpScreenLayoutPanel.this.layoutBtn[i].isSelected()) break;
                    XpScreenLayoutPanel.this.layoutBtn[i].setSelected(true);
                    break;
                }
            }
        }
    };

    public XpScreenLayoutPanel() {
        TransactionLogName tid = new TransactionLogName("TID=ScreenLayoutPanel");
        this.logger.log(Level.FINE, "{0} begin, Creating ScreenLayout panel", tid);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end, Creating ScreenLayout panel", tid);
    }

    private void initUI() {
        final HashMap<String, XPscreenLayout> layouts = ScreenLayoutHelper.getInstance().getConfiguredLayouts();
        this.setIcon(CvUtils.getIcon("XP_LAYOUT_ICON"));
        this.setTitle(XP_SCREEN_LAYOUT_NAME);
        this.setOpaque(false);
        this.setName("screenLayoutPanel");
        this.setToolTipText(XP_SCREEN_LAYOUT_TOOLTIP);
        this.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        String[] names = layouts.keySet().toArray(new String[layouts.size()]);
        this.layoutBtn = new JToggleButton[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.layoutBtn[i] = new JToggleButton(CvUtils.getIcon("XP_" + names[i].trim() + "_ICON"));
            this.layoutBtn[i].setName(names[i].trim());
            this.layoutBtn[i].setPreferredSize(new Dimension(60, 40));
            this.layoutBtn[i].setMargin(new Insets(0, 0, 0, 0));
            bg.add(this.layoutBtn[i]);
            this.add((Component)this.layoutBtn[i], new GridBagConstraints(i + 1, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.layoutBtn[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JToggleButton button = (JToggleButton)e.getSource();
                    XpScreenLayoutPanel.this.getScreen().setLayout((XPscreenLayout)layouts.get(button.getName()));
                }
            });
        }
        this.layoutBtn[0].setSelected(true);
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.removePropertyChangeListener("layout_changed", this.vpListener);
        screen.addPropertyChangeListener("layout_changed", this.vpListener);
        if (this.getScreen().getLayout() instanceof XPscreenLayout) {
            XPscreenLayout scrnLayout = (XPscreenLayout)this.getScreen().getLayout();
            String layout = XPscreenLayout.getLayoutName(scrnLayout.getLayoutString());
            for (int i = 0; i < this.layoutBtn.length; ++i) {
                if (!this.layoutBtn[i].getName().equalsIgnoreCase(layout)) continue;
                this.logger.log(Level.INFO, "Screen layout changed to:" + layout);
                if (this.layoutBtn[i].isSelected()) break;
                this.layoutBtn[i].setSelected(true);
                break;
            }
        }
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_SCREEN_LAYOUT_NAME");
    }
}

