/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpSaveStateAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.NumericDocument;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class XpSaveStatePanel
extends XPcaAutoControlPanel
implements PropertyChangeListener {
    private JButton saveStateButton = null;
    private JLabel seriesDescLabel = null;
    private JTextField seriesDescTxt = null;
    private JRadioButton allImageRadioButton = null;
    private JRadioButton rangeImageRadioButton = null;
    private JRadioButton selectedImageRadioButton = null;
    private JLabel fromImageLabel = null;
    private JTextField fromImageTxtFld = null;
    private JLabel toImageLabel = null;
    private JTextField toImageTxtFld = null;
    private JPanel mainPanel = null;
    private JPanel userInputPanel = null;
    private JPanel radioButtonPanel = null;
    private JPanel imageRangePanel = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private XpSaveStateAction saveStateAction = new XpSaveStateAction();
    private final int ALL_IMAGE_MODE = 0;
    private final int ONLY_SEL_IMAGE_MODE = 1;
    private final int SEL_IMAGES_MODE = 2;
    private final int IMAGE_RANGE_MODE = 3;
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");

    public XpSaveStatePanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateSaveStatePanel");
        this.logger.log(Level.FINE, "{0} begin,Creating SaveStatePanel", tln);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating SaveStatePanel", tln);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        String seriesDescLabelString = CvUtils.getResourceBundle().getString("XP_SAVE_STATE_SERIES_DESC");
        GridBagConstraints bagConstraints = new GridBagConstraints();
        this.setTitle(CvUtils.getResourceBundle().getString("XP_SAVE_STATE_TITLE"));
        this.setIcon(CvUtils.getIcon("XP_SAVE_STATE_ICON"));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(this.gridBagLayout);
        this.mainPanel.setName(XpSaveStatePanel.class.getName() + "mainPanel");
        this.seriesDescLabel = new JLabel();
        this.seriesDescLabel.setText(seriesDescLabelString);
        this.seriesDescLabel.setName(XpSaveStatePanel.class.getName() + "seriesDescLabel");
        this.seriesDescLabel.setSize(new Dimension(seriesDescLabelString.length(), 50));
        bagConstraints.weightx = 0.0;
        bagConstraints.gridy = 0;
        this.seriesDescTxt = new JTextField();
        this.seriesDescTxt.setName("seriesDescTxt");
        this.seriesDescTxt.setPreferredSize(new Dimension(150, 35));
        this.seriesDescTxt.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                XpSaveStatePanel.this.saveStateAction.setSeriesDescription(XpSaveStatePanel.this.seriesDescTxt.getText().toUpperCase().trim());
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.userInputPanel = new JPanel();
        this.userInputPanel.add((Component)this.seriesDescLabel, null);
        this.userInputPanel.add((Component)this.seriesDescTxt, null);
        this.userInputPanel.setName(XpSaveStatePanel.class.getName() + "userInputPanel");
        this.mainPanel.add((Component)this.userInputPanel, bagConstraints);
        String allRadioString = CvUtils.getResourceBundle().getString("XP_SAVE_STATE_ALL_IMG");
        String selImageString = CvUtils.getResourceBundle().getString("XP_SAVE_STATE_ONLY_ONE_IMG");
        String rangeImageString = CvUtils.getResourceBundle().getString("XP_SAVE_STATE_IMG_RANGE");
        this.allImageRadioButton = new JRadioButton();
        this.allImageRadioButton.setName("allImageRadioButton");
        this.selectedImageRadioButton = new JRadioButton();
        this.selectedImageRadioButton.setName("selectedImageRadioButton");
        this.rangeImageRadioButton = new JRadioButton();
        this.rangeImageRadioButton.setName("rangeImageRadioButton");
        this.allImageRadioButton.setText(allRadioString);
        this.allImageRadioButton.setFocusable(false);
        this.allImageRadioButton.setSelected(true);
        this.selectedImageRadioButton.setText(selImageString);
        this.selectedImageRadioButton.setFocusable(false);
        this.rangeImageRadioButton.setText(rangeImageString);
        this.rangeImageRadioButton.setFocusable(false);
        this.allImageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpSaveStatePanel.this.resetSelection();
                XpSaveStatePanel.this.allImageAction();
            }
        });
        this.selectedImageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpSaveStatePanel.this.resetSelection();
                XpSaveStatePanel.this.onlySelImageAction();
            }
        });
        this.rangeImageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpSaveStatePanel.this.resetSelection();
                XpSaveStatePanel.this.rangeImageAction();
            }
        });
        this.buttonGroup.add(this.allImageRadioButton);
        this.buttonGroup.add(this.selectedImageRadioButton);
        this.buttonGroup.add(this.rangeImageRadioButton);
        this.radioButtonPanel = new JPanel();
        this.radioButtonPanel.setName(XpSaveStatePanel.class.getName() + "radioButtonPanel");
        this.radioButtonPanel.setLayout(new GridLayout(3, 1));
        this.radioButtonPanel.add(this.allImageRadioButton);
        this.radioButtonPanel.add(this.selectedImageRadioButton);
        this.radioButtonPanel.add(this.rangeImageRadioButton);
        bagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.radioButtonPanel, bagConstraints);
        String fromImageStr = CvUtils.getResourceBundle().getString("XP_SAVE_STATE_FRM_IMG");
        String toImageStr = CvUtils.getResourceBundle().getString("XP_SAVE_STATE_TO_IMG");
        this.fromImageLabel = new JLabel();
        this.fromImageLabel.setName(XpSaveStatePanel.class.getName() + "fromImageLabel");
        this.toImageLabel = new JLabel();
        this.toImageLabel.setName(XpSaveStatePanel.class.getName() + "toImageLabel");
        this.fromImageTxtFld = new JTextField();
        this.fromImageTxtFld.setName("fromImageTxtFld");
        this.fromImageLabel.setText(fromImageStr);
        this.toImageLabel.setText(toImageStr);
        this.imageRangePanel = new JPanel();
        this.imageRangePanel.setName(XpSaveStatePanel.class.getName() + "imageRangePanel");
        this.imageRangePanel.add((Component)this.fromImageLabel, null);
        this.fromImageTxtFld.setPreferredSize(new Dimension(50, 35));
        this.fromImageTxtFld.setDocument(new NumericDocument());
        this.imageRangePanel.add((Component)this.fromImageTxtFld, null);
        this.imageRangePanel.add((Component)this.toImageLabel, null);
        this.toImageTxtFld = new JTextField();
        this.toImageTxtFld.setName("toImageTxtFld");
        this.toImageTxtFld.setPreferredSize(new Dimension(50, 35));
        this.toImageTxtFld.setDocument(new NumericDocument());
        this.imageRangePanel.add((Component)this.toImageTxtFld, null);
        bagConstraints.gridy = 2;
        this.toImageTxtFld.setEnabled(false);
        this.fromImageTxtFld.setEnabled(false);
        this.mainPanel.add((Component)this.imageRangePanel, bagConstraints);
        bagConstraints.weightx = 0.0;
        bagConstraints.gridy = 3;
        bagConstraints.anchor = 20;
        bagConstraints.insets = new Insets(10, 0, 0, 0);
        this.saveStateButton = new JButton();
        this.saveStateButton.setName("saveStateButton");
        this.saveStateButton.setIcon(CvUtils.getIcon("XP_SAVE_STATE_ICON"));
        this.saveStateButton.setFocusable(false);
        this.saveStateButton.setAction(this.saveStateAction);
        this.saveStateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpSaveStatePanel.this.saveStateAction.setSeriesDescription(XpSaveStatePanel.this.seriesDescTxt.getText().toUpperCase().trim());
                if (XpSaveStatePanel.this.rangeImageRadioButton.isSelected()) {
                    String from = XpSaveStatePanel.this.fromImageTxtFld.getText();
                    String to = XpSaveStatePanel.this.toImageTxtFld.getText();
                    int range0 = Integer.parseInt(from.equalsIgnoreCase("") ? "0" : from);
                    int range1 = Integer.parseInt(to.equalsIgnoreCase("") ? "0" : to);
                    XpSaveStatePanel.this.saveStateAction.setImageRange(range0, range1);
                }
            }
        });
        this.mainPanel.add((Component)this.saveStateButton, bagConstraints);
        this.add((Component)this.mainPanel, "North");
    }

    private void allImageAction() {
        this.saveStateAction.setMode(0);
        this.setRangeFieldEnable(false);
    }

    private void rangeImageAction() {
        this.saveStateAction.setMode(3);
        this.setRangeFieldEnable(true);
    }

    private void selImagesAction() {
        this.saveStateAction.setMode(2);
        this.setRangeFieldEnable(false);
    }

    private void onlySelImageAction() {
        this.saveStateAction.setMode(1);
        this.setRangeFieldEnable(false);
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.addPropertyChangeListener(this);
        try {
            Action act = this.saveStateButton.getAction();
            if (act instanceof PlasmaControl) {
                ((PlasmaControl)((Object)act)).setCapable(screen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_SAVE_STATE_NAME");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("CONTENT_CHANGED")) {
            this.resetSelection();
        }
    }

    private void resetSelection() {
        FramePositioningCapable fpc = (FramePositioningCapable)this.screen_.getCapable(FramePositioningCapable.class.getName());
        this.fromImageTxtFld.setText("1");
        this.toImageTxtFld.setText("" + fpc.getNumFrames());
    }

    private void setRangeFieldEnable(boolean flag) {
        this.fromImageTxtFld.setEnabled(flag);
        this.toImageTxtFld.setEnabled(flag);
    }
}

