/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ToolManager;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;

public class XpMyToolPanel
extends XPcaAutoControlPanel
implements PlasmaControl {
    boolean uiIntiated = false;
    private static final Dimension iconSize = new Dimension(24, 24);
    private Capable cap = null;
    private int extraToolCount = 1;
    ArrayList<JCheckBox> checkBoxList = new ArrayList();
    XPscreen screen = null;
    transient PropertyChangeListener myToolsChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ((Integer)evt.getNewValue() == ToolManager.getInstance().ADD_TOOL_FROM_MOUSE_RIGHT_MENU) {
                XpMyToolPanel.this.updateSelection();
            }
        }
    };

    public XpMyToolPanel() {
        this.setToolTipText(CvUtils.getResourceBundle().getString("XP_MY_TOOL_NAME"));
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            CvUtils.updateBackground(this, LookAndFeelFactory.getColor(null, "P9"));
        }
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (!this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, LookAndFeelFactory.getColor(null, "P9"));
        }
    }

    private void initUI() {
        String[] keys;
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        if (ToolManager.getInstance().getActions() == null || ToolManager.getInstance().getActions().size() == 0) {
            this.uiIntiated = false;
            return;
        }
        String exclude_Tools = CvPropertiesManager.getProperty("mytool_exclude");
        for (String key : keys = CvPropertiesManager.getProperty("mytoolsettings", "").split(",")) {
            try {
                Icon icon;
                if (exclude_Tools != null && exclude_Tools.contains(key)) continue;
                Object obj = ToolManager.getInstance().getAction(key);
                JCheckBox box = null;
                if (obj instanceof XPcaPanel) {
                    XPcaPanel cap = (XPcaPanel)obj;
                    icon = cap.getIcon();
                    if (icon != null) {
                        String compName = cap.getName();
                        if (compName == null) {
                            Object toolObj = ToolManager.getInstance().getAllToolsMaps().get(key).get(0);
                            if (toolObj instanceof JComponent) {
                                compName = ((JComponent)toolObj).getToolTipText();
                            } else if (toolObj instanceof JToggleButton) {
                                compName = ((JToggleButton)toolObj).getToolTipText();
                            } else {
                                System.err.println("Tool Tip is not exist !!!!!!!!!!!!!!! :" + toolObj);
                            }
                        }
                        box = new JCheckBox(compName);
                        box.setIcon(XpMyToolPanel.getScaledIcon(icon));
                    } else {
                        System.err.println("No Icon : skipping ----------------->" + key);
                    }
                } else if (obj instanceof Action) {
                    try {
                        Object name = ((Action)obj).getValue("ShortDescription");
                        if (!(name == null || name.toString().trim().equals("") || key.contains("XpDisplayNormalAction") || key.contains("XpResetAllAction"))) {
                            box = new JCheckBox(name.toString());
                        } else if (((Action)obj).getValue("Name") != null && !((Action)obj).getValue("Name").toString().trim().equals("")) {
                            Object shot_description = ((Action)obj).getValue("Name");
                            box = new JCheckBox(shot_description.toString());
                        } else {
                            System.err.println("!!!!!!!!!!!!!!!!!!! Action : No name for my tools: " + key);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("!!!!!!!!!!!!!!Failed to get tool tip text : " + key);
                    }
                    if (box == null) continue;
                    Object dsIcon = ((Action)obj).getValue("SmallIcon");
                    if (dsIcon instanceof ImageIcon) {
                        icon = null;
                        icon = key.contains("XpHorizontalTickAction") ? (ImageIcon)dsIcon : XpMyToolPanel.getScaledIcon(dsIcon);
                        if (icon != null) {
                            box.setIcon(icon);
                        } else {
                            box.setIcon((ImageIcon)dsIcon);
                        }
                    } else if (dsIcon == null) {
                        System.err.println("!!!!!!!!!!!!!!Failed to get image, skipping from available tools: " + key);
                        continue;
                    }
                } else if (obj instanceof AbstractButton) {
                    Action a = ((AbstractButton)obj).getAction();
                    box = new JCheckBox(((AbstractButton)obj).getToolTipText());
                    if (a != null) {
                        Object dsIcon = a.getValue("SmallIcon");
                        if (dsIcon instanceof ImageIcon) {
                            Icon icon2 = XpMyToolPanel.getScaledIcon((ImageIcon)dsIcon);
                            a.putValue("SmallIcon", icon2);
                            box.setIcon(icon2);
                        }
                    } else {
                        icon = ((AbstractButton)obj).getIcon();
                        box.setIcon(icon);
                    }
                } else {
                    System.err.println("!!!!!!!!!!!!!!!!!Please handle this action type also::::::" + obj);
                    continue;
                }
                if (box == null) continue;
                box.setName(key);
                box.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XpMyToolPanel.this.refreshUI();
                    }
                });
                box.setFocusPainted(false);
                this.checkBoxList.add(box);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(null);
        buttonPanel.setLayout(new GridBagLayout());
        JButton applyButton = new JButton(new ApplyButton());
        buttonPanel.add((Component)applyButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 100, 20), 0, 0));
        applyButton.setName("My_Tools_Add");
        JButton cancelButton = new JButton(new CancelButton());
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        cancelButton.setName("My_Tools_Cancel");
        buttonPanel.setName(XpMyToolPanel.class.getName() + "buttonPanel");
        int avaTools = this.checkBoxList.size();
        JPanel toolsPanel = new JPanel(new GridLayout(avaTools, 1, 2, 2));
        toolsPanel.setName("myToolsSettingPanel");
        CvUtils.updateBackground(toolsPanel, LookAndFeelFactory.getColor(null, "P9"));
        for (int i = 0; i < avaTools; ++i) {
            JPanel p = new JPanel(new FlowLayout(0));
            JCheckBox box = this.checkBoxList.get(i);
            String displayStr = box.getText();
            Icon icon = box.getIcon();
            box.setIcon(null);
            box.setText("");
            CvUtils.updateBackground(p, LookAndFeelFactory.getColor(null, "P9"));
            JLabel lab = new JLabel(displayStr, icon, 2);
            lab.setToolTipText(displayStr);
            lab.setPreferredSize(new Dimension(250, 40));
            box.setBorderPainted(false);
            p.add(box);
            p.add(lab);
            toolsPanel.add(p);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(null);
        JScrollPane sp = new JScrollPane(toolsPanel, 20, 31);
        sp.setPreferredSize(new Dimension(300, 250));
        sp.setBackground(LookAndFeelFactory.getColor(null, "P9"));
        panel.add((Component)sp, "Center");
        panel.add((Component)buttonPanel, "South");
        this.add((Component)panel, "Center");
        CvUtils.updateBackground(this, LookAndFeelFactory.getColor(null, "P9"));
        this.uiIntiated = true;
        ToolManager.getInstance().loadMyToolKeys();
        this.updateSelection();
    }

    private void refreshUI() {
        this.revalidate();
        this.repaint();
    }

    private static void updateBackground(JComponent pan, Color c) {
        if (pan != null) {
            pan.setBackground(c);
            Component[] children = pan.getComponents();
            for (int i = 0; children != null && i < children.length; ++i) {
                if (children[i] instanceof JPanel) {
                    XpMyToolPanel.updateBackground((JComponent)children[i], c);
                    continue;
                }
                if (!(children[i] instanceof JSlider)) continue;
                children[i].setBackground(c);
            }
        }
    }

    private static Icon getScaledIcon(Object icon) {
        ImageIcon ic = null;
        if (icon instanceof ImageIcon) {
            Image img = ((ImageIcon)icon).getImage();
            if (img != null) {
                ic = new ImageIcon(img.getScaledInstance(XpMyToolPanel.iconSize.width, XpMyToolPanel.iconSize.height, 4));
                return ic;
            }
            return (ImageIcon)icon;
        }
        if (icon instanceof Icon) {
            return (Icon)icon;
        }
        return ic;
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_MY_TOOL_NAME");
    }

    @Override
    public Icon getIcon() {
        return CvUtils.getIcon("XP_MY_TOOL_ICON");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.cap = screen;
        this.screen = screen;
        screen.addPropertyChangeListener("MyTools", this.myToolsChangeListener);
    }

    private void revertSelection() {
        List<String> selectedTools = ToolManager.getInstance().getFavoriteToolKeys();
        for (JCheckBox checkBox : this.checkBoxList) {
            if (selectedTools.contains(checkBox.getName())) {
                checkBox.setSelected(true);
                continue;
            }
            checkBox.setSelected(false);
        }
        this.refreshUI();
    }

    private void updateSelection() {
        List<String> myTools = ToolManager.getInstance().getFavoriteToolKeys();
        for (JCheckBox checkBox : this.checkBoxList) {
            if (myTools.contains(checkBox.getName())) {
                checkBox.setSelected(true);
                continue;
            }
            checkBox.setSelected(false);
        }
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_MY_TOOL_NAME");
    }

    @Override
    public void setCapable(Capable s) {
        this.cap = s;
    }

    class CancelButton
    extends AbstractAction {
        CancelButton() {
            super(CvUtils.getResourceBundle().getString("XP_BUT_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XpMyToolPanel.this.revertSelection();
        }
    }

    class ApplyButton
    extends AbstractAction {
        ApplyButton() {
            super(CvUtils.getResourceBundle().getString("XP_APPLY_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<String> selectedTools = new ArrayList<String>();
            for (JCheckBox checkBox : XpMyToolPanel.this.checkBoxList) {
                if (!checkBox.isSelected()) continue;
                selectedTools.add(checkBox.getName());
            }
            String strExtraToolCount = CvPropertiesManager.getProperty("mytool.extraToolCount", Integer.valueOf(XpMyToolPanel.this.extraToolCount).toString());
            if (null != strExtraToolCount) {
                XpMyToolPanel.this.extraToolCount = Integer.parseInt(strExtraToolCount);
            }
            if (selectedTools.size() + XpMyToolPanel.this.extraToolCount <= ToolManager.getInstance().getMyToolLimit()) {
                ToolManager.getInstance().setFavoriteToolKeys(selectedTools);
                XpMyToolPanel.this.screen.firePropertyChange("MyTools", 0, ToolManager.getInstance().ADD_TOOL_FROM_MYTOOL_SETTINGS);
            } else {
                JOptionPane.showOptionDialog(XpMyToolPanel.this.screen, CvUtils.getResourceBundle().getString("MY_TOOLS_EXCEEDED") + ToolManager.getInstance().getMyToolLimit(), CvUtils.getResourceBundle().getString("My_Tools"), 0, 1, null, new String[]{CvUtils.getResourceBundle().getString("XP_BUT_OK")}, "default");
            }
        }
    }
}

