/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class XpLargeFontAnnotationPanel
extends XPcaAutoControlPanel
implements XpIPrefsCallBack {
    private JLabel titlelbl;
    private JButton applybtn;
    private JButton savebtn;
    private JCheckBox[] grpnames;
    private JPanel buttonPanel;
    private JPanel listPanel;
    private JPanel labelPanel;
    private String[] groupElemts;
    private String imageType;
    private boolean initialized = false;
    transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("data_changed") || evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equals("VOLUME_PROPERTY")) {
                XpLargeFontAnnotationPanel.access$102(XpLargeFontAnnotationPanel.this, null);
                XpLargeFontAnnotationPanel.this.updateAnnotList();
            }
        }
    };

    public XpLargeFontAnnotationPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateCustomAnnotPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating Large Font Annotation Panel", tln);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating Large Font Annotation Panel", tln);
    }

    private void initUI() {
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        this.setIcon(CvUtils.getIcon("XP_LARGE_FONT_SCREEN_ICON"));
        this.setTitle(CvUtils.getResourceBundle().getString("XP_LARGE_FONT_TITLE"));
        this.titlelbl = new JLabel();
        this.titlelbl.setText(CvUtils.getResourceBundle().getString("XP_ANNOT_LARGE_FONT_PA_LB"));
        this.titlelbl.setName(XpLargeFontAnnotationPanel.class.getName() + "titlelbl");
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelPanel.setBackground(null);
        this.labelPanel.add((Component)this.titlelbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 22, 0, 0), 0, 0));
        this.labelPanel.setName(XpLargeFontAnnotationPanel.class.getName() + "labelPanel");
        JPanel topLabel = new JPanel();
        topLabel.setLayout(new BorderLayout());
        topLabel.setBackground(null);
        topLabel.add((Component)this.labelPanel, "West");
        topLabel.setName(XpLargeFontAnnotationPanel.class.getName() + "topLabel");
        this.listPanel = new JPanel();
        this.listPanel.setName("largeFontAnnotsPnl");
        this.listPanel.setLayout(new GridLayout(0, 1));
        this.listPanel.setBackground(UIManager.getColor("P9"));
        this.savebtn = new JButton(new XpSavePrefsAction(this));
        this.savebtn.setText(CvUtils.getResourceBundle().getString("XP_SAVE_PREFS_NAME"));
        this.savebtn.setFocusable(false);
        this.savebtn.setName("largeFontSaveBtn");
        this.applybtn = new JButton();
        this.applybtn.setText(CvUtils.getResourceBundle().getString("XP_BUT_APPLY"));
        this.applybtn.setFocusable(false);
        this.applybtn.setName("largeFontApplyBtn");
        this.applybtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpLargeFontAnnotationPanel.this.apply_button_actionPerformed(e);
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(null);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.savebtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 100, 20), 0, 0));
        this.buttonPanel.add((Component)this.applybtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.setName(XpLargeFontAnnotationPanel.class.getName() + "buttonPanel");
        this.add((Component)topLabel, "North");
        this.add((Component)this.listPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.updateAnnotList();
        screen.removePropertyChangeListener(this.vpListener);
        screen.addPropertyChangeListener(this.vpListener);
    }

    public void updateAnnotList() {
        if (this.grpnames != null) {
            return;
        }
        this.listPanel.removeAll();
        if (this.getScreen() != null) {
            this.imageType = CvUtils.getImageTypeKey(this.getScreen());
        }
        this.groupElemts = XPDisplayPrefsUtils.getLargeFontAnnotationGroups((AnnotCapable)this.getCapable(AnnotCapable.class.getName()), this.imageType);
        if (this.groupElemts != null) {
            this.grpnames = new JCheckBox[this.groupElemts.length];
            this.listPanel.removeAll();
            for (int i = 0; i < this.groupElemts.length; ++i) {
                String text = this.groupElemts[i];
                try {
                    text = CvUtils.getResourceBundle().getString(this.groupElemts[i]);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Resource is not available for string = ", text);
                }
                this.grpnames[i] = new JCheckBox(i + 1 + "." + text.replace('_', ' '));
                this.grpnames[i].setActionCommand(this.groupElemts[i]);
                boolean isSelected = XPDisplayPrefsUtils.queryScreenLargeFontAnnotationGroup(i);
                this.grpnames[i].setFocusable(false);
                this.grpnames[i].setSelected(isSelected);
                this.listPanel.add(this.grpnames[i]);
            }
        }
    }

    private void apply_button_actionPerformed(ActionEvent e) {
        int custmmask = 0;
        int[] annotkey = null;
        for (int i = 0; i < this.grpnames.length; ++i) {
            if (!this.grpnames[i].isSelected()) continue;
            int grMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(i);
            custmmask |= grMask;
        }
        XPDisplayPrefsUtils.updateScreenLargeFontAnnotationLevel(custmmask);
        SelectionCapable sc = (SelectionCapable)this.getScreen().getCapable(SelectionCapable.class.getName());
        Capable ca = (Capable)((Object)sc.getViewportComponent(sc.getComponentSelection()));
        XpViewport vp = null;
        if (ca instanceof XpCompositePort) {
            vp = ((XpCompositePort)ca).getPort(0);
        } else if (ca instanceof XpSingularPort) {
            vp = (XpSingularPort)ca;
        } else if (ca instanceof J3DViewport) {
            vp = (J3DViewport)ca;
        }
        annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(vp, this.imageType, XPDisplayPrefsUtils.getScreenLargeFontAnnotationLevel());
        XPDisplayPrefsUtils.setLargeFontAnnotation((AnnotCapable)((Object)sc), annotkey);
        String scrnannotlevel = XPDisplayPrefsUtils.getScreenAnnotationLevel();
        if (!scrnannotlevel.equalsIgnoreCase("custom")) {
            XPDisplayPrefsUtils.setAnnotLevel((AnnotCapable)((Object)sc), scrnannotlevel);
        } else {
            XPDisplayPrefsUtils.setCustomAnnotItems((AnnotCapable)((Object)sc), this.imageType, XPDisplayPrefsUtils.getScreenCustomAnnotationLevel());
        }
        this.getScreen().updateUI();
    }

    @Override
    public void sync() {
        int custmmask = 0;
        int[] annotkey = null;
        for (int i = 0; i < this.grpnames.length; ++i) {
            if (!this.grpnames[i].isSelected()) continue;
            int grMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(i);
            custmmask |= grMask;
        }
        XPDisplayPrefsUtils.saveScreenLargeFontAnnotationLevel(custmmask);
        SelectionCapable sc = (SelectionCapable)this.getScreen().getCapable(SelectionCapable.class.getName());
        Capable ca = (Capable)((Object)sc.getViewportComponent(sc.getComponentSelection()));
        XpViewport vp = null;
        if (ca instanceof XpCompositePort) {
            vp = ((XpCompositePort)ca).getPort(0);
        } else if (ca instanceof XpSingularPort) {
            vp = (XpFrameVisualizer)((XpSingularPort)ca);
        } else if (ca instanceof J3DViewport) {
            vp = (J3DViewport)ca;
        }
        annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(vp, this.imageType, XPDisplayPrefsUtils.getScreenLargeFontAnnotationLevel());
        XPDisplayPrefsUtils.setLargeFontAnnotation(vp, annotkey);
        String scrnannotlevel = XPDisplayPrefsUtils.getScreenAnnotationLevel();
        if (!scrnannotlevel.equalsIgnoreCase("custom")) {
            XPDisplayPrefsUtils.setAnnotLevel((AnnotCapable)((Object)sc), scrnannotlevel);
        } else {
            XPDisplayPrefsUtils.setCustomAnnotItems((AnnotCapable)((Object)sc), this.imageType, XPDisplayPrefsUtils.getScreenCustomAnnotationLevel());
        }
        this.getScreen().updateUI();
    }

    static /* synthetic */ JCheckBox[] access$102(XpLargeFontAnnotationPanel x0, JCheckBox[] x1) {
        x0.grpnames = x1;
        return x1;
    }
}

