/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpLinkPortAction;
import com.ge.med.cse.cvf.action.XpMinMaxPortAction;
import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class XpImageControlPanel
extends XPcaAutoControlPanel
implements ActionListener {
    public static final String CLOSE_APP = "close_app";
    protected transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    protected static int currentSelectedMode = -1;
    protected static int prevSelectedMode = -1;
    protected JPanel controlBtnPanel = null;
    protected JToggleButton linkBtn = null;
    protected JToggleButton minMaxBtn = null;
    protected JButton closeBtn = null;
    protected HashMap<Integer, AbstractButton> mouseModeToButtonMap = new HashMap();
    protected HashMap<String, Integer> buttonActionToModeMap = new HashMap();
    protected transient MouseModeCapable modeCapable = null;
    protected String appName = null;
    protected String prefix = "";
    private static ResourceBundle res = CvUtils.getResourceBundle();
    protected static final int MOUSE_MODE_ACTION_BTN = CvMouseControllerUtil.getMouseModeToApplyButton(CvPropertiesManager.getProperties());
    protected static final String BORDER_FACTORY = "BorderFactory.class";
    transient PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newMode;
            Integer[] newValue = (Integer[])evt.getNewValue();
            if (newValue.length == 2 && currentSelectedMode != (newMode = newValue[0].intValue())) {
                currentSelectedMode = newMode;
                if (XpImageControlPanel.this.mouseModeToButtonMap.get(newMode) != null) {
                    XpImageControlPanel.this.mouseModeToButtonMap.get(newMode).setSelected(true);
                }
            }
        }
    };
    transient PropertyChangeListener cineListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean isCineOn = (Boolean)evt.getNewValue();
            String modesOnCine = CvPropertiesManager.getProperty(XpImageControlPanel.this.prefix + "MouseModesEnabledDuringCineOn");
            if (modesOnCine == null) {
                return;
            }
            String[] modesOnDuringCine = modesOnCine.split(",");
            ArrayList<Integer> modesOnDrngCine = new ArrayList<Integer>();
            for (int i = 0; i < modesOnDuringCine.length; ++i) {
                modesOnDrngCine.add(Integer.valueOf(modesOnDuringCine[i].trim()));
            }
            if (modesOnDrngCine.size() > 0) {
                if (isCineOn) {
                    prevSelectedMode = XpImageControlPanel.this.modeCapable.getMouseMode(MOUSE_MODE_ACTION_BTN);
                    if (!modesOnDrngCine.contains(prevSelectedMode)) {
                        XpImageControlPanel.this.modeCapable.setMouseMode(Integer.parseInt(CvPropertiesManager.getProperty(XpImageControlPanel.this.prefix + "DefaultMouseModeDuringCineOn", "3")), MOUSE_MODE_ACTION_BTN);
                    }
                } else {
                    XpImageControlPanel.this.modeCapable.setMouseMode(prevSelectedMode, MOUSE_MODE_ACTION_BTN);
                }
            }
            for (Map.Entry<Integer, AbstractButton> pair : XpImageControlPanel.this.mouseModeToButtonMap.entrySet()) {
                if (modesOnDrngCine.contains(pair.getKey())) continue;
                XpImageControlPanel.this.mouseModeToButtonMap.get(pair.getKey()).setEnabled(!isCineOn);
            }
        }
    };
    transient PropertyChangeListener portChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int capablePortCount = 0;
            int nports = XpImageControlPanel.this.getScreen().getScreenLayout().getNoOfPorts();
            for (int i = 0; i < nports; ++i) {
                if (!(XpImageControlPanel.this.getScreen().getPort(i) instanceof Capable)) continue;
                ++capablePortCount;
            }
            if (XpImageControlPanel.this.linkBtn != null) {
                XpImageControlPanel.this.linkBtn.setVisible(capablePortCount > 1);
            }
        }
    };
    transient PropertyChangeListener refImgListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean isRefOn = (Boolean)evt.getNewValue();
            if (isRefOn) {
                String modesOnRefVp = CvPropertiesManager.getProperty(XpImageControlPanel.this.prefix + "MouseModesEnabledWhenRefVp_Selected");
                if (modesOnRefVp == null) {
                    return;
                }
                String[] modesOnRefVp_sel = modesOnRefVp.split(",");
                ArrayList<Integer> modesOnRef = new ArrayList<Integer>();
                for (int i = 0; i < modesOnRefVp_sel.length; ++i) {
                    modesOnRef.add(Integer.valueOf(modesOnRefVp_sel[i].trim()));
                }
                for (Map.Entry<Integer, AbstractButton> pair : XpImageControlPanel.this.mouseModeToButtonMap.entrySet()) {
                    if (modesOnRef.contains(pair.getKey())) continue;
                    XpImageControlPanel.this.mouseModeToButtonMap.get(pair.getKey()).setEnabled(false);
                }
            } else {
                for (int i = 0; i < XpImageControlPanel.this.mouseModeToButtonMap.size(); ++i) {
                    XpImageControlPanel.this.mouseModeToButtonMap.get(i).setEnabled(true);
                }
            }
        }
    };
    transient PropertyChangeListener pagingListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if ("paging_property".equals(pce.getPropertyName())) {
                Component[] comps;
                for (Component comp : comps = XpImageControlPanel.this.controlBtnPanel.getComponents()) {
                    AbstractButton modebutton;
                    if (!(comp instanceof AbstractButton) || !(modebutton = (AbstractButton)comp).getName().equalsIgnoreCase(res.getString("MouseButtonController.PAGE"))) continue;
                    modebutton.setEnabled(Boolean.parseBoolean(pce.getNewValue().toString().trim()));
                }
            }
        }
    };

    public XpImageControlPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, "Image control panel creation failed." + ex);
        }
    }

    public XpImageControlPanel(String appName) {
        try {
            this.appName = appName;
            if (this.appName != null || this.appName != "") {
                this.prefix = this.appName + ".";
            }
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, "Image control panel creation failed." + ex);
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(null);
        this.setLayout(new GridBagLayout());
        this.setName("imageControlPanel");
        this.controlBtnPanel = new JPanel();
        this.controlBtnPanel.setLayout(new GridBagLayout());
        if (null != UIManager.getColor("P8")) {
            this.controlBtnPanel.setBackground(UIManager.getColor("P8"));
        }
        this.controlBtnPanel.setName("imageControlBtnPanel");
        XpLinkPortAction linkAction = new XpLinkPortAction();
        this.linkBtn = new JToggleButton(linkAction);
        linkAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("SwingSelectedKey")) {
                    XpImageControlPanel.this.linkBtn.setSelected((Boolean)evt.getNewValue());
                }
            }
        });
        this.linkBtn.setName("link_button");
        this.linkBtn.setFocusable(false);
        this.linkBtn.setMargin(new Insets(0, 0, 0, 0));
        this.linkBtn.setPreferredSize(new Dimension(50, 25));
        if (Boolean.parseBoolean(CvPropertiesManager.getProperty("MinMaxButtonOn"))) {
            this.minMaxBtn = new JToggleButton(new XpMinMaxPortAction());
            this.minMaxBtn.setName("minmax_button");
            this.minMaxBtn.setFocusable(false);
            this.minMaxBtn.setMargin(new Insets(0, 0, 0, 0));
            this.minMaxBtn.setPreferredSize(new Dimension(50, 25));
        }
        JPanel emptyPnl = new JPanel();
        if (null != UIManager.getColor("P10")) {
            emptyPnl.setBackground(UIManager.getColor("P10"));
        }
        emptyPnl.setName(XpImageControlPanel.class.getName() + "emptyPnl");
        JPanel buttonPnl = new JPanel();
        buttonPnl.setLayout(new BorderLayout());
        if (null != UIManager.getColor("P8")) {
            buttonPnl.setBackground(UIManager.getColor("P8"));
        }
        buttonPnl.setName(XpImageControlPanel.class.getName() + "buttonPnl");
        if (this.minMaxBtn != null) {
            buttonPnl.add((Component)this.minMaxBtn, "East");
            buttonPnl.add((Component)emptyPnl, "Center");
            buttonPnl.add((Component)this.linkBtn, "West");
        } else {
            buttonPnl.add((Component)this.linkBtn, "East");
        }
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BorderLayout());
        if (null != UIManager.getColor("P10")) {
            btnPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("P10")));
        }
        if (null != UIManager.getColor("P8")) {
            btnPanel.setBackground(UIManager.getColor("P8"));
        }
        btnPanel.add((Component)this.controlBtnPanel, "West");
        btnPanel.add((Component)buttonPnl, "East");
        this.closeBtn = new JButton();
        this.closeBtn.setIcon(CvUtils.getIcon("XP_CLOSE_APP_ICON"));
        this.closeBtn.setToolTipText(CvUtils.getResourceBundle().getString("XP_CLOSE_APP_TOOLTIP"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpImageControlPanel.this.getScreen().firePropertyChange(XpImageControlPanel.CLOSE_APP, false, true);
            }
        });
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.setFocusable(false);
        this.closeBtn.setBackground(null);
        this.closeBtn.setBorder(null);
        if (null != UIManager.getColor("P3")) {
            this.closeBtn.setForeground(UIManager.getColor("P3"));
        }
        this.closeBtn.setPreferredSize(new Dimension(20, 20));
        this.closeBtn.setName(XpImageControlPanel.class.getName() + "closeBtn");
        JPanel closePnl = new JPanel();
        if (null != UIManager.getColor("P10")) {
            closePnl.setBackground(UIManager.getColor("P10"));
        }
        closePnl.setLayout(new BorderLayout());
        closePnl.add((Component)this.closeBtn, "East");
        closePnl.setName(XpImageControlPanel.class.getName() + "closePnl");
        JPanel imgCtrlLblPnl = new JPanel();
        imgCtrlLblPnl.setLayout(new GridBagLayout());
        JLabel imgctrlLbl = new JLabel(CvUtils.getResourceBundle().getString("XP_IMGCONTROL_TXT"));
        if (null != UIManager.getColor("P7")) {
            imgctrlLbl.setForeground(UIManager.getColor("P7"));
        }
        imgCtrlLblPnl.add((Component)imgctrlLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        imgCtrlLblPnl.add((Component)closePnl, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (null != UIManager.getColor("P10")) {
            imgCtrlLblPnl.setBackground(UIManager.getColor("P10"));
        }
        imgCtrlLblPnl.setName(XpImageControlPanel.class.getName() + "imgCtrlLblPnl");
        Insets insets = new Insets(4, 4, 4, 4);
        double[] corners = new double[]{4.0, 0.0, 0.0, 4.0};
        Class borderFactoryClass = LookAndFeelFactory.getClass(BORDER_FACTORY);
        if (null != borderFactoryClass) {
            Method createBorderMethod = borderFactoryClass.getMethod("createRoundedCornerBorder", Insets.class, double[].class);
            Border bb = (Border)createBorderMethod.invoke(null, insets, corners);
            imgCtrlLblPnl.setBorder(bb);
        }
        JPanel titlePnl = new JPanel();
        titlePnl.setLayout(new BorderLayout());
        if (null != UIManager.getColor("P8")) {
            titlePnl.setBackground(UIManager.getColor("P8"));
        }
        titlePnl.add((Component)imgCtrlLblPnl, "Center");
        titlePnl.setName(XpImageControlPanel.class.getName() + "titlePnl");
        String enable_close = CvPropertiesManager.getProperty("ENABLE_CLOSE_APP_CONTROL", "true");
        int i = -1;
        if (enable_close.equalsIgnoreCase("true")) {
            i = 0;
            this.add((Component)titlePnl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)btnPanel, new GridBagConstraints(0, i + 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)emptyPnl, new GridBagConstraints(0, i + 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addControllers() {
        if (null != this.modeCapable) {
            try {
                int[] modes = this.modeCapable.getSupportedModes();
                AbstractButton[] btns = CvMouseControllerUtil.getMouseModeButtons(this.modeCapable, "HORIZONTAL");
                for (int i = 0; i < modes.length; ++i) {
                    if (btns[i] != null) {
                        this.controlBtnPanel.add((Component)btns[i], new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
                        currentSelectedMode = this.modeCapable.getMouseMode(MOUSE_MODE_ACTION_BTN);
                        if (currentSelectedMode == modes[i]) {
                            btns[i].setSelected(true);
                        }
                        this.mouseModeToButtonMap.put(modes[i], btns[i]);
                        this.buttonActionToModeMap.put(btns[i].getActionCommand(), modes[i]);
                    }
                    btns[i].addActionListener(this);
                    JSeparator separator1 = new JSeparator(1);
                    if (null != UIManager.getColor("P10")) {
                        separator1.setForeground(UIManager.getColor("P10"));
                    }
                    this.controlBtnPanel.add((Component)separator1, new GridBagConstraints(modes.length, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
                }
                this.modeCapable.removePropertyChangeListener(this.mouseModeChangeListener);
                this.modeCapable.addPropertyChangeListener(this.mouseModeChangeListener);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.setMouseModeCapable();
        this.addControllers();
        if (this.linkBtn != null) {
            int capablePortCount = 0;
            int nports = this.getScreen().getScreenLayout().getNoOfPorts();
            for (int i = 0; i < nports; ++i) {
                if (!(this.getScreen().getPort(i) instanceof Capable)) continue;
                ++capablePortCount;
            }
            if (this.linkBtn.getAction() instanceof PlasmaControl) {
                ((PlasmaControl)((Object)this.linkBtn.getAction())).setCapable(screen);
            }
            this.linkBtn.setVisible(capablePortCount > 1);
        }
        if (this.minMaxBtn != null) {
            if (this.minMaxBtn.getAction() instanceof PlasmaControl) {
                ((PlasmaControl)((Object)this.minMaxBtn.getAction())).setCapable(screen);
            }
            this.minMaxBtn.setVisible(true);
        }
        this.addPropertyChangeListeners();
    }

    protected void addPropertyChangeListeners() {
        this.getScreen().removePropertyChangeListener("Cine", this.cineListener);
        this.getScreen().addPropertyChangeListener("Cine", this.cineListener);
        this.getScreen().removePropertyChangeListener("reference_vp_selection", this.refImgListener);
        this.getScreen().addPropertyChangeListener("reference_vp_selection", this.refImgListener);
        this.getScreen().removePropertyChangeListener("port_change_property", this.portChangeListener);
        this.getScreen().addPropertyChangeListener("port_change_property", this.portChangeListener);
        this.getScreen().removePropertyChangeListener("paging_property", this.pagingListener);
        this.getScreen().addPropertyChangeListener("paging_property", this.pagingListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int mode = this.buttonActionToModeMap.get(e.getActionCommand());
        this.modeCapable.setMouseMode(mode, MOUSE_MODE_ACTION_BTN);
        currentSelectedMode = mode;
    }

    protected void setMouseModeCapable() {
        XpFrameVisualizer sPort;
        XpMouseController mouseCtrl;
        XpViewport port = this.findSelectedViewportByClass(XpCompositePort.class);
        if (port instanceof XpCompositePort && (mouseCtrl = (sPort = ((XpCompositePort)port).getPort(0)).getMouseController()) instanceof MouseModeCapable) {
            this.modeCapable = (MouseModeCapable)((Object)mouseCtrl);
        }
    }

    protected XpViewport findSelectedViewportByClass(Class c) {
        XPscreen cap_ = this.getScreen();
        if (cap_ == null) {
            return null;
        }
        SelectionCapable selCap = (SelectionCapable)cap_.getCapable(SelectionCapable.class.getName());
        if (selCap == null) {
            return c.isInstance(cap_) && cap_ instanceof XpViewport ? (XpViewport)((Object)cap_) : null;
        }
        JComponent comp = null;
        do {
            if (c.isInstance(comp = selCap.getViewportComponent(selCap.getComponentSelection())) && comp instanceof XpViewport) {
                return (XpViewport)comp;
            }
            SelectionCapable selectionCapable = selCap = comp instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        } while (comp != null && selCap != null);
        return null;
    }
}

