/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpHorizontalTickAction;
import com.ge.med.cse.cvf.action.XpReportCursorAction;
import com.ge.med.cse.cvf.action.XpVerticalTickAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.idc.XpReportCursorCapable;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XpGuidesPanel
extends XPcaAutoControlPanel
implements XpIPrefsCallBack {
    JPanel guidesSetting;
    JPanel guidePane;
    JPanel saveSetting;
    JPanel guidesPanel;
    JLabel vImage;
    JLabel hImage;
    JLabel curserImage;
    JCheckBox vTickMark;
    JCheckBox hTickMark;
    JCheckBox reportCurser;
    JButton save;
    XpReportCursorAction repAction = new XpReportCursorAction();
    private boolean initialized = false;
    transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("report_cursor_property")) {
                boolean onoff = (Boolean)evt.getNewValue();
                XpGuidesPanel.this.reportCurser.setSelected(onoff);
            } else if (evt.getPropertyName().equals("tick_mark_added_property")) {
                int on = (Integer)evt.getNewValue();
                if (on == 1) {
                    XpGuidesPanel.this.hTickMark.setSelected(true);
                } else if (on == 0) {
                    XpGuidesPanel.this.vTickMark.setSelected(true);
                }
            } else if (evt.getPropertyName().equals("tick_mark_removed_property")) {
                int off = (Integer)evt.getNewValue();
                if (off == 1) {
                    XpGuidesPanel.this.hTickMark.setSelected(false);
                } else if (off == 0) {
                    XpGuidesPanel.this.vTickMark.setSelected(false);
                }
            } else if (evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equals("data_changed")) {
                if (!XpGuidesPanel.this.initialized) {
                    XpGuidesPanel.this.updateGuidesSettings();
                    XpGuidesPanel.this.initialized = true;
                }
                XpGuidesPanel.this.loadUserPrefs();
            }
        }
    };

    public XpGuidesPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateGuidesPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating Guides Panel", tln);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setBackground(null);
        this.logger.log(Level.FINE, "{0} end,Creating Guides Panel", tln);
    }

    private void jbInit() throws Exception {
        this.initUI();
        this.setTitle(CvUtils.getResourceBundle().getString("XP_GUIDES_SETTINGS_TITLE"));
        this.setLayout(new BorderLayout());
        this.guidePane.setLayout(new GridBagLayout());
        this.guidePane.add((Component)new JLabel(""), new GridBagConstraints(0, 0, 5, 1, 1.0, 1.0, 10, 2, new Insets(0, 20, 10, 0), 0, 0));
        this.guidePane.add((Component)new JLabel(""), new GridBagConstraints(5, 0, 2, 4, 1.0, 1.0, 10, 2, new Insets(0, 20, 10, 0), 0, 0));
        this.guidePane.add((Component)new JLabel("  "), new GridBagConstraints(3, 0, 1, 4, 0.0, 0.0, 10, 2, new Insets(0, 20, 10, 0), 0, 0));
        this.guidePane.add((Component)this.vTickMark, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.guidePane.add((Component)this.vImage, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.guidePane.add((Component)this.hTickMark, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.guidePane.add((Component)this.hImage, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.guidePane.add((Component)this.reportCurser, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 50, 0), 0, 0));
        this.guidePane.add((Component)this.curserImage, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 50, 0), 0, 0));
        this.guidePane.setName(XpGuidesPanel.class.getName() + "guidePane");
        this.saveSetting.setName(XpGuidesPanel.class.getName() + "saveSetting");
        this.guidesPanel.setName(XpGuidesPanel.class.getName() + "guidesPanel");
        this.vImage.setIcon(CvUtils.getIcon("XP_VERTICAL_TICK_ICON"));
        this.hImage.setIcon(CvUtils.getIcon("XP_HORIZONTAL_TICK_ICON"));
        this.curserImage.setIcon(CvUtils.getIcon("XP_REPORT_CURSOR_ICON"));
        this.saveSetting.add((Component)this.save, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.guidesPanel.add((Component)this.guidePane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 100), 0, 0));
        this.guidesPanel.add((Component)this.saveSetting, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 40), 0, 0));
        this.add((Component)this.guidesPanel, "North");
        this.updateGuidesSettings();
        this.reportCurser.setAction(this.repAction);
    }

    private void initUI() {
        this.guidesSetting = new JPanel();
        this.guidePane = new JPanel();
        this.saveSetting = new JPanel();
        this.saveSetting.setLayout(new GridBagLayout());
        this.guidesPanel = new JPanel(new GridBagLayout());
        this.guidesSetting.setName(XpGuidesPanel.class.getName() + "guidesSetting");
        this.guidePane.setName(XpGuidesPanel.class.getName() + "guidePane");
        this.saveSetting.setName(XpGuidesPanel.class.getName() + "saveSetting");
        this.guidesPanel.setName(XpGuidesPanel.class.getName() + "guidesPanel");
        this.vImage = new JLabel();
        this.hImage = new JLabel();
        this.curserImage = new JLabel();
        this.curserImage.setName(XpGuidesPanel.class.getName() + "curserImage");
        this.hImage.setName(XpGuidesPanel.class.getName() + "hImage");
        this.vImage.setName(XpGuidesPanel.class.getName() + "vImage");
        this.vTickMark = new JCheckBox(new XpVerticalTickAction());
        this.hTickMark = new JCheckBox(new XpHorizontalTickAction());
        this.reportCurser = new JCheckBox();
        this.vTickMark.setFocusable(false);
        this.hTickMark.setFocusable(false);
        this.reportCurser.setFocusable(false);
        this.vTickMark.setName("vTickMrk");
        this.hTickMark.setName("hTickMrk");
        this.reportCurser.setName("reprtCurser");
        this.save = new JButton(new XpSavePrefsAction(this));
        this.save.setName("guideSaveBtn");
        this.save.setFocusable(false);
        this.save.setName(XpGuidesPanel.class.getName() + "save");
    }

    @Override
    public void setScreen(XPscreen screen) {
        Action act3;
        Action act1;
        super.setScreen(screen);
        this.repAction.setCapable(screen);
        Action act = this.hTickMark.getAction();
        if (act instanceof PlasmaControl) {
            ((PlasmaControl)((Object)act)).setCapable(screen);
        }
        if ((act1 = this.vTickMark.getAction()) instanceof PlasmaControl) {
            ((PlasmaControl)((Object)act1)).setCapable(screen);
        }
        if ((act3 = this.save.getAction()) instanceof PlasmaControl) {
            ((PlasmaControl)((Object)act3)).setCapable(screen);
        }
        screen.addPropertyChangeListener(this.vpListener);
        this.loadUserPrefs();
    }

    private void loadUserPrefs() {
        XpTickMarkCapable tickMarkCapable = (XpTickMarkCapable)this.screen_.getCapable(XpTickMarkCapable.class.getName());
        if (this.hTickMark.isSelected()) {
            tickMarkCapable.addTickMark(1);
        } else {
            tickMarkCapable.removeTickMark(1);
        }
        if (this.vTickMark.isSelected()) {
            tickMarkCapable.addTickMark(0);
        } else {
            tickMarkCapable.removeTickMark(0);
        }
        if (this.reportCurser.isSelected()) {
            XpReportCursorCapable cursorCapable = (XpReportCursorCapable)this.screen_.getCapable(XpReportCursorCapable.class.getName());
            cursorCapable.setReportCursorVisible(this.reportCurser.isSelected());
        } else {
            XpReportCursorCapable cursorCapable = (XpReportCursorCapable)this.screen_.getCapable(XpReportCursorCapable.class.getName());
            cursorCapable.setReportCursorVisible(this.reportCurser.isSelected());
        }
    }

    @Override
    public void sync() {
        XPDisplayPrefsUtils.saveHorizontalTicksStatus(this.hTickMark.isSelected());
        XPDisplayPrefsUtils.saveVerticalTicksStatus(this.vTickMark.isSelected());
        XPDisplayPrefsUtils.saveReportCursorStatus(this.reportCurser.isSelected());
    }

    private void updateGuidesSettings() {
        this.hTickMark.setSelected(XPDisplayPrefsUtils.getHorizontalTicksStatus());
        this.vTickMark.setSelected(XPDisplayPrefsUtils.getVerticalTicksStatus());
        this.reportCurser.setSelected(XPDisplayPrefsUtils.getReportCursorStatus());
    }

    @Override
    public Icon getIcon() {
        return CvUtils.getIcon("XP_GUIDES_SETTING_ICON");
    }
}

