/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpFlipHorizontalAction;
import com.ge.med.cse.cvf.action.XpFlipHorizontalVerticalAction;
import com.ge.med.cse.cvf.action.XpFlipVerticalAction;
import com.ge.med.cse.cvf.action.XpResetPanAction;
import com.ge.med.cse.cvf.action.XpRotateLeftAction;
import com.ge.med.cse.cvf.action.XpRotateRightAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpFlipRotatePanel
extends XPcaAutoControlPanel {
    private JButton fhBut = null;
    private JButton fvBut = null;
    private JButton flipBothBut = null;
    private JButton rlBut = null;
    private JButton rrBut = null;
    private JButton resetAllBut = null;
    private JLabel rotAngLabel = new JLabel();
    private JTextField rotAngleF = new JTextField();
    private JSlider rotAngle = new JSlider(0);
    private DecimalFormat df = new DecimalFormat("###0.0");
    private NumberFormat numberFormatter = NumberFormat.getNumberInstance(this.getLocale());
    private JButton btRotLeftRandom = new JButton();
    private JButton btRotRightRandom = new JButton();
    private boolean valueChanged = false;
    private static final String ROTATE_L_RANDOM_CMD = "ROTATE_L_RANDOM_CMD";
    private static final String ROTATE_R_RANDOM_CMD = "ROTATE_R_RANDOM_CMD";
    private String FLIP_ROTATE_ERROR_MSG = CvUtils.getResourceBundle().getString("XP_ROTATE_ERROR_MSG");
    private String FLIP_ROTATE_RESET_MSG = CvUtils.getResourceBundle().getString("XP_ROTATE_RESET_MSG");
    List<AbstractButton> buttonList = new ArrayList<AbstractButton>();
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiIntiated = false;
    transient ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            double val = 0.0;
            try {
                val = Double.parseDouble(XpFlipRotatePanel.this.rotAngleF.getText());
                XpFlipRotatePanel.this.logger.log(UserMessageLevel.USER_MSG, "");
            }
            catch (Exception exp) {
                val = (double)XpFlipRotatePanel.this.rotAngle.getValue() / 10.0;
                XpFlipRotatePanel.this.logger.log(UserMessageLevel.USER_MSG, XpFlipRotatePanel.this.FLIP_ROTATE_ERROR_MSG + "\n" + XpFlipRotatePanel.this.FLIP_ROTATE_RESET_MSG + val);
                exp.printStackTrace();
            }
            val = XpFlipRotatePanel.this.getRotationAngle(val);
            XpFlipRotatePanel.this.rotAngleF.setText("" + val);
            int sliderVal = (int)(val * 10.0);
            if (sliderVal != XpFlipRotatePanel.this.rotAngle.getValue()) {
                XpFlipRotatePanel.this.valueChanged = true;
            }
            XpFlipRotatePanel.this.rotAngle.setValue(sliderVal);
        }
    };

    public XpFlipRotatePanel() {
        this.setIcon(CvUtils.getIcon("XP_FLIP_ROTATE_CAP_ICON"));
        TransactionLogName tln = new TransactionLogName("TID=CreateFlipRotatePanel");
        this.logger.log(Level.FINE, "{0} begin Creating FlipRotate Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating FlipRotate Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.uiIntiated = true;
            this.setActionCapable();
        }
    }

    private void initUI() {
        this.setOpaque(false);
        this.rlBut = this.getHideActionTextButton(new XpRotateLeftAction());
        this.rrBut = this.getHideActionTextButton(new XpRotateRightAction());
        this.rlBut.setName("ROTATE_LEFT");
        this.rrBut.setName("ROTATE_RIGHT");
        this.buttonList.add(this.rlBut);
        this.buttonList.add(this.rrBut);
        this.fhBut = this.getHideActionTextButton(new XpFlipHorizontalAction());
        this.fvBut = this.getHideActionTextButton(new XpFlipVerticalAction());
        this.fhBut.setPreferredSize(new Dimension(45, 36));
        this.fvBut.setPreferredSize(new Dimension(45, 36));
        this.fhBut.setName("FLIP_HORZ");
        this.fvBut.setName("FLIP_VERT");
        this.buttonList.add(this.fhBut);
        this.buttonList.add(this.fvBut);
        boolean value = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.flipRotatePanel.flipBoth", "true"));
        if (value) {
            this.flipBothBut = this.getHideActionTextButton(new XpFlipHorizontalVerticalAction());
            this.flipBothBut.setPreferredSize(new Dimension(45, 36));
            this.flipBothBut.setName("FLIP_BOTH");
            this.buttonList.add(this.flipBothBut);
        }
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        topPanel.setName(XpFlipRotatePanel.class.getName() + "topPanel");
        mainPanel.setName(XpFlipRotatePanel.class.getName() + "mainPanel");
        buttonPanel.setName(XpFlipRotatePanel.class.getName() + "buttonPanel");
        topPanel.setLayout(new BorderLayout());
        mainPanel.setLayout(new GridLayout(5, 1));
        buttonPanel.setLayout(new GridLayout(1, this.buttonList.size(), 5, 0));
        for (int i = 0; i < this.buttonList.size(); ++i) {
            JPanel butPanel = new JPanel(new GridBagLayout());
            butPanel.add((Component)this.buttonList.get(i), new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 0), 0, 0));
            buttonPanel.add(butPanel);
        }
        mainPanel.add(buttonPanel);
        String val = CvPropertiesManager.getProperty("cvf.rotate.advance", "false");
        boolean adv = "true".equalsIgnoreCase(val);
        value = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.flipRotatePanel.reset", "true"));
        this.rotAngLabel.setText(CvUtils.getResourceBundle().getString("XP_ANGLE_TEXT"));
        this.rotAngleF.setName("ROTATE_ANGLE_TEXT_FIELD");
        this.rotAngleF.setPreferredSize(new Dimension(50, 20));
        this.rotAngleF.setText(this.df.format(0.0));
        this.rotAngleF.setHorizontalAlignment(4);
        this.rotAngleF.addActionListener(this.listener);
        this.rotAngleF.addFocusListener(new RotAngleFocusListener());
        this.rotAngle.setMaximum(1800);
        this.rotAngle.setMinimum(0);
        this.rotAngle.setName("ROTATE_ANGLE_SLIDER");
        this.rotAngle.setMajorTickSpacing(30);
        this.rotAngle.setMinorTickSpacing(5);
        this.rotAngle.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("" + this.numberFormatter.format(0.0)));
        labelTable.put(new Integer(300), new JLabel("" + this.numberFormatter.format(30.0)));
        labelTable.put(new Integer(600), new JLabel("" + this.numberFormatter.format(60.0)));
        labelTable.put(new Integer(900), new JLabel("" + this.numberFormatter.format(90.0)));
        labelTable.put(new Integer(1200), new JLabel("" + this.numberFormatter.format(120.0)));
        labelTable.put(new Integer(1500), new JLabel("" + this.numberFormatter.format(150.0)));
        labelTable.put(new Integer(1800), new JLabel("" + this.numberFormatter.format(180.0)));
        this.rotAngle.setLabelTable(labelTable);
        this.rotAngle.setPaintLabels(true);
        this.rotAngle.setValue(0);
        this.rotAngle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                if (!XpFlipRotatePanel.this.valueChanged) {
                    XpFlipRotatePanel.this.rotAngleF.setText("" + XpFlipRotatePanel.this.getRotationAngle((double)XpFlipRotatePanel.this.rotAngle.getValue() / 10.0));
                }
                XpFlipRotatePanel.this.valueChanged = false;
            }
        });
        this.rotAngle.setInputMap(0, new InputMap());
        this.btRotLeftRandom.setName("ROTATE_LEFT_RANDOM");
        this.btRotLeftRandom.setIcon(CvUtils.getIcon("XP_ROTATE_LEFT_RANDOM_ICON"));
        this.btRotLeftRandom.setActionCommand(ROTATE_L_RANDOM_CMD);
        this.btRotLeftRandom.addActionListener(new RandomRotateActionListener());
        this.btRotLeftRandom.setToolTipText(CvUtils.getResourceBundle().getString("XP_ROTATE_LEFT_RANDOM_TOOLTIP"));
        this.btRotLeftRandom.setPreferredSize(new Dimension(45, 36));
        this.btRotRightRandom.setName("ROTATE_RIGHT_RANDOM");
        this.btRotRightRandom.setIcon(CvUtils.getIcon("XP_ROTATE_RIGHT_RANDOM_ICON"));
        this.btRotRightRandom.setActionCommand(ROTATE_R_RANDOM_CMD);
        this.btRotRightRandom.addActionListener(new RandomRotateActionListener());
        this.btRotRightRandom.setToolTipText(CvUtils.getResourceBundle().getString("XP_ROTATE_RIGHT_RANDOM_TOOLTIP"));
        this.btRotRightRandom.setPreferredSize(new Dimension(45, 36));
        if (adv) {
            JPanel seperatorPanel = new JPanel();
            seperatorPanel.setLayout(new BorderLayout());
            JSeparator separator = new JSeparator();
            seperatorPanel.add((Component)separator, "North");
            mainPanel.add(separator);
            JPanel anglePanel = new JPanel(new FlowLayout(0));
            anglePanel.add(this.rotAngLabel);
            anglePanel.add(this.rotAngleF);
            mainPanel.add(anglePanel);
            mainPanel.add((Component)this.rotAngle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel randomButtonPanel = new JPanel(new GridBagLayout());
            randomButtonPanel.add((Component)this.btRotLeftRandom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 10), 0, 0));
            randomButtonPanel.add((Component)this.btRotRightRandom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 10), 0, 0));
            if (value) {
                this.resetAllBut = this.getHideActionTextButton(new XpResetPanAction());
                this.resetAllBut.setName("RESET");
                this.resetAllBut.setPreferredSize(new Dimension(45, 36));
                this.buttonList.add(this.resetAllBut);
                randomButtonPanel.add((Component)this.resetAllBut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 10), 0, 0));
            }
            mainPanel.add(randomButtonPanel);
        } else if (value) {
            this.resetAllBut = this.getHideActionTextButton(new XpResetPanAction());
            this.resetAllBut.setName("RESET");
            this.resetAllBut.setSize(new Dimension(45, 36));
            JPanel seperatorPanel = new JPanel();
            seperatorPanel.setLayout(new BorderLayout());
            JPanel resetPanel = new JPanel(new FlowLayout());
            JSeparator separator = new JSeparator();
            resetPanel.add(this.resetAllBut);
            seperatorPanel.add(separator);
            mainPanel.add(seperatorPanel);
            mainPanel.add(resetPanel);
            this.buttonList.add(this.resetAllBut);
        }
        topPanel.add((Component)mainPanel, "North");
        this.add((Component)topPanel, "North");
    }

    protected JButton getHideActionTextButton(Action action) {
        JButton toReturn = new JButton();
        toReturn.putClientProperty("hideActionText", Boolean.TRUE);
        toReturn.setAction(action);
        toReturn.setFocusable(false);
        return toReturn;
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        if (this.uiIntiated) {
            this.setActionCapable();
        }
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_FLIP_ROTATE_CAP_TITLE");
    }

    private void setActionCapable() {
        try {
            for (AbstractButton but : this.buttonList) {
                Action act = but.getAction();
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(this.screen_);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_FLIP_ROTATE_CAP_TITLE");
    }

    public Double getRotationAngle(double val) {
        if (val > 180.0 || val < 0.0) {
            this.rotAngleF.setText("");
            val = (double)this.rotAngle.getValue() / 10.0;
            if (val % 0.5 != 0.0) {
                this.rotAngleF.setText("");
                double rem = val % 0.5;
                val = rem <= 0.25 ? (val -= rem) : (val += 0.5 - rem);
            }
            this.logger.log(UserMessageLevel.USER_MSG, this.FLIP_ROTATE_ERROR_MSG + "\n" + this.FLIP_ROTATE_RESET_MSG + val);
            System.out.println("Invalid number reset to " + val);
        } else if (val % 0.5 != 0.0) {
            this.rotAngleF.setText("");
            double rem = val % 0.5;
            val = rem <= 0.25 ? (val -= rem) : (val += 0.5 - rem);
        }
        return val;
    }

    private class RotAngleFocusListener
    implements FocusListener {
        private RotAngleFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            double val = 0.0;
            try {
                val = Double.parseDouble(XpFlipRotatePanel.this.rotAngleF.getText());
                XpFlipRotatePanel.this.logger.log(UserMessageLevel.USER_MSG, "");
            }
            catch (Exception exp) {
                val = (double)XpFlipRotatePanel.this.rotAngle.getValue() / 10.0;
                XpFlipRotatePanel.this.logger.log(UserMessageLevel.USER_MSG, XpFlipRotatePanel.this.FLIP_ROTATE_ERROR_MSG + "\n" + XpFlipRotatePanel.this.FLIP_ROTATE_RESET_MSG + val);
                exp.printStackTrace();
            }
            val = XpFlipRotatePanel.this.getRotationAngle(val);
            XpFlipRotatePanel.this.rotAngleF.setText("" + val);
            int sliderVal = (int)(val * 10.0);
            XpFlipRotatePanel.this.valueChanged = true;
            XpFlipRotatePanel.this.rotAngle.setValue(sliderVal);
            if (!e.isTemporary() && XpFlipRotatePanel.this.rotAngleF.getText().length() < 1) {
                int txtVal = XpFlipRotatePanel.this.rotAngle.getValue();
                XpFlipRotatePanel.this.rotAngleF.setText("" + (double)txtVal / 10.0);
            }
        }
    }

    private class RandomRotateActionListener
    implements ActionListener {
        private RandomRotateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            TransactionLogName tln = new TransactionLogName("TID=SD_flipRotate");
            PanZoomCapable pzPort = (PanZoomCapable)XpFlipRotatePanel.this.getScreen().getCapable(PanZoomCapable.class.getName());
            if (pzPort == null) {
                XpFlipRotatePanel.this.logger.log(Level.SEVERE, "{0} SEV5 Not PanZoomCapable", tln);
                return;
            }
            float angle = Float.parseFloat(XpFlipRotatePanel.this.rotAngleF.getText());
            if (cmd.equals(XpFlipRotatePanel.ROTATE_L_RANDOM_CMD)) {
                pzPort.setRotate(pzPort.getRotate() - (double)angle);
                XpFlipRotatePanel.this.logger.log(Level.FINEST, "{0} Rotate Left by " + angle, tln);
            } else if (cmd.equals(XpFlipRotatePanel.ROTATE_R_RANDOM_CMD)) {
                pzPort.setRotate(pzPort.getRotate() + (double)angle);
                XpFlipRotatePanel.this.logger.log(Level.FINEST, "{0} Rotate Right by " + angle, tln);
            }
            pzPort.repaint();
        }
    }
}

