/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpF1FilmAction;
import com.ge.med.cse.cvf.action.XpF2FilmAction;
import com.ge.med.cse.cvf.action.XpF3FilmAction;
import com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.model.XpRangeModel;
import com.ge.med.cse.cvf.print.ForcePrint;
import com.ge.med.cse.cvf.print.PrintProgress;
import com.ge.med.cse.cvf.print.PrintRowColFormat;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.SeriesPrint;
import com.ge.med.cse.cvf.print.XpFilmErrorLookup;
import com.ge.med.cse.cvf.ui.RowColFormatToggleButton;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPageablePort;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.event.PrintJobAttributeEvent;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpFilmPanel
extends XPcaAutoControlPanel {
    private JButton flmImg;
    private JButton flmPage;
    private JButton flmMid;
    private JButton flmsers;
    private JButton flm_cancel;
    private JLabel format;
    private JLabel interval;
    private JLabel tolbl;
    private JCheckBox lastPageCheckBox;
    JLabel text;
    private JToggleButton combox;
    private JRadioButton all;
    private JRadioButton range;
    private JSpinner imgInterval;
    private JSpinner from;
    private JSpinner to;
    private JTextArea statusArea;
    private JPanel sersPanel;
    private RowColFormatToggleButton rowcolBtn;
    private static String use_fc_format = CvUtils.getResourceBundle().getString("XP_AS_IS");
    private static String FILM_IMAGE = "FilmImage";
    private static String FILM_PAGE = "FilmPage";
    private static String FILM_MID = "FilmMid";
    private static String FILM_SERIES = "FilmSeries";
    private static String CANCEL_FILM = "CancelFilm";
    private static String FILM_ALL = "AllFilm";
    private static String FILM_RANGE = "FilmRange";
    private static String FILM_FROM = "FilmFrom";
    private static String FILM_TO = "FilmTo";
    private static String FILM_INTERVAL = "FilmInterval";
    private int totalimgs;
    private transient PrintService service;
    private transient DocPrintJob job;
    private transient XpDicomElement exNo = new XpDicomElement(32, 16);
    private transient XpDicomElement seNo = new XpDicomElement(32, 17);
    private transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private boolean uiIntiated = false;
    private transient SpinnerKeyListener kl = new SpinnerKeyListener();
    private transient PropertyChangeListener vpListn = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ComponentSelection") || evt.getPropertyName().equals("CONTENT_CHANGED")) {
                if (XpFilmPanel.this.uiIntiated) {
                    boolean xsportdifferent = true;
                    if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection") && evt.getOldValue() instanceof Integer && evt.getNewValue() instanceof Integer) {
                        boolean bl = xsportdifferent = (Integer)evt.getOldValue() > -1 && evt.getOldValue() != evt.getNewValue();
                    }
                    if (XpFilmPanel.this.imageLeft <= 0 && xsportdifferent) {
                        XpFilmPanel.this.updatePanel(XpFilmPanel.this.screen_.getSelectedPort());
                    }
                }
            } else if (evt.getPropertyName().equals("reference_vp_selection")) {
                FrameCapable fcp;
                XpFrameVisualizer fv;
                SelectionCapable slcCap = (SelectionCapable)XpFilmPanel.this.screen_.getCapable(SelectionCapable.class.getName());
                JComponent port = slcCap.getViewportComponent(slcCap.getComponentSelection());
                int portIndex = XpReferenceImageApp.getSelectedRefPortIndex((XpCompositePort)port);
                if (portIndex < 0) {
                    portIndex = ((XpCompositePort)port).getComponentSelection();
                }
                if ((fv = ((XpCompositePort)port).getPort(portIndex)) != null && (fcp = (FrameCapable)((Object)fv.getCapable(FrameCapable.class.getName()))) != null) {
                    CvUtils.setEnabled(XpFilmPanel.this.sersPanel, fcp.getNumFrames() <= CvUtils.getLargeSeriesSize());
                }
            }
        }
    };
    int imageLeft = -1;
    transient DicomPageablePort pageable = null;
    private long prsStartTime = 0L;
    private int numCount = -1;
    transient PrintJobListener pjl = new PrintJobListener(){

        @Override
        public void printDataTransferCompleted(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "{0} Print Data Transfer Completed");
        }

        @Override
        public void printJobCanceled(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "Printjob canceled");
            if (XpFilmPanel.this.imageLeft > 0) {
                XpFilmPanel.this.seriesPrintComplete();
            }
            XpFilmPanel.this.statusArea.setText(CvUtils.getResourceBundle().getString("FILM_USER_CANCEL"));
        }

        @Override
        public void printJobCompleted(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "job is completed");
            if (XpFilmPanel.this.imageLeft > 0) {
                XpFilmPanel.this.seriesPrintComplete();
            }
        }

        @Override
        public void printJobFailed(final PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "Printjob failed");
            XpFilmPanel.this.statusArea.setText(CvUtils.getResourceBundle().getString("FILM_JOB_FAILED"));
            final int imgLeft = XpFilmPanel.this.imageLeft;
            if (XpFilmPanel.this.imageLeft > 0) {
                XpFilmPanel.this.seriesPrintComplete();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (pje.getPrintEventType() == 201) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 202) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 203) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 204) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 205) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 206) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 207) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 103) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = CvUtils.getResourceBundle().getString("FILM_JOB_FAILED");
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = CvUtils.getResourceBundle().getString("FILM_ERROR");
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error + pje.getPrintEventType()});
                    }
                }
            });
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "{0} Print Job No More Events");
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "{0} Print Job Requires Attention");
        }
    };
    transient PrintJobAttributeListener pjal = new PrintJobAttributeListener(){

        @Override
        public void attributeUpdate(PrintJobAttributeEvent pjae) {
            final PrintProgress pp = (PrintProgress)pjae.getAttributes().get(PrintProgress.class);
            XpFilmPanel.this.logger.log(Level.FINEST, "{0} printProgress=" + pp.toString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    --XpFilmPanel.this.imageLeft;
                    XpFilmPanel.this.numCount++;
                    if (XpFilmPanel.this.pageable != null) {
                        XpFilmPanel.this.pageable.disposePrintable(pp.getValue() - 1);
                    }
                    if (XpFilmPanel.this.imageLeft < 0) {
                        return;
                    }
                    if (XpFilmPanel.this.imageLeft == 0) {
                        XpFilmPanel.this.seriesPrintComplete();
                    } else {
                        XpFilmPanel.this.statusArea.setForeground(Color.BLACK);
                        XpFilmPanel.this.statusArea.setText("Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "      " + XpFilmPanel.this.imageLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT"));
                    }
                }
            });
        }
    };
    private SPINNER lastModifiedSpinner = SPINNER.NONE;

    public XpFilmPanel() {
        this.setIcon(CvUtils.getIcon("XP_FILM_ICON"));
        this.setBackground(null);
        this.setName("XpFilmControlPanel");
        TransactionLogName tln = new TransactionLogName("TID=CreateFilmPanel");
        this.logger.log(Level.FINE, "{0} begin Creating Film Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating Film Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.updatePanel(this.screen_.getSelectedPort());
            this.setActionCapable(this.flmImg);
            this.setActionCapable(this.flmPage);
            this.setActionCapable(this.flmMid);
            this.uiIntiated = true;
        }
        if (this.service == null) {
            this.service = CvUtils.getDefaultPrintService();
            if (this.service == null) {
                this.logger.log(Level.INFO, "{0} No service found");
                this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                this.statusArea.setText(CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR});
                return;
            }
        }
        this.job = this.service.createPrintJob();
        if (this.job == null) {
            this.logger.log(Level.INFO, "Printjob can not be created");
            return;
        }
        this.job.addPrintJobListener(this.pjl);
        this.job.addPrintJobAttributeListener(this.pjal, null);
    }

    public void setCapable(Capable c) {
        this.rowcolBtn.setCapable(c);
    }

    private void initUI() {
        this.flmImg = new JButton();
        this.flmImg.setName(FILM_IMAGE);
        this.flmImg.setAction(new XpF1FilmAction());
        this.flmImg.setFocusable(false);
        this.flmPage = new JButton();
        this.flmPage.setName(FILM_PAGE);
        this.flmPage.setAction(new XpF2FilmAction());
        this.flmPage.setFocusable(false);
        this.flmMid = new JButton();
        this.flmMid.setName(FILM_MID);
        this.flmMid.setAction(new XpF3FilmAction());
        this.flmMid.setFocusable(false);
        JPanel topbpanel = new JPanel();
        this.rowcolBtn = new RowColFormatToggleButton(8, 8);
        this.rowcolBtn.setSize(new Dimension(14, 35));
        topbpanel.setName(XpFilmPanel.class.getName() + "topbpanel");
        GroupLayout topbpanelLayout = new GroupLayout(topbpanel);
        topbpanel.setLayout(topbpanelLayout);
        topbpanelLayout.setHorizontalGroup(topbpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topbpanelLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.flmImg).addGap(20, 20, 20).addComponent(this.flmPage).addGap(20, 20, 20).addComponent(this.flmMid)));
        topbpanelLayout.setVerticalGroup(topbpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, topbpanelLayout.createSequentialGroup().addGroup(topbpanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.flmMid, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.flmImg, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.flmPage, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))));
        this.format = new JLabel(CvUtils.getResourceBundle().getString("XP_FILM_FRMAT"));
        this.format.setName(XpFilmPanel.class.getName() + "format");
        this.combox = new JToggleButton(use_fc_format);
        this.combox.setSize(new Dimension(14, 35));
        AncestorListener[] ancListener = this.combox.getAncestorListeners();
        for (int i = 0; i < ancListener.length; ++i) {
            this.combox.removeAncestorListener(ancListener[i]);
        }
        this.combox.setName(XpFilmPanel.class.getName() + "combox");
        this.combox.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.combox);
        bg.add(this.rowcolBtn);
        this.combox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XpFilmPanel.this.service == null) {
                    XpFilmPanel.this.service = CvUtils.getDefaultPrintService();
                    if (XpFilmPanel.this.service == null) {
                        XpFilmPanel.this.logger.log(Level.INFO, "{0} No service found");
                        XpFilmPanel.this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                        XpFilmPanel.this.statusArea.setText(CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR});
                        return;
                    }
                }
            }
        });
        this.combox.setFocusable(false);
        HashPrintRequestAttributeSet aset = null;
        aset = new HashPrintRequestAttributeSet();
        this.rowcolBtn.setName(XpFilmPanel.class.getName() + "rowcolBtn");
        this.lastPageCheckBox = new JCheckBox();
        this.lastPageCheckBox.setFocusable(false);
        this.lastPageCheckBox.setSelected(true);
        this.lastPageCheckBox.setName(XpFilmPanel.class.getName() + "lastPageCheckBox");
        this.text = new JLabel(CvUtils.getResourceBundle().getString("XP_FILM_LPAGE"));
        this.text.setName(XpFilmPanel.class.getName() + "text");
        JPanel lastfilmpanel = new JPanel();
        GroupLayout lastfilmpanelLayout = new GroupLayout(lastfilmpanel);
        lastfilmpanel.setName(XpFilmPanel.class.getName() + "lastfilmpanel");
        lastfilmpanel.setLayout(lastfilmpanelLayout);
        lastfilmpanelLayout.setHorizontalGroup(lastfilmpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lastfilmpanelLayout.createSequentialGroup().addContainerGap().addGap(12, 12, 12).addComponent(this.lastPageCheckBox).addGap(3, 3, 3).addComponent(this.text)));
        lastfilmpanelLayout.setVerticalGroup(lastfilmpanelLayout.createSequentialGroup().addContainerGap().addGroup(lastfilmpanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastPageCheckBox).addComponent(this.text)));
        JPanel formtpanel = new JPanel();
        GroupLayout formatPanelLayout = new GroupLayout(formtpanel);
        formtpanel.setName(XpFilmPanel.class.getName() + "formtpanel");
        GroupLayout formtpanelLayout = new GroupLayout(formtpanel);
        formtpanel.setLayout(formtpanelLayout);
        formtpanelLayout.setHorizontalGroup(formtpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formtpanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.format).addGap(3, 3, 3).addComponent(this.combox, 75, 110, 140).addGap(12, 12, 12).addComponent(this.rowcolBtn, 75, 80, 80)));
        formtpanelLayout.setVerticalGroup(formtpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formtpanelLayout.createSequentialGroup().addGroup(formtpanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.format).addComponent(this.combox).addComponent(this.rowcolBtn))));
        this.flmsers = new JButton();
        this.flmsers.setName(FILM_SERIES);
        this.flmsers.setFocusable(false);
        this.flmsers.setSize(300, 200);
        this.flmsers.setText(CvUtils.getResourceBundle().getString("XP_FILM_SERS"));
        this.flmsers.setToolTipText(CvUtils.getResourceBundle().getString("XP_FILM_SERS_TOOLTIP"));
        this.flmsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpFilmPanel.this.btPrintSeries_actionPerformed(e);
            }
        });
        this.flm_cancel = new JButton();
        this.flm_cancel.setName(CANCEL_FILM);
        this.flm_cancel.setFocusable(false);
        this.flmsers.setSize(300, 200);
        this.flm_cancel.setText(CvUtils.getResourceBundle().getString("XP_FILM_CANCEL"));
        this.flm_cancel.setToolTipText(CvUtils.getResourceBundle().getString("XP_FILM_CANCEL_TOOLTIP"));
        this.flm_cancel.setEnabled(false);
        this.flm_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpFilmPanel.this.btflmcancel_actionPerformed(e);
            }
        });
        JPanel btmbpanel = new JPanel();
        GroupLayout btmbpanelLayout = new GroupLayout(btmbpanel);
        btmbpanel.setLayout(btmbpanelLayout);
        btmbpanelLayout.setHorizontalGroup(btmbpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btmbpanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.flmsers, 100, 150, 150).addGap(50, 50, 50).addComponent(this.flm_cancel, 100, 150, 150).addContainerGap(50, Short.MAX_VALUE)));
        btmbpanelLayout.setVerticalGroup(btmbpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btmbpanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.flmsers).addComponent(this.flm_cancel)));
        Color borderColor = LookAndFeelFactory.getColor("foreground.color", null);
        this.statusArea = new JTextArea(2, 0);
        this.statusArea.setText("");
        this.statusArea.setForeground(borderColor);
        this.statusArea.setLineWrap(true);
        this.statusArea.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.statusArea.setEditable(false);
        this.statusArea.setFocusable(false);
        this.statusArea.setName(XpFilmPanel.class.getName() + "statusArea");
        JPanel statusPanel = new JPanel();
        statusPanel.setName(XpFilmPanel.class.getName() + "statusPanel");
        statusPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(borderColor), CvUtils.getResourceBundle().getString("XP_FILM_STATUS_TITLE")));
        GroupLayout statusPanelLayout = new GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusArea, -2, 280, -2)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.statusArea, -1, 32, Short.MAX_VALUE).addContainerGap()));
        this.all = new JRadioButton();
        this.all.setName(FILM_ALL);
        this.all.setText(CvUtils.getResourceBundle().getString("XP_FILM_ALL"));
        this.all.setFocusable(false);
        this.all.setSelected(true);
        this.interval = new JLabel();
        this.interval.setText(CvUtils.getResourceBundle().getString("XP_FILM_INTERVAL"));
        this.interval.setName(XpFilmPanel.class.getName() + "interval");
        this.imgInterval = new JSpinner();
        this.imgInterval.setName(FILM_INTERVAL);
        this.imgInterval.setPreferredSize(new Dimension(15, 15));
        this.imgInterval.setFocusable(false);
        this.imgInterval.setModel(new SpinnerNumberModel(1, 1, 1, 1));
        ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().addKeyListener(this.kl);
        this.from = new JSpinner();
        this.from.setName(FILM_FROM);
        this.from.setFocusable(false);
        this.from.setEnabled(false);
        this.from.setPreferredSize(new Dimension(15, 15));
        ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().addKeyListener(this.kl);
        this.tolbl = new JLabel();
        this.tolbl.setText(CvUtils.getResourceBundle().getString("ROI_PROP_TO_LABEL"));
        this.tolbl.setName(XpFilmPanel.class.getName() + "tolbl");
        this.to = new JSpinner();
        this.to.setName(FILM_TO);
        this.to.setFocusable(false);
        this.to.setEnabled(false);
        this.to.setPreferredSize(new Dimension(15, 15));
        ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().addKeyListener(this.kl);
        this.to.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        this.range = new JRadioButton();
        this.range.setName(FILM_RANGE);
        this.range.setText(CvUtils.getResourceBundle().getString("XP_FILM_RANGE"));
        this.range.setFocusable(false);
        this.range.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpFilmPanel.this.range.setSelected(true);
                XpFilmPanel.this.from.setEnabled(true);
                XpFilmPanel.this.to.setEnabled(true);
            }
        });
        this.all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpFilmPanel.this.all.setSelected(true);
                XpFilmPanel.this.from.setEnabled(false);
                XpFilmPanel.this.to.setEnabled(false);
            }
        });
        ButtonGroup gp = new ButtonGroup();
        gp.add(this.all);
        gp.add(this.range);
        JPanel allPanel = new JPanel();
        GroupLayout allPanelLayout = new GroupLayout(allPanel);
        allPanel.setLayout(allPanelLayout);
        allPanelLayout.setHorizontalGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allPanelLayout.createSequentialGroup().addContainerGap().addGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.interval).addGap(20, 20, 20).addComponent(this.imgInterval, -2, 60, -2)).addGroup(allPanelLayout.createSequentialGroup().addGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allPanelLayout.createSequentialGroup().addComponent(this.range).addGap(6, 6, 6).addComponent(this.from).addGap(6, 6, 6).addComponent(this.tolbl, 15, 35, 50).addGap(6, 6, 6).addComponent(this.to)).addComponent(this.all, -2, 67, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(allPanelLayout.createSequentialGroup().addGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(btmbpanel, 320, 320, 320).addGap(3, 3, 3).addComponent(statusPanel, 310, 310, 310))));
        allPanelLayout.setVerticalGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allPanelLayout.createSequentialGroup().addComponent(this.all).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, Short.MAX_VALUE).addGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.range).addComponent(this.from).addComponent(this.tolbl).addComponent(this.to)).addGap(10, 10, 10).addGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interval).addComponent(this.imgInterval)).addComponent(statusPanel, -2, -1, -2).addGap(3, 3, 3).addComponent(btmbpanel)));
        allPanelLayout.linkSize(0, this.from, this.to, this.imgInterval);
        this.sersPanel = new JPanel();
        this.sersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(borderColor), CvUtils.getResourceBundle().getString("XP_FILM_SERS")));
        this.sersPanel.setName(XpFilmPanel.class.getName() + "sersPanel");
        GroupLayout sersPanelLayout = new GroupLayout(this.sersPanel);
        this.sersPanel.setLayout(sersPanelLayout);
        sersPanelLayout.setHorizontalGroup(sersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sersPanelLayout.createSequentialGroup().addGroup(sersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(allPanel, -2, 320, -2).addComponent(formtpanel, -1, -1, Short.MAX_VALUE).addComponent(lastfilmpanel, -1, -1, Short.MAX_VALUE))));
        sersPanelLayout.setVerticalGroup(sersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sersPanelLayout.createSequentialGroup().addComponent(formtpanel, -2, -1, -2).addComponent(lastfilmpanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(allPanel, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sersPanel, -2, 330, -2).addComponent(topbpanel, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(topbpanel, -2, -1, -2).addComponent(this.sersPanel, -2, 310, -2)));
    }

    private void updatePanel(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (comp instanceof SelectionCapable) {
                    FramePositioningCapable fpcap = (FramePositioningCapable)((Object)comp);
                    XpFilmPanel.this.totalimgs = fpcap.getNumFrames();
                    if (XpFilmPanel.this.totalimgs < 1) {
                        return;
                    }
                    int value = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().getText());
                    SpinnerNumberModel spmodel = value > XpFilmPanel.this.totalimgs ? new SpinnerNumberModel(XpFilmPanel.this.totalimgs, 1, XpFilmPanel.this.totalimgs, 1) : new SpinnerNumberModel(value, 1, XpFilmPanel.this.totalimgs, 1);
                    XpFilmPanel.this.imgInterval.setModel(spmodel);
                    XpRangeModel model = new XpRangeModel();
                    XpFilmPanel.this.from.setModel(model.getMinRangeSpinnerModel(fpcap));
                    XpFilmPanel.this.to.setModel(model.getMaxRangeSpinnerModel(fpcap));
                    ((JSpinner.NumberEditor)XpFilmPanel.this.from.getEditor()).getTextField().removeKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.from.getEditor()).getTextField().addKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.to.getEditor()).getTextField().removeKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.to.getEditor()).getTextField().addKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().removeKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().addKeyListener(XpFilmPanel.this.kl);
                    XpFilmPanel.this.lastModifiedSpinner = SPINNER.NONE;
                    CvUtils.setEnabled(XpFilmPanel.this.sersPanel, XpFilmPanel.this.totalimgs <= CvUtils.getLargeSeriesSize());
                    if (!XpFilmPanel.this.range.isSelected()) {
                        XpFilmPanel.this.from.setEnabled(false);
                        XpFilmPanel.this.to.setEnabled(false);
                    } else {
                        XpFilmPanel.this.from.setEnabled(true);
                        XpFilmPanel.this.to.setEnabled(true);
                    }
                    if (XpFilmPanel.this.totalimgs <= CvUtils.getLargeSeriesSize()) {
                        XpFilmPanel.this.flm_cancel.setEnabled(false);
                    }
                }
            }
        });
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.screen_.removePropertyChangeListener(this.vpListn);
        this.screen_.addPropertyChangeListener(this.vpListn);
        if (this.uiIntiated) {
            this.setActionCapable(this.flmImg);
            this.setActionCapable(this.flmPage);
            this.setActionCapable(this.flmMid);
            this.updatePanel(this.screen_.getSelectedPort());
        }
    }

    private void setActionCapable(JButton flmPage2) {
        if (flmPage2.getAction() instanceof PlasmaControl) {
            ((PlasmaControl)((Object)flmPage2.getAction())).setCapable(this.screen_);
        }
    }

    public void btPrintSeries_actionPerformed(ActionEvent e) {
        final TransactionLogName tln = new TransactionLogName("TID=CV_printSeries");
        this.validateInput();
        if (this.imageLeft > 0 || CvUtils.isFilmPrintingInProgress(this.job)) {
            this.logger.log(Level.WARNING, "{0} Series Printing already in Progress", tln);
            return;
        }
        if (this.service == null) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR});
            return;
        }
        PrinterStatus ps = this.service.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (ps != null) {
            status = ps.getValue();
        }
        if (!status) {
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", tln);
            this.statusArea.setText(CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NOT_RUN")});
            return;
        }
        int index = this.screen_.getSelectedPortNumber();
        JComponent comp = this.screen_.getPort(index);
        if (comp == null || !(comp instanceof Capable) || !(comp instanceof XpViewport)) {
            this.logger.log(Level.WARNING, "{0} Filming not supported", tln);
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            return;
        }
        if (comp instanceof FrameCapable && ((FrameCapable)((Object)comp)).getNumFrames() > CvUtils.getLargeSeriesSize()) {
            this.logger.log(Level.WARNING, "{0} Print series not supported for series size > " + CvUtils.getLargeSeriesSize());
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            return;
        }
        Capable cpb = (Capable)((Object)comp);
        final XpViewport port = (XpViewport)((XpViewport)cpb).clone();
        XpAnnotationGenerator annotGen = ((XpViewport)cpb).getAnnotationGenerator();
        Properties props = annotGen instanceof XpApdAnnotationGenerator ? ((XpApdAnnotationGenerator)annotGen).getProperties() : null;
        port.setAnnotationGenerator(annotGen.getClass(), props);
        final Dimension portSize_ = port instanceof XpCompositePort ? new Dimension(((XpCompositePort)cpb).getPort(0).getWidth(), ((XpCompositePort)cpb).getPort(0).getHeight()) : new Dimension(((XpViewport)cpb).getWidth(), ((XpViewport)cpb).getHeight());
        int[] annotkey = null;
        String imageType = null;
        if (cpb instanceof FrameOwner) {
            imageType = CvUtils.getImageTypeKey(cpb);
        }
        boolean isRefAllOn = false;
        if (cpb instanceof XpCompositePort) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(((XpCompositePort)cpb).getPort(0), imageType, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            isRefAllOn = XpReferenceImageApp.isRefPortAllOn((XpCompositePort)cpb);
            if (isRefAllOn && XpReferenceImageApp.copyInstance((XpCompositePort)cpb, port, true) == null) {
                this.logger.log(Level.SEVERE, "{0} Sev5 Error in printing: Failed to copy Ref image app instance");
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FILM_ERROR")});
                return;
            }
        } else if (cpb instanceof XpImageViewport) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys((XpImageViewport)cpb, imageType, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            isRefAllOn = XpReferenceImageApp.isRefPortAllOn((XpImageViewport)cpb);
            if (isRefAllOn && XpReferenceImageApp.copyInstance((XpImageViewport)cpb, port, true) == null) {
                this.logger.log(Level.SEVERE, "{0} Sev5 Error in printing: Failed to copy Ref image app instance");
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FILM_ERROR")});
                return;
            }
        } else {
            this.logger.log(Level.WARNING, "{0} Filming not supported", tln);
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            return;
        }
        final boolean refon = isRefAllOn;
        final String filmAnnotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
        final int filmCustAnnoMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
        final int[] aKey = annotkey;
        Thread spt = new Thread(){

            @Override
            public void run() {
                block15: {
                    SimpleDoc doc = null;
                    HashPrintRequestAttributeSet aset = null;
                    aset = new HashPrintRequestAttributeSet();
                    aset.add(new SeriesPrint("SeriesPrint", new Locale("en")));
                    if (XpFilmPanel.this.lastPageCheckBox.isSelected()) {
                        aset.add(new ForcePrint("ForcePrint", new Locale("en")));
                    }
                    if (XpFilmPanel.this.rowcolBtn.isSelected() && XpFilmPanel.this.rowcolBtn.getRow() != 0 && XpFilmPanel.this.rowcolBtn.getCol() != 0) {
                        try {
                            int rows = XpFilmPanel.this.rowcolBtn.getRow();
                            int columns = XpFilmPanel.this.rowcolBtn.getCol();
                            aset.add(new PrintRowColFormat(rows, columns));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    int numFrames = 0;
                    if (port != null && port instanceof FramePositioningCapable) {
                        numFrames = ((FramePositioningCapable)((Object)port)).getNumFrames();
                    }
                    int i = 1;
                    int inc = 1;
                    int maxImage = numFrames;
                    try {
                        inc = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().getText());
                        if (XpFilmPanel.this.range.isSelected()) {
                            i = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.from.getEditor()).getTextField().getText());
                            maxImage = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.to.getEditor()).getTextField().getText());
                        }
                    }
                    catch (NumberFormatException e) {
                        XpFilmPanel.this.logger.log(Level.WARNING, "Values are non integers : " + e.getMessage());
                    }
                    XpFilmPanel.this.imageLeft = numFrames = (maxImage - i) / inc + 1;
                    if (XpFilmPanel.this.flmsers.isEnabled()) {
                        XpFilmPanel.this.flmsers.setEnabled(false);
                        XpFilmPanel.this.flm_cancel.setEnabled(true);
                    }
                    try {
                        if (port != null) {
                            double width = port.getImageAt((int)0).getSlice().width;
                            double height = port.getImageAt((int)0).getSlice().height;
                            XpFilmPanel.this.logger.log(Level.INFO, "{0} begin NUMIMAGES=" + XpFilmPanel.this.imageLeft + " IMAGESIZE=" + width + " x " + height, tln);
                            XpFilmPanel.this.prsStartTime = System.currentTimeMillis();
                            XpFilmPanel.this.numCount = 0;
                            XpDicomObject img = (XpDicomObject)((Object)port.getImageAt(i - 1));
                            img.getValues(new XpDicomElement[]{XpFilmPanel.this.exNo, XpFilmPanel.this.seNo});
                            XpFilmPanel.this.pageable = new DicomPageablePort(port, i - 1, maxImage - 1, inc);
                            XpFilmPanel.this.pageable.setSize(portSize_);
                            XpFilmPanel.this.pageable.setReferenceOn(refon);
                            XpFilmPanel.this.pageable.setLargeFontKeys(aKey);
                            XpFilmPanel.this.pageable.setFilmAnnotationSetting(filmAnnotLevel, filmCustAnnoMask);
                            doc = new SimpleDoc(XpFilmPanel.this.pageable, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
                            XpFilmPanel.this.job.print(doc, aset);
                        } else {
                            XpFilmPanel.this.logger.log(Level.WARNING, "Viewport is null", tln);
                        }
                    }
                    catch (PrintException pe) {
                        XpFilmPanel.this.logger.log(Level.SEVERE, "{0} Error in printing due to " + pe.getMessage(), tln);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, pe.getMessage()});
                        XpFilmPanel.this.imageLeft = -1;
                        if (!XpFilmPanel.this.flmsers.isEnabled()) {
                            XpFilmPanel.this.flmsers.setEnabled(true);
                            XpFilmPanel.this.flm_cancel.setEnabled(false);
                        }
                    }
                    catch (Exception ex) {
                        XpFilmPanel.this.logger.log(Level.SEVERE, "{0} Error in printing due to " + ex.getMessage(), tln);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, ex.getMessage()});
                        XpFilmPanel.this.imageLeft = -1;
                        if (XpFilmPanel.this.flmsers.isEnabled()) break block15;
                        XpFilmPanel.this.flmsers.setEnabled(true);
                        XpFilmPanel.this.flm_cancel.setEnabled(false);
                    }
                }
                XpFilmPanel.this.logger.log(Level.INFO, "{0} end", tln);
            }
        };
        spt.start();
    }

    private void btflmcancel_actionPerformed(ActionEvent e) {
        PrinterJob pjob = (PrinterJob)((Object)this.job);
        pjob.cancel();
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_FILM_PA_TOOLTIP");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_FILM_PA_NAME");
    }

    private void seriesPrintComplete() {
        this.logger.log(Level.INFO, "seriesPrintComplete called.");
        if (this.pageable != null) {
            this.pageable.dispose();
            this.pageable = null;
        }
        if (this.prsStartTime > 0L) {
            long endTime = System.currentTimeMillis();
            if ((endTime - this.prsStartTime) / 1000L > 0L) {
                long prsRate = (long)this.numCount / ((endTime - this.prsStartTime) / 1000L);
                this.logger.log(Level.INFO, "FILMRATE = {0} images/sec", prsRate);
            }
            this.prsStartTime = 0L;
            this.numCount = -1;
        }
        this.imageLeft = -1;
        this.lastModifiedSpinner = SPINNER.NONE;
        this.statusArea.setText("");
        if (!this.flmsers.isEnabled()) {
            this.flmsers.setEnabled(true);
            this.flm_cancel.setEnabled(false);
        }
    }

    private void validateInput() {
        int toInt;
        int fromInt;
        String fromStrVal = ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().getText();
        String toStrVal = ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().getText();
        String imgIntervalStrVal = ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().getText();
        if (fromStrVal == null || fromStrVal.equals("")) {
            ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
        }
        if (toStrVal == null || toStrVal.equals("")) {
            ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
        }
        if (imgIntervalStrVal == null || imgIntervalStrVal.equals("")) {
            ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMinimum()));
        }
        int min = Integer.parseInt(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
        int max = Integer.parseInt(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
        try {
            fromStrVal = ((JSpinner.DefaultEditor)this.from.getEditor()).getTextField().getText();
            fromInt = Integer.parseInt(fromStrVal);
            if (fromInt < min || fromInt > CvUtils.getLargeSeriesSize()) {
                ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
            }
        }
        catch (NumberFormatException nfe) {
            ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
        }
        try {
            toStrVal = ((JSpinner.DefaultEditor)this.to.getEditor()).getTextField().getText();
            toInt = Integer.parseInt(toStrVal);
            if (toInt > max || toInt > CvUtils.getLargeSeriesSize()) {
                ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
            }
        }
        catch (NumberFormatException nfe) {
            ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
        }
        try {
            imgIntervalStrVal = ((JSpinner.DefaultEditor)this.imgInterval.getEditor()).getTextField().getText();
            int imgIntervalInt = Integer.parseInt(imgIntervalStrVal);
            if (imgIntervalInt <= 0) {
                ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMinimum()));
            }
            if (imgIntervalInt > max || imgIntervalInt > CvUtils.getLargeSeriesSize()) {
                ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMaximum()));
            }
        }
        catch (NumberFormatException nfe) {
            ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMinimum()));
        }
        fromStrVal = ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().getText();
        toStrVal = ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().getText();
        imgIntervalStrVal = ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().getText();
        try {
            fromInt = Integer.parseInt(fromStrVal);
            toInt = Integer.parseInt(toStrVal);
            if (fromInt > toInt) {
                if (this.lastModifiedSpinner == SPINNER.FROM) {
                    ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
                } else if (this.lastModifiedSpinner == SPINNER.TO) {
                    ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
                }
            }
            this.lastModifiedSpinner = SPINNER.NONE;
        }
        catch (Exception e) {
            this.lastModifiedSpinner = SPINNER.NONE;
        }
    }

    private class SpinnerKeyListener
    implements KeyListener {
        private SpinnerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String componentName = ((JFormattedTextField)e.getSource()).getParent().getParent().getName();
            if (componentName.equalsIgnoreCase(FILM_FROM)) {
                XpFilmPanel.this.lastModifiedSpinner = SPINNER.FROM;
            } else if (componentName.equalsIgnoreCase(FILM_TO)) {
                XpFilmPanel.this.lastModifiedSpinner = SPINNER.TO;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if ((c < '0' || c > '9') && c != '\b' && c != '\u007f') {
                XpFilmPanel.this.getToolkit().beep();
                e.consume();
            }
        }
    }

    private static enum SPINNER {
        NONE,
        FROM,
        TO;

    }
}

