/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.cpanels.XpFilmCustomAnnotation;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class XpFilmAnnotationPanel
extends XPcaAutoControlPanel
implements XpIPrefsCallBack {
    JRadioButton fullAnnot;
    JRadioButton partlAnnot;
    JRadioButton noAnnot;
    JRadioButton custmAnnot;
    JPanel radbutPanel;
    JPanel saveBtPanel;
    JPanel mainPanel;
    JPanel topPanel;
    JButton custm;
    JButton save;
    ButtonGroup bg;
    private boolean initialized = false;
    XpFilmCustomAnnotation custmPanel = new XpFilmCustomAnnotation(this);
    transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equals("data_changed") || evt.getPropertyName().equals("VOLUME_PROPERTY")) {
                if (!XpFilmAnnotationPanel.this.initialized) {
                    XpFilmAnnotationPanel.this.updateAnnotationSettings();
                    XpFilmAnnotationPanel.this.initialized = true;
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("film_annotation_level")) {
                String level = (String)evt.getNewValue();
                if (level == null) {
                    return;
                }
                if (level.equalsIgnoreCase("all")) {
                    XpFilmAnnotationPanel.this.fullAnnot.setSelected(true);
                } else if (level.equalsIgnoreCase("partial")) {
                    XpFilmAnnotationPanel.this.partlAnnot.setSelected(true);
                } else if (level.equalsIgnoreCase("custom")) {
                    XpFilmAnnotationPanel.this.custmAnnot.setSelected(true);
                } else {
                    XpFilmAnnotationPanel.this.noAnnot.setSelected(true);
                }
            }
        }
    };
    transient ActionListener annotLevelChangeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            TransactionLogName tln = new TransactionLogName("TID=CV_filmAnnotationLevel_" + cmd);
            XpFilmAnnotationPanel.this.logger.log(Level.INFO, "{0} begin", tln);
            XPDisplayPrefsUtils.updateFilmAnnotatLevel(cmd);
            XpFilmAnnotationPanel.this.screen_.putClientProperty("film_annotation_level", cmd);
            XpFilmAnnotationPanel.this.logger.log(Level.INFO, "{0} end", tln);
        }
    };

    public XpFilmAnnotationPanel() {
        TransactionLogName tln = new TransactionLogName("CreateFilmAnnotationPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating FilmAnnotationPanel", tln);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating FilmAnnotationPanel", tln);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        this.setIcon(CvUtils.getIcon("XP_FILM_ANNOT_SETTINGS_ICON"));
        this.setTitle(CvUtils.getResourceBundle().getString("XP_FILM_ANNOT_SETTINGS_TITLE"));
        this.fullAnnot = new JRadioButton();
        this.fullAnnot.setText(CvUtils.getResourceBundle().getString("XP_ANN_FULL_NAME"));
        this.fullAnnot.setFocusable(false);
        this.fullAnnot.addActionListener(this.annotLevelChangeListener);
        this.fullAnnot.setName("filmFullAnnotn");
        this.fullAnnot.setActionCommand("all");
        this.partlAnnot = new JRadioButton();
        this.partlAnnot.setText(CvUtils.getResourceBundle().getString("XP_ANN_PART_NAME"));
        this.partlAnnot.setFocusable(false);
        this.partlAnnot.addActionListener(this.annotLevelChangeListener);
        this.partlAnnot.setName("filmPartlAnnotn");
        this.partlAnnot.setActionCommand("partial");
        this.noAnnot = new JRadioButton();
        this.noAnnot.setText(CvUtils.getResourceBundle().getString("XP_ANN_NO_NAME"));
        this.noAnnot.setFocusable(false);
        this.noAnnot.addActionListener(this.annotLevelChangeListener);
        this.noAnnot.setActionCommand("none");
        this.noAnnot.setName("filmNoAnnotn");
        this.custmAnnot = new JRadioButton();
        this.custmAnnot.setText(CvUtils.getResourceBundle().getString("XP_CUSTM_ANN_NAME"));
        this.custmAnnot.setFocusable(false);
        this.custmAnnot.setActionCommand("custom");
        this.custmAnnot.addActionListener(this.annotLevelChangeListener);
        this.custmAnnot.setName("filmCustmAnnotn");
        this.bg = new ButtonGroup();
        this.bg.add(this.fullAnnot);
        this.bg.add(this.partlAnnot);
        this.bg.add(this.noAnnot);
        this.bg.add(this.custmAnnot);
        String annotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
        if (annotLevel.equals("all")) {
            this.fullAnnot.setSelected(true);
        } else if (annotLevel.equals("partial")) {
            this.partlAnnot.setSelected(true);
        } else if (annotLevel.equals("none")) {
            this.noAnnot.setSelected(true);
        } else if (annotLevel.equals("custom")) {
            this.custmAnnot.setSelected(true);
        }
        this.custm = new JButton();
        this.custm.setText(CvUtils.getResourceBundle().getString("XP_ANNOT_CUSTOM_NAME"));
        this.custm.setFocusable(false);
        this.custm.setName("filmCustmBtn");
        this.custm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpFilmAnnotationPanel.this.custm_but_actionPerformed(e);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.custmAnnot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 20), 0, 0));
        panel.add((Component)this.custm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        panel.setName(XpFilmAnnotationPanel.class.getName() + "panel");
        this.saveBtPanel = new JPanel();
        this.save = new JButton(new XpSavePrefsAction(this));
        this.save.setText(CvUtils.getResourceBundle().getString("XP_SAVE_PREFS_NAME"));
        this.save.setFocusable(false);
        this.save.setName("filmAnnotSaveBtn");
        this.saveBtPanel.setLayout(new GridBagLayout());
        this.saveBtPanel.add((Component)this.save, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 20), 0, 0));
        this.saveBtPanel.setName(XpFilmAnnotationPanel.class.getName() + "saveBtPanel");
        this.radbutPanel = new JPanel();
        this.radbutPanel.setLayout(new GridBagLayout());
        this.radbutPanel.add((Component)this.fullAnnot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 0, 10, 20), 0, 0));
        this.radbutPanel.setName(XpFilmAnnotationPanel.class.getName() + "radbutPanel");
        this.radbutPanel.add((Component)this.partlAnnot, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        this.radbutPanel.add((Component)this.noAnnot, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        this.radbutPanel.add((Component)panel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 40, 20), 0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)this.radbutPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.setName(XpFilmAnnotationPanel.class.getName() + "panel1");
        panel1.add((Component)this.saveBtPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)panel1, "North");
        this.mainPanel.setName(XpFilmAnnotationPanel.class.getName() + "mainPanel");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.mainPanel, "Center");
        this.topPanel.setName(XpFilmAnnotationPanel.class.getName() + "topPanel");
        this.add((Component)this.topPanel, "Center");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.screen_ = screen;
        this.screen_.removePropertyChangeListener(this.vpListener);
        this.screen_.addPropertyChangeListener(this.vpListener);
        this.updateAnnotationSettings();
    }

    private void custm_but_actionPerformed(ActionEvent e) {
        this.topPanel.removeAll();
        this.topPanel.add((Component)this.custmPanel, "Center");
        this.custmPanel.setScreen(this.screen_);
        this.topPanel.updateUI();
    }

    @Override
    public void sync() {
        if (this.fullAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveFilmAnnotatLevel("all");
        } else if (this.partlAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveFilmAnnotatLevel("partial");
        } else if (this.noAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveFilmAnnotatLevel("none");
        } else if (this.custmAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveFilmAnnotatLevel("custom");
            XPDisplayPrefsUtils.saveFilmCustomAnnotationLevel(XPDisplayPrefsUtils.getFilmCustomAnnotationLevel());
        }
    }

    private void updateAnnotationSettings() {
        String annotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
        if (annotLevel.equalsIgnoreCase("all")) {
            this.fullAnnot.setSelected(true);
        } else if (annotLevel.equalsIgnoreCase("partial")) {
            this.partlAnnot.setSelected(true);
        } else if (annotLevel.equalsIgnoreCase("custom")) {
            this.custmAnnot.setSelected(true);
        } else if (annotLevel.equalsIgnoreCase("none")) {
            this.noAnnot.setSelected(true);
        }
    }
}

