/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.crossref.CvCrossRefUtils;
import com.ge.med.cse.cvf.crossref.XPCrossRefLinesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpCrossReferencePanel
extends XPcaAutoControlPanel
implements ActionListener {
    JRadioButton allImgsBtn;
    JRadioButton imgRangeBtn;
    JRadioButton startImgNoBtn;
    JRadioButton imageNoBtn;
    JRadioButton firstlastImgsBtn;
    JSpinner seriesNo;
    JSpinner startRange;
    JSpinner endRange;
    JSpinner startImgNo;
    JSpinner imgNo;
    JSpinner imgInterval;
    JLabel rangelbl;
    JLabel seriesNolbl;
    JLabel imgIntervallbl;
    JButton addBtn;
    JButton appendBtn;
    JButton eraseBtn;
    ButtonGroup imgSelGroup;
    JPanel seriesPnl;
    JPanel imgRangePnl;
    JPanel startImgNoPnl;
    JPanel imgNoPnl;
    JPanel imgSelectnPnl;
    JPanel imgIntrvlPnl;
    JPanel selectnPnl;
    JPanel actionBtnPnl;
    private static final String ALL_IMAGES = "all_images";
    private static final String IMAGE_RANGE = "image_range";
    private static final String START_IMAGE_NO = "start_image_no";
    private static final String IMAGE_NO = "image_no";
    private static final String FIRST_LAST_IMAGES = "first_last_images";
    private static final String ADD_IMAGES = "add_images";
    private static final String APPEND_IMAGES = "append_images";
    private static final String ERASE_IMAGES = "erase_images";
    private final transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    ArrayList<Integer> seriesNoList = new ArrayList();
    ArrayList<Integer> imageNoList = new ArrayList();
    transient ImgOptionSelectionListener imgOptnSelListener = new ImgOptionSelectionListener();
    private transient PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ComponentSelection")) {
                XpCrossReferencePanel.this.updatePanel(XpCrossReferencePanel.this.screen_.getSelectedPort());
            } else if (evt.getPropertyName().equalsIgnoreCase("CONTENT_CHANGED")) {
                XpCrossReferencePanel.this.updatePanel(XpCrossReferencePanel.this.screen_.getSelectedPort());
            }
        }
    };

    public XpCrossReferencePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startRange.setEnabled(false);
        this.endRange.setEnabled(false);
        this.startImgNo.setEnabled(false);
        this.imgNo.setEnabled(false);
    }

    private void jbInit() throws Exception {
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        this.setIcon(null);
        this.setName("<html> Cross <br> Ref </html>");
        this.setTitle("Cross Reference");
        this.seriesNolbl = new JLabel("Series Number");
        this.seriesNolbl.setName(XpCrossReferencePanel.class.getName() + "seriesNolbl");
        this.seriesNo = new JSpinner();
        this.seriesNo.setName("seriesNo");
        this.seriesNo.setPreferredSize(new Dimension(70, 25));
        this.seriesPnl = new JPanel(new GridBagLayout());
        this.seriesPnl.add((Component)this.seriesNolbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.seriesPnl.add((Component)this.seriesNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.seriesPnl.setName(XpCrossReferencePanel.class.getName() + "seriesPnl");
        this.allImgsBtn = new JRadioButton();
        this.allImgsBtn.setText("All");
        this.allImgsBtn.setName("allImgsBtn");
        this.allImgsBtn.setFocusable(false);
        this.allImgsBtn.setActionCommand(ALL_IMAGES);
        this.allImgsBtn.setSelected(true);
        this.allImgsBtn.addActionListener(this.imgOptnSelListener);
        this.imgRangeBtn = new JRadioButton();
        this.imgRangeBtn.setText("Image Range");
        this.imgRangeBtn.setName("imgRangeBtn");
        this.imgRangeBtn.setFocusable(false);
        this.imgRangeBtn.setActionCommand(IMAGE_RANGE);
        this.imgRangeBtn.addActionListener(this.imgOptnSelListener);
        this.startRange = new JSpinner();
        this.startRange.setName("startRange");
        this.startRange.setPreferredSize(new Dimension(70, 25));
        this.rangelbl = new JLabel("to");
        this.rangelbl.setName(XpCrossReferencePanel.class.getName() + "rangelbl");
        this.endRange = new JSpinner();
        this.endRange.setName("endRange");
        this.endRange.setPreferredSize(new Dimension(70, 25));
        this.imgRangePnl = new JPanel(new GridBagLayout());
        this.imgRangePnl.add((Component)this.startRange, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 30, 0, 10), 0, 0));
        this.imgRangePnl.add((Component)this.rangelbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.imgRangePnl.add((Component)this.endRange, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.imgRangePnl.setName(XpCrossReferencePanel.class.getName() + "imgRangePnl");
        this.startImgNoBtn = new JRadioButton();
        this.startImgNoBtn.setText("Start Image Number");
        this.startImgNoBtn.setName("startImgNoBtn");
        this.startImgNoBtn.setFocusable(false);
        this.startImgNoBtn.setActionCommand(START_IMAGE_NO);
        this.startImgNoBtn.addActionListener(this.imgOptnSelListener);
        this.startImgNo = new JSpinner();
        this.startImgNo.setName("startImgNo");
        this.startImgNo.setPreferredSize(new Dimension(70, 25));
        this.startImgNoPnl = new JPanel(new GridBagLayout());
        this.startImgNoPnl.add((Component)this.startImgNoBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.startImgNoPnl.add((Component)this.startImgNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.startImgNoPnl.setName(XpCrossReferencePanel.class.getName() + "startImgNoPnl");
        this.imageNoBtn = new JRadioButton();
        this.imageNoBtn.setText("Image Number");
        this.imageNoBtn.setName("imageNoBtn");
        this.imageNoBtn.setFocusable(false);
        this.imageNoBtn.setActionCommand(IMAGE_NO);
        this.imageNoBtn.addActionListener(this.imgOptnSelListener);
        this.imgNo = new JSpinner();
        this.imgNo.setName("imgNo");
        this.imgNo.setPreferredSize(new Dimension(70, 25));
        this.imgNoPnl = new JPanel(new GridBagLayout());
        this.imgNoPnl.add((Component)this.imageNoBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.imgNoPnl.add((Component)this.imgNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.imgNoPnl.setName(XpCrossReferencePanel.class.getName() + "imgNoPnl");
        this.firstlastImgsBtn = new JRadioButton();
        this.firstlastImgsBtn.setText("First And Last Images");
        this.firstlastImgsBtn.setName("firstlastImgsBtn");
        this.firstlastImgsBtn.setFocusable(false);
        this.firstlastImgsBtn.setActionCommand(FIRST_LAST_IMAGES);
        this.firstlastImgsBtn.addActionListener(this.imgOptnSelListener);
        this.imgSelGroup = new ButtonGroup();
        this.imgSelGroup.add(this.allImgsBtn);
        this.imgSelGroup.add(this.imgRangeBtn);
        this.imgSelGroup.add(this.startImgNoBtn);
        this.imgSelGroup.add(this.imageNoBtn);
        this.imgSelGroup.add(this.firstlastImgsBtn);
        this.imgSelectnPnl = new JPanel(new GridBagLayout());
        this.imgSelectnPnl.add((Component)this.allImgsBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imgSelectnPnl.add((Component)this.imgRangeBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imgSelectnPnl.add((Component)this.imgRangePnl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imgSelectnPnl.add((Component)this.startImgNoPnl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.imgSelectnPnl.add((Component)this.imgNoPnl, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imgSelectnPnl.add((Component)this.firstlastImgsBtn, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imgSelectnPnl.setName(XpCrossReferencePanel.class.getName() + "imgSelectnPnl");
        this.imgIntervallbl = new JLabel("Image Interval");
        this.imgIntervallbl.setName("imgIntervallbl");
        this.imgIntervallbl.setFocusable(false);
        this.imgInterval = new JSpinner();
        this.imgInterval.setName("imgInterval");
        this.imgInterval.setPreferredSize(new Dimension(70, 25));
        this.imgIntrvlPnl = new JPanel(new GridBagLayout());
        this.imgIntrvlPnl.add((Component)this.imgIntervallbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.imgIntrvlPnl.add((Component)this.imgInterval, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.imgIntrvlPnl.setName(XpCrossReferencePanel.class.getName() + "imgIntrvlPnl");
        this.selectnPnl = new JPanel(new GridBagLayout());
        this.selectnPnl.add((Component)this.seriesPnl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.selectnPnl.add((Component)this.imgSelectnPnl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.selectnPnl.add((Component)this.imgIntrvlPnl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectnPnl, "North");
        this.selectnPnl.setName(XpCrossReferencePanel.class.getName() + "selectnPnl");
        this.addBtn = new JButton();
        this.addBtn.setText("Add");
        this.addBtn.setName("addBtn");
        this.addBtn.setFocusable(false);
        this.addBtn.setActionCommand(ADD_IMAGES);
        this.addBtn.setPreferredSize(new Dimension(60, 30));
        this.addBtn.addActionListener(this);
        this.appendBtn = new JButton();
        this.appendBtn.setText("Append");
        this.appendBtn.setName("appendBtn");
        this.appendBtn.setFocusable(false);
        this.appendBtn.setActionCommand(APPEND_IMAGES);
        this.appendBtn.setPreferredSize(new Dimension(60, 30));
        this.appendBtn.addActionListener(this);
        this.eraseBtn = new JButton();
        this.eraseBtn.setText("Erase");
        this.eraseBtn.setName("eraseBtn");
        this.eraseBtn.setFocusable(false);
        this.eraseBtn.setActionCommand(ERASE_IMAGES);
        this.eraseBtn.setPreferredSize(new Dimension(60, 30));
        this.eraseBtn.addActionListener(this);
        this.actionBtnPnl = new JPanel(new GridBagLayout());
        this.actionBtnPnl.add((Component)this.addBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.actionBtnPnl.add((Component)this.appendBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.actionBtnPnl.add((Component)this.eraseBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.actionBtnPnl.setName(XpCrossReferencePanel.class.getName() + "actionBtnPnl");
        this.add((Component)this.actionBtnPnl, "Center");
    }

    private void updatePanel(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (comp instanceof Capable) {
                    DMSystem dmsys = null;
                    try {
                        dmsys = CvUtils.getDMSystem();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    DMSession sess = dmsys != null ? dmsys.getLocalDB() : null;
                    XpViewport compPort = null;
                    if (XpCrossReferencePanel.this.getSelectedViewPort() == null) {
                        XpCrossReferencePanel.this.logger.log(Level.WARNING, "Slected viewport is null.");
                        return;
                    }
                    compPort = XpCrossReferencePanel.this.getSelectedViewPort();
                    XpCrossReferencePanel.this.populateSeriesImgNoList(sess, compPort);
                    SpinnerListModel seriesNoModel = new SpinnerListModel(XpCrossReferencePanel.this.seriesNoList);
                    seriesNoModel.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            XpCrossReferencePanel.this.populateRemainingSpinners();
                        }
                    });
                    XpCrossReferencePanel.this.seriesNo.setModel(seriesNoModel);
                    XpCrossReferencePanel.this.populateRemainingSpinners();
                }
            }
        });
    }

    private XpViewport getSelectedViewPort() {
        if (this.screen_ == null || !(this.screen_ instanceof XPscreen)) {
            return null;
        }
        JComponent com = this.screen_.getSelectedPort();
        while (com != null && com instanceof XPscreen) {
            com = ((XPscreen)com).getSelectedPort();
        }
        if (com instanceof XpViewport) {
            return (XpViewport)com;
        }
        return null;
    }

    private void populateSeriesImgNoList(DMSession sess, XpViewport compPort) {
        XpImage img;
        this.seriesNoList.clear();
        this.imageNoList.clear();
        if (sess == null || compPort == null) {
            return;
        }
        String examid = (String)((XpMedicalDmImage)compPort.getImages()[0]).getDMImage().getValue(new DMTag(32, 16));
        String examuid = (String)((XpMedicalDmImage)compPort.getImages()[0]).getDMImage().getValue(new DMTag(32, 13));
        String query = "(0x0020, 0x000D) = " + examuid;
        if (examid != null && examid.trim().length() > 0) {
            query = query + " AND (0x0020, 0x0010) = " + examid;
        }
        DMObject[] dmo1 = sess.getRelated("study", new DMQuery(query));
        DMObject[] seriesObj = dmo1[0].getRelated("series");
        this.sortImages(seriesObj);
        DMImage dmimg = null;
        if (compPort instanceof FrameOwner && (img = ((FrameOwner)((Object)compPort)).getFrame()) != null && img instanceof XpMedicalDmImage) {
            dmimg = ((XpMedicalDmImage)img).getDMImage();
        }
        for (int i = 0; i < seriesObj.length; ++i) {
            String imgNo;
            CvCrossRefUtils.CrossRefResult result = CvCrossRefUtils.isSeriesValidForCrossReference(seriesObj[i], dmimg);
            if (result == null || result.status != -1) continue;
            String seriesNo = (String)seriesObj[i].getValue(32, 17);
            if (seriesNo != null) {
                this.seriesNoList.add(new Integer(seriesNo.trim()));
            }
            if ((imgNo = this.getTotalImages(seriesObj[i])) == null) continue;
            this.imageNoList.add(new Integer(imgNo));
        }
    }

    public void sortImages(DMObject[] images) {
        Arrays.sort(images, new Comparator(){

            public int compare(Object o1, Object o2) {
                DMObject img1 = (DMObject)o1;
                DMObject img2 = (DMObject)o2;
                XpDicomElement dicomElem2 = new XpDicomElement(32, 17);
                dicomElem2.value = img1.getValue(dicomElem2.group, dicomElem2.element);
                int imgNum1 = dicomElem2.getIntValue();
                dicomElem2.value = img2.getValue(dicomElem2.group, dicomElem2.element);
                int imgNum2 = dicomElem2.getIntValue();
                if (imgNum1 < imgNum2) {
                    return -1;
                }
                if (imgNum1 > imgNum2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private String getTotalImages(Object value) {
        if (value == null || !(value instanceof DMObject)) {
            return null;
        }
        DMObject obj = (DMObject)value;
        int num = obj.getNumberOfRelated("image");
        return "" + num;
    }

    private void populateRemainingSpinners() {
        int value = (Integer)this.seriesNo.getValue();
        SpinnerNumberModel startRangeModel = null;
        SpinnerNumberModel endRangeModel = null;
        SpinnerNumberModel startImgNoModel = null;
        SpinnerNumberModel imgNoMOdel = null;
        SpinnerNumberModel imgIntervalModel = null;
        if (value > 0) {
            int totalImg = this.imageNoList.get(this.seriesNoList.indexOf(value));
            startRangeModel = new SpinnerNumberModel(1, 1, totalImg, 1);
            this.startRange.setModel(startRangeModel);
            endRangeModel = new SpinnerNumberModel(totalImg, 1, totalImg, 1);
            this.endRange.setModel(endRangeModel);
            startImgNoModel = new SpinnerNumberModel(1, 1, totalImg, 1);
            this.startImgNo.setModel(startImgNoModel);
            imgNoMOdel = new SpinnerNumberModel(1, 1, totalImg, 1);
            this.imgNo.setModel(imgNoMOdel);
            imgIntervalModel = new SpinnerNumberModel(1, 1, totalImg, 1);
            this.imgInterval.setModel(imgIntervalModel);
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        XPCrossRefLinesManager.setScreen(screen);
        this.updatePanel(this.screen_.getSelectedPort());
        this.screen_.removePropertyChangeListener(this.viewPortListener);
        this.screen_.addPropertyChangeListener(this.viewPortListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ADD_IMAGES) || e.getActionCommand().equals(APPEND_IMAGES)) {
            int seriesno = (Integer)this.seriesNo.getValue();
            int startImg = 0;
            int endImg = 0;
            if (seriesno > 0 & this.allImgsBtn.isSelected()) {
                startImg = 1;
                endImg = this.imageNoList.get(this.seriesNoList.indexOf(seriesno));
            } else if (this.imgRangeBtn.isSelected()) {
                startImg = (Integer)this.startRange.getValue();
                endImg = (Integer)this.endRange.getValue();
            } else if (this.startImgNoBtn.isSelected()) {
                startImg = (Integer)this.startImgNo.getValue();
                endImg = this.imageNoList.get(this.seriesNoList.indexOf(seriesno));
            } else if (this.imageNoBtn.isSelected()) {
                startImg = (Integer)this.imgNo.getValue();
                endImg = (Integer)this.imgNo.getValue();
            } else if (this.firstlastImgsBtn.isSelected()) {
                startImg = -1;
                endImg = -1;
            }
            int interval = -1;
            if (this.imgInterval.isEnabled()) {
                interval = (Integer)this.imgInterval.getValue();
            }
            boolean append = false;
            if (e.getActionCommand().equals(APPEND_IMAGES)) {
                append = true;
            }
            XPCrossRefLinesManager.putCrossReferenceLines(seriesno, startImg, endImg, interval, append);
        } else if (e.getActionCommand().equals(APPEND_IMAGES)) {
            this.imgInterval.setEnabled(false);
        } else if (e.getActionCommand().equals(ERASE_IMAGES)) {
            XPCrossRefLinesManager.removeCrossReferenceLines();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Cross Refence Panel");
        frame.setContentPane(new XpCrossReferencePanel());
        frame.setResizable(true);
        frame.setSize(new Dimension(300, 300));
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class ImgOptionSelectionListener
    implements ActionListener {
        private ImgOptionSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(XpCrossReferencePanel.ALL_IMAGES)) {
                XpCrossReferencePanel.this.startRange.setEnabled(false);
                XpCrossReferencePanel.this.endRange.setEnabled(false);
                XpCrossReferencePanel.this.startImgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgInterval.setEnabled(true);
            } else if (e.getActionCommand().equals(XpCrossReferencePanel.IMAGE_RANGE)) {
                XpCrossReferencePanel.this.startRange.setEnabled(true);
                XpCrossReferencePanel.this.endRange.setEnabled(true);
                XpCrossReferencePanel.this.startImgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgInterval.setEnabled(true);
            } else if (e.getActionCommand().equals(XpCrossReferencePanel.START_IMAGE_NO)) {
                XpCrossReferencePanel.this.startRange.setEnabled(false);
                XpCrossReferencePanel.this.endRange.setEnabled(false);
                XpCrossReferencePanel.this.startImgNo.setEnabled(true);
                XpCrossReferencePanel.this.imgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgInterval.setEnabled(true);
            } else if (e.getActionCommand().equals(XpCrossReferencePanel.IMAGE_NO)) {
                XpCrossReferencePanel.this.startRange.setEnabled(false);
                XpCrossReferencePanel.this.endRange.setEnabled(false);
                XpCrossReferencePanel.this.startImgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgNo.setEnabled(true);
                XpCrossReferencePanel.this.imgInterval.setEnabled(true);
            } else if (e.getActionCommand().equals(XpCrossReferencePanel.FIRST_LAST_IMAGES)) {
                XpCrossReferencePanel.this.startRange.setEnabled(false);
                XpCrossReferencePanel.this.endRange.setEnabled(false);
                XpCrossReferencePanel.this.startImgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgNo.setEnabled(false);
                XpCrossReferencePanel.this.imgInterval.setEnabled(false);
            }
        }
    }
}

