/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.model.XpRangeModel;
import com.ge.med.cse.cvf.ui.CVCineRateSlider;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwCineFrameRangeControl;
import com.ge.med.terra.xpv.autoControls.XPwCineModeControl;
import com.ge.med.terra.xpv.autoControls.XPwCineSkipControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class XpCinePanel
extends XPcaAutoControlPanel
implements ActionListener {
    private XPwCineFrameRangeControl fromSpinner = new XPwCineFrameRangeControl(true);
    private XPwCineFrameRangeControl toSpinner = new XPwCineFrameRangeControl(false);
    private XPwCineSkipControl intervalSpinner = new XPwCineSkipControl();
    private XPwCineModeControl pongBut = new XPwCineModeControl(false);
    private XPwCineModeControl loopBut = new XPwCineModeControl(true);
    private CVCineRateSlider slider = new CVCineRateSlider();
    private transient XpRangeModel rangmodel = null;
    private JButton playFrw;
    private JButton playBkw;
    private JButton end;
    private JButton begin;
    private JButton stepFrw;
    private JButton stepBkw;
    private JRadioButton playAll;
    private JRadioButton playRange;
    private ButtonGroup bg;
    private JLabel intvLbl;
    private JLabel plyModeLbl;
    private JLabel frmMinRateLbl;
    private JLabel frmMaxRateLbl;
    private JLabel rangelbl;
    private JTextArea frmRateLbl;
    private JPanel buttonPanel;
    private int allOptn;
    private int rangOptn;
    private int totalImgs;
    private transient PlayOptionListener listener = new PlayOptionListener();
    private static final String PLAY_FORWARD = "play_forward";
    private static final String PAUSE = "pause";
    private static final String PLAY_BACKWARD = "play_backward";
    private static final String STEP_FORWARD = "step forward";
    private static final String STEP_BACKWARD = "step_backward";
    private static final String BEGIN = "begin";
    private static final String END = "end";
    private static final String playAllbtn = "all";
    private static final String playrangebtn = "range";
    private boolean playOptn = true;
    private boolean playDir;
    private transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiIntiated = false;
    private transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CineCapable cpb = (CineCapable)XpCinePanel.this.getScreen().getCapable(CineCapable.class.getName());
            int skip = 0;
            if (cpb != null) {
                skip = cpb.getCineSkip();
            }
            if (evt.getPropertyName().equals("parent_port_changed") && (Integer)evt.getNewValue() >= 0) {
                XpCinePanel.this.updatePanel();
            }
            if (!evt.getPropertyName().equals("ComponentSelection")) {
                if (evt.getPropertyName().equals("CONTENT_CHANGED")) {
                    XpCinePanel.this.updatePanel();
                } else if (evt.getPropertyName().equals("Cine")) {
                    if (evt.getNewValue().toString().equalsIgnoreCase("true")) {
                        if (XpCinePanel.this.uiIntiated) {
                            if (skip < 0) {
                                XpCinePanel.this.playBkw.setIcon(CvUtils.getIcon("XP_CINE_PAUSE_ICON"));
                                XpCinePanel.this.playBkw.setToolTipText(CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP"));
                                XpCinePanel.this.playBkw.setActionCommand(XpCinePanel.PAUSE);
                                XpCinePanel.this.playFrw.setEnabled(false);
                                XpCinePanel.this.playDir = false;
                            } else {
                                XpCinePanel.this.playFrw.setIcon(CvUtils.getIcon("XP_CINE_PAUSE_ICON"));
                                XpCinePanel.this.playFrw.setToolTipText(CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP"));
                                XpCinePanel.this.playFrw.setActionCommand(XpCinePanel.PAUSE);
                                XpCinePanel.this.playBkw.setEnabled(false);
                                XpCinePanel.this.playDir = true;
                            }
                            if (cpb != null) {
                                XpCinePanel.this.slider.setValue(1000 / cpb.getCineRate());
                            }
                            XpCinePanel.this.playAll.setEnabled(false);
                            XpCinePanel.this.playRange.setEnabled(false);
                            XpCinePanel.this.toSpinner.setEnabled(false);
                            XpCinePanel.this.fromSpinner.setEnabled(false);
                            XpCinePanel.this.stepFrw.setEnabled(false);
                            XpCinePanel.this.stepBkw.setEnabled(false);
                            XpCinePanel.this.begin.setEnabled(false);
                            XpCinePanel.this.end.setEnabled(false);
                        }
                    } else if (evt.getNewValue().toString().equalsIgnoreCase("false") && XpCinePanel.this.uiIntiated) {
                        if (XpCinePanel.this.playDir) {
                            XpCinePanel.this.playFrw.setIcon(CvUtils.getIcon("XP_CINE_PLY_FW_ICON"));
                            XpCinePanel.this.playFrw.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_FW"));
                            XpCinePanel.this.playFrw.setActionCommand(XpCinePanel.PLAY_FORWARD);
                        } else {
                            XpCinePanel.this.playBkw.setIcon(CvUtils.getIcon("XP_CINE_PLY_BW_ICON"));
                            XpCinePanel.this.playBkw.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_BKW"));
                            XpCinePanel.this.playBkw.setActionCommand(XpCinePanel.PLAY_BACKWARD);
                        }
                        XpCinePanel.this.playAll.setEnabled(true);
                        XpCinePanel.this.playRange.setEnabled(true);
                        if (XpCinePanel.this.playRange.isSelected()) {
                            XpCinePanel.this.toSpinner.setEnabled(true);
                            XpCinePanel.this.fromSpinner.setEnabled(true);
                        }
                        XpCinePanel.this.playFrw.setEnabled(true);
                        XpCinePanel.this.playBkw.setEnabled(true);
                        XpCinePanel.this.stepFrw.setEnabled(true);
                        XpCinePanel.this.stepBkw.setEnabled(true);
                        XpCinePanel.this.begin.setEnabled(true);
                        XpCinePanel.this.end.setEnabled(true);
                        XpCinePanel.this.slider.setNoSkipFrameRate(-1);
                    }
                } else if ("NO_SKIP_RATE".equalsIgnoreCase(evt.getPropertyName())) {
                    XpCinePanel.this.slider.setNoSkipFrameRate((Integer)evt.getNewValue());
                } else if ("CineSkip".equalsIgnoreCase(evt.getPropertyName())) {
                    int interval = (Integer)evt.getNewValue();
                    XpCinePanel.this.intervalSpinner.setValue(Math.abs(interval));
                } else if ("CineStartOffset".equalsIgnoreCase(evt.getPropertyName())) {
                    int start = (Integer)evt.getNewValue();
                    XpCinePanel.this.fromSpinner.setValue(start + 1);
                    boolean range = start > 0;
                    XpCinePanel.this.playAll.setSelected(!range);
                    XpCinePanel.this.playRange.setSelected(range);
                    XpCinePanel.this.fromSpinner.setEnabled(range);
                    XpCinePanel.this.toSpinner.setEnabled(range);
                } else if ("CineEndOffset".equalsIgnoreCase(evt.getPropertyName())) {
                    int end = (Integer)evt.getNewValue();
                    XpCinePanel.this.toSpinner.setValue(end + 1);
                    boolean range = false;
                    if (cpb != null) {
                        range = end < cpb.getMaxFrame() - 1;
                    }
                    XpCinePanel.this.playAll.setSelected(!range);
                    XpCinePanel.this.playRange.setSelected(range);
                    XpCinePanel.this.fromSpinner.setEnabled(range);
                    XpCinePanel.this.toSpinner.setEnabled(range);
                } else if (evt.getPropertyName().equalsIgnoreCase("reference_viewport")) {
                    if (evt.getNewValue().toString().equalsIgnoreCase("true")) {
                        if (XpCinePanel.this.uiIntiated) {
                            XpCinePanel.this.playAll.setEnabled(false);
                            XpCinePanel.this.playRange.setEnabled(false);
                            if (XpCinePanel.this.playRange.isSelected()) {
                                XpCinePanel.this.toSpinner.setEnabled(false);
                                XpCinePanel.this.fromSpinner.setEnabled(false);
                            }
                            XpCinePanel.this.intervalSpinner.setEnabled(false);
                            XpCinePanel.this.pongBut.setEnabled(false);
                            XpCinePanel.this.loopBut.setEnabled(false);
                            XpCinePanel.this.slider.setEnabled(false);
                            XpCinePanel.this.playFrw.setEnabled(false);
                            XpCinePanel.this.playBkw.setEnabled(false);
                            XpCinePanel.this.stepFrw.setEnabled(false);
                            XpCinePanel.this.stepBkw.setEnabled(false);
                            XpCinePanel.this.begin.setEnabled(false);
                            XpCinePanel.this.end.setEnabled(false);
                        }
                    } else if (evt.getNewValue().toString().equalsIgnoreCase("false") && XpCinePanel.this.uiIntiated) {
                        XpCinePanel.this.playAll.setEnabled(true);
                        XpCinePanel.this.playRange.setEnabled(true);
                        if (XpCinePanel.this.playRange.isSelected()) {
                            XpCinePanel.this.toSpinner.setEnabled(true);
                            XpCinePanel.this.fromSpinner.setEnabled(true);
                        }
                        XpCinePanel.this.intervalSpinner.setEnabled(true);
                        XpCinePanel.this.pongBut.setEnabled(true);
                        XpCinePanel.this.loopBut.setEnabled(true);
                        XpCinePanel.this.slider.setEnabled(true);
                        XpCinePanel.this.playFrw.setEnabled(true);
                        XpCinePanel.this.playBkw.setEnabled(true);
                        XpCinePanel.this.stepFrw.setEnabled(true);
                        XpCinePanel.this.stepBkw.setEnabled(true);
                        XpCinePanel.this.begin.setEnabled(true);
                        XpCinePanel.this.end.setEnabled(true);
                    }
                }
            }
        }
    };

    public XpCinePanel() {
        this.setName("XpCinePanel");
        this.setIcon(CvUtils.getIcon("XP_CINE_ICON"));
        this.setAll(true);
        TransactionLogName tln = new TransactionLogName("TID=CreateCinePanel");
        this.logger.log(Level.FINE, "{0} begin Creating Cine Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.jbInit();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating Cine Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.jbInit();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.uiIntiated = true;
            this.updatePanel();
            this.setSelection();
        }
    }

    private void jbInit() {
        this.setBackground(null);
        this.pongBut.setIcon(CvUtils.getIcon("XP_CINE_SPATIAL_ICON"));
        this.loopBut.setIcon(CvUtils.getIcon("XP_CINE_TEMPORAL_ICON"));
        this.playAll = new JRadioButton();
        this.playAll.setText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_ALL"));
        this.playAll.setName(playAllbtn);
        this.playAll.setFocusable(false);
        this.playAll.addActionListener(this.listener);
        this.playAll.setSelected(true);
        this.playRange = new JRadioButton();
        this.playRange.setText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_RANGE"));
        this.playRange.setName(playrangebtn);
        this.playRange.setFocusable(false);
        this.playRange.addActionListener(this.listener);
        this.bg = new ButtonGroup();
        this.bg.add(this.playAll);
        this.bg.add(this.playRange);
        this.rangelbl = new JLabel(CvUtils.getResourceBundle().getString("ROI_PROP_TO_LABEL"));
        this.rangelbl.setName(XpCinePanel.class.getName() + "rangelbl");
        this.fromSpinner.setEnabled(false);
        this.toSpinner.setEnabled(false);
        this.fromSpinner.setName("frmSpinner");
        this.toSpinner.setName("toSpinner");
        this.intervalSpinner.setName("intvSpinner");
        this.fromSpinner.setModeChangeAllowed(false);
        this.toSpinner.setModeChangeAllowed(false);
        JPanel spinnerpanel = new JPanel();
        GroupLayout spinnerpanelLayout = new GroupLayout(spinnerpanel);
        spinnerpanel.setLayout(spinnerpanelLayout);
        spinnerpanelLayout.setHorizontalGroup(spinnerpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spinnerpanelLayout.createSequentialGroup().addContainerGap().addGroup(spinnerpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.playAll).addGroup(spinnerpanelLayout.createSequentialGroup().addComponent(this.playRange).addGap(30, 30, 30).addComponent(this.fromSpinner).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rangelbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toSpinner))).addContainerGap(-1, Short.MAX_VALUE)));
        spinnerpanelLayout.setVerticalGroup(spinnerpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spinnerpanelLayout.createSequentialGroup().addComponent(this.playAll, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spinnerpanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playRange, -2, 33, -2).addComponent(this.fromSpinner).addComponent(this.toSpinner).addComponent(this.rangelbl))));
        this.playFrw = new JButton();
        this.playFrw.setFocusable(false);
        this.playFrw.setActionCommand(PLAY_FORWARD);
        this.playFrw.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_FW"));
        this.playFrw.setIcon(CvUtils.getIcon("XP_CINE_PLY_FW_ICON"));
        this.playFrw.addActionListener(this);
        this.playFrw.setName("playFrwBtn");
        this.playBkw = new JButton();
        this.playBkw.setFocusable(false);
        this.playBkw.setActionCommand(PLAY_BACKWARD);
        this.playBkw.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_BKW"));
        this.playBkw.setIcon(CvUtils.getIcon("XP_CINE_PLY_BW_ICON"));
        this.playBkw.addActionListener(this);
        this.playBkw.setName("playBkwBtn");
        this.stepFrw = new JButton();
        this.stepFrw.setFocusable(false);
        this.stepFrw.setActionCommand(STEP_FORWARD);
        this.stepFrw.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_STEP_FW"));
        this.stepFrw.setIcon(CvUtils.getIcon("XP_CINE_STEP_FW_ICON"));
        this.stepFrw.addActionListener(this);
        this.stepFrw.setName("stepFrwBtn");
        this.stepBkw = new JButton();
        this.stepBkw.setFocusable(false);
        this.stepBkw.setActionCommand(STEP_BACKWARD);
        this.stepBkw.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_STEP_BKW"));
        this.stepBkw.setIcon(CvUtils.getIcon("XP_CINE_STEP_BW_ICON"));
        this.stepBkw.addActionListener(this);
        this.stepBkw.setName("stepBkwBtn");
        this.begin = new JButton();
        this.begin.setFocusable(false);
        this.begin.setActionCommand(BEGIN);
        this.begin.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_BG"));
        this.begin.setIcon(CvUtils.getIcon("XP_CINE_BG_ICON"));
        this.begin.addActionListener(this);
        this.begin.setName("beginBtn");
        this.end = new JButton();
        this.end.setFocusable(false);
        this.end.setActionCommand(END);
        this.end.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_END"));
        this.end.setIcon(CvUtils.getIcon("XP_CINE_END_ICON"));
        this.end.addActionListener(this);
        this.end.setName("endBtn");
        this.buttonPanel = new JPanel();
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.begin, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stepBkw, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.playBkw, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.playFrw, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stepFrw, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.end, -2, 31, -2).addContainerGap(56, Short.MAX_VALUE)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, buttonPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.begin).addComponent(this.stepBkw).addComponent(this.playBkw).addComponent(this.playFrw).addComponent(this.stepFrw).addComponent(this.end))));
        this.intvLbl = new JLabel();
        this.intvLbl.setText(CvUtils.getResourceBundle().getString("XP_CINE_INV_LBL"));
        this.intvLbl.setName(XpCinePanel.class.getName() + "intvLbl");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.loopBut);
        group1.add(this.pongBut);
        this.plyModeLbl = new JLabel();
        this.plyModeLbl.setText(CvUtils.getResourceBundle().getString("XP_CINE_PLYMD_LBL"));
        this.plyModeLbl.setName(XpCinePanel.class.getName() + "plyModeLbl");
        this.loopBut.setName("loopBtn");
        this.loopBut.setToolTipText(CvUtils.getResourceBundle().getString("XP_LOOP_MODE"));
        this.pongBut.setName("pongBtn");
        this.pongBut.setToolTipText(CvUtils.getResourceBundle().getString("XP_PING_MODE"));
        this.frmRateLbl = new JTextArea();
        this.frmRateLbl.setLineWrap(true);
        this.frmRateLbl.setOpaque(false);
        this.frmRateLbl.setEditable(false);
        this.frmRateLbl.setText(CvUtils.getResourceBundle().getString("XP_CINE_FRMRATE_LBL"));
        this.frmRateLbl.setWrapStyleWord(true);
        this.frmRateLbl.setFocusable(false);
        this.frmRateLbl.setName(XpCinePanel.class.getName() + "frmRateLbl");
        this.slider.setName("frmRate");
        this.slider.setToolTipText(null);
        this.slider.setPreferredSize(new Dimension(150, 30));
        this.frmMinRateLbl = new JLabel();
        this.frmMinRateLbl.setText("" + this.slider.getMinimum());
        this.frmMinRateLbl.setName(XpCinePanel.class.getName() + "frmMinRateLbl");
        this.frmMaxRateLbl = new JLabel();
        this.frmMaxRateLbl.setText("" + this.slider.getMaximum());
        this.frmMaxRateLbl.setName(XpCinePanel.class.getName() + "frmMaxRateLbl");
        JPanel intvPanel = new JPanel();
        GroupLayout intvPanelLayout = new GroupLayout(intvPanel);
        intvPanel.setLayout(intvPanelLayout);
        intvPanelLayout.setHorizontalGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intvPanelLayout.createSequentialGroup().addContainerGap().addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intvPanelLayout.createSequentialGroup().addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plyModeLbl).addComponent(this.intvLbl).addComponent(this.frmRateLbl, -2, 110, -2)).addGap(21, 21, 21).addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intvPanelLayout.createSequentialGroup().addComponent(this.frmMinRateLbl, -2, 21, -2).addComponent(this.slider, -2, 0, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.frmMaxRateLbl, -2, 21, -2).addGap(21, 21, 21)).addGroup(intvPanelLayout.createSequentialGroup().addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intervalSpinner, -2, 50, -2).addGroup(intvPanelLayout.createSequentialGroup().addComponent(this.pongBut, -2, 37, -2).addGap(18, 18, 18).addComponent(this.loopBut, -2, 36, -2))).addContainerGap(-1, Short.MAX_VALUE)))).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE))));
        intvPanelLayout.setVerticalGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intvPanelLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intvLbl).addComponent(this.intervalSpinner)).addGap(14, 14, 14).addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loopBut, GroupLayout.Alignment.TRAILING).addComponent(this.plyModeLbl)).addComponent(this.pongBut)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intvPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.frmRateLbl).addComponent(this.frmMinRateLbl)).addComponent(this.slider, -2, 35, -2).addComponent(this.frmMaxRateLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2)));
        intvPanelLayout.linkSize(0, this.fromSpinner, this.intervalSpinner);
        JPanel frmpanel = new JPanel();
        GroupLayout frmpanelLayout = new GroupLayout(frmpanel);
        frmpanel.setLayout(frmpanelLayout);
        frmpanelLayout.setHorizontalGroup(frmpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmpanelLayout.createSequentialGroup().addComponent(intvPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        frmpanelLayout.setVerticalGroup(frmpanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmpanelLayout.createSequentialGroup().addComponent(intvPanel, -1, -1, Short.MAX_VALUE)));
        GroupLayout cinelayout = new GroupLayout(this);
        this.setLayout(cinelayout);
        cinelayout.setHorizontalGroup(cinelayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cinelayout.createSequentialGroup().addGroup(cinelayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(spinnerpanel, -1, -1, Short.MAX_VALUE).addGroup(cinelayout.createSequentialGroup().addComponent(frmpanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        cinelayout.setVerticalGroup(cinelayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cinelayout.createSequentialGroup().addGap(6, 6, 6).addComponent(spinnerpanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(frmpanel, -2, -1, -2)));
        this.rangmodel = new XpRangeModel();
    }

    private void updatePanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpinnerNumberModel intervmodel = null;
                if (XpCinePanel.this.screen_ instanceof FramePositioningCapable && XpCinePanel.this.screen_ instanceof CineCapable) {
                    XPscreen fpc = XpCinePanel.this.screen_;
                    if (fpc == null) {
                        return;
                    }
                    XPscreen ccp = XpCinePanel.this.screen_;
                    if (ccp == null) {
                        return;
                    }
                    XpCinePanel.this.totalImgs = fpc.getNumFrames();
                    if (XpCinePanel.this.totalImgs < 1) {
                        return;
                    }
                    int value = ((Number)XpCinePanel.this.intervalSpinner.getValue()).intValue();
                    intervmodel = value > XpCinePanel.this.totalImgs ? new SpinnerNumberModel(XpCinePanel.this.totalImgs, 1, XpCinePanel.this.totalImgs, 1) : new SpinnerNumberModel(value, 1, XpCinePanel.this.totalImgs, 1);
                    XpCinePanel.this.intervalSpinner.setModel(intervmodel);
                    XpCinePanel.this.fromSpinner.setModel(XpCinePanel.this.rangmodel.getMinRangeSpinnerModel(fpc));
                    XpCinePanel.this.toSpinner.setModel(XpCinePanel.this.rangmodel.getMaxRangeSpinnerModel(fpc));
                    ccp.setStartOffset(0);
                    ccp.setEndOffset(XpCinePanel.this.totalImgs - 1);
                }
            }
        });
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.removePropertyChangeListener(this.vpListener);
        screen.addPropertyChangeListener(this.vpListener);
        if (this.uiIntiated) {
            this.updatePanel();
            this.setSelection();
        }
    }

    private void setSelection() {
        if (this.playAll.isSelected()) {
            this.allOptn = 1;
        } else if (this.playRange.isSelected()) {
            this.rangOptn = 1;
        }
        if (this.playOptn) {
            this.playAll.setSelected(true);
        } else {
            this.playRange.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String source = e.getActionCommand();
        CineCapable ccpb = (CineCapable)this.getScreen().getCapable(CineCapable.class.getName());
        FramePositioningCapable fpc = (FramePositioningCapable)this.getScreen().getCapable(FramePositioningCapable.class.getName());
        RowColCapable rcc = (RowColCapable)this.getScreen().getCapable(RowColCapable.class.getName());
        if (ccpb == null) {
            return;
        }
        int idex = fpc.getFrameIndex();
        if (source.equals(PLAY_FORWARD) || source.equals(PLAY_BACKWARD)) {
            if (this.playAll.isSelected()) {
                ccpb.setStartOffset(0);
                ccpb.setEndOffset(fpc.getNumFrames() - 1);
                ccpb.setCineRate(1000 / this.slider.getValue());
                if (this.allOptn == 1) {
                    if (source.equals(PLAY_FORWARD)) {
                        ccpb.setOffset(0);
                        ccpb.setCineSkip(((Number)this.intervalSpinner.getValue()).intValue());
                    } else {
                        ccpb.setOffset(fpc.getNumFrames() - 1);
                        ccpb.setCineSkip(-1 * ((Number)this.intervalSpinner.getValue()).intValue());
                    }
                } else if (source.equals(PLAY_FORWARD)) {
                    ccpb.setOffset(idex);
                    ccpb.setCineSkip(((Number)this.intervalSpinner.getValue()).intValue());
                } else if (source.equals(PLAY_BACKWARD)) {
                    ccpb.setOffset(idex);
                    ccpb.setCineSkip(-1 * ((Number)this.intervalSpinner.getValue()).intValue());
                }
            } else if (this.playRange.isSelected()) {
                int from = ((Number)this.fromSpinner.getValue()).intValue();
                int to = ((Number)this.toSpinner.getValue()).intValue();
                ccpb.setStartOffset(from - 1);
                ccpb.setEndOffset(to - 1);
                ccpb.setCineRate(1000 / this.slider.getValue());
                if (this.rangOptn == 1) {
                    if (source.equals(PLAY_FORWARD)) {
                        ccpb.setOffset(ccpb.getStartOffset());
                        ccpb.setCineSkip(((Number)this.intervalSpinner.getValue()).intValue());
                    } else if (source.equals(PLAY_BACKWARD)) {
                        ccpb.setOffset(ccpb.getEndOffset());
                        ccpb.setCineSkip(-1 * ((Number)this.intervalSpinner.getValue()).intValue());
                    }
                } else if (source.equals(PLAY_FORWARD)) {
                    ccpb.setOffset(idex);
                    ccpb.setCineSkip(((Number)this.intervalSpinner.getValue()).intValue());
                } else if (source.equals(PLAY_BACKWARD)) {
                    ccpb.setOffset(idex);
                    ccpb.setCineSkip(-1 * ((Number)this.intervalSpinner.getValue()).intValue());
                }
            }
            int totalimgs = ccpb.getEndOffset() - ccpb.getStartOffset();
            int cskip = ccpb.getCineSkip();
            if (totalimgs == 0 || totalimgs < Math.abs(cskip)) {
                ccpb.setCineSkip(Math.abs(cskip));
                return;
            }
            this.screen_.updateUI();
            ccpb.setCine(true);
            this.slider.setCineOn(ccpb.getCine());
        } else if (source.equals(PAUSE)) {
            if (this.playAll.isSelected()) {
                ++this.allOptn;
            } else if (this.playRange.isSelected()) {
                ++this.rangOptn;
            }
            ccpb.setCine(false);
            this.screen_.updateUI();
        } else if (source.equals(STEP_FORWARD)) {
            if (ccpb.getCine()) {
                return;
            }
            int interval = ((Number)this.intervalSpinner.getValue()).intValue();
            if (this.playRange.isSelected()) {
                int max = ((Number)this.toSpinner.getValue()).intValue() - 1;
                int frmIndex = fpc.getFrameIndex();
                int nextVal = interval + frmIndex;
                if (nextVal > max) {
                    ccpb.setOffset(frmIndex);
                } else {
                    ccpb.setOffset(nextVal);
                }
            } else {
                int nextVal = interval + fpc.getFrameIndex();
                if (nextVal > ccpb.getEndOffset()) {
                    ccpb.setOffset(fpc.getFrameIndex());
                } else {
                    ccpb.setOffset(nextVal);
                }
            }
        } else if (source.equals(STEP_BACKWARD)) {
            if (ccpb.getCine()) {
                return;
            }
            int interval = ((Number)this.intervalSpinner.getValue()).intValue();
            if (this.playRange.isSelected()) {
                int begin = ((Number)this.fromSpinner.getValue()).intValue() - 1;
                int frmIndx = fpc.getFrameIndex();
                int prevVal = frmIndx - interval;
                if (prevVal < begin) {
                    ccpb.setOffset(frmIndx);
                } else {
                    ccpb.setOffset(prevVal);
                }
            } else {
                int frmIndx = fpc.getFrameIndex();
                int prevVal = frmIndx - interval;
                if (prevVal < ccpb.getStartOffset()) {
                    ccpb.setOffset(frmIndx);
                } else {
                    ccpb.setOffset(prevVal);
                }
            }
        } else if (source.equals(BEGIN)) {
            if (ccpb.getCine()) {
                return;
            }
            if (this.playRange.isSelected()) {
                int first = ((Number)this.fromSpinner.getValue()).intValue();
                ccpb.setOffset(first - 1);
            } else {
                ccpb.setOffset(ccpb.getStartOffset());
            }
        } else if (source.equals(END)) {
            if (ccpb.getCine()) {
                return;
            }
            if (this.playRange.isSelected()) {
                int end = ((Number)this.toSpinner.getValue()).intValue();
                ccpb.setOffset(end - 1);
            } else {
                ccpb.setOffset(ccpb.getEndOffset());
            }
        }
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_CINE_NAME");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_CINE_NAME");
    }

    class PlayOptionListener
    implements ActionListener {
        PlayOptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CineCapable cc = (CineCapable)XpCinePanel.this.getScreen().getCapable(CineCapable.class.getName());
            FramePositioningCapable fcp = (FramePositioningCapable)XpCinePanel.this.getScreen().getCapable(FramePositioningCapable.class.getName());
            if (cc == null) {
                return;
            }
            JRadioButton btn = (JRadioButton)e.getSource();
            if (btn.getName().equals(XpCinePanel.playAllbtn)) {
                XpCinePanel.this.playOptn = true;
                XpCinePanel.this.allOptn = 1;
                XpCinePanel.this.rangOptn = 0;
                XpCinePanel.this.fromSpinner.setEnabled(false);
                XpCinePanel.this.toSpinner.setEnabled(false);
                cc.setStartOffset(0);
                cc.setEndOffset(fcp.getNumFrames() - 1);
            } else if (btn.getName().equals(XpCinePanel.playrangebtn)) {
                XpCinePanel.this.playOptn = false;
                XpCinePanel.this.allOptn = 0;
                XpCinePanel.this.rangOptn = 1;
                XpCinePanel.this.fromSpinner.setEnabled(true);
                XpCinePanel.this.toSpinner.setEnabled(true);
            }
        }
    }
}

