/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class XPwWinLevelField
extends JFormattedTextField
implements CapableListener,
ActionListener,
PropertyChangeListener {
    transient XPscreen screen = null;
    transient AutoControlPanelSeek panelSeek = null;
    WindowLevelCapable wlc_;

    public XPwWinLevelField() {
        this.addActionListener(this);
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setHorizontalAlignment(4);
    }

    public XPwWinLevelField(NumberFormat format) {
        super(format);
        format.setMaximumFractionDigits(3);
        this.addActionListener(this);
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setHorizontalAlignment(4);
    }

    public void removeActionListener() {
        this.removeActionListener(this);
    }

    public void addActionListener() {
        this.addActionListener(this);
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        WindowLevelCapable wlc = (WindowLevelCapable)this.screen.getCapable(WindowLevelCapable.class.getName());
        if (this.wlc_ != null) {
            this.wlc_.removePropertyChangeListener(this);
        }
        this.wlc_ = wlc;
        if (wlc != null) {
            double newWL = (wlc.getWinMax() + wlc.getWinMin()) / 2.0;
            this.setValue(new Double(newWL));
            this.invalidate();
            wlc.removePropertyChangeListener(this);
            wlc.addPropertyChangeListener("winMax", this);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void actionPerformed(ActionEvent ce) {
        this.setWindowLevel();
    }

    private void setWindowLevel() {
        WindowLevelCapable wlc;
        if (this.screen != null) {
            XpSeriesDisplayer sd = null;
            if (this.screen.getPort(0) instanceof XpSeriesDisplayer) {
                sd = (XpSeriesDisplayer)this.screen.getPort(0);
                XpImage xi = sd.getFrame();
            } else {
                return;
            }
        }
        if ((wlc = (WindowLevelCapable)this.panelSeek.getCapable(WindowLevelCapable.class.getName())) == null) {
            return;
        }
        String mod = "";
        if (wlc instanceof FrameOwner && ((FrameOwner)((Object)wlc)).getFrame() instanceof XpMedicalImage) {
            mod = DicomUtils.getModality((XpMedicalImage)((FrameOwner)((Object)wlc)).getFrame());
        }
        double newWL = ((Number)this.getValue()).doubleValue();
        double maxwl = CvUtils.getMaxWL(mod);
        double minwl = CvUtils.getMinWL(mod);
        if (newWL > maxwl) {
            newWL = maxwl;
            this.setValue(new Double(newWL));
        } else if (newWL < minwl) {
            newWL = minwl;
            this.setValue(new Double(newWL));
        }
        double max = wlc.getWinMax();
        double min = wlc.getWinMin();
        double currentWW = max - min;
        wlc.setWinMinMax(newWL - currentWW * 0.5, newWL + currentWW * 0.5);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

