/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator;
import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XPDisplayPrefsUtils {
    public static final String SCREEN_ANNOTATION_LEVEL = "screen_annotation_level";
    public static final String SCREEN_CUSTOM_ANNOTATION_LEVEL = "screen_custom_annotation_level";
    public static final String SCREEN_LARGE_FONT_ANNOTATION_LEVEL = "screen_large_font_annotation_level";
    public static final String FILM_ANNOTATION_LEVEL = "film_annotation_level";
    public static final String FILM_CUSTOM_ANNOTATION_LEVEL = "film_custom_annotation_level";
    public static final String FILM_LARGE_FONT_ANNOTATION_LEVEL = "film_large_font_annotation_level";
    public static final String ANNOTATION_LEVEL_FULL = "all";
    public static final String ANNOTATION_LEVEL_PARTIAL = "partial";
    public static final String ANNOTATION_LEVEL_NONE = "none";
    public static final String ANNOTATION_LEVEL_CUSTOM = "custom";
    public static final String ANNOTATION_LEVEL_LARGE_FONT = "largeFont";
    public static final String SB_KEY = "Series_binding";
    public static final String MIDDLE_IMAGE_WWWL_KEY = "cvf.applymiddleimagewindowing";
    public static final String LB_KEY = "Loop_back";
    public static final String HOR_TICK_MARK = "horizontal_tick_mark";
    public static final String VER_TICK_MARK = "vertical_tick_mark";
    public static final String REPORT_CURSOR = "report_curser_info";
    public static final String GRID_SPACING = "grid_spacing";
    public static final String TICK_SPACING = "tick_spacing";
    public static final String LINE_STYLE = "line_style";
    public static final String TICK_LENGTH = "tick_length";
    public static final String DOTTEDLINE = "DOTTED";
    public static final String SOLIDLINE = "SOLID";
    public static final String GRID_LINES_ON = "Grid_lines";
    public static final String MY_TOOLS = "my_tools";
    public static final String MY_FAVORITE_HOVERMENU = "my_favorite_hovermenu";
    private static final String CUSTOM_ANNOT_KEY = ".CUSTOM_ANNOT_ITEMS";
    private static final String LARGEFONT_ANNOT_KEY = ".LARGEFONT_ANNOT_ITEMS";
    private static int SCREEN_LARGE_FONT_MASK = XPDisplayPrefsUtils.getSystemScreenLargeFontAnnotationLevel();
    private static int FILM_LARGE_FONT_MASK = XPDisplayPrefsUtils.getSystemFilmLargeFontAnnotationLevel();
    private static String SCREEN_ANNOT_LEVEL = XPDisplayPrefsUtils.getSystemScreenAnnotationLevel();
    private static String FILM_ANNOT_LEVEL = XPDisplayPrefsUtils.getSystemFilmAnnotationLevel();
    private static int SCREEN_CUSTOM_MASK = XPDisplayPrefsUtils.getSystemScreenCustomAnnotationLevel();
    private static int FILM_CUSTOM_MASK = XPDisplayPrefsUtils.getSystemFilmCustomAnnotationLevel();
    private static boolean SERIES_BINDING_STATUS = XPDisplayPrefsUtils.getSystemSeriesBindingStatus();
    private static boolean LOOP_BACK_STATUS = XPDisplayPrefsUtils.getSystemLoopBackStatus();
    private static boolean HTICKS_STATUS = XPDisplayPrefsUtils.getSystemHorizontalTicksStatus();
    private static boolean VTICKS_STATUS = XPDisplayPrefsUtils.getSystemVerticalTicksStatus();
    private static boolean REPORT_CURSOR_STATUS = XPDisplayPrefsUtils.getSystemReportCursorStatus();
    private static double GSPACING = XPDisplayPrefsUtils.getSystemGridSpacing();
    private static double TSPACING = XPDisplayPrefsUtils.getSystemTickSpacing();
    private static double TLENGTH = XPDisplayPrefsUtils.getSystemTickLength();
    private static String LSTYLE = XPDisplayPrefsUtils.getSystemLineStyle();
    private static boolean GLINES_ON = XPDisplayPrefsUtils.getSystemGridLinesOn();
    private static String MYTOOLS = XPDisplayPrefsUtils.getSystemMyTools();
    private static boolean MIDDLEIMAGE_WINDOWING_STATUS = XPDisplayPrefsUtils.getSystemMiddleImageWindowingStatus();

    public static void reReadUserPrefs() {
        try {
            SCREEN_LARGE_FONT_MASK = XPDisplayPrefsUtils.getSystemScreenLargeFontAnnotationLevel();
            FILM_LARGE_FONT_MASK = XPDisplayPrefsUtils.getSystemFilmLargeFontAnnotationLevel();
            SCREEN_ANNOT_LEVEL = XPDisplayPrefsUtils.getSystemScreenAnnotationLevel();
            FILM_ANNOT_LEVEL = XPDisplayPrefsUtils.getSystemFilmAnnotationLevel();
            SCREEN_CUSTOM_MASK = XPDisplayPrefsUtils.getSystemScreenCustomAnnotationLevel();
            FILM_CUSTOM_MASK = XPDisplayPrefsUtils.getSystemFilmCustomAnnotationLevel();
            SERIES_BINDING_STATUS = XPDisplayPrefsUtils.getSystemSeriesBindingStatus();
            LOOP_BACK_STATUS = XPDisplayPrefsUtils.getSystemLoopBackStatus();
            HTICKS_STATUS = XPDisplayPrefsUtils.getSystemHorizontalTicksStatus();
            VTICKS_STATUS = XPDisplayPrefsUtils.getSystemVerticalTicksStatus();
            REPORT_CURSOR_STATUS = XPDisplayPrefsUtils.getSystemReportCursorStatus();
            GSPACING = XPDisplayPrefsUtils.getSystemGridSpacing();
            TSPACING = XPDisplayPrefsUtils.getSystemTickSpacing();
            TLENGTH = XPDisplayPrefsUtils.getSystemTickLength();
            LSTYLE = XPDisplayPrefsUtils.getSystemLineStyle();
            GLINES_ON = XPDisplayPrefsUtils.getSystemGridLinesOn();
            MYTOOLS = XPDisplayPrefsUtils.getSystemMyTools();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getLogger(XPDisplayPrefsUtils.class.getName()).log(Level.SEVERE, "Exception during the prefs reread , {0}", new Object[]{e});
        }
    }

    private static synchronized boolean getSystemLoopBackStatus() {
        return CvPropertiesManager.getUserPreferences().getBoolean(LB_KEY, false);
    }

    public static synchronized String[] getCustomAnnotationGroups(AnnotCapable acap, String imgType) {
        if (imgType == null || acap == null) {
            return null;
        }
        XpAnnotationGenerator ag = acap.getAnnotationGenerator();
        if (ag instanceof XpCVAnnotationGenerator) {
            String citems = null;
            citems = ((XpCVAnnotationGenerator)ag).getProperty(imgType + CUSTOM_ANNOT_KEY);
            if (citems != null) {
                return citems.split("#");
            }
            return null;
        }
        return null;
    }

    public static synchronized String[] getLargeFontAnnotationGroups(AnnotCapable acap, String imgType) {
        if (imgType == null || acap == null) {
            return null;
        }
        XpAnnotationGenerator ag = acap.getAnnotationGenerator();
        if (ag instanceof XpCVAnnotationGenerator) {
            String litems = ((XpCVAnnotationGenerator)ag).getProperty(imgType + LARGEFONT_ANNOT_KEY);
            if (litems != null) {
                return litems.split("#");
            }
            return null;
        }
        return null;
    }

    public static synchronized String getScreenAnnotationLevel() {
        return SCREEN_ANNOT_LEVEL;
    }

    public static synchronized String getSystemScreenAnnotationLevel() {
        return CvPropertiesManager.getUserPreferences().get(SCREEN_ANNOTATION_LEVEL, ANNOTATION_LEVEL_FULL);
    }

    public static synchronized void updateScreenAnnotationLevel(String val) {
        if (val == null) {
            return;
        }
        if (val.equalsIgnoreCase(ANNOTATION_LEVEL_FULL)) {
            SCREEN_ANNOT_LEVEL = ANNOTATION_LEVEL_FULL;
        } else if (val.equalsIgnoreCase(ANNOTATION_LEVEL_PARTIAL)) {
            SCREEN_ANNOT_LEVEL = ANNOTATION_LEVEL_PARTIAL;
        } else if (val.equalsIgnoreCase(ANNOTATION_LEVEL_NONE)) {
            SCREEN_ANNOT_LEVEL = ANNOTATION_LEVEL_NONE;
        } else if (val.equalsIgnoreCase(ANNOTATION_LEVEL_CUSTOM)) {
            SCREEN_ANNOT_LEVEL = ANNOTATION_LEVEL_CUSTOM;
        }
    }

    public static synchronized void saveScreenAnnotationLevel(String val) {
        if (val == null) {
            return;
        }
        XPDisplayPrefsUtils.updateScreenAnnotationLevel(val);
        CvPropertiesManager.getUserPreferences().put(SCREEN_ANNOTATION_LEVEL, SCREEN_ANNOT_LEVEL);
    }

    public static synchronized int getCustomAnnotationGroupMask(int group) {
        return 1 << group;
    }

    public static synchronized int getLargeFontAnnotationGroupMask(int group) {
        return 1 << group;
    }

    public static synchronized boolean queryScreenLargeFontAnnotationGroup(int group) {
        int custmMask;
        int groupMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(group);
        return (groupMask & (custmMask = XPDisplayPrefsUtils.getScreenLargeFontAnnotationLevel())) != 0;
    }

    public static synchronized int getSystemScreenLargeFontAnnotationLevel() {
        return CvPropertiesManager.getUserPreferences().getInt(SCREEN_LARGE_FONT_ANNOTATION_LEVEL, 0);
    }

    public static synchronized int getScreenLargeFontAnnotationLevel() {
        return SCREEN_LARGE_FONT_MASK;
    }

    public static synchronized void updateScreenLargeFontAnnotationLevel(int mask) {
        SCREEN_LARGE_FONT_MASK = mask;
    }

    public static synchronized void saveScreenLargeFontAnnotationLevel(int mask) {
        XPDisplayPrefsUtils.updateScreenLargeFontAnnotationLevel(mask);
        CvPropertiesManager.getUserPreferences().putInt(SCREEN_LARGE_FONT_ANNOTATION_LEVEL, mask);
    }

    public static synchronized boolean queryScreenCustomAnnotationGroup(int group) {
        int custmMask;
        int groupMask = XPDisplayPrefsUtils.getCustomAnnotationGroupMask(group);
        return (groupMask & (custmMask = XPDisplayPrefsUtils.getScreenCustomAnnotationLevel())) != 0;
    }

    public static synchronized int getScreenCustomAnnotationLevel() {
        return SCREEN_CUSTOM_MASK;
    }

    public static synchronized int getSystemScreenCustomAnnotationLevel() {
        return CvPropertiesManager.getUserPreferences().getInt(SCREEN_CUSTOM_ANNOTATION_LEVEL, 524287);
    }

    public static synchronized void updateScreenCustomAnnotationLevel(int mask) {
        SCREEN_CUSTOM_MASK = mask;
    }

    public static synchronized void saveScreenCustomAnnotationLevel(int mask) {
        XPDisplayPrefsUtils.updateScreenCustomAnnotationLevel(mask);
        CvPropertiesManager.getUserPreferences().putInt(SCREEN_CUSTOM_ANNOTATION_LEVEL, mask);
    }

    public static synchronized String getSystemFilmAnnotationLevel() {
        return CvPropertiesManager.getUserPreferences().get(FILM_ANNOTATION_LEVEL, ANNOTATION_LEVEL_FULL);
    }

    public static synchronized String getFilmAnnotationLevel() {
        return FILM_ANNOT_LEVEL;
    }

    public static synchronized int getFilmCustomAnnotationLevel() {
        return FILM_CUSTOM_MASK;
    }

    public static synchronized int getSystemFilmCustomAnnotationLevel() {
        return CvPropertiesManager.getUserPreferences().getInt(FILM_CUSTOM_ANNOTATION_LEVEL, 524287);
    }

    public static synchronized int getSystemFilmLargeFontAnnotationLevel() {
        return CvPropertiesManager.getUserPreferences().getInt(FILM_LARGE_FONT_ANNOTATION_LEVEL, 0);
    }

    public static synchronized int getFilmLargeFontAnnotationLevel() {
        return FILM_LARGE_FONT_MASK;
    }

    public static synchronized void updateFilmAnnotatLevel(String val) {
        if (val == null) {
            return;
        }
        if (val.equalsIgnoreCase(ANNOTATION_LEVEL_FULL)) {
            FILM_ANNOT_LEVEL = ANNOTATION_LEVEL_FULL;
        } else if (val.equalsIgnoreCase(ANNOTATION_LEVEL_PARTIAL)) {
            FILM_ANNOT_LEVEL = ANNOTATION_LEVEL_PARTIAL;
        } else if (val.equalsIgnoreCase(ANNOTATION_LEVEL_CUSTOM)) {
            FILM_ANNOT_LEVEL = ANNOTATION_LEVEL_CUSTOM;
        } else if (val.equalsIgnoreCase(ANNOTATION_LEVEL_NONE)) {
            FILM_ANNOT_LEVEL = ANNOTATION_LEVEL_NONE;
        }
    }

    public static synchronized void saveFilmAnnotatLevel(String val) {
        if (val == null) {
            return;
        }
        XPDisplayPrefsUtils.updateFilmAnnotatLevel(val);
        CvPropertiesManager.getUserPreferences().put(FILM_ANNOTATION_LEVEL, FILM_ANNOT_LEVEL);
    }

    public static synchronized void updateFilmCustomAnnotationLevel(int mask) {
        FILM_CUSTOM_MASK = mask;
    }

    public static synchronized void saveFilmCustomAnnotationLevel(int mask) {
        XPDisplayPrefsUtils.updateFilmCustomAnnotationLevel(mask);
        CvPropertiesManager.getUserPreferences().put(FILM_CUSTOM_ANNOTATION_LEVEL, Integer.toString(mask));
    }

    public static void updateFilmLargeFontAnnotationLevel(int mask) {
        FILM_LARGE_FONT_MASK = mask;
    }

    public static synchronized void saveFilmLargeFontAnnotationLevel(int mask) {
        XPDisplayPrefsUtils.updateFilmLargeFontAnnotationLevel(mask);
        CvPropertiesManager.getUserPreferences().put(FILM_LARGE_FONT_ANNOTATION_LEVEL, Integer.toString(mask));
    }

    public static synchronized boolean queryFilmCustomAnnotationGroup(int group) {
        int customMask;
        int groupMask = XPDisplayPrefsUtils.getCustomAnnotationGroupMask(group);
        return (groupMask & (customMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel())) != 0;
    }

    public static synchronized boolean queryFilmLargeFontAnnotationGroup(int group) {
        int customMask;
        int groupMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(group);
        return (groupMask & (customMask = XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel())) != 0;
    }

    public static void setAnnotLevel(AnnotCapable port, String level) {
        if (!level.equals(ANNOTATION_LEVEL_CUSTOM)) {
            XPDisplayPrefsUtils.setNonCustomAnnotLevel(port, level);
        } else if (port instanceof FrameOwner) {
            String imgType = CvUtils.getImageTypeKey(port);
            XPDisplayPrefsUtils.setCustomAnnotItems(port, imgType, XPDisplayPrefsUtils.getScreenCustomAnnotationLevel());
        }
    }

    private static void setNonCustomAnnotLevel(AnnotCapable port, String level) {
        String[] items = port.getAnnotationItems();
        if (items != null && items.length != 0) {
            port.setAnnotationItems(items, false);
        }
        items = null;
        items = port.getAnnotationItems(level);
        if (items != null && items.length != 0) {
            port.setAnnotationItems(items, true);
        }
    }

    public static void setCustomAnnotItems(AnnotCapable port, String imgType, int mask) {
        String[] items = XPDisplayPrefsUtils.getCustomAnnotationGroups(port, imgType);
        if (items != null) {
            XPDisplayPrefsUtils.setNonCustomAnnotLevel(port, ANNOTATION_LEVEL_NONE);
            for (int i = 0; i < items.length; ++i) {
                int groupMask = XPDisplayPrefsUtils.getCustomAnnotationGroupMask(i);
                boolean selected = (groupMask & mask) != 0;
                port.setAnnotationItems(new String[]{items[i]}, selected);
            }
            port.repaint();
        }
    }

    public static int[] getLargeFontAnnotationKeys(XpViewport vp, String imgType, int mask) {
        ArrayList<Integer> keylist = new ArrayList<Integer>();
        int[] intarr = null;
        int key = -1;
        XpApdAnnotation apdm = null;
        if (vp != null) {
            XpAnnotationModel am;
            XpVisualComponent vc;
            if (vp instanceof XpSingularPort) {
                vc = ((XpSingularPort)vp).getMedicalImageVc();
                if (vc != null) {
                    am = ((XpMedicalImage2DVc)vc).getAnnotationModel();
                    if (am instanceof XpApdAnnotation) {
                        apdm = (XpApdAnnotation)am;
                    }
                } else {
                    System.out.println("XPDisplayPrefsUtils.getLargeFontAnnotationKeys():: Vc is null");
                }
            } else if (vp instanceof J3DViewport) {
                vc = ((J3DViewport)vp).getAnnotationVc();
                if (vc != null) {
                    am = ((XpAnnotationVc)vc).getAnnotationModel();
                    if (am instanceof XpApdAnnotation) {
                        apdm = (XpApdAnnotation)am;
                    }
                } else {
                    System.out.println("XPDisplayPrefsUtils.getLargeFontAnnotationKeys():: Vc is null");
                }
            }
        }
        if (apdm == null) {
            return null;
        }
        String[] items = XPDisplayPrefsUtils.getLargeFontAnnotationGroups(vp, imgType);
        if (items != null) {
            int i;
            for (i = 0; i < items.length; ++i) {
                String[] segname;
                int val;
                boolean selected;
                int groupMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(i);
                boolean bl = selected = (groupMask & mask) != 0;
                if (!selected || (val = apdm.queryAnnoGroupNumber(items[i])) == -1 || (segname = apdm.getAnnotationSegmentItems(val)) == null) continue;
                int size = segname.length;
                for (int j = 0; j < size; ++j) {
                    key = apdm.getAnnotationKey(segname[j]);
                    if (key == -1) continue;
                    keylist.add(key);
                }
            }
            if (keylist.size() > 0) {
                intarr = new int[keylist.size()];
                for (i = 0; i < intarr.length; ++i) {
                    intarr[i] = (Integer)keylist.get(i);
                }
            }
        }
        return intarr;
    }

    public static void setLargeFontAnnotation(AnnotCapable cap, int[] keys) {
        String st = "";
        StringBuffer stb = new StringBuffer(st);
        Properties prop = new Properties();
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                stb.append(keys[i]);
                stb.append(",");
            }
            st = stb.toString();
            stb = null;
        }
        prop.setProperty("LargeFontKeys", st);
        XpAnnotationGenerator ag = cap.getAnnotationGenerator();
        if (ag != null) {
            ag.setProperties(prop);
            Properties p = ((XpApdAnnotationGenerator)ag).getProperties();
            cap.setAnnotationGenerator(ag.getClass(), p);
        }
    }

    public static synchronized boolean getSystemSeriesBindingStatus() {
        return CvPropertiesManager.getUserPreferences().getBoolean(SB_KEY, false);
    }

    public static synchronized boolean getSeriesBindingStatus() {
        return SERIES_BINDING_STATUS;
    }

    public static synchronized void updateSeriesBindingStatus(boolean sb) {
        SERIES_BINDING_STATUS = sb;
    }

    public static synchronized void saveSeriesBindingStatus(boolean sb) {
        XPDisplayPrefsUtils.updateSeriesBindingStatus(sb);
        CvPropertiesManager.getUserPreferences().putBoolean(SB_KEY, sb);
    }

    public static synchronized boolean getLoopBackStatus() {
        return LOOP_BACK_STATUS;
    }

    public static synchronized void updateLoopBackStatus(boolean lb) {
        LOOP_BACK_STATUS = lb;
    }

    public static synchronized void saveLoopBackStatus(boolean lb) {
        XPDisplayPrefsUtils.updateLoopBackStatus(lb);
        CvPropertiesManager.getUserPreferences().putBoolean(LB_KEY, lb);
    }

    public static boolean getSystemHorizontalTicksStatus() {
        return CvPropertiesManager.getUserPreferences().getBoolean(HOR_TICK_MARK, false);
    }

    public static boolean getHorizontalTicksStatus() {
        return HTICKS_STATUS;
    }

    public static synchronized void updateHorizontalTicksStatus(boolean ts) {
        HTICKS_STATUS = ts;
    }

    public static synchronized void saveHorizontalTicksStatus(boolean ts) {
        XPDisplayPrefsUtils.updateHorizontalTicksStatus(ts);
        CvPropertiesManager.getUserPreferences().putBoolean(HOR_TICK_MARK, ts);
    }

    public static boolean getSystemVerticalTicksStatus() {
        return CvPropertiesManager.getUserPreferences().getBoolean(VER_TICK_MARK, false);
    }

    public static boolean getVerticalTicksStatus() {
        return VTICKS_STATUS;
    }

    public static synchronized void updateVerticalTicksStatus(boolean ts) {
        VTICKS_STATUS = ts;
    }

    public static synchronized void saveVerticalTicksStatus(boolean ts) {
        XPDisplayPrefsUtils.updateVerticalTicksStatus(ts);
        CvPropertiesManager.getUserPreferences().putBoolean(VER_TICK_MARK, ts);
    }

    public static boolean getSystemReportCursorStatus() {
        return CvPropertiesManager.getUserPreferences().getBoolean(REPORT_CURSOR, false);
    }

    public static boolean getReportCursorStatus() {
        return REPORT_CURSOR_STATUS;
    }

    public static synchronized void updateReportCursorStatus(boolean rcs) {
        REPORT_CURSOR_STATUS = rcs;
    }

    public static synchronized void saveReportCursorStatus(boolean rcs) {
        REPORT_CURSOR_STATUS = rcs;
        CvPropertiesManager.getUserPreferences().putBoolean(REPORT_CURSOR, rcs);
    }

    public static synchronized double getSystemGridSpacing() {
        return CvPropertiesManager.getUserPreferences().getDouble(GRID_SPACING, 30.0);
    }

    public static synchronized double getSystemTickSpacing() {
        return CvPropertiesManager.getUserPreferences().getDouble(TICK_SPACING, 10.0);
    }

    public static synchronized double getSystemTickLength() {
        return CvPropertiesManager.getUserPreferences().getDouble(TICK_LENGTH, 5.0);
    }

    public static synchronized String getSystemLineStyle() {
        return CvPropertiesManager.getUserPreferences().get(LINE_STYLE, DOTTEDLINE);
    }

    public static synchronized boolean getSystemGridLinesOn() {
        return CvPropertiesManager.getUserPreferences().getBoolean(GRID_LINES_ON, false);
    }

    public static synchronized String getSystemMyTools() {
        return CvPropertiesManager.getUserPreferences().get(MY_TOOLS, "");
    }

    public static synchronized String getMyFavoriteHoverMenu(String AppName) {
        if (AppName != null && !AppName.trim().equals("")) {
            AppName = AppName + ".";
        } else if (AppName == null) {
            AppName = "";
        }
        String fav_menu = AppName.trim() + MY_FAVORITE_HOVERMENU;
        String fav_menu_items = CvPropertiesManager.getUserPreferences().get(fav_menu, "");
        if ("".equals(fav_menu_items)) {
            return CvPropertiesManager.getProperty("cvf.setup.default.actions");
        }
        return fav_menu_items;
    }

    public static synchronized void updateGridSpacing(double gs) {
        GSPACING = gs;
        CvImageGrid.setGridSpacing(GSPACING);
    }

    public static synchronized void updateTickSpacing(double ts) {
        TSPACING = ts;
        CvImageGrid.setTickSpacing(TSPACING);
    }

    public static synchronized void updateTickLength(double tl) {
        TLENGTH = tl;
        CvImageGrid.setTickLength(TLENGTH);
    }

    public static synchronized void updateLineStyle(String style) {
        LSTYLE = style;
        CvImageGrid.setLineStyle(LSTYLE);
    }

    public static synchronized void updateMyTools(String mytools) {
        MYTOOLS = mytools;
    }

    public static synchronized void updateGridLinesOn(boolean on) {
        GLINES_ON = on;
        CvImageGrid.setGridLinesOn(GLINES_ON);
    }

    public static synchronized void saveGridSpacing(double gs) {
        XPDisplayPrefsUtils.updateGridSpacing(gs);
        CvPropertiesManager.getUserPreferences().putDouble(GRID_SPACING, gs);
    }

    public static synchronized void saveTickSpacing(double ts) {
        XPDisplayPrefsUtils.updateTickSpacing(ts);
        CvPropertiesManager.getUserPreferences().putDouble(TICK_SPACING, ts);
    }

    public static synchronized void saveTickLength(double tl) {
        XPDisplayPrefsUtils.updateTickLength(tl);
        CvPropertiesManager.getUserPreferences().putDouble(TICK_LENGTH, tl);
    }

    public static synchronized void saveLineStyle(String style) {
        XPDisplayPrefsUtils.updateLineStyle(style);
        CvPropertiesManager.getUserPreferences().put(LINE_STYLE, style);
    }

    public static synchronized void saveGridLinesOn(boolean on) {
        XPDisplayPrefsUtils.updateGridLinesOn(on);
        CvPropertiesManager.getUserPreferences().putBoolean(GRID_LINES_ON, on);
    }

    public static synchronized void saveMyTools(String mytools) {
        XPDisplayPrefsUtils.updateMyTools(mytools);
        CvPropertiesManager.getUserPreferences().put(MY_TOOLS, mytools);
    }

    public static synchronized void saveMyfavoriteHovermenuPanels(String appname, String myfavoritehovermenu) {
        appname = appname != null && !appname.trim().equals("") ? appname.trim() + "." : "";
        String pstring = appname.trim() + MY_FAVORITE_HOVERMENU;
        CvPropertiesManager.getUserPreferences().put(pstring, myfavoritehovermenu);
    }

    public static synchronized double getGridSpacing() {
        return GSPACING;
    }

    public static synchronized double getTickSpacing() {
        return TSPACING;
    }

    public static synchronized double getTickLength() {
        return TLENGTH;
    }

    public static synchronized String getLineStyle() {
        return LSTYLE;
    }

    public static synchronized boolean getGridLinesOn() {
        return GLINES_ON;
    }

    public static synchronized boolean getSystemMiddleImageWindowingStatus() {
        return CvPropertiesManager.getBoolean(MIDDLE_IMAGE_WWWL_KEY, false);
    }

    public static synchronized boolean getMiddleImageWindowingStatus() {
        return MIDDLEIMAGE_WINDOWING_STATUS;
    }

    public static synchronized void updateWindowingToMiddleImage(boolean middleImageWindowing) {
        MIDDLEIMAGE_WINDOWING_STATUS = middleImageWindowing;
    }

    public static synchronized void saveMiddleImageWindowingStatus(boolean middleImageWindowingEnabled) {
        MIDDLEIMAGE_WINDOWING_STATUS = middleImageWindowingEnabled;
    }
}

