/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.terra.jami.XpMagnifierVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.xpv.mouseController.Xp2DViewerMouseController;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class XpMagnifierMouseController
extends Xp2DViewerMouseController {
    private XpSingularPort vp = null;
    private XpMagnifierVc magVc = null;

    @Override
    public void setTarget(JComponent jc) {
        if (jc instanceof XpSingularPort) {
            this.vp = (XpSingularPort)jc;
            XpMedicalImage2DVc image2DVc = this.vp.getMedicalImageVc();
            this.magVc = new XpMagnifierVc(image2DVc, 100.0, 100.0);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.magVc.setMouseMask(this.findButtonMask(me.getButton()));
        if (me.getX() > this.vp.getWidth() || me.getX() < 0 || me.getY() > this.vp.getHeight() || me.getY() < 0) {
            return;
        }
        this.vp.getMedicalImageVc().add((Component)this.magVc, 0);
        this.vp.getMedicalImageVc().validate();
        this.magVc.getMouseListeners()[0].mousePressed(me);
    }

    private int findButtonMask(int button) {
        switch (button) {
            case 1: {
                return 16;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 4;
            }
        }
        return 16;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.getX() > this.vp.getWidth() || me.getX() < 0 || me.getY() > this.vp.getHeight() || me.getY() < 0) {
            return;
        }
        this.magVc.getMouseMotionListeners()[0].mouseDragged(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.vp.getMedicalImageVc().remove(this.magVc);
        this.magVc.getMouseListeners()[0].mouseReleased(me);
        this.vp.invalidate();
        this.vp.validate();
        this.vp.repaint();
    }
}

