/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XPCrossRefLinesManager;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.print.DndPrint;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.idc.Capable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.tap.print.ImageTransferable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class XpFilmDndMouseController
extends MouseInputAdapter
implements XpMouseController,
DragSourceListener,
DragGestureListener {
    private DragSource dragSource = null;
    private static final Logger logger = Logger.getLogger(XPCrossRefLinesManager.class.getName());
    private JComponent target = null;

    @Override
    public void setTarget(JComponent vc) {
        if (vc == null) {
            this.target = vc;
            if (this.dragSource != null) {
                this.dragSource.removeDragSourceListener(this);
            }
        } else {
            this.target = vc;
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this.target, 1, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        TransactionLogName tln = new TransactionLogName("TID=CV_filmDndAction");
        if (this.target == null || dsde.getSource().equals(this.target)) {
            logger.log(Level.INFO, "{0} Sev5 Target is NULL !!", tln);
            return;
        }
        logger.log(Level.INFO, "{0} begin", tln);
        PrintService service_ = CvUtils.getDefaultPrintService();
        if (service_ == null) {
            logger.log(Level.INFO, "{0} Sev5 No print services found !!", tln);
            return;
        }
        PrinterStatus ps = service_.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (ps != null) {
            status = service_.getAttribute(PrinterStatus.class).getValue();
        }
        if (ps == null && !status) {
            logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", tln);
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
            return;
        }
        DocPrintJob job = service_.createPrintJob();
        if (job == null) {
            logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print Job", tln);
            return;
        }
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        SimpleDoc doc = null;
        int[] annotkey = null;
        String imageType = null;
        if (this.target instanceof Capable && this.target instanceof FrameOwner) {
            imageType = CvUtils.getImageTypeKey((Capable)((Object)this.target));
        }
        annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys((XpFrameVisualizer)this.target, imageType, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
        if (this.target instanceof XpSingularPort) {
            XpViewport clonePort = null;
            XpAnnotationGenerator annotGen = null;
            if (this.target.getParent() != null && this.target.getParent() instanceof XpViewport && this.target.getParent() instanceof SelectionCapable) {
                XpViewport parentPort = (XpViewport)this.target.getParent();
                if (XpReferenceImageApp.isRefPortOn(parentPort)) {
                    int portIndex = -1;
                    SelectionCapable sc = (SelectionCapable)((Object)parentPort);
                    for (int i = 0; i < sc.getNumComponents(); ++i) {
                        if (sc.getViewportComponent(i) != this.target) continue;
                        portIndex = i;
                    }
                    if (portIndex == -1) {
                        logger.log(Level.INFO, "{0} Sev5 Target is out of context!!!", tln);
                        return;
                    }
                    clonePort = (XpViewport)XpReferenceImageApp.cloneWithRefPort(parentPort, portIndex);
                    if (clonePort == null) {
                        logger.log(Level.INFO, "{0} Sev5 Error while cloning reference viewport!!!", tln);
                        return;
                    }
                    if (XpReferenceImageApp.isRefPortOn(parentPort, portIndex)) {
                        clonePort.putClientProperty("reference_viewport", "true");
                    }
                } else {
                    String renderer = CvPropertiesManager.getProperty("cvf.print.renderer");
                    clonePort = this.target instanceof XpFrameVisualizer && renderer != null ? CvUtils.createViewPortCopy((XpFrameVisualizer)this.target, renderer) : (XpViewport)((XpViewport)this.target).clone();
                }
                annotGen = parentPort.getAnnotationGenerator();
            } else {
                clonePort = (XpViewport)((XpViewport)this.target).clone();
                annotGen = ((XpViewport)this.target).getAnnotationGenerator();
            }
            if (annotGen != null) {
                Properties props = annotGen instanceof XpApdAnnotationGenerator ? ((XpApdAnnotationGenerator)annotGen).getProperties() : null;
                clonePort.setAnnotationGenerator(annotGen.getClass(), props);
            }
            String filmAnnotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
            int filmCustAnnoMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
            DicomPrintable printable = CvUtils.getDicomPrintable(clonePort);
            if (printable instanceof DicomPrintablePort) {
                ((DicomPrintablePort)printable).setFilmAnnotationItems(filmAnnotLevel, filmCustAnnoMask);
                if (annotkey != null) {
                    ((DicomPrintablePort)printable).setLargeFontAnnotation(annotkey);
                }
            }
            if ((doc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null)) == null) {
                logger.log(Level.SEVERE, "{0} Sev5 Error in printing : NULL Dicom Print doc", tln);
                return;
            }
            aset.add(new DndPrint("DndPrint", new Locale("en")));
            try {
                job.print(doc, aset);
            }
            catch (PrintException pe) {
                logger.log(Level.SEVERE, "{0} Error in printing due to " + pe.getMessage(), tln);
            }
            logger.log(Level.INFO, "{0} end", tln);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.target == null) {
            return;
        }
        InputEvent event = dge.getTriggerEvent();
        if (event != null) {
            boolean b1;
            int mod = event.getModifiers();
            boolean bl = b1 = 0 != (mod & 0x10);
            if (b1 && this.target instanceof XpSingularPort && this.target.getClientProperty("reference_viewport") == null) {
                this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, (Transferable)new ImageTransferable((Image)new BufferedImage(1024, 1024, 5)), this);
            }
        }
    }
}

