/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class MouseModeController
implements MouseModeCapable,
XpMouseController {
    public static final int MAX_CONTROLLER = Integer.parseInt(CvPropertiesManager.getProperty("cvf.MouseController.Max", "20"));
    protected JComponent target = null;
    protected MouseInputListener activeMouseController = null;
    protected Cursor previousCursor = null;
    private LinkedHashMap<Integer, MouseModeRecord> mouseModeMap = new LinkedHashMap();
    private LinkedHashMap<Integer, Integer> inputmaskToModeMap = new LinkedHashMap();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private transient int activeMouseButton = 0;

    @Override
    public void setTarget(JComponent jc) {
        this.target = jc;
    }

    protected void updateCursor(int mode) {
        Object c;
        MouseModeRecord mmr;
        if (this.target != null && (mmr = this.mouseModeMap.get(new Integer(mode))) != null && (c = mmr.getModeProperty("cursor_property")) != null) {
            this.target.setCursor((Cursor)c);
        }
    }

    @Override
    public int[] getSupportedModes() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean i = false;
        if (this.mouseModeMap.size() > 0) {
            Collection<MouseModeRecord> mmc = this.mouseModeMap.values();
            for (MouseModeRecord m : mmc) {
                if (!m.isVisible()) continue;
                list.add(m.getMouseMode());
            }
        }
        int[] smodes = new int[list.size()];
        for (int j = 0; j < smodes.length; ++j) {
            smodes[j] = (Integer)list.get(j);
        }
        return smodes;
    }

    @Override
    public void setMouseMode(int mode, int binding) {
        Integer b = new Integer(binding);
        Integer m = new Integer(mode);
        MouseModeRecord mmr = this.mouseModeMap.get(m);
        if (mmr == null) {
            mmr = new MouseModeRecord(mode);
        }
        mmr.setBindingMask(binding);
        this.mouseModeMap.put(m, mmr);
        this.inputmaskToModeMap.put(b, m);
        this.pcs.firePropertyChange("MOUSEMODE", null, new Integer[]{mode, binding});
    }

    @Override
    public int getMouseMode(int binding) {
        int mode = -1;
        Integer m = this.inputmaskToModeMap.get(new Integer(binding));
        if (m != null) {
            mode = m;
        }
        return mode;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener("MOUSEMODE", pcl);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener("MOUSEMODE", pcl);
    }

    @Override
    public int getModeBinding(int mode) {
        int binding = -1;
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        if (mmr != null) {
            binding = mmr.getBindingMask();
        }
        return binding;
    }

    @Override
    public void installMouseListener(int mode, MouseInputListener listener) {
        Integer m = new Integer(mode);
        MouseModeRecord mmr = this.mouseModeMap.get(m);
        if (mmr != null) {
            mmr.setModeMouseListener(listener);
        } else {
            mmr = new MouseModeRecord(mode);
            mmr.setModeMouseListener(listener);
            this.mouseModeMap.put(m, mmr);
        }
    }

    public void activateMouseListener(int mode) {
        MouseInputListener l;
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        if (mmr != null && mmr.isModeEnabled() && (l = mmr.getModeMouseListener()) instanceof XpMouseController) {
            if (this.activeMouseController != null && this.activeMouseController instanceof XpMouseController) {
                ((XpMouseController)this.activeMouseController).setTarget(null);
            }
            if (this.target != null) {
                this.previousCursor = this.target.getCursor();
            }
            this.activeMouseController = l;
            ((XpMouseController)l).setTarget(this.target);
            this.updateCursor(mode);
        }
    }

    @Override
    public Object getModeProperty(int mode, String property) {
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        Object val = null;
        if (mmr != null) {
            val = mmr.getModeProperty(property);
        }
        return val;
    }

    @Override
    public void putModeProperty(int mode, String property, Object value) {
        Integer m = new Integer(mode);
        MouseModeRecord mmr = this.mouseModeMap.get(m);
        if (mmr == null) {
            mmr = new MouseModeRecord(mode);
            mmr.setModeProperty(property, value);
            this.mouseModeMap.put(m, mmr);
        } else if (value != null) {
            mmr.setModeProperty(property, value);
        }
    }

    public void dispose() {
        PropertyChangeListener[] lsnrs = this.pcs.getPropertyChangeListeners();
        int n = lsnrs.length;
        for (int i = 0; i < n; ++i) {
            this.pcs.removePropertyChangeListener(lsnrs[i]);
        }
        this.target = null;
        this.activeMouseController = null;
        this.previousCursor = null;
        this.mouseModeMap.clear();
        this.inputmaskToModeMap.clear();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.activeMouseButton != 0) {
            return;
        }
        if (e.getButton() == 1) {
            this.activeMouseButton = 16;
        } else if (e.getButton() == 2) {
            this.activeMouseButton = 8;
        } else if (e.getButton() == 3) {
            this.activeMouseButton = 4;
        }
        int binding = e.getModifiersEx() & 0xFFFFFEFF;
        Integer m = this.inputmaskToModeMap.get(new Integer(binding));
        if (m != null) {
            this.activateMouseListener(m);
            if (this.activeMouseController != null) {
                this.activeMouseController.mousePressed(e);
            }
        } else {
            this.activeMouseController = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.activeMouseController != null) {
            this.activeMouseController.mouseDragged(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!(e.getButton() == 1 && this.activeMouseButton == 16 || e.getButton() == 2 && this.activeMouseButton == 8 || e.getButton() == 3 && this.activeMouseButton == 4)) {
            return;
        }
        this.activeMouseButton = 0;
        if (this.activeMouseController != null) {
            if (this.target != null && this.previousCursor != null) {
                this.target.setCursor(this.previousCursor);
            }
            this.activeMouseController.mouseReleased(e);
            ((XpMouseController)this.activeMouseController).setTarget(null);
            this.activeMouseController = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.activeMouseController != null) {
            this.activeMouseController.mouseClicked(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.activeMouseController != null) {
            this.activeMouseController.mouseEntered(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.activeMouseController != null) {
            this.activeMouseController.mouseMoved(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.activeMouseController != null) {
            this.activeMouseController.mouseExited(e);
        }
    }

    @Override
    public void setModeEnabled(int mode, boolean enable) {
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        if (mmr != null) {
            mmr.setModeEnabled(enable);
        }
    }

    @Override
    public boolean isModeEnabled(int mode) {
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        if (mmr != null) {
            return mmr.isModeEnabled();
        }
        return false;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }

    @Override
    public Capable getCapable(String capableIFName) {
        if (this.target != null && this.target instanceof Capable) {
            return ((Capable)((Object)this.target)).getCapable(capableIFName);
        }
        return null;
    }

    @Override
    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
    }

    @Override
    public void setVisible(int mode, boolean visible) {
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        if (mmr != null) {
            mmr.setVisible(visible);
        }
    }

    @Override
    public boolean isVisible(int mode) {
        MouseModeRecord mmr = this.mouseModeMap.get(new Integer(mode));
        if (mmr != null) {
            return mmr.isVisible();
        }
        return false;
    }

    private static class MouseModeRecord {
        private int mode = -1;
        private int modeBindingMask = 0;
        private MouseInputListener modeListener = null;
        private Properties modeProps = new Properties();
        private boolean enabled = false;
        private boolean visible = true;

        public MouseModeRecord(int m) {
            this.mode = m;
            this.enabled = true;
        }

        public int getMouseMode() {
            return this.mode;
        }

        public void setBindingMask(int mask) {
            this.modeBindingMask = this.modeBindingMask == 0 ? mask : (this.modeBindingMask |= mask);
        }

        public int getBindingMask() {
            return this.modeBindingMask;
        }

        public void setModeMouseListener(MouseInputListener ml) {
            this.modeListener = ml;
        }

        public MouseInputListener getModeMouseListener() {
            return this.modeListener;
        }

        public void setModeProperty(String prop, Object val) {
            this.modeProps.put(prop, val);
        }

        public Object getModeProperty(String prop) {
            return this.modeProps.get(prop);
        }

        public void setModeEnabled(boolean flag) {
            this.enabled = flag;
        }

        public boolean isModeEnabled() {
            return this.enabled;
        }

        public void setVisible(boolean flag) {
            this.visible = flag;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

