/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.controls.CvMouseController;
import com.ge.med.cse.cvf.controls.MouseModeController;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.mouseController.CustomCursor;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonController;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public class CvMouseControllerUtil {
    public static final String mouseMenuControllerPrefix = "MouseMenu.Controller";
    public static final String LEFTBUTTON = "LEFTBUTTON";
    public static final String MIDDLEBUTTON = "MIDDLEBUTTON";
    public static final String RIGHTBUTTON = "RIGHTBUTTON";
    public static final String mouseControllerDisplayMenuButton = ".displaymenubtn";
    public static final String mouseControllerApplyButton = ".applybtn";
    public static final String mouseControllerLeftButtonDefault = ".leftbtn.default";
    public static final String mouseControllerMiddleButtonDefault = ".middlebtn.default";
    public static final String mouseControllerRightButtonDefault = ".rightbtn.default";
    public static final String mouseControllerRightCtrlButtonDefault = ".rightctrlbtn.default";
    public static final String MOUSECONTROLLER_LEFT_SHIFT_BUTTON_DEFAULT = ".leftshiftbtn.default";
    public static final String mouseControllerSystemSuffix = ".system";
    public static final String mouseControllerAWSuffix = ".aw";
    public static final String mouseMenuControllerAllignment = ".allignment";
    public static final String VERTICAL_ALLIGNMENT = "VERTICAL";
    public static final String HORIZONTAL_ALLIGNMENT = "HORIZONTAL";
    public static final int ICON_SIZE = 25;
    private static ResourceBundle res = CvUtils.getResourceBundle();
    private static Map[] modeProps = new Map[MouseModeController.MAX_CONTROLLER];
    public static String id = "all";
    private static HashMap<String, MouseModeSyncHandler> modeSyncHandler = new HashMap();

    public static void loadDefaultMouseModeProperty() {
        CvMouseControllerUtil.putDefaultModeProperty(0, "name_property", res.getString("MouseButtonController.SELECT"));
        CvMouseControllerUtil.putDefaultModeProperty(0, "icon_property", CvUtils.getIcon("XP_SELECT_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(0, "selected_icon_property", CvUtils.getIcon("XP_SELECT_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(0, "short_description_property", "Object Select Mode");
        CvMouseControllerUtil.putDefaultModeProperty(0, "cursor_property", Cursor.getDefaultCursor());
        CvMouseControllerUtil.putDefaultModeProperty(1, "name_property", res.getString("MouseButtonController.PAGE"));
        CvMouseControllerUtil.putDefaultModeProperty(1, "icon_property", CvUtils.getIcon("XP_PAGE_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(1, "short_description_property", "Page Through Images");
        CvMouseControllerUtil.putDefaultModeProperty(1, "cursor_property", CustomCursor.PAGE_CURSOR);
        CvMouseControllerUtil.putDefaultModeProperty(2, "name_property", res.getString("MouseButtonController.PAN"));
        CvMouseControllerUtil.putDefaultModeProperty(2, "icon_property", CvUtils.getIcon("XP_PAN_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(2, "selected_icon_property", CvUtils.getIcon("XP_PAN_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(2, "short_description_property", "Pan/Roam Image");
        CvMouseControllerUtil.putDefaultModeProperty(2, "cursor_property", CustomCursor.PAN_CURSOR);
        CvMouseControllerUtil.putDefaultModeProperty(3, "name_property", res.getString("MouseButtonController.ZOOM"));
        CvMouseControllerUtil.putDefaultModeProperty(3, "icon_property", CvUtils.getIcon("XP_ZOOM_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(3, "selected_icon_property", CvUtils.getIcon("XP_ZOOM_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(3, "short_description_property", "Zoom");
        CvMouseControllerUtil.putDefaultModeProperty(3, "cursor_property", CustomCursor.ZOOM_CURSOR);
        CvMouseControllerUtil.putDefaultModeProperty(4, "name_property", res.getString("MouseButtonController.WINDOWING"));
        CvMouseControllerUtil.putDefaultModeProperty(4, "icon_property", CvUtils.getIcon("XP_WINDOWING_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(4, "selected_icon_property", CvUtils.getIcon("XP_WINDOWING_MODE_ICON"));
        CvMouseControllerUtil.putDefaultModeProperty(4, "short_description_property", "Window/Level Image");
        CvMouseControllerUtil.putDefaultModeProperty(4, "cursor_property", CustomCursor.WL_CURSOR);
        CvMouseControllerUtil.putDefaultModeProperty(5, "name_property", res.getString("MouseButtonController.ROTATE"));
        CvMouseControllerUtil.putDefaultModeProperty(5, "icon_property", new ImageIcon(LeftMouseButtonController.class.getResource("drag3dcubecorner1.gif")));
        CvMouseControllerUtil.putDefaultModeProperty(5, "selected_icon_property", new ImageIcon(LeftMouseButtonController.class.getResource("drag3dcubecorner1.gif")));
        CvMouseControllerUtil.putDefaultModeProperty(5, "short_description_property", "Rotate");
        CvMouseControllerUtil.putDefaultModeProperty(5, "cursor_property", CustomCursor.ROTATION_3D_CURSOR);
        CvMouseControllerUtil.putDefaultModeProperty(8, "name_property", res.getString("MouseButtonController.SELECT"));
        CvMouseControllerUtil.putDefaultModeProperty(8, "icon_property", new ImageIcon(LeftMouseButtonController.class.getResource("icocursorarrow_16_1.gif")));
        CvMouseControllerUtil.putDefaultModeProperty(8, "selected_icon_property", new ImageIcon(LeftMouseButtonController.class.getResource("icocursorarrow_16_3.gif")));
        CvMouseControllerUtil.putDefaultModeProperty(8, "short_description_property", "Shift 3D Cursor");
        CvMouseControllerUtil.putDefaultModeProperty(8, "cursor_property", Cursor.getDefaultCursor());
    }

    public static Object getDefaultModeProperty(int mode, String property) {
        if (modeProps[mode] != null) {
            return modeProps[mode].get(property);
        }
        return null;
    }

    public static void putDefaultModeProperty(int mode, String property, Object value) {
        if (modeProps[mode] == null) {
            CvMouseControllerUtil.modeProps[mode] = new HashMap();
        }
        modeProps[mode].put(property, value);
    }

    public static int getMouseModeToApplyButton(Properties prop) {
        String mouseBtnApplyMode = prop.getProperty("MouseMenu.Controller.applybtn", LEFTBUTTON);
        if (mouseBtnApplyMode.equals(LEFTBUTTON)) {
            return 1024;
        }
        if (mouseBtnApplyMode.equals(MIDDLEBUTTON)) {
            return 2048;
        }
        if (mouseBtnApplyMode.equals(RIGHTBUTTON)) {
            return 4096;
        }
        return 1024;
    }

    public static int getMouseMenuDisplayButton(Properties prop) {
        String mouseMenuDisplayBtn = prop.getProperty("MouseMenu.Controller.displaymenubtn", RIGHTBUTTON);
        if (mouseMenuDisplayBtn.equals(LEFTBUTTON)) {
            return 1024;
        }
        if (mouseMenuDisplayBtn.equals(MIDDLEBUTTON)) {
            return 2048;
        }
        if (mouseMenuDisplayBtn.equals(RIGHTBUTTON)) {
            return 4096;
        }
        return 4096;
    }

    public static String getMouseButtonDefaultConstant(int binding) {
        switch (binding) {
            case 1024: {
                return mouseControllerLeftButtonDefault;
            }
            case 2048: {
                return mouseControllerMiddleButtonDefault;
            }
            case 4096: {
                return mouseControllerRightButtonDefault;
            }
            case 4224: {
                return mouseControllerRightCtrlButtonDefault;
            }
            case 1088: {
                return MOUSECONTROLLER_LEFT_SHIFT_BUTTON_DEFAULT;
            }
        }
        return null;
    }

    public static JPopupMenu getMouseModeMenu(final MouseModeCapable modeCapable, String allignment, final int binding) {
        final JPopupMenu popUpMenu = new JPopupMenu();
        JPanel controlBtnPanel = new JPanel();
        controlBtnPanel.setLayout(new GridBagLayout());
        final int[] modes = modeCapable.getSupportedModes();
        final AbstractButton[] btns = CvMouseControllerUtil.getMouseModeButtons(modeCapable, allignment);
        int selected = modeCapable.getMouseMode(binding);
        for (int i = 0; i < modes.length; ++i) {
            boolean enabled = modeCapable.isModeEnabled(modes[i]);
            if (allignment.equals(HORIZONTAL_ALLIGNMENT)) {
                controlBtnPanel.add((Component)btns[i], new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
            } else if (allignment.equals(VERTICAL_ALLIGNMENT)) {
                popUpMenu.add(btns[i]);
            }
            if (selected == modes[i]) {
                btns[i].setSelected(true);
            }
            btns[i].setEnabled(enabled);
            final int modesi = modes[i];
            btns[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    modeCapable.setMouseMode(modesi, binding);
                    popUpMenu.setVisible(false);
                }
            });
        }
        if (allignment.equals(HORIZONTAL_ALLIGNMENT)) {
            popUpMenu.add(controlBtnPanel);
        }
        PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer[] newValue = (Integer[])evt.getNewValue();
                if (newValue.length == 2) {
                    int newMode = newValue[0];
                    int bind = newValue[1];
                    for (int i = 0; i < modes.length; ++i) {
                        if (modes[i] != newMode || binding != bind || !btns[i].isEnabled()) continue;
                        btns[i].setSelected(true);
                    }
                }
            }
        };
        modeCapable.removePropertyChangeListener(mouseModeChangeListener);
        modeCapable.addPropertyChangeListener(mouseModeChangeListener);
        return popUpMenu;
    }

    public static AbstractButton[] getMouseModeButtons(MouseModeCapable modeCapable, String allignment) {
        AbstractButton[] mouseModeButtons = new AbstractButton[modeCapable.getSupportedModes().length];
        int[] modes = modeCapable.getSupportedModes();
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < modes.length; ++i) {
            String name = (String)modeCapable.getModeProperty(modes[i], "name_property");
            Icon ico = (Icon)modeCapable.getModeProperty(modes[i], "icon_property");
            if (name == null) {
                name = "Unknown mode";
            }
            if (allignment.equals(HORIZONTAL_ALLIGNMENT)) {
                mouseModeButtons[i] = new JToggleButton();
                mouseModeButtons[i].setIcon(ico);
                mouseModeButtons[i].setToolTipText(name);
                mouseModeButtons[i].setActionCommand(name);
                mouseModeButtons[i].setName(name);
                mouseModeButtons[i].setFocusPainted(false);
                mouseModeButtons[i].setFocusable(false);
                mouseModeButtons[i].setBackground(null);
                mouseModeButtons[i].setBorder(null);
                mouseModeButtons[i].setPreferredSize(new Dimension(25, 25));
            } else if (allignment.equals(VERTICAL_ALLIGNMENT)) {
                mouseModeButtons[i] = new JRadioButtonMenuItem(name, ico);
            }
            bg.add(mouseModeButtons[i]);
        }
        return mouseModeButtons;
    }

    public static void setMouseModeEnable(JPopupMenu pmenu, String alignment, String modename, boolean enable) {
        block5: {
            Component[] comp;
            block4: {
                Component[] comp2;
                if (pmenu == null) {
                    return;
                }
                if (!alignment.equals(HORIZONTAL_ALLIGNMENT)) break block4;
                Component panel = pmenu.getComponent(0);
                if (panel == null || !(panel instanceof JPanel) || (comp2 = ((JPanel)panel).getComponents()) == null) break block5;
                for (Component btn : comp2) {
                    if (!(btn instanceof AbstractButton) || !((AbstractButton)btn).getName().equals(modename)) continue;
                    ((AbstractButton)btn).setEnabled(enable);
                }
                break block5;
            }
            if (alignment.equals(VERTICAL_ALLIGNMENT) && (comp = pmenu.getComponents()) != null) {
                for (Component btn : comp) {
                    if (!(btn instanceof JMenuItem) || !((JMenuItem)btn).getText().equals(modename)) continue;
                    ((JRadioButtonMenuItem)btn).setEnabled(enable);
                }
            }
        }
    }

    public static void setSystemDefaultMouseMode(MouseModeCapable modeCapable, String appName, Properties prop) {
        String prefix = (appName != null && appName.length() > 0 ? appName + "." : "") + mouseMenuControllerPrefix;
        String modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(1024) + mouseControllerSystemSuffix;
        String defaultMouseModeStr = prop.getProperty(modeProp);
        if (defaultMouseModeStr != null) {
            modeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 1024);
        }
        if ((defaultMouseModeStr = prop.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(2048) + mouseControllerSystemSuffix)) != null) {
            modeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 2048);
        }
        if ((defaultMouseModeStr = prop.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(4096) + mouseControllerSystemSuffix)) != null) {
            modeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 4096);
        }
        if ((defaultMouseModeStr = prop.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(4224) + mouseControllerSystemSuffix)) != null) {
            modeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 4224);
        }
        if ((defaultMouseModeStr = prop.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(1088) + mouseControllerSystemSuffix)) != null) {
            modeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 1088);
        }
    }

    public static MouseModeSyncHandler getMouseModeSyncHandler(String name) {
        if (!modeSyncHandler.containsKey(name)) {
            MouseModeSyncHandler msHandler = new MouseModeSyncHandler();
            modeSyncHandler.put(name, msHandler);
        }
        return modeSyncHandler.get(name);
    }

    public static void disposeMouseControllers() {
        for (MouseModeSyncHandler modeSyncHandler : CvMouseControllerUtil.modeSyncHandler.values()) {
            modeSyncHandler.dispose();
        }
    }

    public static class MouseModeSyncHandler {
        private ArrayList<MouseModeCapable> modeCapablesToSync = new ArrayList();
        private PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer[] newValue = (Integer[])evt.getNewValue();
                if (newValue.length == 2) {
                    int newMode = newValue[0];
                    int binding = newValue[1];
                    for (MouseModeCapable modeCapable : MouseModeSyncHandler.this.modeCapablesToSync) {
                        if (modeCapable.getMouseMode(binding) == newMode) continue;
                        modeCapable.setMouseMode(newMode, binding);
                    }
                }
            }
        };

        public void addMouseModeChangeListener(MouseModeCapable modeCap) {
            if (!this.modeCapablesToSync.contains(modeCap)) {
                this.modeCapablesToSync.add(modeCap);
                modeCap.removePropertyChangeListener(this.mouseModeChangeListener);
                modeCap.addPropertyChangeListener(this.mouseModeChangeListener);
            }
        }

        public void removeMouseModeChangeListener(MouseModeCapable modeCap) {
            if (this.modeCapablesToSync.contains(modeCap)) {
                this.modeCapablesToSync.remove(modeCap);
                modeCap.removePropertyChangeListener(this.mouseModeChangeListener);
            }
        }

        public void dispose() {
            for (CvMouseController cvMouseController : this.modeCapablesToSync) {
                cvMouseController.dispose();
            }
            this.modeCapablesToSync.clear();
        }
    }
}

