/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.commands.CommandControl;
import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.controls.MouseModeController;
import com.ge.med.cse.cvf.idc.PagingCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvResourceBundle;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class CvMouseController
extends MouseModeController {
    protected static final Logger logger = Logger.getLogger(CvMouseController.class.getName());
    private static final String mouseMenuControllerCount = ".count";
    private static final String mouseModeSuffix = ".mode";
    private static final String mouseModeOverwriteSuffix = ".overwrite";
    private static final String mouseControllerNameSuffix = ".name";
    private static final String mouseControllerTooltipSuffix = ".tooltip";
    private static final String mouseControllerShortDescSuffix = ".shortdesc";
    private static final String mouseControllerIconSuffix = ".icon";
    private static final String mouseControllerSelectedIconSuffix = ".selectedicon";
    private static final String MOUSEMODE_VISIBILE = ".visible";
    private static final String mouseMenuPrefix = "MouseMenu";
    private static final String mouseMenuGroup = ".group";
    private static final String mouseMenuCount = ".count";
    private static final String mouseMenuLabel = ".label";
    private static final String mouseMenuParam = ".param";
    private static final String mouseMenuCheckBox = ".checkbox";
    protected static final String DEFAULT_APP = "";
    protected static final int ICON_SIZE = 27;
    protected String appName = "";
    protected JPopupMenu popUpMenu = null;
    public List<Action> actonList = new ArrayList<Action>();
    public Vector<Action> subMenuActionList = new Vector();
    protected String modality = "";
    protected Properties prop = null;
    private boolean mdrag = false;
    private String prefix = "MouseMenu.Controller";
    private AncestorListener alistner = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            JComponent ancestor;
            CvMouseController.this.target = ancestor = event.getComponent();
            CvMouseController.this.setCapableToMouseActions();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    };
    private transient PropertyChangeListener paginglistener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PagingCapable pcap = (PagingCapable)((Object)SwingUtilities.getAncestorOfClass(PagingCapable.class, CvMouseController.this.target));
            if (pcap != null) {
                boolean pagingFlag = pcap.isPagingOn();
                CvMouseController.this.setModeEnabled(1, pagingFlag);
            }
        }
    };
    PropertyChangeListener cineListener = new PropertyChangeListener(){
        private int prevMode = -1;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("Cine")) {
                boolean isCineOn = (Boolean)evt.getNewValue();
                String modesOnCine = CvMouseController.this.prop.getProperty("MouseModesEnabledDuringCineOn");
                if (modesOnCine == null) {
                    return;
                }
                String[] modesOnDuringCine = modesOnCine.split(",");
                ArrayList<Integer> modesOnDrngCine = new ArrayList<Integer>();
                for (int i = 0; i < modesOnDuringCine.length; ++i) {
                    modesOnDrngCine.add(Integer.valueOf(modesOnDuringCine[i].trim()));
                }
                if (modesOnDrngCine.size() > 0) {
                    if (isCineOn) {
                        this.prevMode = CvMouseController.this.getMouseMode(CvMouseControllerUtil.getMouseModeToApplyButton(CvMouseController.this.prop));
                        if (!modesOnDrngCine.contains(this.prevMode)) {
                            CvMouseController.this.setMouseMode(Integer.parseInt(CvMouseController.this.prop.getProperty("DefaultMouseModeDuringCineOn", "3")), CvMouseControllerUtil.getMouseModeToApplyButton(CvMouseController.this.prop));
                        }
                    } else {
                        CvMouseController.this.setMouseMode(this.prevMode, CvMouseControllerUtil.getMouseModeToApplyButton(CvMouseController.this.prop));
                    }
                }
            }
        }
    };

    public CvMouseController() {
        this.prop = CvPropertiesManager.getProperties();
        this.init();
    }

    public CvMouseController(Properties properties) {
        this.prop = CvPropertiesManager.getProperties();
        if (properties != null) {
            this.prop.putAll((Map<?, ?>)properties);
        }
        this.init();
    }

    public CvMouseController(String appName) {
        this.prop = CvPropertiesManager.getProperties();
        this.appName = appName;
        this.init();
    }

    public CvMouseController(String appName, Properties properties) {
        this.prop = CvPropertiesManager.getProperties();
        if (properties != null) {
            this.prop.putAll((Map<?, ?>)properties);
        }
        this.appName = appName;
        this.init();
    }

    protected void init() {
        this.prefix = (this.appName != null && this.appName.length() > 0 ? this.appName + "." : DEFAULT_APP) + "MouseMenu.Controller";
        this.loadMouseModeProperty();
        CvMouseControllerUtil.setSystemDefaultMouseMode(this, this.appName, this.prop);
        this.createMouseMenu();
    }

    private void loadMouseModeProperty() {
        block18: {
            String filmDragAndDrop = CvUtils.getResourceBundle().getString("XP_FILM_DRAG_AND_DROP");
            try {
                String mouseModeCountString = this.prop.getProperty(this.prefix + ".count");
                if (mouseModeCountString == null) break block18;
                int mouseModecount = Integer.parseInt(mouseModeCountString);
                MouseInputListener mouseModeListener = null;
                for (int i = 0; i < mouseModecount; ++i) {
                    String compName = this.prop.getProperty(this.prefix + "." + String.valueOf(i));
                    while (compName == null || compName == DEFAULT_APP) {
                        ++mouseModecount;
                        compName = this.prop.getProperty(this.prefix + "." + String.valueOf(++i));
                    }
                    Class compClsass = CvUtils.getClass(compName);
                    mouseModeListener = (MouseInputListener)compClsass.newInstance();
                    String modeString = this.prop.getProperty(this.prefix + "." + String.valueOf(i) + mouseModeSuffix);
                    int mode = Integer.parseInt(modeString.trim());
                    String overwriteString = this.prop.getProperty(this.prefix + "." + String.valueOf(i) + mouseModeOverwriteSuffix);
                    boolean isOverwrite = Boolean.valueOf(overwriteString);
                    if (isOverwrite) {
                        Icon selectedIcon;
                        String shortDesc;
                        String tooltip;
                        String name = this.prop.getProperty(this.prefix + "." + String.valueOf(i) + mouseControllerNameSuffix);
                        try {
                            tooltip = CvUtils.getResourceBundle().getString(this.prefix + "." + name + mouseControllerTooltipSuffix);
                        }
                        catch (Exception e) {
                            tooltip = CvUtils.getResourceBundle().getString("MouseMenu.Controller." + name + mouseControllerTooltipSuffix);
                        }
                        try {
                            shortDesc = CvUtils.getResourceBundle().getString(this.prefix + "." + name + mouseControllerShortDescSuffix);
                        }
                        catch (Exception e) {
                            shortDesc = CvUtils.getResourceBundle().getString("MouseMenu.Controller." + name + mouseControllerShortDescSuffix);
                        }
                        ImageIcon icon = (ImageIcon)CvUtils.getIcon(this.prefix + "." + name + mouseControllerIconSuffix);
                        if (icon == null) {
                            icon = (ImageIcon)CvUtils.getIcon("MouseMenu.Controller." + name + mouseControllerIconSuffix);
                        }
                        if ((selectedIcon = CvUtils.getIcon(this.prefix + "." + name + mouseControllerSelectedIconSuffix)) == null) {
                            selectedIcon = CvUtils.getIcon("MouseMenu.Controller." + name + mouseControllerSelectedIconSuffix);
                        }
                        this.putModeProperty(mode, "name_property", tooltip);
                        this.putModeProperty(mode, "short_description_property", shortDesc);
                        this.putModeProperty(mode, "icon_property", icon);
                        this.putModeProperty(mode, "selected_icon_property", selectedIcon);
                        if (icon != null) {
                            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2), name);
                            this.putModeProperty(mode, "cursor_property", cursor);
                        }
                    } else if (this.getModeProperty(mode, "name_property") == null && CvMouseControllerUtil.getDefaultModeProperty(mode, "name_property") != null) {
                        if (compClsass.getName().equals("com.ge.med.cse.cvf.controls.XpFilmDndMouseController")) {
                            this.putModeProperty(mode, "name_property", filmDragAndDrop);
                        } else {
                            this.putModeProperty(mode, "name_property", CvMouseControllerUtil.getDefaultModeProperty(mode, "name_property"));
                        }
                        this.putModeProperty(mode, "short_description_property", CvMouseControllerUtil.getDefaultModeProperty(mode, "short_description_property"));
                        this.putModeProperty(mode, "icon_property", CvMouseControllerUtil.getDefaultModeProperty(mode, "icon_property"));
                        this.putModeProperty(mode, "selected_icon_property", CvMouseControllerUtil.getDefaultModeProperty(mode, "selected_icon_property"));
                        this.putModeProperty(mode, "cursor_property", CvMouseControllerUtil.getDefaultModeProperty(mode, "cursor_property"));
                    } else if (this.getModeProperty(mode, "name_property") == null) {
                        this.putModeProperty(mode, "name_property", CvMouseControllerUtil.getDefaultModeProperty(mode, "name_property"));
                    }
                    this.installMouseListener(mode, mouseModeListener);
                    String visible = this.prop.getProperty(this.prefix + "." + String.valueOf(i) + MOUSEMODE_VISIBILE);
                    if (visible == null || Boolean.parseBoolean(visible)) continue;
                    this.setVisible(mode, false);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e.getLocalizedMessage());
            }
        }
    }

    protected void createMouseMenu() {
        String allignment = this.prop.getProperty(this.prefix + ".allignment", "VERTICAL");
        int binding = CvMouseControllerUtil.getMouseModeToApplyButton(this.prop);
        this.popUpMenu = CvMouseControllerUtil.getMouseModeMenu(this, allignment, binding);
        this.popUpMenu.setName("CvMouseControllerPopupMenu");
        this.popUpMenu.setUI(new BasicPopupMenuUI());
        this.createMouseMenuActions(this.popUpMenu);
        this.popUpMenu.setOpaque(true);
    }

    private void createMouseMenuActions(JPopupMenu popmenu) {
        block22: {
            if (this.target != null) {
                this.modality = CvUtils.getCurrentModality((Capable)((Object)this.target));
            }
            if (this.modality != null) {
                this.modality = this.modality.toLowerCase();
            }
            String menuprefix = (this.appName != null && this.appName.length() > 0 ? this.appName + "." : DEFAULT_APP) + mouseMenuPrefix;
            try {
                String mouseActionCountStirng = this.prop.getProperty(menuprefix + mouseMenuGroup + ".count" + "." + this.modality, this.prop.getProperty(menuprefix + mouseMenuGroup + ".count"));
                if (mouseActionCountStirng == null) break block22;
                int groupCount = Integer.parseInt(mouseActionCountStirng);
                Action act = null;
                this.actonList.clear();
                this.subMenuActionList.clear();
                for (int i = 0; i < groupCount; ++i) {
                    ArrayList<Action> list = new ArrayList<Action>();
                    int count = Integer.parseInt(this.prop.getProperty(menuprefix + "." + String.valueOf(i) + ".count" + "." + this.modality, this.prop.getProperty(menuprefix + "." + String.valueOf(i) + ".count")));
                    if (count != 0) {
                        popmenu.addSeparator();
                    }
                    for (int j = 0; j < count; ++j) {
                        String subCountStr = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + ".count" + "." + this.modality, this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + ".count"));
                        if (subCountStr != null) {
                            String templabel;
                            int subCount = Integer.parseInt(subCountStr);
                            String label = templabel = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + mouseMenuLabel);
                            CvResourceBundle bundle = new CvResourceBundle();
                            try {
                                label = bundle.getString(templabel);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            JMenu menu = new JMenu(label);
                            String iconprop = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + mouseControllerIconSuffix);
                            if (iconprop != null) {
                                Icon micon = null;
                                Icon icon = CvUtils.getIcon(iconprop);
                                if (icon != null) {
                                    micon = icon;
                                } else {
                                    File f = new File(iconprop);
                                    if (f.exists()) {
                                        micon = new ImageIcon(iconprop);
                                    }
                                }
                                if (micon != null) {
                                    menu.setIcon(micon);
                                }
                            }
                            for (int k = 0; k < subCount; ++k) {
                                String subSubStr = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + ".count" + "." + this.modality, this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + ".count"));
                                if (subSubStr != null) {
                                    String tempsubMenuTitile;
                                    int subsubCount = Integer.parseInt(subSubStr);
                                    label = tempsubMenuTitile = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + mouseMenuLabel);
                                    try {
                                        label = bundle.getString(tempsubMenuTitile);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    JMenu subMenu = new JMenu(label);
                                    menu.add(subMenu);
                                    for (int l = 0; l < subsubCount; ++l) {
                                        String classname = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + "." + String.valueOf(l));
                                        Action subAct = (Action)CvUtils.getClass(classname).newInstance();
                                        String param = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + "." + String.valueOf(l) + mouseMenuParam);
                                        if (subAct instanceof CommandControl && param != null) {
                                            CommandControl ctrl = (CommandControl)((Object)subAct);
                                            String[] params = param.split(",");
                                            ctrl.setParams(params);
                                        }
                                        String checkBox = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + "." + String.valueOf(l) + mouseMenuCheckBox);
                                        JMenuItem item = null;
                                        item = checkBox != null ? new JCheckBoxMenuItem(subAct) : new JMenuItem(subAct);
                                        subMenu.add(item);
                                        this.subMenuActionList.add(subAct);
                                        popmenu.add(menu);
                                    }
                                    continue;
                                }
                                String classname = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k));
                                String param = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + mouseMenuParam);
                                Action subAct = (Action)CvUtils.getClass(classname).newInstance();
                                if (subAct instanceof CommandControl && param != null) {
                                    CommandControl ctrl = (CommandControl)((Object)subAct);
                                    String[] params = param.split(",");
                                    ctrl.setParams(params);
                                }
                                String checkBox = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + String.valueOf(k) + mouseMenuCheckBox);
                                JMenuItem item = null;
                                item = checkBox != null ? new JCheckBoxMenuItem(subAct) : new JMenuItem(subAct);
                                menu.add(item);
                                this.subMenuActionList.add(subAct);
                                popmenu.add(menu);
                            }
                            continue;
                        }
                        String compName = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + "." + this.modality, this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j)));
                        Class compClsass = CvUtils.getClass(compName);
                        act = (Action)compClsass.newInstance();
                        String checkBox = this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + mouseMenuCheckBox + "." + this.modality, this.prop.getProperty(menuprefix + "." + String.valueOf(i) + "." + String.valueOf(j) + mouseMenuCheckBox));
                        JMenuItem item = null;
                        item = checkBox != null ? new JCheckBoxMenuItem(act) : new JMenuItem(act);
                        popmenu.add(item);
                        list.add(act);
                    }
                    this.actonList.addAll(list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "Unable to install Mouse Actions. " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setTarget(JComponent vc) {
        if (vc == null) {
            return;
        }
        super.setTarget(vc);
        this.target = vc;
        if (this.target != null) {
            this.target.removeAncestorListener(this.alistner);
            this.target.addAncestorListener(this.alistner);
        }
        this.setCapableToMouseActions();
    }

    private void setCapableToMouseActions() {
        PagingCapable pcap;
        Capable capable = (Capable)((Object)SwingUtilities.getAncestorOfClass(XPscreen.class, this.target));
        if (capable == null) {
            capable = (Capable)((Object)SwingUtilities.getAncestorOfClass(XpCompositePort.class, this.target));
        }
        if (capable == null && (this.target instanceof XpCompositePort || this.target instanceof XpSingularPort)) {
            capable = (Capable)((Object)this.target);
        }
        if (capable != null) {
            for (int i = 0; i < this.actonList.size(); ++i) {
                Action act = this.actonList.get(i);
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(capable);
            }
            int submenuActionCount = this.subMenuActionList.size();
            for (int i = 0; i < submenuActionCount; ++i) {
                Action act = this.subMenuActionList.get(i);
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(capable);
            }
            capable.removePropertyChangeListener(this.cineListener);
            capable.addPropertyChangeListener(this.cineListener);
        }
        if ((pcap = (PagingCapable)((Object)SwingUtilities.getAncestorOfClass(PagingCapable.class, this.target))) != null) {
            pcap.removePropertyChangeListener("paging_property", this.paginglistener);
            pcap.addPropertyChangeListener("paging_property", this.paginglistener);
        }
    }

    @Override
    public void setModeEnabled(int mode, boolean enable) {
        super.setModeEnabled(mode, enable);
        String alignment = this.prop.getProperty(this.prefix + ".allignment", "VERTICAL");
        CvMouseControllerUtil.setMouseModeEnable(this.popUpMenu, alignment, (String)this.getModeProperty(mode, "name_property"), enable);
    }

    @Override
    public void setMouseMode(int mode, int binding) {
        super.setMouseMode(mode, binding);
    }

    @Override
    public int getMouseMode(int binding) {
        return super.getMouseMode(binding);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int displayBtn = CvMouseControllerUtil.getMouseMenuDisplayButton(this.prop);
        if (!this.mdrag) {
            String currentModality;
            if (this.target instanceof Capable && (currentModality = CvUtils.getCurrentModality((Capable)((Object)this.target))) != null && !currentModality.equalsIgnoreCase(this.modality)) {
                this.createMouseMenu();
                this.setCapableToMouseActions();
                this.modality = currentModality;
            }
            if (displayBtn == 1024 && SwingUtilities.isLeftMouseButton(e)) {
                this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (displayBtn == 2048 && SwingUtilities.isMiddleMouseButton(e)) {
                this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (displayBtn == 4096 && SwingUtilities.isRightMouseButton(e)) {
                this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
                this.updateCheckBoxMenu_ActionState();
            }
        }
        super.mouseReleased(e);
        this.mdrag = false;
    }

    private void updateCheckBoxMenu_ActionState() {
        int count = this.popUpMenu.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Action action;
            Component comp = this.popUpMenu.getComponent(i);
            if (!(comp instanceof JCheckBoxMenuItem) || !((action = ((JCheckBoxMenuItem)comp).getAction()) instanceof BaseAction)) continue;
            boolean isSel = ((BaseAction)action).isApplied();
            ((JCheckBoxMenuItem)comp).setSelected(isSel);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mdrag = true;
        super.mouseDragged(e);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.popUpMenu != null) {
            this.popUpMenu.removeAll();
        }
        this.popUpMenu = null;
        if (this.actonList != null) {
            this.actonList.clear();
        }
        if (this.subMenuActionList != null) {
            this.subMenuActionList.clear();
        }
    }

    public void setEnableAction(boolean enable, String action) {
        AbstractAction aa;
        boolean found = false;
        for (Action a : this.actonList) {
            if (!(a instanceof AbstractAction) || !this.isMatchAction(aa = (AbstractAction)a, action)) continue;
            aa.setEnabled(enable);
            found = true;
            break;
        }
        if (!found) {
            for (Action a : this.subMenuActionList) {
                if (!(a instanceof AbstractAction) || !this.isMatchAction(aa = (AbstractAction)a, action)) continue;
                aa.setEnabled(enable);
                break;
            }
        }
    }

    private boolean isMatchAction(AbstractAction aa, String action) {
        return aa.getValue("Name").equals(action) || aa.getClass().getName().equals(action) || aa.getClass().getSimpleName().equals(action);
    }

    static {
        CvMouseControllerUtil.loadDefaultMouseModeProperty();
    }
}

