/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.base.CvResponseCurve;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpResponseCurve;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.j3d.WLMouseController;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class CVWindowController
extends WLMouseController {
    private WindowLevelCapable wlCapable = null;
    private double startWW = 0.0;
    private double startWL = 0.0;
    private double startMin = 0.0;
    private double startMax = 0.0;
    private static final double wlSensitivity = 0.7;
    private static final double wwSensitivity = 0.7;
    private static XpResponseCurve wlResponse = new CvResponseCurve();
    private double MAX_WW = 65535.0;
    private double MIN_WW = 0.0;
    private double MAX_WL = 32767.0;
    private double MIN_WL = -32767.0;
    private double rescaleSlope = 1.0;
    private String modality = "";
    private double windowWidth;
    private XpImage xiPrev = null;
    Point prev_pt = new Point();
    Point start_pt = new Point();

    @Override
    public void mousePressed(MouseEvent me) {
        Point p = me.getPoint();
        this.prev_pt.setLocation(p);
        this.start_pt = p;
        this.startMin = this.wlCapable.getWinMin();
        this.startMax = this.wlCapable.getWinMax();
        this.startWW = this.startMax - this.startMin;
        this.startWL = (this.startMax + this.startMin) / 2.0;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Point p = me.getPoint();
        double dx = p.x - this.start_pt.x;
        double dy = p.y - this.start_pt.y;
        this.wwwl(dx, dy);
        this.prev_pt.setLocation(p);
    }

    @Override
    public void setTarget(JComponent vc) {
        super.setTarget(vc);
        if (vc instanceof Capable) {
            XpImage xi;
            this.wlCapable = (WindowLevelCapable)((Capable)((Object)vc)).getCapable(WindowLevelCapable.class.getName());
            FrameOwner frameOwner = (FrameOwner)((Object)((Capable)((Object)vc)).getCapable(FrameOwner.class.getName()));
            if (frameOwner != null && (xi = frameOwner.getFrame()) != null && xi != this.xiPrev) {
                this.rescaleSlope = xi.getRescaleSlope();
                this.windowWidth = xi.getDefaultWindowWidth();
                this.modality = CvUtils.getCurrentModality(this.wlCapable) + "";
                double fraction = Double.parseDouble(CvPropertiesManager.getProperty("cvf.WWWLMouseIncrement.Percentage", "10"));
                double targetedIncrementNear = this.windowWidth * fraction / 100.0;
                wlResponse = new CvResponseCurve(100.0, 250.0, targetedIncrementNear / 100.0, 3.0);
                this.xiPrev = xi;
            }
        } else {
            this.wlCapable = null;
        }
    }

    @Override
    protected void wwwl(double dx, double dy) {
        String modality = "";
        modality = CvUtils.getCurrentModality(this.wlCapable) + "";
        this.MAX_WW = CvUtils.getMaxWW(modality);
        this.MIN_WW = CvUtils.getMinWW(modality);
        this.MAX_WL = CvUtils.getMaxWL(modality);
        this.MIN_WL = CvUtils.getMinWL(modality);
        if (modality.equals("PT")) {
            dx = -dx;
            dy = -dy;
        } else if (modality.equals("CT")) {
            dy = -dy;
        }
        double wwdelta = 0.7 * dx;
        double wldelta = 0.7 * dy;
        double ww = wlResponse.response(this.startWW, wwdelta);
        double wl = wlResponse.response(this.startWL, wldelta);
        if (ww > this.MAX_WW) {
            ww = this.MAX_WW;
        }
        if (wl > this.MAX_WL) {
            wl = this.MAX_WL;
        }
        if (wl < this.MIN_WL) {
            wl = this.MIN_WL;
        }
        if (ww < this.MIN_WW) {
            ww = this.MIN_WW;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        if (this.wlCapable != null) {
            this.wlCapable.setWinMinMax(min, max);
            this.wlCapable.repaint();
        }
    }
}

