/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.commands;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    private final Map cellSizes = new HashMap();

    public TextAreaRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        Color bgColor;
        String tableBorder = LookAndFeelFactory.getPropertyValue("CommandLine.TableBorder");
        if (null != tableBorder && tableBorder.equals("null")) {
            this.setBorder(table.getBorder());
        }
        this.setFont(table.getFont());
        this.setText((String)table.getValueAt(row, column));
        Object val = table.getModel().getValueAt(row, 3);
        if (isSelected) {
            if (val == null) {
                bgColor = LookAndFeelFactory.getColor(null, "P9");
                if (null != bgColor) {
                    this.setBackground(bgColor);
                }
            } else {
                bgColor = LookAndFeelFactory.getColor(null, "P12");
                if (null != bgColor) {
                    this.setBackground(bgColor);
                }
            }
        } else if (row % 2 == 0) {
            if (val == null) {
                bgColor = LookAndFeelFactory.getColor(null, "P9");
                if (null != bgColor) {
                    this.setBackground(bgColor);
                }
            } else {
                bgColor = LookAndFeelFactory.getColor(null, "P5");
                if (null != bgColor) {
                    this.setBackground(bgColor);
                }
            }
        } else if (val == null) {
            bgColor = LookAndFeelFactory.getColor(null, "P9");
            if (null != bgColor) {
                this.setBackground(bgColor);
            }
        } else {
            bgColor = LookAndFeelFactory.getColor(null, "P2");
            if (null != bgColor) {
                this.setBackground(bgColor);
            }
        }
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.setColumnMargin(4);
        this.setSize(columnModel.getColumn(column).getWidth(), 100);
        int height_wanted = (int)this.getPreferredSize().getHeight();
        this.addSize(table, row, column, height_wanted);
        height_wanted = this.findTotalMaximumRowSize(table, row);
        if (height_wanted != table.getRowHeight(row)) {
            table.setRowHeight(row, height_wanted);
        }
        return this;
    }

    private void addSize(JTable table, int row, int column, int height) {
        HashMap<Integer, Integer> rowheights;
        HashMap<Integer, HashMap<Integer, Integer>> rows = (HashMap<Integer, HashMap<Integer, Integer>>)this.cellSizes.get(table);
        if (rows == null) {
            rows = new HashMap<Integer, HashMap<Integer, Integer>>();
            this.cellSizes.put(table, rows);
        }
        if ((rowheights = (HashMap<Integer, Integer>)rows.get(new Integer(row))) == null) {
            rowheights = new HashMap<Integer, Integer>();
            rows.put(new Integer(row), rowheights);
        }
        rowheights.put(new Integer(column), new Integer(height));
    }

    private int findTotalMaximumRowSize(JTable table, int row) {
        int maximum_height = 0;
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            TableCellRenderer cellRenderer = tc.getCellRenderer();
            if (!(cellRenderer instanceof TextAreaRenderer)) continue;
            TextAreaRenderer tar = (TextAreaRenderer)cellRenderer;
            maximum_height = Math.max(maximum_height, tar.findMaximumRowSize(table, row));
        }
        return maximum_height;
    }

    private int findMaximumRowSize(JTable table, int row) {
        Map rows = (Map)this.cellSizes.get(table);
        if (rows == null) {
            return 0;
        }
        Map rowheights = (Map)rows.get(new Integer(row));
        if (rowheights == null) {
            return 0;
        }
        int maximum_height = 0;
        for (Map.Entry entry : rowheights.entrySet()) {
            int cellHeight = (Integer)entry.getValue();
            maximum_height = Math.max(maximum_height, cellHeight);
        }
        return maximum_height;
    }
}

