/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class XpZoomLinkDirector
implements XpViewportDirector {
    protected ArrayList<PanZoomCapable> portList = new ArrayList();
    private ZoomPropertyChangeListener listener = new ZoomPropertyChangeListener(this);
    protected boolean propOnSelectedPorts = false;

    public XpZoomLinkDirector() {
        String str = CvPropertiesManager.getProperty("cvf.zoomlinkdirector.onSelection", "false");
        this.propOnSelectedPorts = Boolean.valueOf(str);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof PanZoomCapable) {
            this.portList.add((PanZoomCapable)((Object)viewport));
            viewport.addPropertyChangeListener("zoom", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            PanZoomCapable port = this.portList.get(i);
            port.removePropertyChangeListener("zoom", this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener("zoom", this.listener);
        }
    }

    protected void notifyZoom(double zoom, Object src) {
        for (int i = 0; i < this.portList.size(); ++i) {
            PanZoomCapable port = this.portList.get(i);
            if (port.equals(src) || this.propOnSelectedPorts && !this.isSelectedPort(port) || port.getZoom() == zoom) continue;
            port.setZoom(zoom);
        }
    }

    protected boolean isSelectedPort(Capable cap) {
        if (cap == null) {
            return false;
        }
        if (cap instanceof SelectionCapable) {
            return ((SelectionCapable)cap).getComponentSelection() != -1;
        }
        if (cap instanceof Selectable) {
            return ((Selectable)((Object)cap)).isSelected();
        }
        return false;
    }

    private static class ZoomPropertyChangeListener
    implements PropertyChangeListener {
        XpZoomLinkDirector adaptee;

        public ZoomPropertyChangeListener(XpZoomLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            double zoom = (Double)evt.getNewValue();
            this.adaptee.notifyZoom(zoom, evt.getSource());
        }
    }
}

