/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class XpWindowingLinkDirector
implements XpViewportDirector {
    protected ArrayList<WindowLevelCapable> portList = new ArrayList();
    private WindowingPropertyChangeListener listener = new WindowingPropertyChangeListener(this);
    protected boolean propOnSelectedPorts = false;

    public XpWindowingLinkDirector() {
        String str = CvPropertiesManager.getProperty("cvf.windowinglinkdirector.onSelection", "false");
        this.propOnSelectedPorts = Boolean.valueOf(str);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof PanZoomCapable) {
            this.portList.add((WindowLevelCapable)((Object)viewport));
            viewport.addPropertyChangeListener("winMin", this.listener);
            viewport.addPropertyChangeListener("winMax", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            WindowLevelCapable port = this.portList.get(i);
            port.removePropertyChangeListener("winMin", this.listener);
            port.removePropertyChangeListener("winMax", this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener("winMin", this.listener);
            viewport.removePropertyChangeListener("winMax", this.listener);
        }
    }

    protected void notifyWindowing(Object src) {
        double refmin = ((WindowLevelCapable)src).getWinMin();
        double refmax = ((WindowLevelCapable)src).getWinMax();
        for (int i = 0; i < this.portList.size(); ++i) {
            WindowLevelCapable port = this.portList.get(i);
            if (port.equals(src) || this.propOnSelectedPorts && !this.isSelectedPort(port) || port.getWinMin() == refmin && port.getWinMax() == refmax) continue;
            port.setWinMinMax(refmin, refmax);
        }
    }

    protected boolean isSelectedPort(Capable cap) {
        if (cap == null) {
            return false;
        }
        if (cap instanceof SelectionCapable) {
            return ((SelectionCapable)cap).getComponentSelection() != -1;
        }
        if (cap instanceof Selectable) {
            return ((Selectable)((Object)cap)).isSelected();
        }
        return false;
    }

    private static class WindowingPropertyChangeListener
    implements PropertyChangeListener {
        XpWindowingLinkDirector adaptee;

        public WindowingPropertyChangeListener(XpWindowingLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.adaptee.notifyWindowing(evt.getSource());
        }
    }
}

