/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.idc.XpPanZoomCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class XpRotateLinkDirector
implements XpViewportDirector {
    protected ArrayList<XpPanZoomCapable> portList = new ArrayList();
    private RotatePropertyChangeListener listener = new RotatePropertyChangeListener(this);
    protected boolean propOnSelectedPorts = false;

    public XpRotateLinkDirector() {
        String str = CvPropertiesManager.getProperty("cvf.rotatelinkdirector.onSelection", "false");
        this.propOnSelectedPorts = Boolean.valueOf(str);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof XpPanZoomCapable) {
            this.portList.add((XpPanZoomCapable)((Object)viewport));
            viewport.addPropertyChangeListener("ROTATE", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpPanZoomCapable port = this.portList.get(i);
            port.removePropertyChangeListener("ROTATE", this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener("ROTATE", this.listener);
        }
    }

    protected void notifyRotate(Double rotate, Object src) {
        this.clearListeners();
        for (int i = 0; i < this.portList.size(); ++i) {
            XpPanZoomCapable port = this.portList.get(i);
            if (port.equals(src) || this.propOnSelectedPorts && !this.isSelectedPort(port) || port.getRotate() == rotate.doubleValue()) continue;
            port.setRotate(rotate);
        }
        this.addListeners();
    }

    private void clearListeners() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpViewport port = (XpViewport)((Object)this.portList.get(i));
            port.removePropertyChangeListener("ROTATE", this.listener);
        }
    }

    private void addListeners() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpViewport port = (XpViewport)((Object)this.portList.get(i));
            port.addPropertyChangeListener("ROTATE", this.listener);
        }
    }

    protected boolean isSelectedPort(Capable cap) {
        if (cap == null) {
            return false;
        }
        if (cap instanceof SelectionCapable) {
            return ((SelectionCapable)cap).getComponentSelection() != -1;
        }
        if (cap instanceof Selectable) {
            return ((Selectable)((Object)cap)).isSelected();
        }
        return false;
    }

    private static class RotatePropertyChangeListener
    implements PropertyChangeListener {
        XpRotateLinkDirector adaptee;

        public RotatePropertyChangeListener(XpRotateLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Double rotate = (Double)evt.getNewValue();
            this.adaptee.notifyRotate(rotate, evt.getSource());
        }
    }
}

