/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class XpPanLinkDirector
implements XpViewportDirector {
    protected ArrayList<PanZoomCapable> portList = new ArrayList();
    private PanPropertyChangeListener listener = new PanPropertyChangeListener(this);
    protected boolean propOnSelectedPorts = false;

    public XpPanLinkDirector() {
        String str = CvPropertiesManager.getProperty("cvf.panlinkdirector.onSelection", "false");
        this.propOnSelectedPorts = Boolean.valueOf(str);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof PanZoomCapable) {
            this.portList.add((PanZoomCapable)((Object)viewport));
            viewport.addPropertyChangeListener("pan", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            PanZoomCapable port = this.portList.get(i);
            port.removePropertyChangeListener("pan", this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener("pan", this.listener);
        }
    }

    protected void notifyPan(Point2D pan, Object src) {
        for (int i = 0; i < this.portList.size(); ++i) {
            PanZoomCapable port = this.portList.get(i);
            if (port.equals(src) || this.propOnSelectedPorts && !this.isSelectedPort(port) || port.getPanX() == pan.getX() && port.getPanY() == pan.getY()) continue;
            port.setPan(pan.getX(), pan.getY());
        }
    }

    protected boolean isSelectedPort(Capable cap) {
        if (cap == null) {
            return false;
        }
        if (cap instanceof SelectionCapable) {
            return ((SelectionCapable)cap).getComponentSelection() != -1;
        }
        if (cap instanceof Selectable) {
            return ((Selectable)((Object)cap)).isSelected();
        }
        return false;
    }

    private static class PanPropertyChangeListener
    implements PropertyChangeListener {
        XpPanLinkDirector adaptee;

        public PanPropertyChangeListener(XpPanLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Point2D pan = (Point2D)evt.getNewValue();
            this.adaptee.notifyPan(pan, evt.getSource());
        }
    }
}

