/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.idc.MultiSelectionCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class XpFrameLinkDirector
implements XpViewportDirector {
    protected ArrayList<XpViewport> portList = new ArrayList();
    public static final String FRAME_OFFSET_PROPERTY = "frame_offset";
    protected boolean propOnSelectedPorts = false;
    PropertyChangeListener frameIndexListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            XpFrameLinkDirector.this.notifyFrameChange(pce);
        }
    };

    public XpFrameLinkDirector() {
        String str = CvPropertiesManager.getProperty("cvf.framelinkdirector.onSelection", "false");
        this.propOnSelectedPorts = Boolean.valueOf(str);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport.getCapable(FramePositioningCapable.class.getName()) != null) {
            this.portList.add(viewport);
            FramePositioningCapable fpc = (FramePositioningCapable)viewport.getCapable(FramePositioningCapable.class.getName());
            if (fpc != null) {
                int offset = fpc.getFrameIndex();
                if (offset < 0) {
                    offset = 0;
                }
                viewport.putClientProperty(FRAME_OFFSET_PROPERTY, new Integer(offset));
                viewport.addPropertyChangeListener("FrameIndex", this.frameIndexListener);
            }
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpViewport port = this.portList.get(i);
            port.putClientProperty(FRAME_OFFSET_PROPERTY, new Integer(0));
            port.removePropertyChangeListener("FrameIndex", this.frameIndexListener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            viewport.removePropertyChangeListener("FrameIndex", this.frameIndexListener);
            viewport.putClientProperty(FRAME_OFFSET_PROPERTY, new Integer(0));
            this.portList.remove(viewport);
        }
    }

    protected void notifyFrameChange(PropertyChangeEvent pce) {
        XpViewport source = (XpViewport)pce.getSource();
        int frameIndex = (Integer)pce.getNewValue();
        int srcOffset = (Integer)source.getClientProperty(FRAME_OFFSET_PROPERTY);
        frameIndex -= srcOffset;
        boolean adjustSrcIndex = false;
        for (int i = 0; i < this.portList.size(); ++i) {
            FramePositioningCapable fpc;
            XpViewport port = this.portList.get(i);
            if (port == source || this.propOnSelectedPorts && !this.isSelectedPort(port, i) || (fpc = (FramePositioningCapable)port.getCapable(FramePositioningCapable.class.getName())) == null || fpc == source) continue;
            int offset = (Integer)port.getClientProperty(FRAME_OFFSET_PROPERTY);
            if (frameIndex + offset < 0 && fpc.getFrameIndex() != 0) {
                fpc.setFrameIndex(0);
                adjustSrcIndex = true;
            } else {
                int maxidx = fpc.getNumFrames();
                if (frameIndex + offset >= maxidx && fpc.getFrameIndex() != maxidx - 1) {
                    fpc.setFrameIndex(maxidx - 1);
                    adjustSrcIndex = true;
                } else {
                    fpc.setFrameIndex(frameIndex + offset);
                }
            }
            fpc.repaint();
        }
        if (adjustSrcIndex) {
            final XpViewport src = source;
            final int idx = frameIndex + srcOffset;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((FramePositioningCapable)src).setFrameIndex(idx);
                    src.repaint();
                }
            });
            adjustSrcIndex = false;
        }
    }

    protected boolean isSelectedPort(Capable cap, int portindex) {
        boolean selection = false;
        if (cap == null) {
            return selection;
        }
        if (cap instanceof SelectionCapable) {
            selection = ((SelectionCapable)cap).getComponentSelection() != -1;
        } else if (cap instanceof Selectable) {
            selection = ((Selectable)((Object)cap)).isSelected();
        }
        MultiSelectionCapable multiSelCap = (MultiSelectionCapable)((Object)SwingUtilities.getAncestorOfClass(MultiSelectionCapable.class, (Component)((Object)cap)));
        int portState = multiSelCap.getComponentSelectionState(portindex);
        if (portState == 0 || portState == 1) {
            selection = true;
        }
        return selection;
    }
}

