/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.idc.XpPanZoomCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class XpFlipHorizontalLinkDirector
implements XpViewportDirector {
    protected ArrayList<XpPanZoomCapable> portList = new ArrayList();
    private FlipPropertyChangeListener listener = new FlipPropertyChangeListener(this);
    protected boolean propOnSelectedPorts = false;

    public XpFlipHorizontalLinkDirector() {
        String str = CvPropertiesManager.getProperty("cvf.fliphorizontallinkdirector.onSelection", "false");
        this.propOnSelectedPorts = Boolean.valueOf(str);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof XpPanZoomCapable) {
            this.portList.add((XpPanZoomCapable)((Object)viewport));
            viewport.addPropertyChangeListener("FLIP_HORIZONTAL", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpPanZoomCapable port = this.portList.get(i);
            port.removePropertyChangeListener("FLIP_HORIZONTAL", this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener("FLIP_HORIZONTAL", this.listener);
        }
    }

    protected void notifyFlipHorizontal(Boolean fh, Object src) {
        this.clearListeners();
        for (int i = 0; i < this.portList.size(); ++i) {
            XpPanZoomCapable port = this.portList.get(i);
            if (port.equals(src) || this.propOnSelectedPorts && !this.isSelectedPort(port) || !fh.booleanValue()) continue;
            port.flipHorizontal();
        }
        this.addListeners();
    }

    private void clearListeners() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpViewport port = (XpViewport)((Object)this.portList.get(i));
            port.removePropertyChangeListener("FLIP_HORIZONTAL", this.listener);
        }
    }

    private void addListeners() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpViewport port = (XpViewport)((Object)this.portList.get(i));
            port.addPropertyChangeListener("FLIP_HORIZONTAL", this.listener);
        }
    }

    protected boolean isSelectedPort(Capable cap) {
        if (cap == null) {
            return false;
        }
        if (cap instanceof SelectionCapable) {
            return ((SelectionCapable)cap).getComponentSelection() != -1;
        }
        if (cap instanceof Selectable) {
            return ((Selectable)((Object)cap)).isSelected();
        }
        return false;
    }

    private static class FlipPropertyChangeListener
    implements PropertyChangeListener {
        XpFlipHorizontalLinkDirector adaptee;

        public FlipPropertyChangeListener(XpFlipHorizontalLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean fh = (Boolean)evt.getNewValue();
            this.adaptee.notifyFlipHorizontal(fh, evt.getSource());
        }
    }
}

