/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.base.BaseScreen;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.commands.TclShell;
import com.ge.med.cse.cvf.log.SimpleUsrMsgUI;
import com.ge.med.cse.cvf.log.UserMsgUI;
import com.ge.med.cse.cvf.plugins.CvPlugInManager;
import com.ge.med.cse.cvf.plugins.CvPlugin;
import com.ge.med.cse.cvf.textpage.TextPageManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ScreenLayoutHelper;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class XPVApp {
    private XPcontrolArea ctrl;
    private XPscreen screen;
    private TclShell commandLine;
    private UserMsgUI userMessage;
    public static final String KEYBOARDACTION = "KeyBoardAction";
    Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean initialized = false;

    public XPVApp() {
        this.screen = (XPscreen)CvUtils.createInstance(CvPropertiesManager.getProperty("XPScreen", BaseScreen.class.getName()));
        CvImageLoader.getInstance().setScreen(this.screen);
        this.ctrl = (XPcontrolArea)CvUtils.createInstance(CvPropertiesManager.getProperty("XPControlArea", XPcontrolArea.class.getName()));
        boolean loadPlugins = CvUtils.isPluginLoad();
        if (loadPlugins) {
            String[] allPlugin;
            CvPlugInManager.getInstace().getPlugins();
            boolean isOnDemanPluginLoad = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.plugin.OnDemandPluginLoad"));
            if (!isOnDemanPluginLoad && (allPlugin = CvPlugInManager.getInstace().getPluginNameForExtension("ControlArea")) != null && allPlugin.length > 0) {
                for (String plugin : allPlugin) {
                    String area = CvPropertiesManager.getProperty("ControlAreas");
                    CvPropertiesManager.setProperty("ControlAreas", area);
                    CvPlugin pluginInst = CvPlugInManager.getInstace().getPluginInstance(plugin);
                    if (pluginInst == null) continue;
                    pluginInst.setCapable(this.screen);
                    area = area + "," + pluginInst.getClass().getName();
                }
            }
        }
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        try {
            this.logger.log(Level.INFO, "TID=ScreenSetProperties begin, creating control panel");
            this.screen.setProperties(CvPropertiesManager.getProperties());
            if (Boolean.valueOf(CvPropertiesManager.getProperty("EnableScreenLayoutLogic", "false")).booleanValue()) {
                ScreenLayoutHelper.getInstance().setScreen(this.screen);
            }
            this.logger.log(Level.INFO, "TID=ScreenSetProperties end, creating control panel");
            this.logger.log(Level.INFO, "TID=CreateControlPanel begin, creating control panel");
            this.ctrl.setProperties(CvPropertiesManager.getProperties());
            this.logger.log(Level.INFO, "TID=CreateControlPanel end, creating control panel");
            this.logger.log(Level.INFO, "TID=CASetScreen begin, creating control panel");
            this.ctrl.setScreen(this.screen);
            this.logger.log(Level.INFO, "TID=CASetScreen end, creating control panel");
            String[] capanels = CvPropertiesManager.getProperty("ControlAreas", "").split(",");
            if (capanels.length > 1 && this.getControlArea().getSelector() != null) {
                this.getControlArea().getSelector().setSelectedApplication(CvPropertiesManager.getProperty("DefaultApp", "2DReview"));
            }
            this.logger.log(Level.INFO, "TID=KBConfig begin, creating control panel");
            this.configureKeyBoardAction();
            this.logger.log(Level.INFO, "TID=KBConfig end, creating control panel");
            this.initialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void configureKeyBoardAction() {
        int kbActionCount = Integer.parseInt(CvPropertiesManager.getProperty(KEYBOARDACTION, "0"));
        for (int i = 0; i < kbActionCount; ++i) {
            int inputPolicy;
            String[] keyBoardActions = CvPropertiesManager.getProperty("KeyBoardAction." + i).split(",");
            String strCompToAdd = keyBoardActions[0];
            Action action = (Action)CvUtils.createInstance(keyBoardActions[1]);
            String strActionName = action.getValue("Name") != null ? action.getValue("Name").toString() : action.getClass().getName();
            KeyStroke ks = KeyStroke.getKeyStroke(keyBoardActions[2]);
            int n = inputPolicy = strCompToAdd.length() > 4 ? Integer.parseInt(keyBoardActions[3]) : 2;
            if (strCompToAdd.equalsIgnoreCase("XPScreen")) {
                this.getScreen().getInputMap(inputPolicy).put(ks, strActionName);
                this.getScreen().getActionMap().put(strActionName, action);
            } else if (strCompToAdd.equalsIgnoreCase("XPControlArea")) {
                this.getControlArea().getInputMap(inputPolicy).put(ks, strActionName);
                this.getControlArea().getActionMap().put(strActionName, action);
            }
            if (action instanceof PlasmaControl) {
                ((PlasmaControl)((Object)action)).setCapable(this.getScreen());
            }
            if (!(action instanceof CapableListener)) continue;
            ((CapableListener)((Object)action)).setControlArea(this.ctrl);
        }
    }

    public XPcontrolArea getControlArea() {
        return this.ctrl;
    }

    public XPscreen getScreen() {
        return this.screen;
    }

    public UserMsgUI getUserMessageUI() {
        if (this.userMessage == null) {
            try {
                String name = CvPropertiesManager.getProperty("UserMsg", SimpleUsrMsgUI.class.getName());
                this.userMessage = (UserMsgUI)CvUtils.getClass(name).newInstance();
            }
            catch (Exception e) {
                this.userMessage = new SimpleUsrMsgUI();
                e.printStackTrace();
            }
        }
        return this.userMessage;
    }

    public TclShell getCommandLine() {
        if (this.commandLine == null) {
            this.logger.log(Level.INFO, "TID=CreateTCLShell begin, creating and showing tcl frame");
            this.commandLine = new TclShell();
            this.commandLine.setControlArea(this.getControlArea());
            this.commandLine.setScreen(this.getScreen());
            this.logger.log(Level.INFO, "TID=CreateTCLShell end, creating and showing tcl frame");
        }
        return this.commandLine;
    }

    public JFrame getControlFrame() {
        JFrame frm = (JFrame)SwingUtilities.getWindowAncestor(this.getControlArea());
        if (frm == null) {
            frm = new JFrame();
            frm.getContentPane().add(this.getControlArea());
        }
        return frm;
    }

    public JFrame getScreenFrame() {
        JFrame frm = (JFrame)SwingUtilities.getWindowAncestor(this.getScreen());
        if (frm == null) {
            frm = new JFrame();
            frm.getContentPane().add(this.getScreen());
        }
        return frm;
    }

    public void dispose() {
        this.getCommandLine().dispose();
        ScreenLayoutHelper.getInstance().removeAll();
        TextPageManager.getInstance().dispose();
        CvImageLoader.getInstance().dispose();
        if (this.getScreen() instanceof BaseScreen) {
            ((BaseScreen)this.getScreen()).dispose();
        } else {
            this.getScreen().clearScreen();
        }
        CvPlugInManager.getInstace().removeAllPlugins();
    }

    static {
        XpPropertiesManager.setProperty("jami.selectionmanager", CvPropertiesManager.getProperty("jami.selectionmanager", "com.ge.med.cse.cvf.base.CVSelectionManager"));
        XpPropertiesManager.setProperty("jami.annotation.swingtooltips", CvPropertiesManager.getProperty("jami.annotation.swingtooltips", "false"));
    }
}

