/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.base.CVViewPortManager;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.idc.DisplayModeCapable;
import com.ge.med.cse.cvf.idc.PagingCapable;
import com.ge.med.cse.cvf.idc.XpCPICapable;
import com.ge.med.cse.cvf.idc.XpCineCapable;
import com.ge.med.cse.cvf.idc.XpClipRoiActor;
import com.ge.med.cse.cvf.idc.XpPanZoomCapable;
import com.ge.med.cse.cvf.idc.XpPropagationCapable;
import com.ge.med.cse.cvf.idc.XpReportCursorCapable;
import com.ge.med.cse.cvf.idc.XpRowColCapable;
import com.ge.med.cse.cvf.idc.XpSelection;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.roi.CvContinuousReporter;
import com.ge.med.cse.cvf.roi.CvImageMatte;
import com.ge.med.cse.cvf.screenbuilder.helper.AnnotationHelper;
import com.ge.med.cse.cvf.util.CvCPI;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DSAImageOp;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.XpTickMarkRuler;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewportManager;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.platform.dm.XpDMgsps;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpFreeHandRoi;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class CvSeriesDisplayer
extends XpSeriesDisplayer
implements XpPropagationCapable,
XpReportCursorCapable,
XpTickMarkCapable,
XpCPICapable,
XpCineCapable,
XpRowColCapable,
DisplayModeCapable,
PropertyChangeListener,
XpSelection,
XpPanZoomCapable,
PagingCapable {
    private static final Logger logger = Logger.getLogger(CvSeriesDisplayer.class.getName());
    private boolean _cineOn = false;
    private int _cineRate = 10;
    private boolean _cinePaused = false;
    private Object prevInterpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private static String cineQuality = "normal";
    private ArrayList<CvContinuousReporter> _cReporters = new ArrayList();
    private ArrayList<XpTickMarkRuler> horTickMarkComps = new ArrayList();
    private ArrayList<XpTickMarkRuler> verTickMarkComps = new ArrayList();
    private transient XpImageRenderAttributes selectedSceneIRA = new XpImageRenderAttributes();
    public static final String CONTENT_CHANGED = "CONTENT_CHANGED";
    public static final String CONTENT_UPDATED = "CONTENT_UPDATED";
    private static int selPolicy = 2;
    private static int selMode = 1;
    private static String rendererType = null;
    private boolean mouseWheelPaging = false;
    private transient Field imgSceneInit = null;
    private static boolean RESTORE_SHUTTER_ON_ALL = false;
    private static boolean rcShowMarker = false;
    private boolean resetRCToCenter = true;
    private boolean retainIRA = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.retain.ira", "false"));
    private static final String GRAB_FOCUS_ON_IMAGE_LOAD = "cvf.grabfocus.onimageload";
    private AnnotationHelper annotHelper = new AnnotationHelper();
    private String appName = null;
    private boolean firstImage = false;
    private transient XpRoiEventListener roiListener = new XpRoiEventListener(){

        @Override
        public void roiReleased(XpRoiEvent re) {
            RoiActor roiactor = re.getRoi();
            int roiContainingPort = 0;
            for (int i = 0; i < CvSeriesDisplayer.this.getRows() * CvSeriesDisplayer.this.getCols(); ++i) {
                XpFrameVisualizer viz = CvSeriesDisplayer.this.getPort(i);
                if (!viz.getRois().contains(roiactor)) continue;
                roiContainingPort = i;
                break;
            }
            if (roiContainingPort >= 0) {
                CvSeriesDisplayer.this.setPortSelection(roiContainingPort, 1, false);
            }
        }

        @Override
        public void imageChanged(XpRoiEvent re) {
        }

        @Override
        public void roiDragged(XpRoiEvent re) {
        }

        @Override
        public void roiPressed(XpRoiEvent re) {
        }
    };
    private transient PropertyChangeListener graphicListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block12: {
                Object newVal;
                block13: {
                    XpImageScene scene2;
                    List rois;
                    block11: {
                        if (!"ROI_ADDED".equals(evt.getPropertyName())) break block11;
                        Object roiactor = evt.getNewValue();
                        if (roiactor instanceof RoiActor) {
                            ((RoiActor)roiactor).removeRoiEventListener(CvSeriesDisplayer.this.roiListener);
                            ((RoiActor)roiactor).addRoiEventListener(CvSeriesDisplayer.this.roiListener);
                            if (roiactor instanceof XpStatisticsRoi && evt.getPropagationId() instanceof XpImageScene) {
                                XpImageScene scene3 = (XpImageScene)evt.getPropagationId();
                                List rois2 = scene3.getRois();
                                int idx = 0;
                                if (rois2.contains(roiactor)) {
                                    for (int i = 0; i < rois2.size(); ++i) {
                                        Object roi = rois2.get(i);
                                        if (!(roi instanceof XpStatisticsRoi)) continue;
                                        ((XpStatisticsRoi)roiactor).setRoiLabel(Integer.toString(++idx));
                                    }
                                }
                            }
                            ((RoiActor)roiactor).setSelected(true);
                        }
                        CvSeriesDisplayer.this.showGraphics(true);
                        CvSeriesDisplayer.this.putClientProperty("showhide_property", new Boolean(true));
                        break block12;
                    }
                    if (!"ROI_REMOVED".equals(evt.getPropertyName())) break block13;
                    Object roiactor = evt.getNewValue();
                    if (!(roiactor instanceof RoiActor)) break block12;
                    ((RoiActor)roiactor).removeRoiEventListener(CvSeriesDisplayer.this.roiListener);
                    if (evt.getPropagationId() instanceof XpImageScene && (rois = (scene2 = (XpImageScene)evt.getPropagationId()).getRois()) != null && rois.size() > 0) {
                        int idx = 0;
                        for (int i = 0; i < rois.size(); ++i) {
                            Object roi = rois.get(i);
                            if (!(roi instanceof XpStatisticsRoi)) continue;
                            ((XpStatisticsRoi)roi).setRoiLabel(Integer.toString(++idx));
                        }
                    }
                    break block12;
                }
                if ("USERANNO_ADDED".equals(evt.getPropertyName())) {
                    Object newVal2 = evt.getNewValue();
                    if (newVal2 instanceof XpUserAnnotationModel) {
                        final XpUserAnnotationModel model = (XpUserAnnotationModel)newVal2;
                        model.addFocusListener(new FocusListener(){

                            @Override
                            public void focusGained(FocusEvent e) {
                                int userAnnotContainingPort = 0;
                                for (int i = 0; i < CvSeriesDisplayer.this.getRows() * CvSeriesDisplayer.this.getCols(); ++i) {
                                    XpFrameVisualizer viz = CvSeriesDisplayer.this.getPort(i);
                                    List ulist = null;
                                    if (viz != null) {
                                        ulist = viz.getUserAnnos();
                                    }
                                    if (ulist == null || !ulist.contains(model)) continue;
                                    userAnnotContainingPort = i;
                                    break;
                                }
                                if (userAnnotContainingPort >= 0) {
                                    CvSeriesDisplayer.this.setPortSelection(userAnnotContainingPort, 1, false);
                                }
                            }

                            @Override
                            public void focusLost(FocusEvent e) {
                            }
                        });
                    }
                    CvSeriesDisplayer.this.showGraphics(true);
                    CvSeriesDisplayer.this.putClientProperty("showhide_property", new Boolean(true));
                } else if ("USERANNO_REMOVED".equals(evt.getPropertyName()) && (newVal = evt.getNewValue()) instanceof XpUserAnnotationModel) {
                    XpUserAnnotationModel model = (XpUserAnnotationModel)newVal;
                    List l = model.getFocusListeners();
                    for (int i = 0; i < l.size(); ++i) {
                        model.removeFocusListener((FocusListener)l.get(i));
                    }
                }
            }
        }
    };
    ArrayList<PropertyChangeListener> pclsnrs = new ArrayList();
    private boolean maximized = false;
    private int prevRow = -1;
    private int prevCol = -1;
    private int prevSelPort = 0;
    private String oldPropMode = null;
    private boolean oldRCState = false;
    private boolean retainRCPosition = false;
    private int selIdx = -1;
    private Cursor prevCursor = null;
    private String propagationMode = "PROPAGATION_MODE_NONE";
    private boolean show_ = true;
    MouseListener selectionLsnr = null;
    boolean paging = true;

    public CvSeriesDisplayer() {
        super(rendererType, selPolicy, selMode);
        this.init();
    }

    public CvSeriesDisplayer(String renderType) {
        this(null, renderType, selPolicy, selMode);
    }

    public CvSeriesDisplayer(String applicaitonName, String renderType) {
        this(applicaitonName, renderType, selPolicy, selMode);
    }

    public CvSeriesDisplayer(int selectionPolicy, int selectionMode) {
        super(selectionPolicy, selectionMode);
        this.init();
    }

    public CvSeriesDisplayer(String applicaitonName, String renderType, int selectionPolicy, int selectionMode) {
        super(renderType, selectionPolicy, selectionMode);
        this.appName = applicaitonName;
        this.init();
    }

    private void init() {
        this.setSharedRenderAttributes(false);
        this.setAutoRepaint(true);
        this.setUI(null);
        this.mouseWheelPaging = CvPropertiesManager.getBoolean("cvf.mouseWheelPaging", false);
        this.setMouseWheelPaging(this.mouseWheelPaging);
        try {
            this.annotHelper.config(this, "configAnnotation", CvPropertiesManager.getProperties());
            this.setAnnotationGenerator(CvUtils.getClass(this.annotHelper.annotGenerator), this.annotHelper.annotprops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addPropertyChangeListener("ROI_ADDED", this.graphicListener);
        this.addPropertyChangeListener("ROI_REMOVED", this.graphicListener);
        this.addPropertyChangeListener("USERANNO_ADDED", this.graphicListener);
        this.addPropertyChangeListener("USERANNO_REMOVED", this.graphicListener);
        this.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XpViewportManager vpMgr = null;
                if (CvSeriesDisplayer.this.appName != null && CvSeriesDisplayer.this.appName.length() > 0) {
                    CvSeriesDisplayer.this.retainIRA = Boolean.parseBoolean(CvPropertiesManager.getProperty(CvSeriesDisplayer.this.appName + ".cvf.retain.ira", "false"));
                    try {
                        String vpmgr = CvPropertiesManager.getProperty("ViewPortManger", CVViewPortManager.class.getName());
                        Constructor c = CvUtils.getClass(vpmgr).getConstructor(String.class);
                        vpMgr = (XpViewportManager)c.newInstance(CvSeriesDisplayer.this.appName);
                        CvSeriesDisplayer.this.setViewportManager(vpMgr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CvSeriesDisplayer.this.setViewportManager((XpViewportManager)CvSeriesDisplayer.this.createInstance(CvPropertiesManager.getProperty("ViewPortManger", CVViewPortManager.class.getName())));
                    }
                } else {
                    CvSeriesDisplayer.this.setViewportManager((XpViewportManager)CvSeriesDisplayer.this.createInstance(CvPropertiesManager.getProperty("ViewPortManger", CVViewPortManager.class.getName())));
                }
            }
        });
        try {
            this.imgSceneInit = XpImageScene.class.getDeclaredField("initScene");
            this.imgSceneInit.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Object createInstance(String className) {
        try {
            return CvUtils.getClass(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void initListeners() {
        this.setKeyboardPaging(false);
        this.setMouseWheelPaging(this.mouseWheelPaging);
    }

    @Override
    public void refreshContents() {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            if (fv == null) continue;
            fv.refreshContents();
            fv.getMedicalImageVc().refreshImageRenderAttributes();
        }
        this.doLayoutPorts();
    }

    @Override
    public void dispose() {
        PropertyChangeListener[] pcls;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer vp = this.getPort(i);
            if (vp == null) continue;
            if (vp.getMouseController() != null) {
                vp.getMouseController().setTarget(null);
            }
            vp.setMouseController(null);
            vp.getAnnotationGenerator().reset();
            ttm.unregisterComponent(vp.getMedicalImageVc().getAnnotationVc());
        }
        this.removePropertyChangeListener("ROI_ADDED", this.graphicListener);
        this.removePropertyChangeListener("ROI_REMOVED", this.graphicListener);
        this.removePropertyChangeListener("USERANNO_ADDED", this.graphicListener);
        this.removePropertyChangeListener("USERANNO_REMOVED", this.graphicListener);
        this.removePropertyChangeListener(this);
        this.clearActiveAnnotationListeners();
        this.roiListener = null;
        if (this._cReporters != null) {
            this._cReporters.clear();
        }
        if (this.horTickMarkComps != null) {
            this.horTickMarkComps.clear();
        }
        if (this.verTickMarkComps != null) {
            this.verTickMarkComps.clear();
        }
        this.selectedSceneIRA = null;
        for (PropertyChangeListener p : pcls = this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(p);
        }
        super.dispose();
    }

    @Override
    public void setImages(XpMedicalImage[] images) {
        this.setImages(images, false);
    }

    @Override
    public void setImages(XpMedicalImage[] images, boolean skipComponentSelectionChangeFiring) {
        long fromTime = System.currentTimeMillis();
        TransactionLogName tln = new TransactionLogName("TID=CV_setImages");
        logger.log(Level.INFO, "{0} begin ", tln);
        if (this.getCine()) {
            return;
        }
        if (images == null || images.length == 0) {
            return;
        }
        this.firstImage = false;
        this.resetRCToCenter = true;
        XpImageRenderAttributes prevImgRendrAtts = null;
        if (this.retainIRA) {
            prevImgRendrAtts = this.getImageRenderAttributes();
        }
        int selPort = this.getComponentSelection();
        DisplayModeCapable.DisplayMode dispMode = this.getDisplayMode();
        super.setImages(images, skipComponentSelectionChangeFiring);
        if (selPort != -1) {
            this.setPortSelection(selPort, 1, false);
        }
        this.setEndOffset(this.getNumFrames() - 1);
        if (!this.firstImage && images[0] != null) {
            this.firstImage = true;
        }
        for (int i = 1; i < this.getNumScenes(); ++i) {
            this.getScene(i).setSelectedState(2);
            if (this.firstImage || images[i] == null) continue;
            this.firstImage = true;
        }
        if (this.firstImage) {
            this.clearActiveAnnotationListeners();
            XpDicomObject dicomObj = this.getDicomSource(0);
            this.annotHelper.configActiveAnnotations(this, dicomObj);
            if ("SSAVE".equals(DicomUtils.getImageType(images[0], false))) {
                this.setTickMarkVisible(1, false);
                this.setTickMarkVisible(0, false);
            } else {
                this.setReportCursorVisible(XPDisplayPrefsUtils.getReportCursorStatus());
                this.setTickMarkVisible(1, XPDisplayPrefsUtils.getHorizontalTicksStatus());
                this.setTickMarkVisible(0, XPDisplayPrefsUtils.getVerticalTicksStatus());
            }
            this.layoutImages();
            this.doPetStuff();
            int width = images[0].getSlice().width;
            int height = images[0].getSlice().height;
            int noImages = images.length;
            logger.log(Level.INFO, "{0} NUMIMAGES=" + noImages + " IMAGESIZE=" + width + " x " + height, tln);
        }
        if (prevImgRendrAtts != null && this.retainIRA) {
            this.setImageRenderAttributes(prevImgRendrAtts);
        }
        this.setDisplayMode(dispMode);
        logger.log(Level.INFO, "{0} end ", tln);
        logger.log(Level.INFO, "Time in seconds for set Images :" + CvUtils.getTimeInSeconds(System.currentTimeMillis() - fromTime));
        this.firePropertyChange(CONTENT_CHANGED, false, true);
        this.requestFocusInWindowOnImageLoad();
    }

    private void doPetStuff() {
        String modality;
        XpImage img = this.getFrame();
        if (img != null && img instanceof XpDicomObject && (modality = DicomUtils.getModality((XpDicomObject)((Object)img))) != null && modality.toUpperCase().equals("PT")) {
            this.setVideoInverted(true);
            this.repaint();
        }
    }

    @Override
    public int addImages(XpMedicalImage[] images) {
        XpImage img;
        long addImagesTime = System.currentTimeMillis();
        TransactionLogName tln = new TransactionLogName("TID=CV_addImages");
        logger.log(Level.INFO, "{0} begin", tln);
        if (images == null || images.length == 0) {
            return -1;
        }
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        XpImageRenderAttributes prevImgRendrAtts = null;
        if (this.retainIRA) {
            prevImgRendrAtts = this.getImageRenderAttributes();
        }
        DisplayModeCapable.DisplayMode dispMode = this.getDisplayMode();
        int selPort = this.getComponentSelection();
        int index = 0;
        int sn1 = 0;
        if (selPort != -1 && (img = this.getImageAt(index = this.getFrameIndex() + selPort)) instanceof XpMedicalImage) {
            sn1 = DicomUtils.getImageNumber((XpMedicalImage)img);
        }
        int result = super.addImages(images);
        if (selPort != -1) {
            for (int i = index; i < this.getNumFrames(); ++i) {
                XpMedicalImage curImg = (XpMedicalImage)this.getFrame(i);
                int sn2 = DicomUtils.getImageNumber(curImg);
                if (sn1 != sn2) continue;
                index = i;
                break;
            }
            this.setFrameIndex(index - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        if (prevImgRendrAtts != null && this.retainIRA) {
            this.setImageRenderAttributes(prevImgRendrAtts);
        }
        this.setDisplayMode(dispMode);
        this.setEndOffset(this.getNumFrames() - 1);
        this.syncCommonRenderAttributes(null);
        this.firePropertyChange(CONTENT_UPDATED, false, true);
        logger.log(Level.INFO, "{0} end", tln);
        logger.log(Level.INFO, "Time for add Images :" + CvUtils.getTimeInSeconds(System.currentTimeMillis() - addImagesTime));
        return result;
    }

    @Override
    public int addImage(XpMedicalImage image) {
        DisplayModeCapable.DisplayMode dispMode = this.getDisplayMode();
        int idx = super.addImage(image);
        this.setDisplayModeForScene(this.getScene(idx), dispMode);
        this.firePropertyChange(CONTENT_UPDATED, false, true);
        return idx;
    }

    @Override
    public int addImage(XpMedicalImage image, int index) {
        int selindex;
        long addImagesTime = System.currentTimeMillis();
        if (image == null) {
            return -1;
        }
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        XpImageRenderAttributes prevImgRendrAtts = null;
        if (this.retainIRA) {
            prevImgRendrAtts = this.getImageRenderAttributes();
        }
        DisplayModeCapable.DisplayMode dispMode = this.getDisplayMode();
        TransactionLogName tln = new TransactionLogName("TID=CV_addImageByIndex");
        logger.log(Level.INFO, "{0} begin", tln);
        int selPort = this.getComponentSelection();
        int n = selindex = selPort != -1 ? this.getFrameIndex() + selPort : -1;
        if (selindex != -1 && index <= selindex) {
            ++selindex;
        }
        int result = super.addImage(image, index);
        if (selindex != -1) {
            this.setFrameIndex(selindex - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        if (prevImgRendrAtts != null && this.retainIRA) {
            this.setImageRenderAttributes(prevImgRendrAtts);
        }
        this.setDisplayModeForScene(this.getScene(index), dispMode);
        this.setEndOffset(this.getNumFrames() - 1);
        this.syncCommonRenderAttributes(null);
        this.firePropertyChange(CONTENT_UPDATED, false, true);
        logger.log(Level.INFO, "{0} end", tln);
        logger.log(Level.INFO, "Time for add Images :" + CvUtils.getTimeInSeconds(System.currentTimeMillis() - addImagesTime));
        return result;
    }

    @Override
    public int addImages(XpMedicalImage[] images, int index) {
        int selindex;
        long addImagesTime = System.currentTimeMillis();
        if (images == null || images.length == 0) {
            return -1;
        }
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        XpImageRenderAttributes prevImgRendrAtts = null;
        if (this.retainIRA) {
            prevImgRendrAtts = this.getImageRenderAttributes();
        }
        DisplayModeCapable.DisplayMode dispMode = this.getDisplayMode();
        TransactionLogName tln = new TransactionLogName("TID=CV_addImagesByIndex");
        logger.log(Level.INFO, "{0} begin", tln);
        int selPort = this.getComponentSelection();
        int n = selindex = selPort != -1 ? this.getFrameIndex() + selPort : -1;
        if (selindex != -1 && index <= selindex) {
            selindex += images.length;
        }
        int result = super.addImages(images, index);
        if (selindex != -1) {
            this.setFrameIndex(selindex - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        if (prevImgRendrAtts != null && this.retainIRA) {
            this.setImageRenderAttributes(prevImgRendrAtts);
        }
        this.setDisplayMode(dispMode);
        this.setEndOffset(this.getNumFrames() - 1);
        this.syncCommonRenderAttributes(null);
        this.firePropertyChange(CONTENT_UPDATED, false, true);
        logger.log(Level.INFO, "{0} end", tln);
        logger.log(Level.INFO, "Time for add Images :" + CvUtils.getTimeInSeconds(System.currentTimeMillis() - addImagesTime));
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ComponentSelection".equals(evt.getPropertyName())) {
            XpImageScene scene2 = null;
            scene2 = this.getSelectionMode() == 1 ? this.getScene(this.getSelectedSceneIndex()) : this.getSelectedPort().getScene();
            if (scene2 != null) {
                this.selectedSceneIRA.set(scene2.getImageRenderAttributes());
            }
        } else if (("winMax".equals(evt.getPropertyName()) || "winMin".equals(evt.getPropertyName()) || "pan".equals(evt.getPropertyName()) || "zoom".equals(evt.getPropertyName())) && (this.getSelectionPolicy() == 2 || "PROPAGATION_MODE_ALL".equals(this.propagationMode) || "PROPAGATION_MODE_FORWARD".equals(this.propagationMode))) {
            this.updatePropRenderAttributes();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.pclsnrs != null) {
            this.pclsnrs.add(listener);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.pclsnrs != null) {
            this.pclsnrs.remove(listener);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, Object propagationId) {
        int i;
        PropertyChangeListener[] pcls = this.getPropertyChangeListeners(propertyName);
        PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        pce.setPropagationId(propagationId);
        if (pcls != null) {
            for (i = 0; i < pcls.length; ++i) {
                pcls[i].propertyChange(pce);
            }
        }
        if (this.pclsnrs != null && this.pclsnrs.size() > 0) {
            for (i = 0; i < this.pclsnrs.size(); ++i) {
                this.pclsnrs.get(i).propertyChange(pce);
            }
        }
    }

    @Override
    public void setZoom(double zoom) {
        if (this.getDisplayMode() != DisplayModeCapable.DisplayMode.FIT_TO_VIEWPORT) {
            zoom = 1.0;
        }
        super.setZoom(zoom);
    }

    @Override
    public void setFrameIndex(int index) {
        if (!this.isPagingOn()) {
            return;
        }
        int idx = this.getComponentSelection();
        super.setFrameIndex(index);
        if (this.getCine()) {
            return;
        }
        if (this.getSelectionMode() == 1 && idx != -1) {
            this.setPortSelection(0, 1, false);
        }
        this.requestFocusInWindowOnImageLoad();
    }

    @Override
    public void setRows(int rows) {
        this.setRowCol(rows, this.getCols());
    }

    @Override
    public void setCols(int columns) {
        this.setRowCol(this.getRows(), columns);
    }

    @Override
    public void setRowCol(int row, int col) {
        int selPort = this.getComponentSelection();
        int selIdx = this.getFrameIndex();
        super.setRowCol(row, col);
        if (selPort >= 0 && selPort >= this.getRows() * this.getCols()) {
            this.setComponentSelection(0);
            this.setFrameIndex(selIdx + selPort);
        }
        if (this.horTickMarkComps.size() > 0 && ((Component)this.horTickMarkComps.get(0)).isVisible()) {
            this.addHorTickMark();
        }
        if (this.verTickMarkComps.size() > 0 && ((Component)this.verTickMarkComps.get(0)).isVisible()) {
            this.addVerTickMark();
        }
        if (!this.getCine()) {
            this.setReportCursorVisible(this.isReportCursorVisible());
        }
        if ((selIdx = this.getComponentSelection()) >= 0) {
            int ports = this.getRows() * this.getCols();
            boolean all = true;
            for (int i = 0; i < ports; ++i) {
                if (this.getPort(i).getScene() == null || this.getPort(i).getScene().getSelectedState() > 0) continue;
                all = false;
                break;
            }
            if (all) {
                int size = this.getNumScenes();
                for (int i = 0; i < size; ++i) {
                    this.getScene(i).setSelectedState(2);
                }
            }
            this.setPortSelection(selIdx, 1, false);
        }
        this.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                    CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public boolean isMaximized() {
        return this.maximized;
    }

    @Override
    public void maximize() {
        if (!this.maximized) {
            this.prevRow = this.getRows();
            this.prevCol = this.getCols();
            this.prevSelPort = this.getComponentSelection();
            if (this.prevSelPort == -1) {
                this.prevSelPort = 0;
            }
            int selIdx = this.getFrameIndex();
            this.setRowCol(1, 1);
            this.setFrameIndex(selIdx + this.prevSelPort);
            this.maximized = true;
            this.firePropertyChange("minmax_property", false, true);
        }
    }

    @Override
    public void minimize() {
        if (this.maximized) {
            int selIdx = this.getFrameIndex();
            this.setRowCol(this.prevRow, this.prevCol);
            if (this.prevSelPort == -1) {
                this.prevSelPort = 0;
            }
            if (this.getComponentSelection() != -1) {
                this.setComponentSelection(this.prevSelPort);
                this.setFrameIndex(selIdx - this.prevSelPort);
            }
            this.maximized = false;
            this.prevSelPort = 0;
            this.prevCol = -1;
            this.prevRow = -1;
            this.firePropertyChange("minmax_property", true, false);
        }
    }

    @Override
    public void setCine(boolean cine) {
        if (!this.isPagingOn()) {
            return;
        }
        boolean prevCine = this.getCine();
        if (!prevCine && cine) {
            this.maximize();
            this._cineOn = cine;
            this.updateStateForCineOn();
            this.firePropertyChange("Cine", false, true);
        }
        if (!cine) {
            this._cineOn = cine;
            this.updateStateForCinePaused();
            this.minimize();
            this.firePropertyChange("Cine", true, false);
        }
    }

    @Override
    public boolean getCine() {
        return this._cineOn;
    }

    @Override
    public void setCineRate(int rate) {
        int oldRate = this.getCineRate();
        this._cineRate = rate;
        this.firePropertyChange("CineRate", oldRate, rate);
    }

    @Override
    public int getCineRate() {
        return this._cineRate;
    }

    @Override
    public void setStartOffset(int offset) {
        int oldVal = this.getStartOffset();
        super.setStartOffset(offset);
        this.firePropertyChange("CineStartOffset", oldVal, this.getStartOffset());
    }

    @Override
    public void setEndOffset(int offset) {
        int oldVal = this.getEndOffset();
        super.setEndOffset(offset);
        this.firePropertyChange("CineEndOffset", oldVal, this.getEndOffset());
    }

    @Override
    public void setCineSkip(int cineSkip) {
        int oldVal = this.getCineSkip();
        super.setCineSkip(cineSkip);
        this.firePropertyChange("CineSkip", oldVal, this.getCineSkip());
    }

    @Override
    public void setOffset(int offset) {
        if (this.getCine()) {
            super.setOffset(offset);
        } else {
            int idx = this.getComponentSelection();
            super.setOffset(offset);
            if (this.getSelectionMode() == 1 && idx != -1) {
                this.setPortSelection(0, 1, false);
            }
        }
    }

    private void enableDrawBorder(boolean drawBorder) {
        int n = this.getNumPorts();
        for (int i = 0; i < n; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setDrawBorder(drawBorder);
            fv.refreshSelection();
        }
    }

    @Override
    public void pauseCine() {
        if (this.getCine() && !this.isPaused()) {
            this._cinePaused = true;
            this.updateStateForCinePaused();
        }
    }

    @Override
    public void resumeCine() {
        if (this.getCine() && this.isPaused()) {
            this._cinePaused = false;
            this.updateStateForCineOn();
        }
    }

    @Override
    public boolean isPaused() {
        return this.getCine() && this._cinePaused;
    }

    private void updateStateForCineOn() {
        if (this.getCine() && !this.isPaused()) {
            this.selIdx = this.getComponentSelection();
            this.prevInterpolationHint = this.getInterpolationHint();
            if (cineQuality.equalsIgnoreCase("high")) {
                this.setInterpolationHint(this.getCineQuality());
            } else if (cineQuality.equalsIgnoreCase("normal")) {
                this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            this.setBorder(null);
            this.setAutoRepaint(false);
            this.enableDrawBorder(false);
            this.paintImmediately(this.getBounds());
            this.clearActiveAnnotationListeners();
            this.oldPropMode = this.getPropagationMode();
            this.setPropagationMode("PROPAGATION_MODE_ALL");
            this.oldRCState = this.isReportCursorVisible();
            if (this.oldRCState && this._cReporters.size() > 0) {
                for (int i = 0; i < this._cReporters.size(); ++i) {
                    this._cReporters.get(i).setVisible(false);
                }
                this.setAnnotationItems(new String[]{"Report_Cursor"}, false);
            }
        }
    }

    private void updateStateForCinePaused() {
        if (!this.getCine() || this.isPaused()) {
            this.setInterpolationHint(this.prevInterpolationHint);
            this.enableDrawBorder(true);
            this.paintImmediately(this.getBounds());
            this.setAutoRepaint(true);
            if (this.oldRCState && this._cReporters.size() > 0) {
                for (int i = 0; i < this._cReporters.size(); ++i) {
                    this._cReporters.get(i).setVisible(true);
                }
                this.setAnnotationItems(new String[]{"Report_Cursor"}, true);
            }
            this.clearActiveAnnotationListeners();
            XpDicomObject dicomObj = this.getDicomSource(0);
            this.annotHelper.configActiveAnnotations(this, dicomObj);
            this.setPropagationMode(this.oldPropMode);
            if (this.getSelectionMode() == 1 && this.selIdx != -1 && this.getComponentSelection() == -1) {
                this.setPortSelection(0, 1, false);
                this.firePropertyChange("ComponentSelection", -1, 0);
            }
            this.refreshContents();
            if (this.getSelectedPort() != null) {
                this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
            }
        }
    }

    @Override
    public boolean isReportCursorVisible() {
        if (this._cReporters != null && this._cReporters.size() > 0) {
            return this._cReporters.get(0).isVisible();
        }
        return false;
    }

    @Override
    public void setReportCursorVisible(boolean onOff) {
        XpImage img = this.getFrame();
        boolean isvalid = CvUtils.measurementsValid(img);
        if (onOff && isvalid) {
            this.addReportCursor();
            if (this.getNumPorts() > 0 && !this.isReportCursorVisible()) {
                this.prevCursor = this.getPort(0).getCursor();
            }
            for (int j = 0; j < this.getNumPorts(); ++j) {
                if (rcShowMarker) continue;
                this.getPort(j).setCursor(new Cursor(1));
            }
            if (this.getNumPorts() > 0 && img != null && img instanceof XpDicomObject) {
                String grresult = CvPropertiesManager.getProperty("cvf.annotation." + DicomUtils.getModality((XpDicomObject)((Object)img)).toLowerCase() + ".groupName.GraphicResult");
                String rcursor = CvPropertiesManager.getProperty("cvf.annotation." + DicomUtils.getModality((XpDicomObject)((Object)img)).toLowerCase() + ".groupName.ReportCursor");
                if (grresult == null) {
                    grresult = "Graphic_Results";
                }
                if (rcursor == null) {
                    rcursor = "Report_Cursor";
                }
                if (DicomUtils.getModality((XpDicomObject)((Object)img)).toLowerCase().equalsIgnoreCase("ct") || this.getPort(0).queryAnnotationItem(grresult)) {
                    this.setAnnotationItems(new String[]{rcursor}, true);
                }
            }
        } else {
            this.removeReportCursor();
            for (int j = 0; j < this.getNumPorts(); ++j) {
                this.getPort(j).setCursor(this.prevCursor);
            }
            if (img != null && img instanceof XpDicomObject) {
                String rcursor = CvPropertiesManager.getProperty("cvf.annotation." + DicomUtils.getModality((XpDicomObject)((Object)img)).toLowerCase() + ".groupName.ReportCursor");
                if (rcursor == null) {
                    rcursor = "Report_Cursor";
                }
                this.setAnnotationItems(new String[]{rcursor}, false);
            }
        }
        for (int i = 0; i < this._cReporters.size(); ++i) {
            this._cReporters.get(i).setVisible(onOff);
        }
        boolean visible = XPDisplayPrefsUtils.getReportCursorStatus();
        this.firePropertyChange("report_cursor_property", !visible, visible);
    }

    private void addReportCursor() {
        int numPorts = this.getNumPorts();
        if (this._cReporters.size() == 0) {
            for (int i = 0; i < numPorts; ++i) {
                CvContinuousReporter rc = null;
                if (rcShowMarker) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    if (pt == null) continue;
                    rc = new CvContinuousReporter(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    rc.showMarker(true);
                } else {
                    rc = new CvContinuousReporter(-1.0, -1.0);
                }
                this._cReporters.add(rc);
                this.getPort(i).getMedicalImageVc().getImageVc().add(this._cReporters.get(i));
                this._cReporters.get(i).setVisible(false);
            }
        } else if (this._cReporters.size() < numPorts) {
            int i;
            boolean visible = this._cReporters.get(0).isVisible();
            if (this.resetRCToCenter) {
                for (i = 0; i < this._cReporters.size(); ++i) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    CPoint cpt = null;
                    if (pt == null) continue;
                    cpt = rcShowMarker ? new CPoint(((Point2D)pt).getX(), ((Point2D)pt).getY(), 0.0, 0) : new CPoint(-1, -1, 0, 0);
                    this._cReporters.get(i).setPoint(cpt);
                }
            }
            for (i = this._cReporters.size(); i < numPorts; ++i) {
                CvContinuousReporter rc = null;
                if (rcShowMarker) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    if (pt == null) continue;
                    rc = new CvContinuousReporter(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    rc.showMarker(true);
                } else {
                    rc = new CvContinuousReporter(-1.0, -1.0);
                }
                this._cReporters.add(rc);
                this.getPort(i).getMedicalImageVc().getImageVc().add(this._cReporters.get(i));
                this._cReporters.get(i).setVisible(visible);
            }
        } else if (this._cReporters.size() > numPorts) {
            for (int i = this._cReporters.size() - 1; i >= numPorts; --i) {
                this._cReporters.get(i).setVisible(false);
                this.getPort(i).getMedicalImageVc().getImageVc().remove(this._cReporters.get(i));
                this._cReporters.remove(i);
            }
        } else {
            boolean visible = this._cReporters.get(0).isVisible();
            if (visible && this.resetRCToCenter) {
                for (int i = 0; i < numPorts; ++i) {
                    Point pt = this.getCenterOfVP(this.getPort(i));
                    CPoint cpt = null;
                    if (pt == null) continue;
                    cpt = rcShowMarker ? new CPoint(((Point2D)pt).getX(), ((Point2D)pt).getY(), 0.0, 0) : new CPoint(-1, -1, 0, 0);
                    this._cReporters.get(i).setPoint(cpt);
                }
            }
        }
        this.resetRCToCenter = false;
    }

    private void removeReportCursor() {
        if (this._cReporters.size() > 0) {
            for (int i = 0; i < this._cReporters.size(); ++i) {
                this._cReporters.get(i).setVisible(false);
                this.getPort(i).getMedicalImageVc().getImageVc().remove(this._cReporters.get(i));
            }
            this._cReporters.clear();
        }
    }

    @Override
    public void addTickMark(int orientation) {
        XpMedicalImage img = (XpMedicalImage)this.getFrame();
        if ("SSAVE".equals(DicomUtils.getImageType(img, false))) {
            return;
        }
        if (orientation == 1) {
            this.addHorTickMark();
        } else {
            this.addVerTickMark();
        }
        this.firePropertyChange("tick_mark_added_property", -1, orientation);
    }

    @Override
    public void removeTickMark(int orientation) {
        this.setTickMarkVisible(orientation, false);
        this.firePropertyChange("tick_mark_removed_property", -1, orientation);
    }

    private void addHorTickMark() {
        int np = this.getNumPorts();
        if (this.horTickMarkComps.size() < np) {
            for (int i = this.horTickMarkComps.size(); i < np; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                XpTickMarkRuler tickM = new XpTickMarkRuler(1);
                fv.getMedicalImageVc().getImageVc().add(tickM);
                fv.getMedicalImageVc().repaint();
                this.horTickMarkComps.add(tickM);
                this.updateUI();
            }
        }
        this.setTickMarkVisible(1, true);
    }

    private void addVerTickMark() {
        int np = this.getNumPorts();
        if (this.verTickMarkComps.size() < np) {
            for (int i = this.verTickMarkComps.size(); i < np; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                XpTickMarkRuler tickM = new XpTickMarkRuler(0);
                fv.getMedicalImageVc().getImageVc().add(tickM);
                fv.getMedicalImageVc().repaint();
                this.verTickMarkComps.add(tickM);
                this.updateUI();
            }
        }
        this.setTickMarkVisible(0, true);
    }

    private void setTickMarkVisible(int orientation, boolean visible) {
        ArrayList<XpTickMarkRuler> list = null;
        list = orientation == 1 ? this.horTickMarkComps : this.verTickMarkComps;
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ((Component)iter.next()).setVisible(visible);
            }
        }
    }

    @Override
    public void setPropagationMode(String mode) {
        String old = this.propagationMode;
        this.propagationMode = mode;
        this.firePropertyChange("ira_propagtion_mode", old, mode);
    }

    @Override
    public String getPropagationMode() {
        return this.propagationMode;
    }

    @Override
    public void propagateROI() {
        this.propagateROI(1, this.getNumFrames());
    }

    @Override
    public void propagateROI(int fromImgNum, int toImgNum) {
        Selectable selectable;
        int i;
        int totalframes = this.getNumFrames();
        if (fromImgNum > totalframes || fromImgNum < 1) {
            return;
        }
        if (toImgNum > totalframes || toImgNum < 1) {
            return;
        }
        if (fromImgNum > toImgNum) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null || fv.getScene() == null) {
            return;
        }
        List roiList = fv.getScene().getRois();
        List uaList = fv.getScene().getUserAnnos();
        ArrayList<RoiActor> selRois = new ArrayList<RoiActor>();
        ArrayList<XpUserAnnotationModel> selUAs = new ArrayList<XpUserAnnotationModel>();
        if (roiList != null) {
            for (i = 0; i < roiList.size(); ++i) {
                RoiActor roi = (RoiActor)roiList.get(i);
                if (!(roi instanceof Visible) || !((Visible)((Object)roi)).isVisible() || !roi.isSelected()) continue;
                selRois.add(roi);
            }
        }
        if (uaList != null) {
            for (i = 0; i < uaList.size(); ++i) {
                XpUserAnnotationModel usm = (XpUserAnnotationModel)uaList.get(i);
                if (!usm.isVisible() || !usm.isSelected()) continue;
                selUAs.add(usm);
            }
        }
        for (i = fromImgNum - 1; i < toImgNum; ++i) {
            Selectable clone;
            XpImageScene scene2 = this.getScene(i);
            if (scene2 == fv.getScene()) continue;
            for (int selRoi = 0; selRoi < selRois.size(); ++selRoi) {
                RoiActor ra = (RoiActor)selRois.get(selRoi);
                if (!(ra instanceof Replicable)) continue;
                clone = (RoiActor)((Replicable)((Object)ra)).clone();
                clone.setSelected(false);
                if (clone instanceof XpFreeHandRoi) {
                    ((XpFreeHandRoi)clone).setDragByRoiLabel(true);
                }
                if (clone instanceof CvImageMatte) {
                    List rl = scene2.getRois();
                    int size = rl.size();
                    for (int j = 0; j < size; ++j) {
                        RoiActor r = (RoiActor)rl.get(j);
                        if (!(r instanceof CvImageMatte)) continue;
                        scene2.remove(r);
                        break;
                    }
                }
                scene2.add((RoiActor)clone);
            }
            for (int selUa = 0; selUa < selUAs.size(); ++selUa) {
                XpUserAnnotationModel uam = (XpUserAnnotationModel)selUAs.get(selUa);
                clone = (XpUserAnnotationModel)uam.clone();
                ((XpUserAnnotationModel)clone).setSelected(false);
                scene2.add((XpUserAnnotationModel)clone);
            }
        }
        int numports = this.getNumPorts();
        int rcsize = this._cReporters.size();
        for (int i2 = 0; i2 < numports && i2 < rcsize; ++i2) {
            if (!this._cReporters.get(i2).isVisible()) continue;
            XpFrameVisualizer tfv = this.getPort(i2);
            tfv.syncScene();
            CvContinuousReporter cr = this._cReporters.get(i2);
            tfv.getMedicalImageVc().getImageVc().remove(cr);
            tfv.getMedicalImageVc().getImageVc().add(cr);
        }
        this.layoutImages();
        List selectedList = XpAppContext.instance().getSelectionManager().getSelected();
        XpAppContext.instance().getSelectionManager().clearSelection();
        for (int selUa = 0; selUa < selUAs.size(); ++selUa) {
            selectable = (Selectable)selUAs.get(selUa);
            selectable.setSelected(true);
            selectedList.remove(selectable);
            selectedList.add(selectable);
        }
        for (int selRoi = 0; selRoi < selRois.size(); ++selRoi) {
            selectable = (Selectable)selRois.get(selRoi);
            selectable.setSelected(true);
            selectedList.remove(selectable);
            selectedList.add(selectable);
        }
    }

    @Override
    public void updatePropRenderAttributes() {
        XpImageRenderAttributes ira = null;
        XpImageScene selScene = null;
        int selSceneIndex = -1;
        if (this.getSelectionMode() == 1) {
            selSceneIndex = this.getSelectedSceneIndex();
            selScene = this.getScene(selSceneIndex);
        } else {
            selScene = this.getSelectedPort().getScene();
            selSceneIndex = this.getSceneIndexAtPort(this.getComponentSelection());
        }
        if (selScene != null) {
            ira = selScene.getImageRenderAttributes();
        }
        if (ira != null) {
            boolean multiSelection;
            String mod = DicomUtils.getModality((XpMedicalImage)selScene.getFrame());
            if (ira.getWindowLevel() < CvUtils.getMinWL(mod)) {
                ira.setWindowLevel(CvUtils.getMinWL(mod));
                return;
            }
            if (ira.getWindowLevel() > CvUtils.getMaxWL(mod)) {
                ira.setWindowLevel(CvUtils.getMaxWL(mod));
                return;
            }
            if (ira.getWindowWidth() > CvUtils.getMaxWW(mod)) {
                ira.setWindowWidth(CvUtils.getMaxWW(mod));
                return;
            }
            if (ira.getWindowWidth() < CvUtils.getMinWW(mod)) {
                ira.setWindowWidth(CvUtils.getMinWW(mod));
                return;
            }
            double zoomFactor = ira.getZoom();
            if (this.getDisplayMode() != DisplayModeCapable.DisplayMode.FIT_TO_VIEWPORT && zoomFactor != 1.0) {
                this.setZoom(1.0);
                return;
            }
            if (zoomFactor < CvUtils.getMinZoom()) {
                this.setZoom(CvUtils.getMinZoom());
                return;
            }
            if (zoomFactor > CvUtils.getMaxZoom()) {
                this.setZoom(CvUtils.getMaxZoom());
                return;
            }
            this.syncCommonRenderAttributes(selScene);
            boolean propwwwl = false;
            boolean proppan = false;
            boolean propzoom = false;
            boolean propModeSet = "PROPAGATION_MODE_ALL".equals(this.propagationMode) || "PROPAGATION_MODE_FORWARD".equals(this.propagationMode);
            boolean bl = multiSelection = this.getSelectionPolicy() == 2;
            if (!(!multiSelection && !propModeSet || ira.equals(this.selectedSceneIRA) && ira.getImageOperations().equals(this.selectedSceneIRA.getImageOperations()))) {
                if (ira.getWindowMax() != this.selectedSceneIRA.getWindowMax() || ira.getWindowMin() != this.selectedSceneIRA.getWindowMin()) {
                    propwwwl = true;
                }
                if ((ira.getPanX() != this.selectedSceneIRA.getPanX() || ira.getPanY() != this.selectedSceneIRA.getPanY()) && ira.getImageOrientation().getFlip() == this.selectedSceneIRA.getImageOrientation().getFlip() && ira.getImageOrientation().getAngle() == this.selectedSceneIRA.getImageOrientation().getAngle()) {
                    proppan = true;
                }
                if (ira.getZoom() != this.selectedSceneIRA.getZoom()) {
                    propzoom = true;
                }
                if (propwwwl || proppan || propzoom) {
                    int start;
                    for (int i = start = !multiSelection && "PROPAGATION_MODE_FORWARD".equals(this.propagationMode) ? selSceneIndex : 0; i < this.getNumScenes(); ++i) {
                        XpImageRenderAttributes attr;
                        XpImageScene is = this.getScene(i);
                        if (is == selScene || !this.getCine() && (!multiSelection || is.getSelectedState() <= 0) && (multiSelection || !propModeSet) || !proppan && !propwwwl && !propzoom || (attr = this.getRenderingAttrFor(is, propwwwl)) == null) continue;
                        if (propwwwl) {
                            attr.setWindowMinMax(ira.getWindowMin(), ira.getWindowMax());
                        }
                        if (proppan) {
                            attr.setPan(ira.getPanX(), ira.getPanY());
                        }
                        if (propzoom) {
                            attr.setZoom(ira.getZoom());
                        }
                        is.setImageRenderAttributes(attr);
                    }
                }
            }
            double oldWMAX = this.selectedSceneIRA.getWindowMax();
            double oldWMIN = this.selectedSceneIRA.getWindowMin();
            boolean oldInv = this.selectedSceneIRA.isVideoInverted();
            Point2D oldPan = this.selectedSceneIRA.getPan();
            double oldZoom = this.selectedSceneIRA.getZoom();
            ira = selScene.getImageRenderAttributes();
            this.selectedSceneIRA.set(ira);
            double newWMAX = ira.getWindowMax();
            double newWMIN = ira.getWindowMin();
            boolean newInv = ira.isVideoInverted();
            Point2D newPan = ira.getPan();
            double newZoom = ira.getZoom();
            if (oldPan.getX() != newPan.getX() || oldPan.getY() != newPan.getY()) {
                this.firePropertyChange("pan", oldPan, newPan);
            }
            if (oldZoom != newZoom) {
                this.firePropertyChange("zoom", oldZoom, newZoom);
            }
            if (oldWMAX != newWMAX) {
                this.firePropertyChange("winMax", oldWMAX, newWMAX);
            }
            if (oldWMIN != newWMIN) {
                this.firePropertyChange("winMin", oldWMIN, newWMIN);
            }
            if (oldInv != newInv) {
                this.firePropertyChange("videoInverted", oldInv, newInv);
            }
        }
        this.refreshImageRenderAttributes();
        if (this.isAutoRepaint()) {
            this.callRepaint();
        }
    }

    protected XpImageRenderAttributes getRenderingAttrFor(XpImageScene is, boolean isWWWL) {
        XpImageRenderAttributes attr = null;
        try {
            boolean isAlreadyNotInited = (Boolean)this.imgSceneInit.get(is);
            if (isAlreadyNotInited) {
                this.imgSceneInit.set(is, Boolean.FALSE);
                attr = is.getImageRenderAttributes();
                if (!isWWWL) {
                    this.imgSceneInit.set(is, Boolean.TRUE);
                }
                return attr;
            }
            return is.getImageRenderAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Exception during get attr , {0}", new Object[]{e});
            return attr;
        }
    }

    private void syncCommonRenderAttributes(XpImageScene selectedScene) {
        XpImageRenderAttributes ira = null;
        XpImageScene selScene = selectedScene;
        if (selScene == null) {
            if (this.getSelectionMode() == 1) {
                int idx = this.getSelectedSceneIndex();
                selScene = this.getScene(idx);
            } else {
                selScene = this.getSelectedPort().getScene();
            }
        }
        if (selScene != null) {
            ira = selScene.getImageRenderAttributes();
        }
        if (ira != null) {
            int slen = this.getNumScenes();
            for (int i = 0; i < slen; ++i) {
                XpImageRenderAttributes attr;
                XpImageScene is = this.getScene(i);
                if (is == selScene || (attr = this.getRenderingAttrFor(is, false)) == null) continue;
                attr.setVideoInverted(ira.isVideoInverted());
                XpImageOrientation ior = attr.getImageOrientation();
                if (ior.getFlip() != ira.getImageOrientation().getFlip()) {
                    ior.flipHorizontal();
                }
                ior.setAngle(ira.getAngle());
                attr.setImageOrientation(ior);
                attr.setColormap(ira.getColormap());
                ArrayList imgops = new ArrayList();
                ListIterator listIterator = attr.getImageOperations().listIterator();
                while (listIterator.hasNext()) {
                    Object obj = listIterator.next();
                    if (!(obj instanceof DSAImageOp)) continue;
                    imgops.add(obj);
                }
                int len = ira.getImageOperations().size();
                for (int o = 0; o < len; ++o) {
                    Object obj = ira.getImageOperations().get(o);
                    if (obj instanceof DSAImageOp) continue;
                    imgops.add(obj);
                }
                attr.setImageOperationList(imgops);
                is.setImageRenderAttributes(attr);
            }
            this.refreshImageRenderAttributes();
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public void resetIRA() {
        super.resetIRA();
        if (this.getSelectedPort() != null) {
            this.selectedSceneIRA.set(this.getSelectedPort().getImageRenderAttributes());
        }
    }

    public XpFrameVisualizer getSelectedPortWithReference() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null && XpReferenceImageApp.isRefPortOn(this)) {
            int portIdx = XpReferenceImageApp.getSelectedRefPortIndex(this);
            fv = this.getPort(portIdx);
        }
        return fv;
    }

    @Override
    public boolean isGraphicsShowing() {
        return this.show_;
    }

    @Override
    public void showGraphics(boolean show) {
        if (this.show_ == show) {
            return;
        }
        for (int i = 0; i < this.getNumScenes(); ++i) {
            List rois = this.getScene(i).getRois();
            for (int j = 0; j < rois.size(); ++j) {
                RoiActor ra = (RoiActor)rois.get(j);
                if (!(ra instanceof Visible)) continue;
                ((Visible)((Object)ra)).setVisible(show);
            }
            List annoList = this.getScene(i).getUserAnnos();
            if (annoList == null) continue;
            int size = annoList.size();
            for (int j = 0; j < size; ++j) {
                XpUserAnnotationModel am = (XpUserAnnotationModel)annoList.get(j);
                am.setVisible(show);
            }
        }
        boolean old = this.show_;
        this.show_ = show;
        this.firePropertyChange("showhide_property", old, show);
    }

    @Override
    public void setCvCPI(XpCPI cpi) {
        this.clearGraphics();
        this.resetIRA();
        CvCPI.applyCPI(cpi, this.getSceneList());
        XpCPI.BitmapDisplayShutter bds = cpi.getBitmapDisplayShutter();
        if (bds != null) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            CvCPI.applyBitmapDisplayShutter(bds, ira);
        }
        if (RESTORE_SHUTTER_ON_ALL) {
            CvCPI.applyDisplayShutter(cpi, this.getSceneList());
        } else {
            CvCPI.applyDisplayShutter(cpi, this);
        }
        this.layoutImages();
        XpAppContext.instance().getSelectionManager().clearSelection();
        this.repaint();
    }

    private List getSceneList() {
        ArrayList<XpImageScene> sceneList = new ArrayList<XpImageScene>();
        for (int iCount = 0; iCount < this.getNumFrames(); ++iCount) {
            sceneList.add(this.getScene(iCount));
        }
        return sceneList;
    }

    @Override
    public XpCPI getCPI() {
        XpFrameVisualizer fv = this.getPort(0);
        Dimension d = fv.getMedicalImageVc().getImageVc().getSize();
        XpCPI cpi = XpCPI.createCPI(this.getSceneList(), d, false);
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        XpColorOverlay co = ira.getColorOverlay();
        if (co != null) {
            XpCPI.setBitmapDisplayShutter(co, 0, cpi);
        }
        List[] rois = new List[1];
        fv = this.getSelectedPortWithReference();
        if (fv != null) {
            rois[0] = fv.getRois();
            Shape ics = null;
            for (RoiActor ra : rois[0]) {
                if (!(ra instanceof XpClipRoiActor)) continue;
                ics = ((XpClipRoiActor)ra).getImageClip();
                break;
            }
            if (ics != null) {
                XpCPI.addDisplayShutter(ics, 0, 0, cpi);
            }
        }
        return cpi;
    }

    @Override
    public void add(RoiActor ra) {
        if (this.getCine() && !this.isPaused()) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        boolean onSelection = CvPropertiesManager.getBoolean("cvf.roi.dropOnSelection", true);
        if (fv == null && !onSelection) {
            fv = this.getPort(0);
        }
        if (fv != null) {
            if (ra instanceof Visible && this.isGraphicsShowing()) {
                ((Visible)((Object)ra)).setVisible(true);
            }
            fv.add(ra);
            int index = this.getPrimarySelectedIndex();
            int crsize = this._cReporters.size();
            if (crsize > 0 && index < crsize && this._cReporters.get(index).isVisible()) {
                CvContinuousReporter cr = this._cReporters.get(index);
                fv.getMedicalImageVc().getImageVc().remove(cr);
                fv.getMedicalImageVc().getImageVc().add(cr);
            }
            fv.repaint();
            fv.requestFocus();
        }
    }

    @Override
    public void add(XpUserAnnotationModel m) {
        if (this.getCine() && !this.isPaused()) {
            return;
        }
        if (m == null) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        boolean onSelection = CvPropertiesManager.getBoolean("cvf.roi.dropOnSelection", true);
        if (fv == null && !onSelection) {
            fv = this.getPort(0);
        }
        if (fv != null) {
            if (this.isGraphicsShowing()) {
                m.setVisible(true);
            }
            fv.add(m);
            m.setSelected(true);
            fv.repaint();
            final XpUserAnnotationModel finalVar = m;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (finalVar.getUserAnnotationVc() != null) {
                        finalVar.getUserAnnotationVc().getTextArea().requestFocusInWindow();
                    }
                }
            });
        }
    }

    @Override
    public boolean remove(XpUserAnnotationModel m) {
        if (super.remove(m)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                        CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void resetWindowing() {
        IndexColorModel colormap = null;
        XpImageRenderAttributes attr = this.getImageRenderAttributes();
        if (attr != null) {
            colormap = attr.getColormap();
        }
        super.resetWindowing();
        if (colormap != null) {
            attr.setColormap(colormap);
            this.setImageRenderAttributes(attr);
        }
        this.doPetStuff();
    }

    @Override
    public Color getAnnotationColor() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationColor();
        }
        return this.getPort(0).getAnnotationColor();
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationGenerator();
        }
        return this.getPort(0).getAnnotationGenerator();
    }

    @Override
    public String[] getAnnotationGroups() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationGroups();
        }
        return this.getPort(0).getAnnotationGroups();
    }

    @Override
    public String[] getAnnotationItems() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationItems();
        }
        return this.getPort(0).getAnnotationItems();
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationItems(agName);
        }
        return this.getPort(0).getAnnotationItems(agName);
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.queryAnnotationItem(aiName);
        }
        return this.getPort(0).queryAnnotationItem(aiName);
    }

    @Override
    public String getAnnotationGroup() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationGroup();
        }
        return this.getPort(0).getAnnotationGroup();
    }

    @Override
    public Map<String, Boolean> getAnnotationItemStates() {
        XpFrameVisualizer fv = this.getSelectedPortWithReference();
        if (fv != null) {
            return fv.getAnnotationItemStates();
        }
        return this.getPort(0).getAnnotationItemStates();
    }

    public final InputStream getGSPS(XpDicomElement[] overrides) {
        XpDMgsps gspsFactory = new XpDMgsps(this);
        return gspsFactory.getGSPS(overrides);
    }

    private XpCPI getCPI(List scenes) {
        XpFrameVisualizer fv = this.getPort(0);
        Dimension d = fv.getMedicalImageVc().getImageVc().getSize();
        XpCPI cpi = XpCPI.createCPI(scenes, d, false);
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        XpColorOverlay co = ira.getColorOverlay();
        if (co != null) {
            XpCPI.setBitmapDisplayShutter(co, 0, cpi);
        }
        fv = this.getSelectedPort();
        List[] rois = new List[]{fv.getRois()};
        Shape ics = null;
        for (RoiActor ra : rois[0]) {
            if (!(ra instanceof XpClipRoiActor)) continue;
            ics = ((XpClipRoiActor)ra).getImageClip();
            break;
        }
        for (RoiActor ra : rois[0]) {
            if (!(ra instanceof XpClipRoiActor)) continue;
            ics = ((XpClipRoiActor)ra).getImageClip();
            break;
        }
        if (ics != null) {
            XpCPI.addDisplayShutter(ics, 0, 0, cpi);
        }
        return cpi;
    }

    public final InputStream getGSPS(int startImg, int endImg, XpDicomElement[] overrides) {
        int num = this.getMaxFrame();
        if (startImg < 1 || startImg > num) {
            startImg = 1;
        }
        if (endImg > num || endImg < 1) {
            endImg = num;
        }
        int ni = endImg - startImg + 1;
        ArrayList<XpImageScene> scenes = new ArrayList<XpImageScene>();
        XpMedicalImage[] imgs = new XpMedicalImage[ni];
        int index = -1;
        for (int i = startImg; i <= endImg; ++i) {
            XpImageScene sc = this.getScene(i - 1);
            scenes.add(sc);
            imgs[++index] = (XpMedicalImage)sc.getFrame();
        }
        XpCPI cpi = this.getCPI(scenes);
        XpDMgsps gspsFactory = new XpDMgsps(imgs, cpi, null);
        return gspsFactory.getGSPS(overrides);
    }

    private Point getCenterOfVP(XpFrameVisualizer port) {
        if (port != null && port.getFrame() != null) {
            int y = 0;
            int width = port.getFrame().getSlice().getSliceColumns();
            int height = port.getFrame().getSlice().getSliceRows();
            int x = width / 2;
            y = height / 2;
            return new Point(x, y);
        }
        return null;
    }

    @Override
    protected MouseListener getSelectionHandler(int portIdx) {
        return new XpFrameVizSelector(this, portIdx);
    }

    public int getRequestedFrameIndex() {
        return this.getFrameIndex();
    }

    @Override
    public int removeImage(int index) {
        if (index < 0 || index >= this.getNumFrames()) {
            return -1;
        }
        int idx = super.removeImage(index);
        this.firePropertyChange(CONTENT_UPDATED, false, true);
        return idx;
    }

    @Override
    public void replaceImage(XpMedicalImage image, int index) {
        if (this.getScene(index) == null) {
            return;
        }
        int selection = this.getScene(index).getSelectedState();
        int selPort = this.getComponentSelection();
        int selindex = selPort != -1 ? this.getFrameIndex() + selPort : -1;
        DisplayModeCapable.DisplayMode dispMode = this.getDisplayMode();
        super.replaceImage(image, index);
        this.getScene(index).setSelectedState(selection);
        if (this.firstImage) {
            this.resetWindowing();
        } else if (this.getSelectedPort() != null) {
            this.syncCommonRenderAttributes(this.getSelectedPort().getScene());
        } else {
            this.syncCommonRenderAttributes(this.getPort(0).getScene());
        }
        this.setDisplayModeForScene(this.getScene(index), dispMode);
        if (index <= this.getRows() * this.getCols()) {
            this.sync();
        }
        if (selindex != -1) {
            this.setFrameIndex(selindex - selPort);
            this.setPortSelection(selPort, 1, false);
        }
        this.doPetStuff();
        this.firePropertyChange(CONTENT_UPDATED, false, true);
    }

    @Override
    public void setSelectionListener(XpSelection.SelectionListener selectionListener) {
        MouseListener selLsnr = this.getSelectionListener();
        if (selLsnr != null) {
            this.detachSelectionListener(selLsnr);
            if (selectionListener instanceof XpSelection.SelectionListener) {
                selectionListener.setTarget(null);
            }
        }
        this.selectionLsnr = selectionListener;
        if (selectionListener != null) {
            selectionListener.setTarget(this);
            this.attachSelectionListener(this.selectionLsnr);
        }
    }

    @Override
    public MouseListener getSelectionListener() {
        return this.selectionLsnr;
    }

    private void attachSelectionListener(MouseListener lsnr) {
        for (int i = 0; i < this.getNumPorts(); ++i) {
            XpFrameVisualizer vp = this.getPort(i);
            vp.getMedicalImageVc().getImageVc().addMouseListener(lsnr);
            vp.getMedicalImageVc().getAnnotationVc().addMouseListener(lsnr);
        }
    }

    private void detachSelectionListener(MouseListener lsnr) {
        for (int i = 0; i < this.getNumPorts(); ++i) {
            XpFrameVisualizer vp = this.getPort(i);
            vp.getMedicalImageVc().getImageVc().removeMouseListener(lsnr);
            vp.getMedicalImageVc().getAnnotationVc().removeMouseListener(lsnr);
        }
    }

    @Override
    public void flipHorizontal() {
        super.flipHorizontal();
        this.firePropertyChange("FLIP_HORIZONTAL", false, true);
    }

    @Override
    public void flipVertical() {
        super.flipVertical();
        this.firePropertyChange("FLIP_VERTICAL", false, true);
    }

    @Override
    public void setRotate(double rotate) {
        double oldRotate = this.getRotate();
        super.setRotate(rotate);
        this.firePropertyChange("ROTATE", oldRotate, rotate);
    }

    private static int getMode(DisplayModeCapable.DisplayMode mode) {
        int psmode = 100;
        if (mode.equals((Object)DisplayModeCapable.DisplayMode.TRUE_SIZE_DISPLAY)) {
            psmode = 101;
        }
        return psmode;
    }

    private void setDisplayModeForScene(XpImageScene scene2, DisplayModeCapable.DisplayMode mode) {
        int psmode = CvSeriesDisplayer.getMode(mode);
        this.setDisplayModeForScene(scene2, mode, psmode);
    }

    private void setDisplayModeForScene(XpImageScene scene2, DisplayModeCapable.DisplayMode dmode, int psmode) {
        if (scene2 != null) {
            XpImageRenderAttributes ira = scene2.getImageRenderAttributes();
            ira.setPresentationSizeMode(psmode);
            if (dmode != DisplayModeCapable.DisplayMode.FIT_TO_VIEWPORT) {
                ira.setZoom(1.0);
            }
            scene2.setImageRenderAttributes(ira);
        }
    }

    @Override
    public void setDisplayMode(DisplayModeCapable.DisplayMode mode) {
        int psmode = CvSeriesDisplayer.getMode(mode);
        List sceneList = this.getSceneList();
        for (int iCount = 0; iCount < sceneList.size(); ++iCount) {
            XpImageScene scene2 = (XpImageScene)sceneList.get(iCount);
            this.setDisplayModeForScene(scene2, mode, psmode);
        }
        this.setFitToViewport(true);
        if (mode.equals((Object)DisplayModeCapable.DisplayMode.TRUE_PIXEL_DISPLAY)) {
            this.setFitToViewport(false);
        }
        this.refreshImageRenderAttributes();
    }

    @Override
    public DisplayModeCapable.DisplayMode getDisplayMode() {
        List sceneList = this.getSceneList();
        DisplayModeCapable.DisplayMode dispMode = DisplayModeCapable.DisplayMode.FIT_TO_VIEWPORT;
        XpImageScene scene2 = null;
        if (sceneList != null && sceneList.size() > 0) {
            scene2 = (XpImageScene)sceneList.get(0);
        }
        if (scene2 != null && scene2.getImageRenderAttributes().getPresentationSizeMode() == 101) {
            dispMode = DisplayModeCapable.DisplayMode.TRUE_SIZE_DISPLAY;
        }
        if (scene2 != null && scene2.getImageRenderAttributes().getPresentationSizeMode() == 100) {
            dispMode = this.getFitToViewport() ? DisplayModeCapable.DisplayMode.FIT_TO_VIEWPORT : DisplayModeCapable.DisplayMode.TRUE_PIXEL_DISPLAY;
        }
        return dispMode;
    }

    @Override
    public void setPaging(boolean paging) {
        this.paging = paging;
        this.setMouseWheelPaging(this.paging);
        this.firePropertyChange("paging_property", !paging, paging);
    }

    @Override
    public boolean isPagingOn() {
        return this.paging;
    }

    public void requestFocusInWindowOnImageLoad() {
        if (CvPropertiesManager.getBoolean(GRAB_FOCUS_ON_IMAGE_LOAD, true)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CvSeriesDisplayer.this.getSelectedPort() != null) {
                        logger.log(Level.INFO, "Selected port not null for grabing focus");
                        CvSeriesDisplayer.this.getSelectedPort().getMedicalImageVc().getImageVc().requestFocusInWindow();
                    }
                }
            });
        }
    }

    static {
        selPolicy = CvPropertiesManager.getBoolean("cvf.multiselection", true) ? 2 : 1;
        selMode = CvPropertiesManager.getBoolean("cvf.portselection", false) ? 2 : 1;
        cineQuality = CvPropertiesManager.getProperty("cvf.cine.quality", "normal");
        RESTORE_SHUTTER_ON_ALL = CvPropertiesManager.getBoolean("cvf.shutter.mode.all", true);
        rcShowMarker = CvPropertiesManager.getBoolean("cvf.reportcursor.showMarker", true);
        rendererType = CvPropertiesManager.getProperty("jami.render", "com.ge.med.terra.jami.render.XpPZWRenderer");
        XpPropertiesManager.setProperty("jami.render", "com.ge.med.terra.jami.render.XpPZWRenderer");
    }

    protected static class XpFrameVizSelector
    implements MouseListener {
        private XpSeriesDisplayer sd_ = null;
        private int portIdx_ = 0;
        private Point mousePoint = new Point();
        boolean pressed = false;
        boolean toResume = false;

        public XpFrameVizSelector(XpSeriesDisplayer sd, int portIdx) {
            this.sd_ = sd;
            this.portIdx_ = portIdx;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            int clickCount = me.getClickCount();
            if (clickCount == 3) {
                int size = this.sd_.getNumScenes();
                for (int i = 0; i < size; ++i) {
                    XpImageScene fs = this.sd_.getScene(i);
                    fs.setSelectedState(2);
                }
                this.sd_.setPortSelection(this.portIdx_, 1, false);
            } else if (clickCount == 2) {
                this.sd_.setPortSelection(-1, 0, true);
                this.sd_.setPortSelection(this.portIdx_, 1, true);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.pressed = true;
            this.mousePoint = me.getPoint();
            if (this.sd_.getCine() && this.sd_ instanceof XpCineCapable && !((XpCineCapable)((Object)this.sd_)).isPaused()) {
                this.toResume = true;
                Container c = SwingUtilities.getAncestorOfClass(XPscreen.class, this.sd_);
                if (c != null && c instanceof XpCineCapable) {
                    ((XpCineCapable)((Object)c)).pauseCine();
                }
            }
            boolean all = true;
            if (this.sd_.getComponentSelection() == -1) {
                all = true;
            } else {
                int ports = this.sd_.getRows() * this.sd_.getCols();
                for (int i = 0; i < ports; ++i) {
                    if (i == this.portIdx_ || this.sd_.getPort(i).getScene() == null || this.sd_.getPort(i).getScene().getSelectedState() > 0) continue;
                    all = false;
                    break;
                }
            }
            if (all) {
                XpImageScene sc = this.sd_.getPort(this.portIdx_).getScene();
                int size = this.sd_.getNumScenes();
                for (int i = 0; i < size; ++i) {
                    XpImageScene fs = this.sd_.getScene(i);
                    if (sc == fs) continue;
                    fs.setSelectedState(2);
                }
            }
            this.sd_.setPortSelection(this.portIdx_, 1, false);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            boolean isSamePoint = me.getPoint().equals(this.mousePoint);
            this.mousePoint.setLocation(0, 0);
            if (this.pressed && !isSamePoint) {
                this.sd_.updatePropRenderAttributes();
            }
            if (this.sd_.getCine() && this.sd_ instanceof XpCineCapable && this.toResume) {
                Container c = SwingUtilities.getAncestorOfClass(XPscreen.class, this.sd_);
                if (c != null && c instanceof XpCineCapable) {
                    ((XpCineCapable)((Object)c)).resumeCine();
                }
                this.toResume = false;
            }
            this.pressed = false;
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }
    }
}

