/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.hc.cse.commons.selection.Selection;
import com.ge.hc.cse.commons.selection.SelectionReader;
import com.ge.med.cse.cvf.base.CvDynamicImageProvider;
import com.ge.med.cse.cvf.base.DefaultImageValidator;
import com.ge.med.cse.cvf.base.PleaseWaitDialog;
import com.ge.med.cse.cvf.comparators.NumberComparator;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.idc.ImageValidator;
import com.ge.med.cse.cvf.idc.XpCPICapable;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.cse.cvf.util.ScreenLayoutHelper;
import com.ge.med.idc.GSPSCapable;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.platform.dm.XpDMgsps;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CvImageLoader {
    protected XPscreen scrn = null;
    private static CvImageLoader instance = null;
    private static final Logger logger = Logger.getLogger(CvImageLoader.class.getName());
    private static final int max_series_size = Integer.parseInt(CvPropertiesManager.getProperty("cvf.imageloader.maxSeriesSize", "20000"));
    private static final boolean showWaitDialog = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.imageloader.showWaitDialog", "false"));
    private static final TransactionLogName tln_getselection = new TransactionLogName("GetSelection");
    private static final TransactionLogName tln_getdmimage = new TransactionLogName("GetDMImage");
    private static final TransactionLogName tln_getSortOrder = new TransactionLogName("GetSortOrder");
    private static final TransactionLogName tln_loadImage = new TransactionLogName("LoadImage");
    private static final boolean loadFromSelectionFile = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.imageloader.loadFromSelectionFile", "true"));
    private SelectionReader selReader = new SelectionReader();
    private ImageValidator imgValidator = null;
    private ArrayList<CvDynamicImageProvider> ips_ = new ArrayList();
    private PleaseWaitDialog waitDialog = null;
    private LockUnlockMgr lockUnlockMgr = new LockUnlockMgr();
    private PropertyChangeListener portChangedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CvImageLoader.this.updateDyanmicProviders();
        }
    };
    public static final int IMAGE_LOAD_SUCCESS = 0;
    public static final int IMAGE_LOAD_PARTIAL = 1;
    public static final int IMAGE_LOAD_FAILED = -1;
    public static final int IMAGE_LOAD_SIZE_EXCEEDED = -2;
    public static final int IMAGE_LOAD_UNSUPPORTED_TYPE = -3;
    public static final int IMAGE_LOAD_UNSUPPORTED_MODALITY = -4;
    public static final int GSPS_REF_IMAGE_NOT_FOUND = -5;
    public static final int CINE_ON_IMGLOAD_FAILED = -6;
    private XpDicomElement serUID = new XpDicomElement(32, 14);

    public static synchronized CvImageLoader getInstance() {
        return instance == null ? (instance = new CvImageLoader()) : instance;
    }

    private CvImageLoader() {
        try {
            String imgValClass = CvPropertiesManager.getProperty("ImageValidator");
            this.imgValidator = imgValClass == null ? new DefaultImageValidator() : (ImageValidator)Thread.currentThread().getContextClassLoader().loadClass(imgValClass).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setScreen(XPscreen screen) {
        if (this.scrn != null) {
            this.scrn.removePropertyChangeListener("layout_changed", this.portChangedListener);
            this.scrn.removePropertyChangeListener("port_change_property", this.portChangedListener);
        }
        this.scrn = screen;
        if (this.scrn != null) {
            this.updateDyanmicProviders();
            this.scrn.addPropertyChangeListener("layout_changed", this.portChangedListener);
            this.scrn.addPropertyChangeListener("port_change_property", this.portChangedListener);
        }
    }

    private void updateDyanmicProviders() {
        int num = this.scrn.getNumPorts();
        int numVisible = this.scrn.getScreenLayout().getNoOfPorts();
        ArrayList<XpCompositePort> visiblePorts = new ArrayList<XpCompositePort>(numVisible);
        for (int i = 0; i < num; ++i) {
            JComponent port = this.scrn.getPort(i);
            if (port instanceof XpCompositePort) {
                if (i < this.ips_.size()) {
                    this.ips_.get(i).attachPort((XpCompositePort)port);
                } else {
                    this.ips_.add(new CvDynamicImageProvider((XpCompositePort)port));
                }
                if (i >= numVisible) continue;
                visiblePorts.add((XpCompositePort)port);
                continue;
            }
            if (i >= this.ips_.size()) continue;
            this.ips_.get(i).attachPort(null);
        }
        ArrayList<XpViewport> toRemove = new ArrayList<XpViewport>();
        HashMap<XpViewport, ArrayList<DMObject>> locks = this.lockUnlockMgr.getLocks();
        for (XpViewport port : locks.keySet()) {
            if (visiblePorts.contains(port)) continue;
            toRemove.add(port);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            this.lockUnlockMgr.unlock((XpViewport)toRemove.get(i));
        }
    }

    public boolean isValid(DMObject[] sel) {
        boolean status = true;
        status = this.imgValidator.isValid(sel);
        if (status) {
            if ("image".equalsIgnoreCase(sel[0].getType()) && sel.length > max_series_size) {
                return false;
            }
            if ("series".equalsIgnoreCase(sel[0].getType()) && sel[0].getNumberOfRelated("image") > max_series_size) {
                return false;
            }
        }
        return status;
    }

    public void loadData(boolean loadGSPS) {
        this.loadData(null, loadGSPS, false);
    }

    public void loadData(XpCompositePort port, boolean loadGSPS) {
        this.loadData(port, loadGSPS, false);
    }

    public void loadData(boolean loadGSPS, boolean loadMultiple) {
        this.loadData(null, loadGSPS, loadMultiple);
    }

    public void loadData(XpCompositePort port, boolean loadGSPS, boolean loadMultiple) {
        try {
            XpCompositePort xpCompositePort = loadMultiple ? null : (port != null ? port : (port = this.scrn != null && this.scrn.getSelectedPort() instanceof XpCompositePort ? (XpCompositePort)this.scrn.getSelectedPort() : null));
            if (!loadMultiple && !(port instanceof XpCompositePort)) {
                logger.log(Level.INFO, "loadData() selected port not composite port ");
                return;
            }
            String selectionFile = CvPropertiesManager.getProperty("SDC_SELECTION_FILE");
            if (loadFromSelectionFile && selectionFile != null && selectionFile.length() > 0) {
                JFrame parent;
                logger.log(Level.INFO, "{0} begin, Read Selection from file ", tln_getselection);
                Selection selection = SelectionReader.readSelection(selectionFile);
                logger.log(Level.INFO, "{0} end, Read Selection from file ", tln_getselection);
                if (selection == null) {
                    logger.log(Level.WARNING, "{0} failed. Selection resulted null/empty selection ", tln_getselection);
                    return;
                }
                if (showWaitDialog && (parent = (JFrame)SwingUtilities.getWindowAncestor(port)) != null && this.waitDialog == null) {
                    this.waitDialog = new PleaseWaitDialog(parent);
                    this.waitDialog.setVisible(true);
                }
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("LOAD_DATA"));
                int selPort = -1;
                if (this.scrn != null) {
                    selPort = this.scrn.getComponentSelection();
                    logger.log(Level.INFO, "Selected port Number :" + selPort);
                }
                logger.log(Level.INFO, "{0} begin, loadSelection ", tln_loadImage);
                int status = this.loadImages(selection, port, loadGSPS, loadMultiple);
                CvImageLoader.logUserMessage(status);
                logger.log(Level.INFO, "{0} end, loadSelection ", tln_loadImage);
                if (this.scrn != null) {
                    if (selPort == -1) {
                        selPort = 0;
                    }
                    this.scrn.setComponentSelection(selPort);
                }
            } else {
                JFrame parent;
                logger.log(Level.INFO, "{0} begin, Get Selection from dmsystem ", tln_getselection);
                DMObject[] sel = CvUtils.getDMSystem().getSelection();
                logger.log(Level.INFO, "{0} end, Get Selection from dmsystem ", tln_getselection);
                if (sel == null || sel.length == 0) {
                    logger.log(Level.WARNING, "{0} failed. Selection resulted null/empty selection ", tln_getselection);
                    return;
                }
                if (showWaitDialog && this.waitDialog == null && (parent = (JFrame)SwingUtilities.getWindowAncestor(port)) != null && this.waitDialog == null) {
                    this.waitDialog = new PleaseWaitDialog(parent);
                    this.waitDialog.setVisible(true);
                }
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("LOAD_DATA"));
                int selPort = -1;
                if (this.scrn != null) {
                    selPort = this.scrn.getComponentSelection();
                    logger.log(Level.INFO, "Selected port Number :" + selPort);
                }
                int status = this.loadImages(sel, port, loadGSPS, loadMultiple);
                CvImageLoader.logUserMessage(status);
                if (this.scrn != null) {
                    if (selPort == -1) {
                        selPort = 0;
                    }
                    this.scrn.setComponentSelection(selPort);
                }
            }
            final XpCompositePort selectedPort = port;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (selectedPort == null) {
                        return;
                    }
                    JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(selectedPort);
                    if (parent != null && !parent.isVisible()) {
                        parent.pack();
                        parent.setVisible(true);
                    }
                }
            });
            if (showWaitDialog && this.waitDialog != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CvImageLoader.this.waitDialog == null) {
                            return;
                        }
                        CvImageLoader.this.waitDialog.dispose();
                        CvImageLoader.this.waitDialog = null;
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (showWaitDialog && this.waitDialog != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CvImageLoader.this.waitDialog == null) {
                            return;
                        }
                        CvImageLoader.this.waitDialog.dispose();
                        CvImageLoader.this.waitDialog = null;
                    }
                });
            }
            CvImageLoader.logUserMessage(-1);
            logger.log(Level.WARNING, "loadData failed with exception : " + ex.getLocalizedMessage());
            return;
        }
    }

    public void loadData(DMObject[] sel, boolean loadGSPS) {
        this.loadData(null, sel, loadGSPS, false);
    }

    public void loadData(XpCompositePort port, DMObject[] sel, boolean loadGSPS) {
        this.loadData(port, sel, loadGSPS, false);
    }

    public void loadData(XpCompositePort port, DMObject[] sel, boolean loadGSPS, boolean loadMultiple) {
        try {
            JFrame parent;
            if (sel == null || sel.length == 0) {
                logger.log(Level.WARNING, "{0} failed. Selection resulted null/empty selection ", tln_getselection);
                return;
            }
            XpCompositePort xpCompositePort = loadMultiple ? null : (port != null ? port : (port = this.scrn != null && this.scrn.getSelectedPort() instanceof XpCompositePort ? (XpCompositePort)this.scrn.getSelectedPort() : null));
            if (!loadMultiple && !(port instanceof XpCompositePort)) {
                logger.log(Level.INFO, "loadData() selected port not composite port ");
                return;
            }
            if (showWaitDialog && (parent = (JFrame)SwingUtilities.getWindowAncestor(this.scrn.getSelectedPort())) != null && this.waitDialog == null) {
                this.waitDialog = new PleaseWaitDialog(parent);
                this.waitDialog.setVisible(true);
            }
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("LOAD_DATA"));
            int selPort = -1;
            if (this.scrn != null) {
                selPort = this.scrn.getComponentSelection();
                logger.log(Level.INFO, "Selected port Number :" + selPort);
            }
            int status = this.loadImages(sel, port, loadGSPS, loadMultiple);
            CvImageLoader.logUserMessage(status);
            if (this.scrn != null) {
                if (selPort == -1) {
                    selPort = 0;
                }
                this.scrn.setComponentSelection(selPort);
            }
            final XpCompositePort selectedPort = port;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (selectedPort == null) {
                        return;
                    }
                    JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(selectedPort);
                    if (parent != null && !parent.isVisible()) {
                        parent.pack();
                        parent.setVisible(true);
                    }
                }
            });
            if (showWaitDialog && this.waitDialog != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CvImageLoader.this.waitDialog != null) {
                            CvImageLoader.this.waitDialog.dispose();
                            CvImageLoader.this.waitDialog = null;
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (showWaitDialog && this.waitDialog != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CvImageLoader.this.waitDialog != null) {
                            CvImageLoader.this.waitDialog.dispose();
                            CvImageLoader.this.waitDialog = null;
                        }
                    }
                });
            }
            CvImageLoader.logUserMessage(-1);
            logger.log(Level.WARNING, "loadData failed with exception : " + ex.getLocalizedMessage());
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized int loadImages(DMObject[] sel, XpCompositePort port, boolean loadGSPS, boolean loadMultiple) {
        if (sel == null || sel.length == 0) {
            logger.log(Level.WARNING, "loadData() received empty selection ");
            return -1;
        }
        XpCompositePort compPort = port;
        if (compPort == null && this.scrn != null) {
            XpCompositePort xpCompositePort = compPort = this.scrn.getSelectedPort() instanceof XpCompositePort ? (XpCompositePort)this.scrn.getSelectedPort() : null;
        }
        if (!loadMultiple && compPort == null) {
            logger.log(Level.WARNING, "loadData() selected port not composite port ");
            return -1;
        }
        if (compPort != null && compPort instanceof XpCompositePort && compPort.getCine()) {
            return -6;
        }
        logger.log(Level.FINE, "loadData() selection type : " + sel[0].getType());
        String modality = DicomUtils.getModality(sel[0]);
        String neededTags = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modality);
        DMTag[] tags = neededTags != null ? CvUtils.getNeededTags(modality, "") : null;
        DMObject selSer = null;
        DMImage[] imgs = null;
        int selImgIndex = -1;
        int imgLoadStatus = 0;
        if (sel[0].getType().equalsIgnoreCase("image") && compPort instanceof XpCompositePort) {
            if (!this.imgValidator.isValid(new DMTagValueInterface[]{sel[0]})) {
                return -3;
            }
            logger.log(Level.INFO, "Loading the images of type IMAGE");
            DMObject seriesParent = sel[0].getRelated("series")[0];
            String result = null;
            result = CvUtils.getDMSystem().send("GET_IMAGE_TO_DISPLAY");
            if (result != null) {
                logger.log(Level.INFO, "Fetching image Index=" + result + " from database");
                selImgIndex = Integer.valueOf(result.trim());
            }
            if (CPIUtils.isGSPS(sel[0])) {
                DMObject gspsObject;
                CvUtils.getDMSystem().setRepresentativeDMObjet(seriesParent);
                DMObject dMObject = gspsObject = selImgIndex != -1 ? (gspsObject = sel[selImgIndex]) : sel[0];
                if (gspsObject != null) return this.gspsLoader((XpViewport)compPort, gspsObject);
                logger.log(Level.WARNING, "NO GSPS Object Found in the database");
                return -1;
            }
            int size = sel.length;
            if (size > max_series_size) {
                logger.log(Level.WARNING, "loadData() selection exceeded the max supported size [Max:" + max_series_size + ", Selected:" + size);
                return -2;
            }
            CvUtils.getDMSystem().setRepresentativeDMObjet(seriesParent);
            ArrayList<DMImage> imglist = new ArrayList<DMImage>(size);
            for (int i = 0; i < size; ++i) {
                try {
                    imglist.add(sel[i].getImages(null)[0]);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in getImages : " + ex.getLocalizedMessage());
                }
            }
            imgs = imglist.toArray(new DMImage[imglist.size()]);
            if (imgs != null && imgs.length == 0) {
                return -1;
            }
            if (imgs != null && imgs.length > 0 && imgs.length < size) {
                imgLoadStatus = 1;
            }
            selSer = seriesParent;
            if (imgs == null || imgs.length <= 0) return -1;
            this.loadImagesOnPort(compPort, imgs, selImgIndex, loadGSPS, selSer);
            return imgLoadStatus;
        }
        if (sel[0].getType().equalsIgnoreCase("series")) {
            if (!loadMultiple) return this.loadSeries(compPort, sel[0], tags, selImgIndex, loadGSPS);
            DMObject[] sers = this.getValidSelections(sel);
            if (sers == null || sers.length == 0) {
                logger.log(Level.WARNING, "loadData() No valid selection found");
                return -3;
            }
            if (sers.length == 1) {
                return this.loadSeries(compPort, sers[0], tags, selImgIndex, loadGSPS);
            }
            if (this.scrn == null) return -1;
            int numSel = sers.length;
            this.configureScreenLayout(numSel);
            numSel = numSel > this.scrn.getScreenLayout().getNoOfPorts() ? this.scrn.getScreenLayout().getNoOfPorts() : numSel;
            int portIdx = 0;
            for (int n = 0; n < numSel; ++n) {
                if (this.scrn.getPort(portIdx) instanceof XpCompositePort) {
                    this.loadSeries((XpCompositePort)this.scrn.getPort(portIdx), sers[n], tags, selImgIndex, loadGSPS);
                }
                ++portIdx;
            }
            if (numSel <= 1 || !(this.scrn instanceof XpLinkPortCapable)) return 0;
            ((XpLinkPortCapable)((Object)this.scrn)).setPortsLinked(true);
            return 0;
        }
        if (sel[0].getType().equalsIgnoreCase("study")) {
            if (!loadMultiple) return this.loadExam(compPort, sel[0], tags, selImgIndex, loadGSPS);
            DMObject[] sers = this.getValidSelections(sel);
            if (sers == null || sers.length == 0) {
                logger.log(Level.WARNING, "loadData() No valid selection found");
                return -3;
            }
            if (sers.length == 1) {
                return this.loadSeries(compPort, sers[0], tags, selImgIndex, loadGSPS);
            }
            if (this.scrn == null) return -1;
            int numSel = sers.length;
            this.configureScreenLayout(numSel);
            numSel = numSel > this.scrn.getScreenLayout().getNoOfPorts() ? this.scrn.getScreenLayout().getNoOfPorts() : numSel;
            int portIdx = 0;
            for (int n = 0; n < numSel; ++n) {
                if (this.scrn.getPort(portIdx) instanceof XpCompositePort) {
                    this.loadSeries((XpCompositePort)this.scrn.getPort(portIdx), sers[n], tags, selImgIndex, loadGSPS);
                }
                ++portIdx;
            }
            if (numSel <= 1 || !(this.scrn instanceof XpLinkPortCapable)) return 0;
            ((XpLinkPortCapable)((Object)this.scrn)).setPortsLinked(true);
            return 0;
        }
        logger.log(Level.INFO, "loadData() selected object is of unknown type : " + sel[0].getType());
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized int loadImages(Selection sel, XpCompositePort port, boolean loadGSPS, boolean loadMultiple) {
        if (sel == null) {
            logger.log(Level.WARNING, "loadData() received empty selection ");
            return -1;
        }
        XpCompositePort compPort = port;
        if (compPort == null && this.scrn != null) {
            XpCompositePort xpCompositePort = compPort = this.scrn.getSelectedPort() instanceof XpCompositePort ? (XpCompositePort)this.scrn.getSelectedPort() : null;
        }
        if (!loadMultiple && compPort == null) {
            logger.log(Level.WARNING, "loadData() selected port not composite port ");
            return -1;
        }
        if (compPort != null && compPort instanceof XpCompositePort && compPort.getCine()) {
            return -6;
        }
        logger.log(Level.FINE, "loadData() selection type : " + sel.getLevel());
        DMImage[] imgs = null;
        int imgLoadStatus = 0;
        DMSession session = CvUtils.getDMSystem().getLocalDB();
        String[] selPaths = sel.getSelectionFilePaths();
        if (selPaths == null || selPaths.length == 0) {
            logger.log(Level.WARNING, "loadData() received empty selection ");
            return -1;
        }
        int selImgIndex = sel.getIndexOfFirstImage();
        String primSelPath = selPaths[selImgIndex];
        System.err.println(">>>>>>>>>>>>>> Sel Path : " + primSelPath);
        if (sel.getLevel().equalsIgnoreCase("image") && compPort instanceof XpCompositePort) {
            int startIndex;
            boolean checkForPrimSelCom = true;
            int nextSelImgIndex = selImgIndex;
            int size = selPaths.length;
            String nextPrimSelPath = primSelPath;
            while (checkForPrimSelCom) {
                try {
                    DMComposite primSelComp = session.getComposite(nextPrimSelPath);
                    if (!this.imgValidator.isValid(new DMTagValueInterface[]{primSelComp})) {
                        return -3;
                    }
                    logger.log(Level.INFO, "Loading the images of type IMAGE");
                    if (CPIUtils.isGSPS(primSelComp)) {
                        if (nextSelImgIndex == selImgIndex) {
                            logger.log(Level.INFO, "Loading GSPS object");
                            return this.gspsLoader((XpViewport)compPort, primSelComp);
                        }
                        logger.log(Level.WARNING, "Selected GSPS is corrupt");
                        return -1;
                    }
                    checkForPrimSelCom = false;
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in primary selected composite : " + ex.getLocalizedMessage());
                    nextSelImgIndex = (nextSelImgIndex + 1) % size;
                    if (nextSelImgIndex == selImgIndex) {
                        logger.log(Level.WARNING, "loadData() received corrupt selection ");
                        return -1;
                    }
                    nextPrimSelPath = selPaths[nextSelImgIndex];
                    checkForPrimSelCom = true;
                }
            }
            if (size > max_series_size) {
                logger.log(Level.WARNING, "loadData() selection exceeded the max supported size [Max:" + max_series_size + ", Selected:" + size);
                return -2;
            }
            ArrayList<DMImage> imglist = new ArrayList<DMImage>();
            int n = startIndex = selImgIndex == 0 ? nextSelImgIndex : 0;
            if (startIndex == 0) {
                try {
                    this.imgValidator.isValid(new DMTagValueInterface[]{session.getComposite(selPaths[startIndex])});
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in first composite : " + ex.getLocalizedMessage());
                    --selImgIndex;
                    startIndex = 1;
                }
            }
            for (int i = startIndex; i < size; ++i) {
                try {
                    DMComposite comp = session.getComposite(selPaths[i]);
                    if (comp == null) continue;
                    imglist.add(comp.getImages(null)[0]);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in getImages : " + ex.getLocalizedMessage());
                }
            }
            imgs = imglist.toArray(new DMImage[imglist.size()]);
            if (imgs != null && imgs.length == 0) {
                return -1;
            }
            if (imgs != null && imgs.length > 0 && imgs.length < size) {
                imgLoadStatus = 1;
            }
            if (imgs == null || imgs.length <= 0) return -1;
            this.loadImagesOnPort(compPort, imgs, selImgIndex, loadGSPS, null);
            return imgLoadStatus;
        }
        if (sel.getLevel().equalsIgnoreCase("series")) {
            selImgIndex = 0;
            if (loadMultiple) {
                DMTag[] tags;
                DMObject[] serdmos = CvUtils.getDMSystem().getSelection();
                if (serdmos == null || serdmos.length == 0) {
                    logger.log(Level.WARNING, "loadData() received empty selection ");
                    return -1;
                }
                DMObject[] sers = this.getValidSelections(serdmos);
                if (sers == null || sers.length == 0) {
                    logger.log(Level.WARNING, "loadData() No valid selection found");
                    return -3;
                }
                String modality = DicomUtils.getModality(sers[0]);
                String neededTags = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modality);
                DMTag[] dMTagArray = tags = neededTags != null ? CvUtils.getNeededTags(modality, "") : null;
                if (sers.length == 1) {
                    return this.loadSeries(compPort, sers[0], tags, selImgIndex, loadGSPS);
                }
                if (this.scrn == null) return -1;
                int numSel = sers.length;
                this.configureScreenLayout(numSel);
                if (this.scrn instanceof XpLinkPortCapable) {
                    ((XpLinkPortCapable)((Object)this.scrn)).setPortsLinked(true);
                }
                numSel = numSel > this.scrn.getScreenLayout().getNoOfPorts() ? this.scrn.getScreenLayout().getNoOfPorts() : numSel;
                int portIdx = 0;
                for (int n = 0; n < numSel; ++n) {
                    if (this.scrn.getPort(portIdx) instanceof XpCompositePort) {
                        this.loadSeries((XpCompositePort)this.scrn.getPort(portIdx), sers[n], tags, selImgIndex, loadGSPS);
                    }
                    ++portIdx;
                }
                return 0;
            }
            DMObject[] serSel = CvUtils.getDMSystem().getSelection();
            if (serSel == null || serSel.length == 0) {
                logger.log(Level.WARNING, "loadData() received empty selection ");
                return -1;
            }
            String modality = DicomUtils.getModality(serSel[0]);
            String neededTags = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modality);
            DMTag[] tags = neededTags != null ? CvUtils.getNeededTags(modality, "") : null;
            return this.loadSeries(compPort, serSel[0], tags, selImgIndex, loadGSPS);
        }
        if (sel.getLevel().equalsIgnoreCase("exam")) {
            selImgIndex = 0;
            if (loadMultiple) {
                DMTag[] tags;
                DMObject[] examdmos = CvUtils.getDMSystem().getSelection();
                if (examdmos == null || examdmos.length == 0) {
                    logger.log(Level.WARNING, "loadData() received empty selection ");
                    return -1;
                }
                DMObject[] exams = this.getValidSelections(examdmos);
                if (exams == null || exams.length == 0) {
                    logger.log(Level.WARNING, "loadData() No valid selection found");
                    return -3;
                }
                String modality = DicomUtils.getModality(exams[0]);
                String neededTags = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modality);
                DMTag[] dMTagArray = tags = neededTags != null ? CvUtils.getNeededTags(modality, "") : null;
                if (exams.length == 1) {
                    return this.loadSeries(compPort, exams[0], tags, selImgIndex, loadGSPS);
                }
                if (this.scrn == null) return -1;
                int numSel = exams.length;
                this.configureScreenLayout(numSel);
                if (this.scrn instanceof XpLinkPortCapable) {
                    ((XpLinkPortCapable)((Object)this.scrn)).setPortsLinked(true);
                }
                numSel = numSel > this.scrn.getScreenLayout().getNoOfPorts() ? this.scrn.getScreenLayout().getNoOfPorts() : numSel;
                int portIdx = 0;
                for (int n = 0; n < numSel; ++n) {
                    if (this.scrn.getPort(portIdx) instanceof XpCompositePort) {
                        this.loadSeries((XpCompositePort)this.scrn.getPort(portIdx), exams[n], tags, selImgIndex, loadGSPS);
                    }
                    ++portIdx;
                }
                return 0;
            }
            DMObject[] examSel = CvUtils.getDMSystem().getSelection();
            if (examSel == null || examSel.length == 0) {
                logger.log(Level.WARNING, "loadData() received empty selection ");
                return -1;
            }
            String modality = DicomUtils.getModality(examSel[0]);
            String neededTags = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modality);
            DMTag[] tags = neededTags != null ? CvUtils.getNeededTags(modality, "") : null;
            return this.loadExam(compPort, examSel[0], tags, selImgIndex, loadGSPS);
        }
        logger.log(Level.INFO, "loadData() selected object is of unknown type : " + sel.getLevel());
        return -1;
    }

    private void loadImagesOnPort(final XpCompositePort serDisp, DMImage[] images, final int frameIdx, final boolean loadGSPS, final DMObject selObj) {
        final CvMedicalDmImageList imgList = new CvMedicalDmImageList(serDisp, images);
        final XpMedicalImage[] toSet = imgList.getImages();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                serDisp.setImages(toSet);
                if (frameIdx != -1) {
                    serDisp.setFrameIndex(imgList.indexOf(frameIdx));
                }
                DMObject selSeries = selObj;
                if (selObj == null && toSet != null && toSet.length > 0) {
                    toSet[0].getValue(CvImageLoader.this.serUID);
                    DMObject[] sers = CvUtils.getDMSystem().getLocalDB().getRelated("series", new DMQuery("(0x0020,0x000E) = " + CvImageLoader.this.serUID.getStringValue()));
                    if (sers != null && sers.length > 0) {
                        selSeries = sers[0];
                    }
                }
                if (selSeries != null && !Boolean.getBoolean("NO_LOCK")) {
                    CvImageLoader.this.lockUnlockMgr.unlock(serDisp);
                    CvImageLoader.this.lockUnlockMgr.lock(serDisp, new DMObject[]{selSeries});
                }
                final DMObject selectedSeries = selSeries;
                if (loadGSPS) {
                    Thread gspsLoadThread = new Thread(){

                        @Override
                        public void run() {
                            logger.log(Level.INFO, "TID=GSPSLoad Start");
                            CvImageLoader.this.loadGSPS(serDisp, selectedSeries);
                            logger.log(Level.INFO, "TID=GSPSLoad End");
                        }
                    };
                    gspsLoadThread.start();
                }
            }
        });
    }

    private int loadExam(XpCompositePort serDisp, DMObject exam, DMTag[] tags, int selFrameIndex, boolean loadGSPS) {
        if (serDisp instanceof XpCompositePort) {
            Object[] sers = exam.getRelated("series");
            if (sers == null || sers.length == 0) {
                logger.log(Level.WARNING, "loadData() selected exam returned no series");
                return -1;
            }
            CvUtils.sortSeriesByBase(sers);
            Object currentSeriesObject = sers[0];
            if (!this.imgValidator.isValid(new DMObject[]{currentSeriesObject})) {
                return -3;
            }
            if (CPIUtils.isGSPS((DMTagValueInterface)currentSeriesObject)) {
                CvUtils.getDMSystem().setRepresentativeDMObjet((DMObject)currentSeriesObject);
                return this.gspsLoader((XpViewport)serDisp, (DMObject)currentSeriesObject);
            }
            int size = ((DMObject)currentSeriesObject).getNumberOfRelated("image");
            if (size > max_series_size) {
                logger.log(Level.WARNING, "loadData() series size exceeded the max supported size [Max:" + max_series_size + ", Selected:" + size);
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
                return -2;
            }
            CvUtils.getDMSystem().setRepresentativeDMObjet((DMObject)currentSeriesObject);
            DMComposite[] comps = ((DMObject)currentSeriesObject).getComposites();
            size = comps.length;
            ArrayList<DMImage> imglist = new ArrayList<DMImage>(size);
            for (int i = 0; i < size; ++i) {
                try {
                    imglist.add(comps[i].getImages(tags)[0]);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Skipping image, exception in getImages : " + ex.getLocalizedMessage());
                }
            }
            ArrayList<DMImage> newImglist = new ArrayList<DMImage>(size);
            newImglist.addAll(imglist);
            for (DMImage image : imglist) {
                try {
                    image.getValue(new DMTag(8, 8));
                    break;
                }
                catch (Exception ex) {
                    newImglist.remove(image);
                    logger.log(Level.INFO, "Skipping image, exception in getValue : " + ex.getLocalizedMessage());
                }
            }
            int imgLoadStatus = 0;
            DMImage[] imgs = newImglist.toArray(new DMImage[newImglist.size()]);
            if (imgs != null) {
                if (imgs.length == 0) {
                    return -1;
                }
                if (imgs.length > 0 && imgs.length < size) {
                    imgLoadStatus = 1;
                }
            }
            Object selSer = currentSeriesObject;
            if (imgs != null && imgs.length > 0) {
                Arrays.sort(imgs, new NumberComparator(32, 19));
                this.loadImagesOnPort(serDisp, imgs, selFrameIndex, loadGSPS, (DMObject)selSer);
                return imgLoadStatus;
            }
        }
        return -1;
    }

    private int loadSeries(XpCompositePort serDisp, DMObject series, DMTag[] tags, int selFrameIndex, boolean loadGSPS) {
        if (serDisp instanceof XpCompositePort) {
            if (!this.imgValidator.isValid(new DMObject[]{series})) {
                return -3;
            }
            if (CPIUtils.isGSPS(series)) {
                CvUtils.getDMSystem().setRepresentativeDMObjet(series);
                return this.gspsLoader((XpViewport)serDisp, series);
            }
            int size = series.getNumberOfRelated("image");
            if (size > max_series_size) {
                logger.log(Level.WARNING, "loadData() series size exceeded the max supported size [Max:" + max_series_size + ", Selected:" + size);
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
                return -2;
            }
            CvUtils.getDMSystem().setRepresentativeDMObjet(series);
            logger.log(Level.INFO, "{0} begin, Get DMImage from series object ", tln_getdmimage);
            DMComposite[] comps = series.getComposites();
            size = comps.length;
            ArrayList<DMImage> imglist = new ArrayList<DMImage>(size);
            for (int i = 0; i < size; ++i) {
                try {
                    imglist.add(comps[i].getImages(tags)[0]);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "exception in getImages : " + ex.getLocalizedMessage());
                }
            }
            ArrayList<DMImage> newImglist = new ArrayList<DMImage>(size);
            newImglist.addAll(imglist);
            for (DMImage image : imglist) {
                try {
                    image.getValue(new DMTag(8, 8));
                    break;
                }
                catch (Exception ex) {
                    newImglist.remove(image);
                    logger.log(Level.INFO, "Skipping image, exception in getValue : " + ex.getLocalizedMessage());
                }
            }
            int imgLoadStatus = 0;
            DMImage[] imgs = newImglist.toArray(new DMImage[newImglist.size()]);
            if (imgs != null && imgs.length == 0) {
                return -1;
            }
            if (imgs != null && imgs.length > 0 && imgs.length < size) {
                imgLoadStatus = 1;
            }
            logger.log(Level.INFO, "{0} end, Get DMImage from series object ", tln_getdmimage);
            DMObject selSer = series;
            if (imgs != null && imgs.length > 0) {
                Arrays.sort(imgs, new NumberComparator(32, 19));
                this.loadImagesOnPort(serDisp, imgs, selFrameIndex, loadGSPS, selSer);
                return imgLoadStatus;
            }
        }
        return -1;
    }

    private DMObject[] getValidSelections(DMObject[] sel) {
        if (sel == null || sel.length == 0) {
            return null;
        }
        ArrayList<Object> selList = new ArrayList<Object>();
        int len = sel.length;
        if ("study".equalsIgnoreCase(sel[0].getType())) {
            block0: for (int i = 0; i < len; ++i) {
                Object[] sers;
                if (!"study".equalsIgnoreCase(sel[i].getType()) || (sers = sel[i].getRelated("series")) == null || sers.length == 0) continue;
                CvUtils.sortSeriesByBase(sers);
                for (int j = 0; j < sers.length; ++j) {
                    if (!this.imgValidator.isValid(new DMObject[]{sers[j]})) continue;
                    int size = ((DMObject)sers[j]).getNumberOfRelated("image");
                    if (size > max_series_size) continue block0;
                    selList.add(sers[j]);
                    continue block0;
                }
            }
        } else if ("series".equalsIgnoreCase(sel[0].getType())) {
            for (int i = 0; i < len; ++i) {
                int size;
                if (!"series".equalsIgnoreCase(sel[i].getType()) || !this.imgValidator.isValid(new DMObject[]{sel[i]}) || (size = sel[i].getNumberOfRelated("image")) > max_series_size) continue;
                selList.add(sel[i]);
            }
        } else if ("image".equalsIgnoreCase(sel[0].getType()) && this.imgValidator.isValid(new DMObject[]{sel[0]}) && sel.length <= max_series_size) {
            return sel;
        }
        if (selList.size() == 0) {
            return null;
        }
        return selList.toArray(new DMObject[selList.size()]);
    }

    private int loadGSPS(XpCompositePort viewport, DMObject selection) {
        if (selection == null && viewport.getFrame() instanceof XpMedicalImage) {
            ((XpMedicalImage)viewport.getFrame()).getValue(this.serUID);
            DMObject[] sers = CvUtils.getDMSystem().getLocalDB().getRelated("series", new DMQuery("(0x0020,0x000E) = " + this.serUID.getStringValue()));
            if (sers != null && sers.length > 0) {
                selection = sers[0];
            }
        }
        if (selection == null) {
            logger.log(Level.INFO, "loadGSPS() selection is null");
            return -1;
        }
        Object gspsObj = null;
        boolean gspsAuxFlag = CvPropertiesManager.getBoolean("GSPS_AUX_TAG", false);
        if (gspsAuxFlag) {
            gspsObj = CPIUtils.getLatestRelatedGSPSObjectFromAuxTag(selection);
        }
        boolean gspsAutoRestoreFlag = CvPropertiesManager.getBoolean("GSPS_AUTO_RESTORE", true);
        if (gspsObj == null && gspsAutoRestoreFlag) {
            logger.log(Level.INFO, "GSPS_AUX_TAG not present, querying for last saved GSPS object for this series");
            gspsObj = CPIUtils.getLatestRelatedGSPSObject(selection);
            if (gspsObj != null && gspsAuxFlag) {
                CPIUtils.setLatestRelatedGSPSObjectToAuxTag(selection, gspsObj);
            }
        }
        if (gspsObj != null) {
            if (gspsObj instanceof DMObject) {
                return this.loadCPI((XpViewport)viewport, (DMObject)gspsObj);
            }
            if (gspsObj instanceof String) {
                return this.loadCPI((XpViewport)viewport, (String)gspsObj);
            }
        }
        logger.log(Level.INFO, "GSPS loading failed");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCPI(XpViewport viewport, DMObject gspsObj) {
        DMObject probj = null;
        DMObject[] prObjs = null;
        DMObject gspsSeries = null;
        if (!CPIUtils.isGSPS(gspsObj)) {
            logger.log(Level.INFO, "series is not GSPS series");
            return -1;
        }
        if (gspsObj.getType().equalsIgnoreCase("series")) {
            prObjs = gspsObj.getRelated("image");
            probj = prObjs[0];
            gspsSeries = gspsObj;
        } else if (gspsObj.getType().equalsIgnoreCase("image")) {
            probj = gspsObj;
            gspsSeries = gspsObj.getRelated("series")[0];
        }
        if (probj == null) {
            logger.log(Level.INFO, "GSPS object is null");
            return -1;
        }
        if (viewport instanceof GSPSCapable) {
            if (!Boolean.getBoolean("NO_LOCK")) {
                this.lockUnlockMgr.lock(viewport, new DMObject[]{gspsSeries});
            }
            FileInputStream gspsStream = null;
            try {
                gspsStream = new FileInputStream(probj.getComposites()[0].getFilePath());
                if (viewport instanceof XpCPICapable) {
                    ((XpCPICapable)((Object)viewport)).setCvCPI(XpDMgsps.getCPI(gspsStream));
                } else {
                    ((GSPSCapable)((Object)viewport)).setGSPS(gspsStream);
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.INFO, e.getMessage());
                int n = -1;
                return n;
            }
            finally {
                try {
                    if (gspsStream != null) {
                        gspsStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
        logger.log(Level.INFO, "Selected viewport is not GSPS capable");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCPI(XpViewport viewport, String gspsFilePath) {
        if (gspsFilePath != null && viewport instanceof GSPSCapable) {
            RandomAccessFile raf = null;
            FileInputStream gspsStream = null;
            FileLock _lock = null;
            try {
                raf = new RandomAccessFile(gspsFilePath, "rw");
                _lock = raf.getChannel().lock();
                gspsStream = new FileInputStream(gspsFilePath);
                this.setGSPS(viewport, gspsStream);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.INFO, e.getMessage());
                int n = -1;
                return n;
            }
            catch (IOException e) {
                e.printStackTrace();
                int n = -1;
                return n;
            }
            finally {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (_lock != null) {
                        _lock.release();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (gspsStream != null) {
                        gspsStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
        logger.log(Level.INFO, "Selected viewport is not GSPS capable");
        return -1;
    }

    private void setGSPS(XpViewport viewport, InputStream stream) {
        if (viewport instanceof XpCPICapable) {
            XpCPI cpi = XpDMgsps.getCPI(stream);
            if (cpi != null) {
                ((XpCPICapable)((Object)viewport)).setCvCPI(cpi);
            }
        } else {
            ((GSPSCapable)((Object)viewport)).setGSPS(stream);
        }
    }

    public int gspsLoader(XpViewport viewport, DMObject gspsObject) {
        if (!(viewport instanceof GSPSCapable)) {
            logger.log(Level.WARNING, "Viewport is not GSPSCapable.");
            return -1;
        }
        if (gspsObject == null) {
            logger.log(Level.WARNING, "Unbale to get GSPS object from database");
            return -1;
        }
        if (!CPIUtils.isGSPS(gspsObject)) {
            logger.log(Level.WARNING, "Selected series is not an GSPS series");
            return -1;
        }
        DMComposite prObj = null;
        if (gspsObject.getType().equalsIgnoreCase("series")) {
            prObj = gspsObject.getRelated("image")[0].getComposites()[0];
        } else if (gspsObject.getType().equalsIgnoreCase("image")) {
            prObj = gspsObject.getComposites()[0];
        }
        return this.gspsLoader(viewport, prObj);
    }

    public int gspsLoader(final XpViewport viewport, final DMComposite gspsObject) {
        boolean look4RefdImages = false;
        if (!(viewport instanceof GSPSCapable)) {
            logger.log(Level.WARNING, "Viewport is not GSPSCapable.");
            return -1;
        }
        if (gspsObject == null) {
            logger.log(Level.WARNING, "Unbale to get GSPS object from database");
            return -1;
        }
        if (!CPIUtils.isGSPS(gspsObject)) {
            logger.log(Level.WARNING, "Selected series is not an GSPS series");
            return -1;
        }
        DMSession session = gspsObject.getSession();
        DMObject[] refdmos = null;
        String refSerUID = null;
        Object seqObj = gspsObject.getValue(40, 12560);
        if (seqObj instanceof DMSequence) {
            DMiSeqItem item;
            Object val;
            DMiSequence peer = ((DMSequence)seqObj).getPeer();
            DMObject[] dmos = null;
            Object obj = peer.getValue(0, new DMTag(8, 4416));
            int numItems = ((DMSequence)seqObj).getNumberOfItems();
            if (obj instanceof DMiSequence && (val = (item = ((DMiSequence)obj).getItem(0)).getValue(new DMTag(8, 4437))) != null) {
                DMQuery dmq = new DMQuery("(0x0008,0x0018) = " + val);
                dmos = session.getRelated("image", dmq);
                if (dmos == null || dmos.length == 0) {
                    logger.log(Level.WARNING, "No Referenced Series Found for the loaded GSPS");
                    return -5;
                }
                refSerUID = (String)dmos[0].getValue(32, 14);
                DMQuery query = new DMQuery("(0x0020,0x000E) = " + refSerUID);
                refdmos = dmos[0].getRelated("series", query);
                int numRefComp = refdmos[0].getComposites().length;
                if (numItems < numRefComp) {
                    look4RefdImages = true;
                }
            }
        }
        if (look4RefdImages) {
            refdmos = CPIUtils.getRefDMObjects(gspsObject);
        }
        if (refdmos == null || refdmos.length == 0) {
            logger.log(Level.WARNING, "No Referenced Series Found for the loaded GSPS");
            return -5;
        }
        if (viewport instanceof XpCompositePort) {
            XpCompositePort port = (XpCompositePort)viewport;
            CvImageLoader.getInstance().loadData(port, refdmos, false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(gspsObject.getFilePath());
                        if (viewport instanceof XpCPICapable) {
                            XpCPI cpi = XpDMgsps.getCPI(in);
                            if (cpi != null) {
                                ((XpCPICapable)((Object)viewport)).setCvCPI(cpi);
                            }
                        } else {
                            ((GSPSCapable)((Object)viewport)).setGSPS(in);
                        }
                        if (!Boolean.getBoolean("NO_LOCK")) {
                            String suid = (String)gspsObject.getValue(((CvImageLoader)CvImageLoader.this).serUID.group, ((CvImageLoader)CvImageLoader.this).serUID.element);
                            DMObject[] sers = CvUtils.getDMSystem().getLocalDB().getRelated("series", new DMQuery("(0x0020,0x000E) = " + suid));
                            if (sers != null && sers.length > 0) {
                                CvImageLoader.this.lockUnlockMgr.lock(viewport, new DMObject[]{sers[0]});
                            }
                        }
                        in.close();
                    }
                    catch (FileNotFoundException expection) {
                        logger.log(Level.WARNING, "Error in reading gspsObject : " + expection.getMessage());
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Error in closing GSPS object stream : " + e.getMessage());
                    }
                }
            });
            return 0;
        }
        logger.log(Level.WARNING, "Viewport not a composite port");
        return -1;
    }

    private static void logUserMessage(int status) {
        if (status == 0) {
            logger.log(UserMessageLevel.USER_MSG, "");
        } else if (status == -1) {
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("IMAGE_LOAD_FAILED"));
        } else if (status == 1) {
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CORRUPTED_IMAGES"));
        } else if (status == -2) {
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
        } else if (status == -5) {
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("GSPS_REF_IMAGE_NOT_FOUND"));
        } else if (status == -6) {
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CINE_ON_IMGLOAD_FAILED"));
        }
    }

    private void configureScreenLayout(int numSelections) {
        ScreenLayoutHelper.getInstance().setScreen(this.scrn);
        HashMap<String, XPscreenLayout> configuredLayouts = ScreenLayoutHelper.getInstance().getConfiguredLayouts();
        int nPorts = 0;
        int maxPorts = 0;
        XPscreenLayout bestFit = null;
        XPscreenLayout biggest = null;
        for (Map.Entry<String, XPscreenLayout> pair : configuredLayouts.entrySet()) {
            int np = pair.getValue().getNoOfPorts();
            if (np >= numSelections && (nPorts == 0 || np < nPorts)) {
                nPorts = np;
                bestFit = pair.getValue();
            }
            if (np <= maxPorts) continue;
            maxPorts = np;
            biggest = pair.getValue();
        }
        if (biggest != null && nPorts == 0) {
            this.scrn.setLayout(biggest);
        } else if (bestFit != null) {
            this.scrn.setLayout(bestFit);
        }
    }

    public synchronized void dispose() {
        logger.log(Level.FINE, "CvImageLoader.dispose()........");
        int size = this.ips_.size();
        for (int i = 0; i < size; ++i) {
            CvDynamicImageProvider dp = this.ips_.get(i);
            dp.attachPort(null);
        }
        this.ips_.clear();
        this.lockUnlockMgr.unlockAll();
        this.lockUnlockMgr = null;
        if (this.scrn != null) {
            this.scrn.removePropertyChangeListener("layout_changed", this.portChangedListener);
            this.scrn.removePropertyChangeListener("port_change_property", this.portChangedListener);
            this.scrn = null;
        }
        instance = null;
    }

    public void loadFusionImages(DMObject dmoCT, DMObject dmoPT) {
    }

    public void clearLocks() {
        this.lockUnlockMgr.unlockAll();
    }

    private static class LockUnlockMgr {
        private HashMap<XpViewport, ArrayList<DMObject>> locks = new HashMap();

        private LockUnlockMgr() {
        }

        public void lock(XpViewport port, DMObject[] dmos) {
            ArrayList<Object> list = null;
            list = this.locks.containsKey(port) ? this.locks.get(port) : new ArrayList();
            for (int i = 0; i < dmos.length; ++i) {
                if (!"study".equalsIgnoreCase(dmos[i].getType()) && !"series".equalsIgnoreCase(dmos[i].getType())) continue;
                logger.log(Level.FINE, ">>>>>>>>>>>>>>> Locking DMObject");
                dmos[i].setLock(2);
                list.add(dmos[i]);
            }
            this.locks.put(port, list);
        }

        public void unlock(XpViewport port) {
            if (this.locks.containsKey(port)) {
                ArrayList<DMObject> list = this.locks.get(port);
                for (int i = 0; i < list.size(); ++i) {
                    logger.log(Level.FINE, ">>>>>>>>>>>>>>> Unlocking DMObject");
                    list.get(i).setLock(0);
                }
                list.clear();
                this.locks.remove(port);
            }
        }

        public void unlockAll() {
            Iterator<XpViewport> it = this.locks.keySet().iterator();
            logger.log(Level.FINE, ">>>>>>>>>>>>>>> unlockAll : " + this.locks.size());
            while (it.hasNext()) {
                XpViewport port = it.next();
                ArrayList<DMObject> list = this.locks.get(port);
                for (int i = 0; i < list.size(); ++i) {
                    logger.log(Level.FINE, ">>>>>>>>>>>>>>> Unlocking DMObject");
                    list.get(i).setLock(0);
                }
                list.clear();
            }
            this.locks.clear();
        }

        public HashMap<XpViewport, ArrayList<DMObject>> getLocks() {
            return this.locks;
        }
    }

    public static class CvMedicalDmImageList {
        private ArrayList<Integer> imgIndexList = new ArrayList();
        private int idx = -1;
        private XpCompositePort sd = null;
        private XpMedicalImage[] imgs = null;

        public CvMedicalDmImageList(XpCompositePort serDisp, DMImage[] dmi) {
            if (dmi == null) {
                logger.log(Level.INFO, "CvMedicalDmImageList ...Image List null");
                return;
            }
            this.sd = serDisp;
            this.imgs = new XpMedicalImage[dmi.length];
            double ww = -1.0;
            double wl = -1.0;
            String imgModality = null;
            if (dmi.length > 0 && XPDisplayPrefsUtils.getMiddleImageWindowingStatus()) {
                int numImages = dmi.length;
                int middleImageNo = -1;
                middleImageNo = numImages % 2 == 0 ? numImages / 2 : (numImages - 1) / 2;
                XpMedicalDmImage img = new XpMedicalDmImage(dmi[middleImageNo]);
                imgModality = DicomUtils.getModality(img);
                ww = img.getDefaultWindowWidth();
                wl = img.getDefaultWindowLevel();
            }
            final double wwMiddleSlice = ww;
            final double wlMiddleSlice = wl;
            final String modality = imgModality;
            for (int i = 0; i < dmi.length; ++i) {
                this.idx = i;
                this.imgIndexList.add(this.idx);
                this.imgs[i] = new XpMedicalDmImage(dmi[i]){
                    private int imgIndex;
                    private boolean isImageCurrupted;
                    {
                        super(x0);
                        this.imgIndex = CvMedicalDmImageList.this.idx;
                        this.isImageCurrupted = false;
                    }

                    @Override
                    protected void initImage() {
                        if (!this.isImageCurrupted) {
                            try {
                                super.initImage();
                            }
                            catch (Exception e) {
                                this.isImageCurrupted = true;
                                CvImageLoader.logUserMessage(1);
                            }
                        }
                    }

                    @Override
                    public RenderedImage getPixelData() {
                        if (!this.isImageCurrupted) {
                            try {
                                return super.getPixelData();
                            }
                            catch (Exception ex) {
                                this.isImageCurrupted = true;
                                int imgIndexToRemove = CvMedicalDmImageList.this.imgIndexList.indexOf(this.imgIndex);
                                CvMedicalDmImageList.this.imgIndexList.remove(new Integer(this.imgIndex));
                                CvMedicalDmImageList.this.sd.removeImage(imgIndexToRemove);
                                CvImageLoader.logUserMessage(1);
                            }
                        }
                        return null;
                    }

                    @Override
                    public int getValue(XpDicomElement value) {
                        block3: {
                            if (!this.isImageCurrupted) {
                                try {
                                    return super.getValue(value);
                                }
                                catch (Exception e) {
                                    this.isImageCurrupted = true;
                                    value.value = "";
                                    int imgIndexToRemove = CvMedicalDmImageList.this.imgIndexList.indexOf(this.imgIndex);
                                    if (imgIndexToRemove == -1) break block3;
                                    CvMedicalDmImageList.this.imgIndexList.remove(new Integer(this.imgIndex));
                                    CvMedicalDmImageList.this.sd.removeImage(imgIndexToRemove);
                                    CvImageLoader.logUserMessage(1);
                                }
                            }
                        }
                        return this.isImageCurrupted ? 0 : 1;
                    }

                    private boolean isMiddleImageWindowingEnabled() {
                        boolean restoreToDefaultWindowing = false;
                        String restorePropertyVal = System.getProperty("cvf.RestoreToDefaultWindowing");
                        if (restorePropertyVal != null && restorePropertyVal.equalsIgnoreCase("true")) {
                            restoreToDefaultWindowing = true;
                        }
                        return modality != null && modality.toUpperCase().equals("MR") && XPDisplayPrefsUtils.getMiddleImageWindowingStatus() && !restoreToDefaultWindowing;
                    }

                    @Override
                    public double getDefaultWindowWidth() {
                        if (this.isMiddleImageWindowingEnabled()) {
                            this.initImage();
                            return wwMiddleSlice;
                        }
                        return super.getDefaultWindowWidth();
                    }

                    @Override
                    public double getDefaultWindowLevel() {
                        if (this.isMiddleImageWindowingEnabled()) {
                            this.initImage();
                            return wlMiddleSlice;
                        }
                        return super.getDefaultWindowLevel();
                    }

                    @Override
                    public int getValues(XpDicomElement[] values) {
                        block4: {
                            if (!this.isImageCurrupted) {
                                try {
                                    return super.getValues(values);
                                }
                                catch (Exception e) {
                                    this.isImageCurrupted = true;
                                    for (int j = 0; j < values.length - 1; ++j) {
                                        values[j].value = "";
                                    }
                                    int imgIndexToRemove = CvMedicalDmImageList.this.imgIndexList.indexOf(this.imgIndex);
                                    if (imgIndexToRemove == -1) break block4;
                                    CvMedicalDmImageList.this.imgIndexList.remove(new Integer(this.imgIndex));
                                    CvMedicalDmImageList.this.sd.removeImage(imgIndexToRemove);
                                    CvImageLoader.logUserMessage(1);
                                }
                            }
                        }
                        return this.isImageCurrupted ? 0 : 1;
                    }
                };
            }
        }

        public XpMedicalImage[] getImages() {
            return this.imgs;
        }

        public int indexOf(int frameIdx) {
            return this.imgIndexList.indexOf(frameIdx);
        }
    }
}

