/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSession;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class CvDynamicImageProvider {
    private static final Logger logger = Logger.getLogger(CvDynamicImageProvider.class.getName());
    private static DMSession session_ = null;
    private XpCompositePort port_ = null;
    private String seriesUID_ = null;
    private String seriesID_ = null;
    private XpDicomElement suid = new XpDicomElement(32, 14);
    private XpDicomElement sid = new XpDicomElement(32, 17);
    private ArrayList<DMImage> _imageList = new ArrayList();
    private static final int MAX_IMAGES = 5;
    private boolean notAdded = true;
    private PropertyChangeListener seriesChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpImage img;
            if (session_ == null) {
                session_ = CvUtils.getDMSystem().getLocalDB();
            }
            if (session_ != null) {
                if (CvDynamicImageProvider.this.notAdded) {
                    session_.removeDMEventListener(CvDynamicImageProvider.this.dmEventListener);
                    session_.addDMEventListener(1, CvDynamicImageProvider.this.dmEventListener);
                    CvDynamicImageProvider.this.notAdded = false;
                }
            } else {
                logger.info("CvDynamicImageProvider.seriesChangeListener : session is NULL !!");
            }
            if (CvDynamicImageProvider.this.port_.getNumFrames() > 0 && (img = CvDynamicImageProvider.this.port_.getFrame(0)) instanceof XpDicomObject) {
                ((XpDicomObject)((Object)img)).getValues(new XpDicomElement[]{CvDynamicImageProvider.this.suid, CvDynamicImageProvider.this.sid});
                if (!(CvDynamicImageProvider.this.suid.getStringValue() == null || CvDynamicImageProvider.this.sid.getStringValue() == null || CvDynamicImageProvider.this.suid.getStringValue().trim().equals(CvDynamicImageProvider.this.seriesUID_) && CvDynamicImageProvider.this.sid.getStringValue().trim().equals(CvDynamicImageProvider.this.seriesID_))) {
                    CvDynamicImageProvider.this.seriesID_ = CvDynamicImageProvider.this.sid.getStringValue();
                    CvDynamicImageProvider.this.seriesUID_ = CvDynamicImageProvider.this.suid.getStringValue();
                    CvDynamicImageProvider.this._imageList.clear();
                }
            }
        }
    };
    private PropertyChangeListener updateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CvDynamicImageProvider.this.updateImages(true);
        }
    };
    private DMEventListener dmEventListener = new DMEventListener(){

        @Override
        public void actionPerformed(DMEvent event) {
            if (event.getID() == 1) {
                CvDynamicImageProvider.this.handleFilteredDMEvent(event);
            }
        }
    };

    CvDynamicImageProvider(XpCompositePort port) {
        session_ = CvUtils.getDMSystem().getLocalDB();
        this.attachPort(port);
    }

    public void attachPort(XpCompositePort port) {
        if (this.port_ == port) {
            return;
        }
        if (this.port_ != null) {
            this.port_.removePropertyChangeListener("CONTENT_CHANGED", this.seriesChangeListener);
            this.port_.removePropertyChangeListener("FrameIndex", this.updateListener);
            if (session_ != null) {
                session_.removeDMEventListener(this.dmEventListener);
                this.notAdded = true;
            }
        }
        this.port_ = port;
        this.seriesID_ = null;
        this.seriesUID_ = null;
        this._imageList.clear();
        if (this.port_ != null) {
            if (this.port_.getNumFrames() > 0) {
                XpImage img = this.port_.getFrame(0);
                if (img instanceof XpDicomObject) {
                    ((XpDicomObject)((Object)img)).getValues(new XpDicomElement[]{this.suid, this.sid});
                    this.seriesID_ = this.sid.getStringValue();
                    this.seriesUID_ = this.suid.getStringValue();
                }
                if (session_ != null && this.notAdded) {
                    session_.addDMEventListener(1, this.dmEventListener);
                    this.notAdded = false;
                }
            }
            this.port_.addPropertyChangeListener("CONTENT_CHANGED", this.seriesChangeListener);
            this.port_.addPropertyChangeListener("FrameIndex", this.updateListener);
        }
    }

    protected void handleFilteredDMEvent(DMEvent event) {
        DMComposite comp = session_.getComposite(event.getSource().toString());
        if (comp != null) {
            String uid = (String)comp.getValue(32, 14);
            String id = (String)comp.getValue(32, 17);
            if (uid.equals(this.seriesUID_) && id.equals(this.seriesID_)) {
                this._imageList.add(comp.getImages(null)[0]);
            }
            this.updateImages(false);
        }
    }

    private synchronized void updateImages(boolean forceUpdate) {
        if (this._imageList.size() > 0) {
            if (this.port_.getCine()) {
                logger.fine("updateImages() : Cine paging in progress, cannot update image list !!");
                return;
            }
            int nports = this.port_.getRows() * this.port_.getCols();
            if (forceUpdate || this._imageList.size() > 5 || nports > this.port_.getNumFrames()) {
                logger.fine("updateImages() : Updating image list with " + this._imageList.size() + " images");
                final DMImage[] imgs = this._imageList.toArray(new DMImage[this._imageList.size()]);
                this._imageList.clear();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CvDynamicImageProvider.this.port_.addImages(XpMedicalDmImage.wrapDMImages(imgs));
                        CvDynamicImageProvider.this.port_.repaint();
                    }
                });
            }
        }
    }
}

