/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpViewportManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class CVViewPortManager
implements XpViewportManager {
    protected static final Logger logger = Logger.getLogger(CVViewPortManager.class.getName());
    protected MouseListener viewportSelector = new ViewPortSelector();
    private String appName = "";
    private static final String DOT = ".";

    public CVViewPortManager() {
    }

    public CVViewPortManager(String applicaitonName) {
        this.appName = applicaitonName;
    }

    @Override
    public void createViewportCB(XpFrameVisualizer fv) {
        fv.getMedicalImageVc().getAnnotationVc().removeMouseListener(this.viewportSelector);
        fv.getMedicalImageVc().getAnnotationVc().addMouseListener(this.viewportSelector);
        CvMouseControllerUtil.MouseModeSyncHandler msHandler = CvMouseControllerUtil.getMouseModeSyncHandler(String.valueOf(this.hashCode()));
        XpMouseController mouseController2 = this.createMouseController();
        if (mouseController2 instanceof MouseModeCapable) {
            MouseModeCapable modeCapable = (MouseModeCapable)((Object)mouseController2);
            msHandler.addMouseModeChangeListener(modeCapable);
        }
        fv.setMouseController(mouseController2);
        logger.log(Level.FINE, "Viewport selection listener and mouse controller added sucessfully");
    }

    protected XpMouseController createMouseController() {
        String mc = "MouseController";
        if (this.appName != null & this.appName.length() > 0) {
            mc = this.appName + DOT;
            mc = mc + "MouseController";
        }
        String mcclassname = CvPropertiesManager.getProperty(mc, "com.ge.med.cse.cvf.controls.CvMouseController");
        try {
            if (this.appName != null && this.appName.length() > 0) {
                Constructor c = CvUtils.getClass(mcclassname).getConstructor(String.class, Properties.class);
                return (XpMouseController)c.newInstance(this.appName, null);
            }
            return (XpMouseController)CvUtils.getClass(mcclassname).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.FINE, "Could not create MouseController " + e);
            return null;
        }
    }

    class ViewPortSelector
    extends MouseAdapter {
        ViewPortSelector() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            XpFrameVisualizer fv = (XpFrameVisualizer)SwingUtilities.getAncestorOfClass(XpFrameVisualizer.class, e.getComponent());
            SelectionCapable sel = (SelectionCapable)((Object)SwingUtilities.getAncestorOfClass(SelectionCapable.class, fv));
            int numberofSel = sel.getNumComponents();
            for (int i = 0; i < numberofSel; ++i) {
                if (!sel.getViewportComponent(i).equals(fv)) continue;
                sel.setComponentSelection(i);
            }
        }
    }
}

