/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.cse.cvf.roi.CvContinuousReporter;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DSAImageOp;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.cse.cvf.util.ValueBasedDecimalFormatter;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.Component;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XpCvApdAnnotationConfig
extends XpMRCTApdAnnotationConfig {
    protected static final Logger logger = Logger.getLogger(XpCvApdAnnotationConfig.class.getName());
    private static final int DEFAULT_ROI_RESULTS = 3;
    private static final int MAX_ALLOWED_ROI_RESULTS = 5;
    private static final String[] roiPropName = new String[]{"roiResult3", "roiResult2", "roiResult1", "roiResult96", "roiResult97"};
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");
    private static final ValueBasedDecimalFormatter dfe = new ValueBasedDecimalFormatter();
    private static final String[] pads = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private ArrayList roiInfoList = new ArrayList();
    private LinkedList lastSelectedRois = new LinkedList();
    private static final String ROI_ANNOTATION_COUNT = CvPropertiesManager.getProperty("cvf.roi.annotations.limit");
    private int selectedRoi = -1;

    private int getROIAnnotationCount() {
        try {
            int roiLimit = Integer.parseInt(ROI_ANNOTATION_COUNT);
            if (roiLimit <= 5 && roiLimit >= 3) {
                return roiLimit;
            }
            return 3;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Setting to default value 3 as the property specified is not valid " + ex);
            return 3;
        }
    }

    @Override
    protected void setROIInfo(XpAnnotationVc avc, JComponent jc) {
        int i;
        XpAnnotationModel am = avc.getAnnotationModel();
        if (am == null) {
            return;
        }
        boolean probeQ = DicomUtils.isMRProbeQImage(am.getDicomObject());
        int noStat = this.getROIAnnotationCount();
        am.setProperty("reportPixel_R", "");
        am.setProperty("reportPixel_A", "");
        am.setProperty("reportPixel_S", "");
        am.setProperty("reportPixel_V", "");
        this.roiInfoList.clear();
        this.selectedRoi = -1;
        int nroi = 0;
        int childCount = jc.getComponentCount();
        for (i = 0; i < childCount; ++i) {
            Component c = jc.getComponent(i);
            if (c instanceof XpImageRoiVc && XpStatisticsRoi.isShowStatistics() || c instanceof InfoLabelReporter) {
                String label = null;
                if (c instanceof XpImageRoiVc) {
                    XpImageRoiVc rvc = (XpImageRoiVc)c;
                    RoiActor ra = rvc.getRoiActor();
                    if (ra instanceof Visible && ((Visible)((Object)ra)).isVisible() && ra instanceof InfoLabelReporter) {
                        InfoLabelReporter ilr = (InfoLabelReporter)((Object)ra);
                        label = ilr.getInfoLabel();
                        if (ra.isSelected()) {
                            this.selectedRoi = nroi;
                        }
                    }
                } else if (c instanceof InfoLabelReporter) {
                    label = ((InfoLabelReporter)((Object)c)).getInfoLabel();
                }
                if (label == null) continue;
                this.roiInfoList.add(nroi, label);
                ++nroi;
                continue;
            }
            if (!(c instanceof CvContinuousReporter)) continue;
            CvContinuousReporter pm = (CvContinuousReporter)c;
            if (pm.isVisible()) {
                CPoint cp = pm.getRAS();
                double value = pm.getValue();
                String R2 = "R ";
                String A2 = "A ";
                String S2 = "S ";
                String V = "V = ";
                double r = cp.x;
                double a = cp.y;
                double s = cp.z;
                if (r < 0.0) {
                    r = -r;
                    R2 = "L ";
                }
                if (a < 0.0) {
                    a = -a;
                    A2 = "P ";
                }
                if (s < 0.0) {
                    s = -s;
                    S2 = "I ";
                }
                R2 = R2 + rasf.format(r) + "mm";
                A2 = A2 + rasf.format(a) + "mm";
                S2 = S2 + rasf.format(s) + "mm";
                V = V + dfe.customFormat(value);
                int rlen = R2.length();
                int alen = A2.length();
                int slen = S2.length();
                int vlen = V.length();
                int max = Math.max(rlen, alen);
                max = Math.max(max, slen);
                if ((max = Math.max(max, vlen)) > rlen) {
                    R2 = R2 + pads[max - rlen];
                }
                if (max > alen) {
                    A2 = A2 + pads[max - alen];
                }
                if (max > slen) {
                    S2 = S2 + pads[max - slen];
                }
                if (max > vlen) {
                    V = V + pads[max - vlen];
                }
                am.setProperty("reportPixel_R", R2);
                am.setProperty("reportPixel_A", A2);
                am.setProperty("reportPixel_S", S2);
                am.setProperty("reportPixel_V", V);
                if (!am.queryAnnotationItem("Graphic_Results")) continue;
                am.setAnnotationItems(new String[]{"Report_Cursor"}, true);
                continue;
            }
            if (probeQ) continue;
            am.setAnnotationItems(new String[]{"Report_Cursor"}, false);
        }
        if (nroi > 0) {
            if (this.selectedRoi == -1) {
                if (this.lastSelectedRois.size() > nroi) {
                    int diff = this.lastSelectedRois.size() - nroi;
                    for (int i2 = 0; i2 < diff; ++i2) {
                        int lastSelectedIdx = Integer.parseInt((String)this.lastSelectedRois.getLast());
                        LinkedList<String> temp = new LinkedList<String>();
                        int nlsr = this.lastSelectedRois.size();
                        for (int j = 0; j < nlsr - 1; ++j) {
                            int index = Integer.parseInt((String)this.lastSelectedRois.get(j));
                            if (index > lastSelectedIdx) {
                                --index;
                            }
                            temp.add("" + index);
                        }
                        this.lastSelectedRois = temp;
                    }
                }
            } else {
                if (this.lastSelectedRois.contains("" + this.selectedRoi)) {
                    this.lastSelectedRois.remove("" + this.selectedRoi);
                }
                this.lastSelectedRois.add("" + this.selectedRoi);
            }
            int rsIndex = 0;
            if (this.lastSelectedRois.size() < nroi) {
                for (int i3 = 0; i3 < nroi; ++i3) {
                    if (this.lastSelectedRois.contains("" + i3)) continue;
                    this.lastSelectedRois.add("" + i3);
                }
            }
            for (int i4 = nroi - 1; i4 >= 0 && noStat > 0; --i4) {
                int index = Integer.parseInt((String)this.lastSelectedRois.get(i4));
                if (index >= this.roiInfoList.size()) continue;
                am.setProperty(roiPropName[rsIndex], (String)this.roiInfoList.get(index));
                ++rsIndex;
                --noStat;
            }
        } else {
            this.lastSelectedRois.clear();
        }
        for (i = nroi; i < noStat; ++i) {
            am.setProperty(roiPropName[i], "");
        }
    }

    public static class SecondaryCapture
    extends XpCvApdAnnotationConfig {
        private static final DecimalFormat df = new DecimalFormat("##0.##");
        private int imgWidth = 0;
        private int imgHeight = 0;

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            if (jc != null) {
                XpMedicalImage2DVc mivc1;
                XpImageOrientation ior;
                XpAnnotationModel am = avc.getAnnotationModel();
                if (am == null) {
                    return;
                }
                FrameOwner fowner = (FrameOwner)((Object)jc);
                int frameNo = 0;
                int frameIndex = 1;
                String modality = null;
                boolean wwwlStyle = true;
                if (fowner.getFrame() instanceof XpMedicalDmImage) {
                    XpSlice slice;
                    XpImage xi = fowner.getFrame();
                    DMImage dmImg = ((XpMedicalDmImage)xi).getDMImage();
                    frameNo = dmImg.getFrameNumber();
                    frameIndex = frameNo + 1;
                    DMComposite dmComp = dmImg.getComposite();
                    if (dmComp != null && "PT".equalsIgnoreCase(modality = DicomUtils.getModality(dmComp))) {
                        wwwlStyle = false;
                    }
                    am.setProperty("frameIndex", frameIndex);
                    XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
                    XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                    double currWW = ira.getWindowWidth();
                    double currWL = ira.getWindowLevel();
                    double zoom = ira.getZoom();
                    am.setProperty("zoomFactor", zoom);
                    List currOperations = ira.getImageOperations();
                    String WWWL_KEY = null;
                    if (wwwlStyle) {
                        WWWL_KEY = "W: " + df.format(currWW) + "  L: " + df.format(currWL);
                    } else {
                        double HWW = currWW * 0.5;
                        double min = currWL - HWW;
                        double max = currWL + HWW;
                        WWWL_KEY = "Min: " + df.format(min) + " Max: " + df.format(max);
                    }
                    am.setProperty("wwwl_key", WWWL_KEY);
                    if (xi != null && (slice = xi.getSlice()) != null) {
                        this.imgWidth = slice.width;
                        this.imgHeight = slice.height;
                        String IMAGE_DIM_KEY = "" + this.imgWidth + " x " + this.imgHeight;
                        am.setProperty("image_dim_key", IMAGE_DIM_KEY);
                    }
                    if (currOperations != null) {
                        int size = currOperations.size();
                        String ops = "";
                        boolean first = true;
                        for (int i = 0; i < size; ++i) {
                            XpImageOp iop = (XpImageOp)currOperations.get(i);
                            ops = first ? iop.getImageOpName() : ops + "," + iop.getImageOpName();
                            first = false;
                        }
                        am.setProperty("single_op_key", ops);
                    }
                }
                if (jc instanceof XpMedicalImage2DVc && (ior = (mivc1 = (XpMedicalImage2DVc)jc).getDisplayOrientation()) != null) {
                    am.setProperty("currentOrientation", ior.toString());
                }
            }
        }
    }

    public static class DBT
    extends XpCvApdAnnotationConfig {
        private static final DMTag XRAY_3D_ACQUISITION_SEQUENCE_TAG = new DMTag(24, 38151);
        private static final DMTag START_ACQUISITION_DATETIME_TAG = new DMTag(24, 38166);
        private static final DMTag EST_RADIO_MAG_FACTOR_TAG = new DMTag(24, 4372);
        private static final DMTag EXPOSUE_CONTROL_MODE_TAG = new DMTag(24, 28768);
        private static final DMTag KVP_TAG = new DMTag(24, 96);
        private static final DMTag EXPOSURE_TAG = new DMTag(24, 37682);
        private static final DMTag EXPOSURE_TIME_TAG = new DMTag(24, 37672);
        private static final DMTag ANODE_TARGET_MATERIAL_TAG = new DMTag(24, 4497);
        private static final DMTag FILTER_MATERIAL_TAG = new DMTag(24, 28752);
        private static final DMTag ORGAN_DOSE_TAG = new DMTag(64, 790);
        private static final DMTag BODY_PART_THICKNESS_TAG = new DMTag(24, 4512);
        private static final DMTag COMPRESSION_FORCE_TAG = new DMTag(24, 4514);
        private static final DMTag POSITIONER_PRIMARY_ANGLE_TAG = new DMTag(24, 38160);
        private static final DMTag DETECTOR_ID_TAG = new DMTag(24, 28682);
        private static final DMTag LAST_DETECTOR_CALIBRATION_DATE_TAG = new DMTag(24, 28684);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            if (jc != null) {
                XpAnnotationModel am = avc.getAnnotationModel();
                if (am == null) {
                    return;
                }
                int frameIndex = 1;
                int frameNo = 0;
                String laterality = null;
                String viewName = null;
                FrameOwner fowner = (FrameOwner)((Object)jc);
                if (fowner.getFrame() instanceof XpMedicalDmImage) {
                    XpImage xi = fowner.getFrame();
                    DMImage dmImg = ((XpMedicalDmImage)xi).getDMImage();
                    frameNo = dmImg.getFrameNumber();
                    frameIndex = frameNo + 1;
                    DMComposite dmComp = dmImg.getComposite();
                    if (dmComp != null) {
                        XpMedicalImage2DVc mivc1;
                        XpImageOrientation ior;
                        laterality = DicomUtils.getLaterality(dmComp);
                        String clinicalViewName = DicomUtils.getClinicalViewName(dmComp);
                        viewName = clinicalViewName.substring(1, clinicalViewName.length());
                        am.setProperty("laterality", laterality);
                        am.setProperty("viewName", viewName);
                        DMSequence xray3DAcquisitionSequence = (DMSequence)dmComp.getValue(XRAY_3D_ACQUISITION_SEQUENCE_TAG);
                        if (xray3DAcquisitionSequence != null && xray3DAcquisitionSequence.getNumberOfItems() > 0) {
                            String acquisitionDateTime = (String)xray3DAcquisitionSequence.getItem(0).getValue(START_ACQUISITION_DATETIME_TAG);
                            String estRadioMagFactor = (String)xray3DAcquisitionSequence.getItem(0).getValue(EST_RADIO_MAG_FACTOR_TAG);
                            String expControlMode = (String)xray3DAcquisitionSequence.getItem(0).getValue(EXPOSUE_CONTROL_MODE_TAG);
                            String kvp = (String)xray3DAcquisitionSequence.getItem(0).getValue(KVP_TAG);
                            String exposure = "" + xray3DAcquisitionSequence.getItem(0).getValue(EXPOSURE_TAG);
                            String exposureTime = "" + xray3DAcquisitionSequence.getItem(0).getValue(EXPOSURE_TIME_TAG);
                            String anodeTargetMaterial = (String)xray3DAcquisitionSequence.getItem(0).getValue(ANODE_TARGET_MATERIAL_TAG);
                            String filterMaterial = (String)xray3DAcquisitionSequence.getItem(0).getValue(FILTER_MATERIAL_TAG);
                            String organDose = (String)xray3DAcquisitionSequence.getItem(0).getValue(ORGAN_DOSE_TAG);
                            String bodyPartThickness = (String)xray3DAcquisitionSequence.getItem(0).getValue(BODY_PART_THICKNESS_TAG);
                            String compressionForce = (String)xray3DAcquisitionSequence.getItem(0).getValue(COMPRESSION_FORCE_TAG);
                            String positionerPrimaryAngle = "" + xray3DAcquisitionSequence.getItem(0).getValue(POSITIONER_PRIMARY_ANGLE_TAG);
                            String detectorId = (String)xray3DAcquisitionSequence.getItem(0).getValue(DETECTOR_ID_TAG);
                            String lastcalibrationdate = (String)xray3DAcquisitionSequence.getItem(0).getValue(LAST_DETECTOR_CALIBRATION_DATE_TAG);
                            if (estRadioMagFactor != null) {
                                am.setProperty("estimatedRadioMagFactor", estRadioMagFactor);
                            }
                            if (expControlMode != null) {
                                am.setProperty("exposureControlMode", expControlMode);
                            }
                            if (kvp != null) {
                                am.setProperty("kvp", kvp);
                            }
                            if (exposure != null) {
                                am.setProperty("exposure", exposure);
                            }
                            if (exposureTime != null) {
                                am.setProperty("exposureTime", exposureTime);
                            }
                            if (anodeTargetMaterial != null) {
                                am.setProperty("anodeTargetMaterial", anodeTargetMaterial);
                            }
                            if (filterMaterial != null) {
                                am.setProperty("filterMaterial", filterMaterial);
                            }
                            if (organDose != null) {
                                am.setProperty("organDose", organDose);
                            }
                            if (bodyPartThickness != null) {
                                am.setProperty("bodyPartThickness", bodyPartThickness);
                            }
                            if (compressionForce != null) {
                                am.setProperty("compressionForce", compressionForce);
                            }
                            if (positionerPrimaryAngle != null) {
                                am.setProperty("positionerPrimaryAngle", positionerPrimaryAngle);
                            }
                            if (detectorId != null) {
                                am.setProperty("detectorID", detectorId);
                            }
                            if (lastcalibrationdate != null) {
                                am.setProperty("lastDetectorCalibrationDate", lastcalibrationdate);
                            }
                            if (acquisitionDateTime != null) {
                                am.setProperty("acquisitionDate", acquisitionDateTime.substring(0, 8));
                                am.setProperty("acquisitionTime", acquisitionDateTime.substring(8, acquisitionDateTime.length()));
                            }
                        }
                        XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
                        XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                        double zoom = ira.getZoom();
                        am.setProperty("zoomFactor", zoom);
                        if (jc instanceof XpMedicalImage2DVc && (ior = (mivc1 = (XpMedicalImage2DVc)jc).getDisplayOrientation()) != null) {
                            am.setProperty("currentOrientation", "" + ior);
                        }
                    }
                }
                am.setProperty("frameIndex", frameIndex);
            }
        }
    }

    public static class MG
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            if (jc != null) {
                XpAnnotationModel am = avc.getAnnotationModel();
                if (am == null) {
                    return;
                }
                FrameOwner fowner = (FrameOwner)((Object)jc);
                String laterality = null;
                String viewName = null;
                if (fowner.getFrame() instanceof XpMedicalDmImage) {
                    XpMedicalImage2DVc mivc1;
                    XpImageOrientation ior;
                    XpImage xi = fowner.getFrame();
                    DMImage dmImg = ((XpMedicalDmImage)xi).getDMImage();
                    DMComposite dmComp = dmImg.getComposite();
                    if (dmComp != null) {
                        laterality = DicomUtils.getLaterality(dmComp);
                        String clinicalViewName = DicomUtils.getClinicalViewName(dmComp);
                        viewName = clinicalViewName.substring(1, clinicalViewName.length());
                        am.setProperty("laterality", laterality);
                        am.setProperty("viewName", viewName);
                    }
                    XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
                    XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                    double zoom = ira.getZoom();
                    am.setProperty("zoomFactor", zoom);
                    if (jc instanceof XpMedicalImage2DVc && (ior = (mivc1 = (XpMedicalImage2DVc)jc).getDisplayOrientation()) != null) {
                        am.setProperty("currentOrientation", "" + ior);
                    }
                }
            }
        }
    }

    public static class OEC
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            if (jc != null) {
                super.configAnnotation(avc, jc);
                XpAnnotationModel am = avc.getAnnotationModel();
                if (am == null) {
                    return;
                }
                FrameOwner fowner = (FrameOwner)((Object)jc);
                int frameIndex = 1;
                int frameNo = 0;
                if (fowner.getFrame() instanceof XpMedicalDmImage) {
                    DMImage dmImg = ((XpMedicalDmImage)fowner.getFrame()).getDMImage();
                    frameNo = dmImg.getFrameNumber();
                    frameIndex = frameNo + 1;
                }
                am.setProperty("frameIndex", frameIndex);
                am.setProperty("frameType", "NAT");
                XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                List imops = ira.getImageOperations();
                if (imops.size() > 0) {
                    for (Object o : imops) {
                        if (!(o instanceof DSAImageOp)) continue;
                        am.setProperty("frameType", "SUB");
                        break;
                    }
                } else {
                    am.setProperty("frameType", "NAT");
                }
            }
        }
    }

    public static class PET
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpDicomElement wwwlUnits = new XpDicomElement(84, 4097);
            XpImage xi = fowner != null ? fowner.getFrame() : null;
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(wwwlUnits);
            }
            this.setRASCorners(avc, vc);
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setROIInfo(avc, viewport);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                double wMax = 0.0;
                double wMin = 0.0;
                String windowingUnits = wwwlUnits.getStringValue();
                if (windowingUnits != null && windowingUnits.compareTo("BQML") == 0) {
                    wMax = ira.getWindowMax() / 1000.0;
                    wMin = ira.getWindowMin() / 1000.0;
                } else {
                    wMax = ira.getWindowMax();
                    wMin = ira.getWindowMin();
                }
                double zoom = ira.getZoom();
                if (jc instanceof XpMedicalImage2DVc) {
                    XpMedicalImage2DVc mivc1 = (XpMedicalImage2DVc)jc;
                    XpImageOrientation ior = mivc1.getDisplayOrientation();
                    String iorStr = "" + ior;
                    am.setProperty("currentOrientation", iorStr);
                }
                am.setProperty("windowMin", wMin);
                am.setProperty("windowMax", wMax);
                am.setProperty("zoomFactor", zoom);
                IndexColorModel icm = ira.getColormap();
                List ops = ira.getImageOperations();
                boolean setGSE = false;
                am.setProperty("currentFilterDescription", "   ");
                am.setProperty("stretchDescription", "   ");
                if (icm != null) {
                    String ctableName = "" + icm;
                    if (ctableName.indexOf("g1") != -1 || ctableName.indexOf("g2") != -1 || ctableName.indexOf("g3") != -1) {
                        setGSE = true;
                    }
                    if (setGSE) {
                        am.setProperty("stretchDescription", ctableName);
                    }
                }
                if (ops != null) {
                    int len = ops.size();
                    String filters = null;
                    for (int i = 0; i < len; ++i) {
                        XpImageOp iop = (XpImageOp)ops.get(i);
                        filters = i == 0 ? "" + iop.getImageOpName() : " " + iop.getImageOpName();
                    }
                    if (filters != null) {
                        am.setProperty("currentFilterDescription", filters);
                    }
                }
            }
        }
    }

    public static class NoMarkers
    extends XpCvApdAnnotationConfig {
        XpDicomElement current_fr = new XpDicomElement(0, 1);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner != null ? fowner.getFrame() : null;
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(this.current_fr);
                if (this.current_fr.value != null) {
                    int iCurrentFrame = (Integer)this.current_fr.value + 1;
                    am.setProperty("current_frame_number", "" + iCurrentFrame);
                }
            }
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setRenderAttributes(avc, mivc);
                XpImageOrientation ior = mivc.getDisplayOrientation();
                if (ior != null) {
                    String iorStr = ior.toString();
                    am.setProperty("currentOrientation", iorStr);
                }
                this.setROIInfo(avc, viewport);
            }
        }
    }

    public static class NM
    extends XpCvApdAnnotationConfig {
        XpDicomElement current_fr = new XpDicomElement(0, 1);
        XpDicomElement total_frames = new XpDicomElement(40, 8);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            XpDicomElement wwwlUnits = new XpDicomElement(84, 4097);
            this.setRASCorners(avc, vc);
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner != null ? fowner.getFrame() : null;
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(wwwlUnits);
                dobj.getValue(this.current_fr);
                if (this.current_fr.value != null) {
                    int iCurrentFrame = (Integer)this.current_fr.value + 1;
                    am.setProperty("current_frame_number", "" + iCurrentFrame);
                }
            }
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setROIInfo(avc, viewport);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                double wMax = 0.0;
                double wMin = 0.0;
                String windowingUnits = wwwlUnits.getStringValue();
                if (windowingUnits != null && windowingUnits.compareTo("BQML") == 0) {
                    wMax = ira.getWindowMax() / 1000.0;
                    wMin = ira.getWindowMin() / 1000.0;
                } else {
                    wMax = ira.getWindowMax();
                    wMin = ira.getWindowMin();
                }
                double zoom = ira.getZoom();
                if (jc instanceof XpMedicalImage2DVc) {
                    XpMedicalImage2DVc mivc1 = (XpMedicalImage2DVc)jc;
                    XpImageOrientation ior = mivc1.getDisplayOrientation();
                    String iorStr = "" + ior;
                    am.setProperty("currentOrientation", iorStr);
                }
                am.setProperty("windowMin", wMin);
                am.setProperty("windowMax", wMax);
                am.setProperty("zoomFactor", zoom);
            }
        }
    }

    public static class Default
    extends XpCvApdAnnotationConfig {
        XpDicomElement current_fr = new XpDicomElement(0, 1);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner != null ? fowner.getFrame() : null;
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(this.current_fr);
                if (this.current_fr.value != null) {
                    int iCurrentFrame = (Integer)this.current_fr.value + 1;
                    am.setProperty("current_frame_number", "" + iCurrentFrame);
                }
            }
            super.configAnnotation(avc, jc);
        }
    }

    public static class CTScout
    extends XpCvApdAnnotationConfig {
    }

    public static class CT
    extends XpCvApdAnnotationConfig {
    }

    public static class MR
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            super.configAnnotation(avc, jc);
            XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
            XpImageOrientation ior = mivc.getDisplayOrientation();
            if (ior != null) {
                Double rotAngle = this.getImageState(ior.getAngle(), ior.getFlip());
                am.setProperty("currentRotation", rotAngle.toString());
            }
        }

        protected double getImageState(double angle, boolean flip) {
            int quotient;
            double degAngle = Math.toDegrees(angle);
            double cAngle = degAngle - (double)(360 * (quotient = (int)(degAngle / 360.0)));
            if (cAngle < 0.0) {
                cAngle = 360.0 + cAngle;
            }
            if (cAngle % 0.5 != 0.0) {
                double rem = cAngle % 0.5;
                cAngle = rem <= 0.25 ? (cAngle -= rem) : (cAngle += 0.5 - rem);
            }
            double quadrant = cAngle / 90.0;
            double rem = cAngle % 90.0;
            int iangle = (int)quadrant;
            double angleVal = 0.0;
            if ((iangle %= 4) == 1) {
                angleVal = 90.0;
            } else if (iangle == 3 && !flip) {
                angleVal = 270.0;
            } else if (iangle == 2 && !flip) {
                angleVal = 180.0;
            } else if (iangle == 3 && flip) {
                angleVal = 90.0;
            } else if (iangle == 2 && flip) {
                angleVal = 0.0;
            }
            return angleVal += rem;
        }

        @Override
        protected void setRenderAttributes(XpAnnotationVc avc, XpImageRenderAttributesOwner iraOwner) {
            super.setRenderAttributes(avc, iraOwner);
            XpAnnotationModel am = avc.getAnnotationModel();
            XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
            if (am != null && ira != null) {
                double ww = ira.getWindowWidth();
                double wl = ira.getWindowLevel();
                am.setProperty("windowWidth", ww);
                am.setProperty("windowLevel", wl);
            }
        }
    }
}

